/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.ufs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocumentIndex;
import com.gridnine.xtrip.common.railway.parsers.helpers.RailwayProductParsersHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.parsers.BaseExchangeProcessor;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSRailwayData;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
public class UFSExchangeProcessor
extends BaseExchangeProcessor<UFSExchangeDocument> {
    public static final String EXCHANGE_FILE_ENCODING = "utf8";
    public static final String STORE_ENCODING = "utf8";
    public static final String BLANK_TYPE_CODE = "\u0423\u0424\u0421 ETKT";
    public static final String BLANK_OWNER_CODE = "\u0423\u0424\u0421";
    public static final int PNR_DAYS_THRESHOLD = 14;

    protected Class<? extends EntityIndex<UFSExchangeDocument>> getIndexClass() {
        return UFSExchangeDocumentIndex.class;
    }

    public String getType() {
        return "UFS";
    }

    public void processExchangeFile(UFSExchangeDocument document) throws Exception {
        this.log.debug(String.format("processing exchange file %s document", document.getLocation()));
        document.setStatus(ProcessingStatus.UNPROCESSED);
        document.getMessages().clear();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Element ufsGateElement = documentBuilder.parse(XUtil.createSource((InputStream)new ByteArrayInputStream(document.getContent()), (String)"utf8")).getDocumentElement();
        UFSRailwayData ufsData = this.createData(ufsGateElement);
        if (ufsData != null) {
            ProductStatus status = RailwayProductParsersHelper.getStatus((TransactionType)ufsData.getTransactionType());
            if (status == ProductStatus.SELL) {
                this.processSellExchangeDocument(document, ufsData);
            } else if (status == ProductStatus.REFUND) {
                this.processRefundExchangeDocument(document, ufsData);
            }
        }
    }

    private void processSellExchangeDocument(UFSExchangeDocument document, UFSRailwayData ufsData) throws Exception {
        List messages = document.getMessages();
        EntityStorage entityStorage = EntityStorage.get();
        document.setStatus(ProcessingStatus.UNPROCESSED);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)ufsData.getSystemNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), null)}));
        List railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
        if (railwayProductIndexes.size() == 0) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)ufsData.getPnr()));
            if (ufsData.getIssueDate() != null) {
                Date issueDateStart = new Date(ufsData.getIssueDate().getTime() - 1209600000L);
                Date issueDateEnd = new Date(ufsData.getIssueDate().getTime() + 1209600000L);
                query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateStart));
                query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateEnd));
            }
            List bookingFileIndexes = entityStorage.search(BookingFileIndex.class, query).getData();
            EntityContainer bookingFileContainer = null;
            if (bookingFileIndexes.size() == 0) {
                BookingFile bookingFile = new BookingFile();
                Reservation reservation = new Reservation();
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.UFS, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)ufsData.getPnr());
                reservation.setBookingFile(bookingFile);
                bookingFile.getReservations().add(reservation);
                bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
            } else {
                BookingFileIndex index = (BookingFileIndex)bookingFileIndexes.get(0);
                if (bookingFileIndexes.size() > 1) {
                    // empty if block
                }
                bookingFileContainer = EntityStorage.get().resolve(index.getSource());
            }
            RailwayProduct product = new RailwayProduct();
            this.updateProduct(product, ufsData, messages);
            this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, product, ufsData.getPnr(), messages);
            entityStorage.save(bookingFileContainer, true);
            messages.addAll(ufsData.getMessages());
            for (Message message : messages) {
                this.logWarningMessage(message, document.getLocation());
            }
            document.setOwner(bookingFileContainer.toReference());
            document.setRelatedBookingFile(bookingFileContainer.toReference());
            document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
            messages.add(MessageHelper.createMessage((String)Messages.UFSExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_importTransactionCompleted, (Object[])new Object[]{ufsData.getTransactionType(), ufsData.getSystemNumber()}), (Object[])new Object[0]));
        } else {
            RailwayProductIndex index = (RailwayProductIndex)railwayProductIndexes.get(0);
            if (railwayProductIndexes.size() > 1) {
                // empty if block
            }
            if (index.getStatus() == ProductStatus.SELL && index.getTicketType() == TicketType.FAKE) {
                EntityContainer bookingFileContainer = EntityStorage.get().resolve(index.getSource());
                RailwayProduct product = this.getProduct((EntityContainer<BookingFile>)bookingFileContainer, index.getSystemNumber(), ProductStatus.SELL);
                this.updateProduct(product, ufsData, messages);
                RailwayProduct refundProduct = product.getNextProduct();
                if (refundProduct != null && refundProduct.getStatus() == ProductStatus.REFUND) {
                    this.synchronizeSellAndRefundData(product, refundProduct);
                }
                this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, product, ufsData.getPnr(), messages);
                entityStorage.save(bookingFileContainer, true);
                messages.addAll(ufsData.getMessages());
                for (Message message : messages) {
                    this.logWarningMessage(message, document.getLocation());
                }
                document.setOwner(bookingFileContainer.toReference());
                document.setRelatedBookingFile(bookingFileContainer.toReference());
                document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
                messages.add(MessageHelper.createMessage((String)Messages.UFSExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_importTransactionCompleted, (Object[])new Object[]{ufsData.getTransactionType(), ufsData.getSystemNumber()}), (Object[])new Object[0]));
            } else {
                messages.add(MessageHelper.createErrorMessage((String)Messages.UFSExchangeProcessor_importFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_ticketAlreadyExist, (Object[])new Object[]{ufsData.getSystemNumber()}), (Object[])new Object[0]));
                document.setStatus(ProcessingStatus.ERROR);
            }
        }
    }

    private void processRefundExchangeDocument(UFSExchangeDocument document, UFSRailwayData ufsData) throws Exception {
        List messages = document.getMessages();
        EntityStorage entityStorage = EntityStorage.get();
        document.setStatus(ProcessingStatus.UNPROCESSED);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)ufsData.getSystemNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.REFUND), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), null)}));
        List railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
        if (railwayProductIndexes.size() == 0) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)ufsData.getSystemNumber()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
            railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
            EntityContainer bookingFileContainer = null;
            RailwayProduct sellProduct = null;
            if (railwayProductIndexes.size() > 0) {
                RailwayProductIndex index = (RailwayProductIndex)railwayProductIndexes.get(0);
                if (railwayProductIndexes.size() > 1) {
                    // empty if block
                }
                bookingFileContainer = EntityStorage.get().resolve(index.getSource());
                sellProduct = this.getProduct((EntityContainer<BookingFile>)bookingFileContainer, index.getSystemNumber(), ProductStatus.SELL);
                ufsData.setPnr(CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)sellProduct.getReservation(), (GdsName)GdsName.UFS, (RecordLocatorType)RecordLocatorType.DEFAULT));
            }
            if (bookingFileContainer == null) {
                if (sellProduct == null) {
                    this.log.info(String.format("Refund ticket's PNR %s would be used for reservation because refund ticket was found before sell ticket", ufsData.getPnr()));
                }
                BookingFile bookingFile = new BookingFile();
                Reservation reservation = new Reservation();
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.UFS, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)ufsData.getPnr());
                reservation.setBookingFile(bookingFile);
                bookingFile.getReservations().add(reservation);
                bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
            }
            RailwayProduct refundProduct = new RailwayProduct();
            this.updateProduct(refundProduct, ufsData, messages);
            if (sellProduct != null) {
                this.synchronizeSellAndRefundData(sellProduct, refundProduct);
            }
            this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, refundProduct, ufsData.getPnr(), messages);
            if (sellProduct == null) {
                sellProduct = new RailwayProduct();
                this.updateFakeProduct(sellProduct, ufsData, messages);
                this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, sellProduct, ufsData.getPnr(), messages);
            }
            refundProduct.setPreviousProduct(sellProduct);
            sellProduct.setNextProduct(refundProduct);
            entityStorage.save(bookingFileContainer, true);
            messages.addAll(ufsData.getMessages());
            for (Message message : messages) {
                this.logWarningMessage(message, document.getLocation());
            }
            document.setOwner(bookingFileContainer.toReference());
            document.setRelatedBookingFile(bookingFileContainer.toReference());
            document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
            messages.add(MessageHelper.createMessage((String)Messages.UFSExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_importTransactionCompleted, (Object[])new Object[]{ufsData.getTransactionType(), ufsData.getSystemNumber()}), (Object[])new Object[0]));
        } else {
            messages.add(MessageHelper.createErrorMessage((String)Messages.UFSExchangeProcessor_importFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_ticketAlreadyExist, (Object[])new Object[]{ufsData.getSystemNumber()}), (Object[])new Object[0]));
            document.setStatus(ProcessingStatus.ERROR);
        }
    }

    private void synchronizeSellAndRefundData(RailwayProduct sellProduct, RailwayProduct refundProduct) throws Exception {
        int refundProductSegmentNumber;
        for (RailwaySegment sellProductSegment : sellProduct.getSegments()) {
            int sellProductSegmentNumber = sellProductSegment.getNumber();
            for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                int refundProductSegmentNumber2 = refundProductSegment.getNumber();
                if (refundProductSegmentNumber2 != sellProductSegmentNumber) continue;
                refundProductSegment.setFare(sellProductSegment.getFare());
                refundProductSegment.setEquivalentFare(sellProductSegment.getEquivalentFare());
                refundProductSegment.setEquivalentVAT(sellProductSegment.getEquivalentVAT());
            }
        }
        refundProduct.getReservedSeats().clear();
        for (ReservedSeat sellProductReservedSeat : sellProduct.getReservedSeats()) {
            ReservedSeat refundProductReservedSeat = (ReservedSeat)XCloneHelper.clone((XCloneable)sellProductReservedSeat);
            refundProductReservedSeat.setSegment(null);
            RailwaySegment sellProductReservedSeatSegment = sellProductReservedSeat.getSegment();
            if (sellProductReservedSeatSegment != null) {
                int sellProductReservedSeatSegmentNumber = sellProductReservedSeatSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductReservedSeatSegmentNumber) continue;
                    refundProductReservedSeat.setSegment(refundProductSegment);
                }
            }
            refundProduct.getReservedSeats().add(refundProductReservedSeat);
        }
        refundProduct.getTaxes().clear();
        for (RailwayTax sellProductTax : sellProduct.getTaxes()) {
            RailwayTax refundProductTax = (RailwayTax)XCloneHelper.clone((XCloneable)sellProductTax);
            refundProductTax.setSegment(null);
            RailwaySegment sellProductTaxSegment = sellProductTax.getSegment();
            if (sellProductTaxSegment != null) {
                int sellProductTaxSegmentNumber = sellProductTaxSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductTaxSegmentNumber) continue;
                    refundProductTax.setSegment(refundProductSegment);
                }
            }
            refundProduct.getTaxes().add(refundProductTax);
        }
        refundProduct.setEquivalentFare(sellProduct.getEquivalentFare());
        refundProduct.setEquivalentVAT(sellProduct.getEquivalentVAT());
        refundProduct.setServiceFare(sellProduct.getServiceFare());
        refundProduct.setServiceVAT(sellProduct.getServiceVAT());
        if (sellProduct.getVendorVatDetalization() != null) {
            refundProduct.setVendorVatDetalization((VatDetalization)XCloneHelper.clone((XCloneable)sellProduct.getVendorVatDetalization(), (boolean)true));
        }
        BigDecimal sellTotalEquivalentFare = sellProduct.getTotalEquivalentFare();
        BigDecimal refundTotalEquivalentFare = refundProduct.getTotalEquivalentFare();
        BigDecimal penaltyFare = null;
        if (sellTotalEquivalentFare != null && refundTotalEquivalentFare != null) {
            penaltyFare = sellTotalEquivalentFare.subtract(refundTotalEquivalentFare);
        }
        BigDecimal penaltyVat = null;
        if (penaltyFare != null && penaltyFare.compareTo(BigDecimal.ZERO) != 0) {
            double vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.PENALTY, (Date)refundProduct.getIssueDate());
            VatAmount vatAmount = new VatAmount();
            vatAmount.setTotalVat(penaltyFare, vatRate);
            penaltyVat = vatAmount.getVatAmount();
            refundProduct.setPenalty(penaltyFare);
            refundProduct.setPenaltyVAT(penaltyVat);
            if (refundProduct.getVendorVatDetalization() != null) {
                VatComponent vatComponent = new VatComponent();
                vatComponent.setBasis(penaltyFare);
                vatComponent.setSum(penaltyVat);
                vatComponent.setRate(Double.valueOf(vatRate));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.PENALTY);
                refundProduct.getVendorVatDetalization().getComponents().add(vatComponent);
            }
        }
        BigDecimal sellTotalEquivalentVat = sellProduct.getTotalEquivalentVAT();
        BigDecimal refundTotalEquivalentVat = null;
        if (sellTotalEquivalentVat != null) {
            refundTotalEquivalentVat = sellTotalEquivalentVat;
        }
        if (penaltyVat != null) {
            refundTotalEquivalentVat = refundTotalEquivalentVat == null ? penaltyVat.negate() : refundTotalEquivalentVat.subtract(penaltyVat);
        }
        refundProduct.setTotalEquivalentVAT(refundTotalEquivalentVat);
    }

    private void updateProduct(RailwayProduct product, UFSRailwayData ufsData, List<Message> messages) throws Exception {
        ProductStatus status = RailwayProductParsersHelper.getStatus((TransactionType)ufsData.getTransactionType());
        String systemNumber = ufsData.getSystemNumber();
        Date issueDate = ufsData.getIssueDate();
        String blankTypeCode = ufsData.getBlankTypeCode();
        TicketType ticketType = ufsData.getTicketType();
        HashMap<Traveller, DictionaryReference<PassengerType>> travellers = new HashMap<Traveller, DictionaryReference<PassengerType>>();
        for (UFSRailwayData.TravellerData travellerData : ufsData.getTravellers()) {
            Traveller traveller = travellerData.getTraveller();
            DictionaryReference<PassengerType> passengerType = travellerData.getPassengerType();
            travellers.put(traveller, passengerType);
        }
        DictionaryReference<BlankType> blankType = this.findBlankType(blankTypeCode);
        ParsersHelper.SalesContextData salesContextData = ParsersHelper.getSalesContextData((String)ufsData.getBlankOwnerCode(), null, null, (String)ufsData.getAgentCode(), null, (String)ufsData.getPccCode(), (GdsName)GdsName.UFS, (Date)ufsData.getIssueDate(), messages);
        EntityReference blankOwner = salesContextData.getBlankOwner();
        EntityReference provider = salesContextData.getProvider();
        EntityReference supplier = salesContextData.getSupplier();
        EntityReference agency = salesContextData.getAgency();
        EntityReference subagency = salesContextData.getSubagency();
        EntityReference salesPoint = salesContextData.getSalesPoint();
        EntityReference agent = salesContextData.getAgent();
        String validatorCode = salesContextData.getValidatorCode();
        String pccCode = salesContextData.getPccCode();
        int number = 1;
        DictionaryReference<RailwayStation> departureStation = ufsData.getDepartureStation();
        DictionaryReference<RailwayStation> arriveStation = ufsData.getArriveStation();
        String trainNumber = ufsData.getTrainNumber();
        String slot = ufsData.getSlot();
        String carriageNumber = ufsData.getCarriageNumber();
        CarriageType carriageType = ufsData.getCarriageType();
        CompartmentType compartmentType = ufsData.getCompartmentType();
        ServiceClass serviceClass = ufsData.getServiceClass();
        List<String> places = ufsData.getPlaces();
        Date departureDate = ufsData.getDepartureDate();
        Date arriveDate = ufsData.getArriveDate();
        BigDecimal equivalentSegmentFare = ufsData.getSegmentAmount();
        Money segmentFare = null;
        if (equivalentSegmentFare != null) {
            segmentFare = new Money();
            segmentFare.setValue(equivalentSegmentFare);
            segmentFare.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
        }
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(number);
        segment.setDepartureStation(departureStation);
        segment.setArriveStation(arriveStation);
        segment.setTrainNumber(trainNumber);
        segment.setSlot(slot);
        segment.setCarriageNumber(carriageNumber);
        segment.setCarriageType(carriageType);
        segment.setCompartmentType(compartmentType);
        segment.setServiceClass(serviceClass);
        segment.getPlaces().clear();
        segment.getPlaces().addAll(places);
        segment.setDepartureDate(departureDate);
        segment.setArriveDate(arriveDate);
        segment.setFare(segmentFare);
        segment.setEquivalentFare(equivalentSegmentFare);
        BigDecimal equivalentReservedSeatAmount = ufsData.getReservedSeatAmount();
        Money reservedSeatAmount = null;
        if (equivalentReservedSeatAmount != null) {
            reservedSeatAmount = new Money();
            reservedSeatAmount.setValue(equivalentReservedSeatAmount);
            reservedSeatAmount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
        }
        ReservedSeat reservedSeat = new ReservedSeat();
        reservedSeat.setSegment(segment);
        reservedSeat.setFare(reservedSeatAmount);
        reservedSeat.setEquivalentFare(equivalentReservedSeatAmount);
        BigDecimal tariffAmount = ufsData.getTariffAmount();
        BigDecimal serviceAmount = ufsData.getServiceAmount();
        BigDecimal tariffVatAmount = ufsData.getTariffVatAmount();
        BigDecimal serviceVatAmount = ufsData.getServiceVatAmount();
        BigDecimal totalEquivalentFare = ufsData.getTotalAmount();
        BigDecimal totalEquivalentVAT = ufsData.getTotalVatAmount();
        VatDetalization vendorVatDetalization = new VatDetalization();
        if (tariffVatAmount != null || serviceVatAmount != null) {
            VatComponent vatComponent;
            double vatRate;
            vendorVatDetalization.setDetalized(true);
            vendorVatDetalization.getComponents().clear();
            if (tariffVatAmount != null) {
                vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)issueDate);
                vatComponent = new VatComponent();
                vatComponent.setBasis(tariffAmount);
                vatComponent.setSum(tariffVatAmount);
                vatComponent.setRate(Double.valueOf(vatRate));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.FARE);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
            if (serviceVatAmount != null) {
                vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate);
                vatComponent = new VatComponent();
                vatComponent.setBasis(serviceAmount);
                vatComponent.setSum(serviceVatAmount);
                vatComponent.setRate(Double.valueOf(vatRate));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.SERVICE);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
        }
        ArrayList<RailwayProductFop> vendorFOPs = new ArrayList<RailwayProductFop>();
        if (totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            vendorFOPs.add(fop);
        }
        ArrayList<RailwayProductFop> subagentFOPs = new ArrayList<RailwayProductFop>();
        if (agency != null && subagency != null && !agency.equals((Object)subagency) && totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            subagentFOPs.add(fop);
        }
        ArrayList<RailwayProductFop> clientFOPs = new ArrayList<RailwayProductFop>();
        if (totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            clientFOPs.add(fop);
        }
        product.setStatus(status);
        product.setSystemNumber(systemNumber);
        product.setIssueDate(issueDate);
        product.setValidatorCode(validatorCode);
        UFSExchangeProcessor.setValidatorRef(product, validatorCode);
        product.setPcc(pccCode);
        product.setEquivalentFare(tariffAmount);
        product.setEquivalentVAT(tariffVatAmount);
        product.setServiceFare(serviceAmount);
        product.setServiceVAT(serviceVatAmount);
        product.setTotalEquivalentFare(totalEquivalentFare);
        product.setTotalEquivalentVAT(totalEquivalentVAT);
        product.setVendorVatDetalization(vendorVatDetalization);
        product.getPassengers().clear();
        product.getPassengerTypes().clear();
        for (Map.Entry entry : travellers.entrySet()) {
            Traveller traveller = (Traveller)entry.getKey();
            DictionaryReference passengerType = (DictionaryReference)entry.getValue();
            product.getPassengers().add(traveller);
            RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, (DictionaryReference)passengerType);
        }
        product.setBlankType(blankType);
        product.setBlankOwnerRef(blankOwner);
        product.setProvider(provider);
        product.getSegments().clear();
        product.getSegments().add(segment);
        product.getReservedSeats().clear();
        product.getReservedSeats().add(reservedSeat);
        for (RailwayProductContractRelationData item : RailwayProductHelper.getContractRelations((RailwayProduct)product)) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    item.getFops().clear();
                    item.getFops().addAll(vendorFOPs);
                    break;
                }
                case SUBAGENCY: {
                    item.getFops().clear();
                    item.getFops().addAll(subagentFOPs);
                    break;
                }
                case CLIENT: {
                    item.getFops().clear();
                    item.getFops().addAll(clientFOPs);
                }
            }
        }
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, (EntityReference)supplier);
        RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)agency);
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)subagency);
        product.setSalesPoint(salesPoint);
        product.setCashier(agent);
        product.setTicketType(ticketType);
    }

    private static void setValidatorRef(RailwayProduct product, String code) {
        if (TextUtil.isBlank((String)code)) {
            return;
        }
        ValidatorIndex validatorIndex = ValidatorHelper.getValidatorIndex((String)code, (EntityReference)product.getBlankOwnerRef(), (String)product.getPcc(), (Date)product.getIssueDate());
        if (validatorIndex != null) {
            product.setValidatorRef(new NestedEntityReference(validatorIndex.getSource(), validatorIndex.getNavigationKey(), Validator.class, null));
        }
    }

    private void updateFakeProduct(RailwayProduct product, UFSRailwayData ufsData, List<Message> messages) {
        String systemNumber = ufsData.getSystemNumber();
        product.setSystemNumber(systemNumber);
        product.setStatus(ProductStatus.SELL);
        product.setTicketType(TicketType.FAKE);
    }

    private void updateBookingFile(EntityContainer<BookingFile> bookingFileContainer, RailwayProduct product, String pnr, List<Message> messages) throws Exception {
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        boolean updatedProduct = false;
        block0: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!basePoduct.getUid().equals(product.getUid())) continue;
                updatedProduct = true;
                continue block0;
            }
        }
        boolean bookingFileContainsNonFakeSell = false;
        boolean bookingFileContainsNonFakeRefund = false;
        block2: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL) {
                        bookingFileContainsNonFakeSell = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        bookingFileContainsNonFakeRefund = true;
                    }
                }
                if (!bookingFileContainsNonFakeSell || !bookingFileContainsNonFakeRefund) continue;
                continue block2;
            }
        }
        if (!bookingFileContainsNonFakeSell && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || !bookingFileContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
            bookingFile.setAgency(RailwayProductHelper.getAgency((RailwayProduct)product));
            bookingFile.setCreateDate(product.getIssueDate());
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)pnr, (GdsName)GdsName.UFS)) continue;
            boolean reservationContainsNonFakeSell = false;
            boolean reservationContainsNonFakeRefund = false;
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL) {
                        reservationContainsNonFakeSell = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        reservationContainsNonFakeRefund = true;
                    }
                }
                if (!reservationContainsNonFakeSell || !reservationContainsNonFakeRefund) continue;
                break;
            }
            if (!reservationContainsNonFakeSell && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || !reservationContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
                reservation.setBookingAgent(product.getCashier());
                reservation.setSalesPoint(product.getSalesPoint());
                reservation.setSubagency(RailwayProductHelper.getSubagency((RailwayProduct)product));
                reservation.setResDate(product.getIssueDate());
            }
            List productTravellers = product.getPassengers();
            List bookingTravellers = bookingFile.getTravellers();
            ArrayList<Traveller> updatedProductTravellers = new ArrayList<Traveller>();
            for (Traveller productTraveller : productTravellers) {
                boolean contains = false;
                for (Traveller bookingTraveller : bookingTravellers) {
                    if (!this.compareTravellers(productTraveller, bookingTraveller)) continue;
                    contains = true;
                    updatedProductTravellers.add(bookingTraveller);
                    break;
                }
                if (contains) continue;
                updatedProductTravellers.add(productTraveller);
                bookingTravellers.add(productTraveller);
            }
            productTravellers.clear();
            productTravellers.addAll(updatedProductTravellers);
            if (updatedProduct) break;
            product.setReservation(reservation);
            reservation.getProducts().add(product);
            break;
        }
    }

    private RailwayProduct getProduct(EntityContainer<BookingFile> bookingFileContainer, String systemNumber, ProductStatus status) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                RailwayProduct product;
                if (!(baseProduct instanceof RailwayProduct) || !TextUtil.isSame((String)(product = (RailwayProduct)baseProduct).getSystemNumber(), (String)systemNumber) || product.getStatus() != status) continue;
                return product;
            }
        }
        return null;
    }

    private boolean compareTravellers(Traveller traveller01, Traveller traveller02) {
        String fullName02;
        String fullName01;
        if (traveller01 == null && traveller02 == null) {
            return true;
        }
        if (traveller01 == null || traveller02 == null) {
            return false;
        }
        if (traveller01.getPassport() != null && traveller02.getPassport() != null) {
            fullName01 = TextUtil.buildFullName((PersonalName)traveller01.getPassport());
            fullName02 = TextUtil.buildFullName((PersonalName)traveller02.getPassport());
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        if (traveller01.getName() != null && traveller02.getName() != null) {
            fullName01 = traveller01.getName();
            fullName02 = traveller02.getName();
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        return false;
    }

    private DictionaryReference<BlankType> findBlankType(String blankTypeCode) {
        BlankType blankType;
        if (Environment.isPublished(DictionaryCache.class) && (blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, blankTypeCode)) != null) {
            return blankType.toReference();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeDocumentRegistrationResult registerExchangeFile(ExchangeFile exchangeFile) throws Exception {
        if (exchangeFile == null) {
            return ParsersHelper.createOkRegistrationResult();
        }
        this.log.debug(String.format("registering exchange file %s", exchangeFile.getLocation()));
        String user = LogicalStorage.get().getUser();
        String location = exchangeFile.getLocation();
        try {
            String checkSum = null;
            byte[] content = exchangeFile.getContent();
            if (content == null) {
                this.log.error(String.format("content of file %s is empty", location));
                this.addFakeDocument(user, exchangeFile, Arrays.asList(MessageHelper.createErrorMessage((String)Messages.UFSExchangeProcessor_fileRegisterFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_exchangeFileContentEmpty, (Object[])new Object[0]), (Object[])new Object[0])));
                return ParsersHelper.createOkRegistrationResult();
            }
            checkSum = MiscUtil.getCheckSum((byte[])content);
            EntityStorage entityStorage = EntityStorage.get();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"checkSum", (Object)checkSum));
            if (entityStorage.search(this.getIndexClass(), query).getData().size() > 0) {
                this.log.error(String.format("file %s is already registered", location));
                this.addFakeDocument(user, exchangeFile, Arrays.asList(MessageHelper.createErrorMessage((String)Messages.UFSExchangeProcessor_fileRegisterFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_exchangeFileAlreadyRegistered, (Object[])new Object[0]), (Object[])new Object[0])));
                return ParsersHelper.createOkRegistrationResult();
            }
            List<UFSRailwayData> ufsDataList = this.createDataList(exchangeFile);
            if (ufsDataList == null) {
                return ParsersHelper.createOkRegistrationResult();
            }
            LogicalSession managedSession = LogicalStorage.get().beginUnitOfWork();
            try {
                for (UFSRailwayData ufsData : ufsDataList) {
                    EntityContainer container = new EntityContainer(UFSExchangeDocument.class);
                    container.setCreatedBy(user);
                    container.setModifiedBy(user);
                    container.setCreated(new Date());
                    container.setModified(new Date());
                    UFSExchangeDocument ufsExchangeDocument = (UFSExchangeDocument)container.getEntity();
                    ufsExchangeDocument.setCreated(exchangeFile.getCreated());
                    ufsExchangeDocument.setCheckSum(checkSum);
                    ufsExchangeDocument.setTitle(location);
                    ufsExchangeDocument.setLocation(location);
                    ufsExchangeDocument.setContent(ufsData.getContent().getBytes("utf8"));
                    ufsExchangeDocument.setType(exchangeFile.getType());
                    ufsExchangeDocument.setContentType(ContentType.XML);
                    ufsExchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
                    ufsExchangeDocument.getMessages().clear();
                    ufsExchangeDocument.getMessages().addAll(ufsData.getMessages());
                    this.updateDocumentData(ufsExchangeDocument, ufsData);
                    EntityStorage.get().save(container, true);
                }
                LogicalStorage.get().endUnitOfWork(managedSession, true);
            }
            finally {
                LogicalStorage.get().cancelUnitOfWork(managedSession);
            }
            return ParsersHelper.createOkRegistrationResult();
        }
        catch (Exception e) {
            this.log.error(String.format("failed registering file %s", location), (Throwable)e);
            this.addFakeDocument(user, exchangeFile, Arrays.asList(MessageHelper.createErrorMessage((String)Messages.UFSExchangeProcessor_fileRegisterFailed, (String)this.getStackTrace(e), (Object[])new Object[0])));
            return ParsersHelper.createOkRegistrationResult();
        }
    }

    private List<UFSRailwayData> createDataList(ExchangeFile file) throws Exception {
        ArrayList<UFSRailwayData> ufsDataList = new ArrayList<UFSRailwayData>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(XUtil.createSource((InputStream)new ByteArrayInputStream(file.getContent()), (String)"utf8"));
        Element root = document.getDocumentElement();
        ArrayList<BlankInfo> blankInfos = new ArrayList<BlankInfo>();
        for (Element blankElement : XmlUtil.getElements((Element)root, (String)"Blank")) {
            String id = XHelper.readString((Element)blankElement, (String)"@ID");
            if (id == null) continue;
            BlankInfo blankInfo = new BlankInfo();
            blankInfo.setBlankElement(blankElement);
            for (Element passengerElement : XmlUtil.getElements((Element)root, (String)"Passenger")) {
                String blankId = XHelper.readString((Element)passengerElement, (String)"@BlankID");
                if (!TextUtil.isSame((String)id, (String)blankId, (boolean)true, (boolean)true)) continue;
                blankInfo.getPassengerElements().add(passengerElement);
            }
            blankInfos.add(blankInfo);
        }
        for (BlankInfo blankInfo : blankInfos) {
            for (Element blankElement : XmlUtil.getElements((Element)root, (String)"Blank")) {
                root.removeChild(blankElement);
            }
            for (Element passengerElement : XmlUtil.getElements((Element)root, (String)"Passenger")) {
                root.removeChild(passengerElement);
            }
            root.appendChild(blankInfo.getBlankElement());
            for (Element passengerElement : blankInfo.getPassengerElements()) {
                root.appendChild(passengerElement);
            }
            UFSRailwayData ufsData = this.createData(root);
            if (ufsData == null) continue;
            ufsDataList.add(ufsData);
        }
        return ufsDataList;
    }

    private UFSRailwayData createData(Element element) throws Exception {
        Iterator arriveStationsIterator;
        RailwayStation arriveLocation;
        Iterator departureStationsIterator;
        RailwayStation departureLocation;
        UFSRailwayData ufsData = null;
        HashSet<Message> messages = new HashSet<Message>();
        TransactionType transactionType = null;
        String transactionTypeCode = XHelper.readString((Element)element, (String)"Type");
        if (!TextUtil.isBlank((String)transactionTypeCode) && (transactionType = this.getTransactionType(transactionTypeCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_transactionTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_transactionTypeWithCodeNotSupported, (Object[])new Object[]{transactionTypeCode}), (Object[])new Object[0]));
        }
        String carrierInn = XHelper.readString((Element)element, (String)"CarrierInn");
        String pnr = null;
        if (transactionType == TransactionType.SELL) {
            pnr = XHelper.readString((Element)element, (String)"TransID");
        } else if (transactionType == TransactionType.REFUND) {
            pnr = XHelper.readString((Element)element, (String)"PrevTransID");
        }
        RailwayStationReference departureStation = null;
        String departureStationCode = XHelper.readString((Element)element, (String)"StationFrom@Code");
        Collection departureLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)departureStationCode);
        if (departureLocations.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithCodeMultipleFound, (Object[])new Object[]{departureStationCode}), (Object[])new Object[0]));
        }
        RailwayStation railwayStation = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
        if (departureLocation != null) {
            departureStation = departureLocation.toReference();
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithCodeNotFound, (Object[])new Object[]{departureStationCode}), (Object[])new Object[0]));
        }
        if (departureStation == null) {
            String departureStationShortName = XHelper.readString((Element)element, (String)"StationFrom");
            departureLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)departureStationShortName);
            if (departureLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithShortNameMultipleFound, (Object[])new Object[]{departureStationShortName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation2 = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
            if (departureLocation != null) {
                departureStation = departureLocation.toReference();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithShortNameNotFound, (Object[])new Object[]{departureStationShortName}), (Object[])new Object[0]));
            }
        }
        RailwayStationReference arriveStation = null;
        String arriveStationCode = XHelper.readString((Element)element, (String)"StationTo@Code");
        Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)arriveStationCode);
        if (arriveLocations.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithCodeMultipleFound, (Object[])new Object[]{arriveStationCode}), (Object[])new Object[0]));
        }
        RailwayStation railwayStation3 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
        if (arriveLocation != null) {
            arriveStation = arriveLocation.toReference();
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithCodeNotFound, (Object[])new Object[]{arriveStationCode}), (Object[])new Object[0]));
        }
        if (arriveLocation == null) {
            String arriveStationShortName = XHelper.readString((Element)element, (String)"StationTo");
            arriveLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)arriveStationShortName);
            if (arriveLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithShortNameMultipleFound, (Object[])new Object[]{arriveStationShortName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation4 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
            if (arriveLocation != null) {
                arriveStation = arriveLocation.toReference();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithShortNameNotFound, (Object[])new Object[]{arriveStationShortName}), (Object[])new Object[0]));
            }
        }
        Date issueDate = null;
        String issueDateString = XHelper.readString((Element)element, (String)"ConfirmTime");
        if (!TextUtil.isBlank((String)issueDateString)) {
            try {
                issueDate = this.getDateTimeFormat().parse(issueDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_issueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        Date departureDate = null;
        String departureDateString = XHelper.readString((Element)element, (String)"DepartTime");
        if (!TextUtil.isBlank((String)departureDateString)) {
            try {
                departureDate = this.getDateTimeFormat().parse(departureDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        Date arriveDate = null;
        String arriveDateString = XHelper.readString((Element)element, (String)"ArrivalTime");
        if (!TextUtil.isBlank((String)arriveDateString)) {
            try {
                arriveDate = this.getDateTimeFormat().parse(arriveDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        String trainData = XHelper.readString((Element)element, (String)"TrainNum");
        String pattern = "^([\\d]+)([\\D]*)$";
        Matcher matcher = Pattern.compile(pattern).matcher(trainData);
        String trainNumber = null;
        String slot = null;
        if (matcher.matches()) {
            trainNumber = matcher.group(1);
            slot = matcher.group(2);
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_trainDataDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dataHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
        }
        String carriageNumber = XHelper.readString((Element)element, (String)"CarNum");
        CarriageType carriageType = null;
        String carriageTypeCode = XHelper.readString((Element)element, (String)"CarType");
        if (!TextUtil.isBlank((String)carriageTypeCode) && (carriageType = this.getCarriageType(carriageTypeCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_carriageTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_carriageTypeWithCodeNotSupported, (Object[])new Object[]{carriageTypeCode}), (Object[])new Object[0]));
        }
        String agentCode = XHelper.readString((Element)element, (String)"Terminal");
        String pccCode = XHelper.readString((Element)element, (String)"Terminal");
        CompartmentType compartmentType = null;
        String compartmentTypeCode = XHelper.readString((Element)element, (String)"GenderClass");
        if (!TextUtil.isBlank((String)compartmentTypeCode)) {
            compartmentType = this.getCompartmentType(compartmentTypeCode);
            if (compartmentType == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_compartmentTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_compartmentTypeWithCodeNotSupported, (Object[])new Object[]{compartmentTypeCode}), (Object[])new Object[0]));
            }
        } else {
            compartmentType = CompartmentType.COMMON;
        }
        ServiceClass serviceClass = null;
        String serviceClassCode = XHelper.readString((Element)element, (String)"ServiceClass");
        if (!TextUtil.isBlank((String)serviceClassCode) && (serviceClass = this.getServiceClass(serviceClassCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_serviceClassDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_serviceClassWithCodeNotSupported, (Object[])new Object[]{serviceClassCode}), (Object[])new Object[0]));
        }
        String systemNumber = null;
        BigDecimal totalAmount = null;
        BigDecimal tariffAmount = null;
        BigDecimal serviceAmount = null;
        BigDecimal totalVatAmount = null;
        BigDecimal tariffVatAmount = null;
        BigDecimal serviceVatAmount = null;
        BigDecimal segmentAmount = null;
        BigDecimal reservedSeatAmount = null;
        Element blankElement = XmlUtil.getElement((Element)element, (String)"Blank");
        if (blankElement != null) {
            String reservedSeatAmountString;
            String segmentAmountAmountString;
            String string;
            String totalVatAmountString;
            systemNumber = XHelper.readString((Element)blankElement, (String)"TicketNum");
            String totalAmountString = XHelper.readString((Element)blankElement, (String)"Amount");
            if (!TextUtil.isBlank((String)totalAmountString)) {
                try {
                    totalAmount = new BigDecimal(totalAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankTotalAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (!TextUtil.isBlank((String)(totalVatAmountString = XHelper.readString((Element)blankElement, (String)"AmountNDS")))) {
                try {
                    totalVatAmount = new BigDecimal(totalVatAmountString);
                }
                catch (NumberFormatException numberFormatException) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankTotalVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (!TextUtil.isBlank((String)(string = XHelper.readString((Element)blankElement, (String)"ServiceNDS")))) {
                try {
                    serviceVatAmount = new BigDecimal(string);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankServiceVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (totalVatAmount != null && serviceVatAmount != null) {
                tariffVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalVatAmount, MiscUtil.negate((BigDecimal)serviceVatAmount)});
            }
            double vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate);
            if (totalAmount != null && serviceVatAmount != null && vatRate != 0.0) {
                serviceAmount = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(serviceVatAmount.doubleValue() / vatRate * (100.0 + vatRate)), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                tariffAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, MiscUtil.negate((BigDecimal)serviceAmount)});
            }
            if (!TextUtil.isBlank((String)(segmentAmountAmountString = XHelper.readString((Element)blankElement, (String)"TicketAmount")))) {
                try {
                    segmentAmount = new BigDecimal(segmentAmountAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankSegmentAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (!TextUtil.isBlank((String)(reservedSeatAmountString = XHelper.readString((Element)blankElement, (String)"ReservedSeatAmount")))) {
                try {
                    reservedSeatAmount = new BigDecimal(reservedSeatAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankReservedSeatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
        }
        ArrayList<UFSRailwayData.TravellerData> travellers = new ArrayList<UFSRailwayData.TravellerData>();
        ArrayList<String> places = new ArrayList<String>();
        for (Element passengerElement : XmlUtil.getElements((Element)element, (String)"Passenger")) {
            String placesData;
            String passengerTypeCode;
            DictionaryReference<PassengerType> passengerType;
            Traveller traveller = new Traveller();
            Passport passport = new Passport();
            PassportType passportType = null;
            String passportTypeCode = XHelper.readString((Element)passengerElement, (String)"DocType");
            if (!TextUtil.isBlank((String)passportTypeCode) && (passportType = this.getPassportType(passportTypeCode)) == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_travellerPassportTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_passportTypeWithCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
            }
            if ((passengerType = UFSHelper.getPassengerType(passengerTypeCode = XHelper.readString((Element)passengerElement, (String)"Type"))) == null) {
                messages.add(MessageHelper.createWarningMessage((String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_PassengerTypeNotFound, (Object[])new Object[]{passengerTypeCode}), (Object[])new Object[0]));
            }
            String passportNumber = XHelper.readString((Element)passengerElement, (String)"DocNum");
            String name = XHelper.readString((Element)passengerElement, (String)"Name");
            if (!TextUtil.isBlank((String)name)) {
                name = name.replaceAll("[\\d-]", "");
            }
            if (!TextUtil.isBlank((String)(placesData = XHelper.readString((Element)passengerElement, (String)"Place")))) {
                for (String place : placesData.trim().split(",")) {
                    if (place.contains("-")) {
                        String[] values = place.split("-");
                        if (values.length != 2) continue;
                        Integer startPlace = null;
                        Integer endPlace = null;
                        try {
                            startPlace = Integer.valueOf(values[0].trim());
                            endPlace = Integer.valueOf(values[1].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_railwayProductPlaceDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[]{passportTypeCode.trim()}), (Object[])new Object[0]));
                        }
                        if (startPlace == null || endPlace == null || startPlace > endPlace) continue;
                        for (int i = startPlace.intValue(); i <= endPlace; ++i) {
                            places.add(String.valueOf(i));
                        }
                        continue;
                    }
                    places.add(place);
                }
            }
            passport.setType(passportType);
            passport.setNumber(passportNumber);
            TextUtil.splitFullName((String)name, (PersonalName)passport);
            traveller.setName(name);
            traveller.setCyrillicName(TextUtil.translit((String)name, (boolean)false));
            traveller.setPassport(passport);
            UFSRailwayData.TravellerData travellerData = new UFSRailwayData.TravellerData();
            travellerData.setTraveller(traveller);
            travellerData.setPassengerType(passengerType);
            travellers.add(travellerData);
        }
        String string = BLANK_TYPE_CODE;
        String blankOwnerCode = BLANK_OWNER_CODE;
        TicketType ticketType = TicketType.OWN;
        ufsData = new UFSRailwayData();
        ufsData.setContent(XUtil.toString((Element)element, (String)"utf8"));
        ufsData.setCarrierInn(carrierInn);
        ufsData.setTransactionType(transactionType);
        ufsData.setPnr(pnr);
        ufsData.setDepartureStation((DictionaryReference<RailwayStation>)departureStation);
        ufsData.setArriveStation((DictionaryReference<RailwayStation>)arriveStation);
        ufsData.setSystemNumber(systemNumber);
        ufsData.setIssueDate(issueDate);
        ufsData.setDepartureDate(departureDate);
        ufsData.setArriveDate(arriveDate);
        ufsData.setTrainNumber(trainNumber);
        ufsData.setSlot(slot);
        ufsData.setCarriageNumber(carriageNumber);
        ufsData.setCarriageType(carriageType);
        ufsData.setAgentCode(agentCode);
        ufsData.setPccCode(pccCode);
        ufsData.setTotalAmount(totalAmount);
        ufsData.setTariffAmount(tariffAmount);
        ufsData.setServiceAmount(serviceAmount);
        ufsData.setTotalVatAmount(totalVatAmount);
        ufsData.setTariffVatAmount(tariffVatAmount);
        ufsData.setServiceVatAmount(serviceVatAmount);
        ufsData.setSegmentAmount(segmentAmount);
        ufsData.setReservedSeatAmount(reservedSeatAmount);
        ufsData.setCompartmentType(compartmentType);
        ufsData.setServiceClass(serviceClass);
        ufsData.setBlankTypeCode(string);
        ufsData.setBlankOwnerCode(blankOwnerCode);
        ufsData.setTicketType(ticketType);
        ufsData.getTravellers().clear();
        ufsData.getTravellers().addAll(travellers);
        ufsData.getPlaces().clear();
        ufsData.getPlaces().addAll(places);
        ufsData.getMessages().clear();
        ufsData.getMessages().addAll(messages);
        return ufsData;
    }

    private DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    private void updateDocumentData(UFSExchangeDocument index, UFSRailwayData ufsData) {
        index.setSystemNumber(ufsData.getSystemNumber());
        index.setTransactionType(ufsData.getTransactionType());
        index.setIssued(ufsData.getIssueDate());
        index.getTravellers().clear();
        for (UFSRailwayData.TravellerData traveller : ufsData.getTravellers()) {
            index.getTravellers().add(traveller.getTraveller().getName());
        }
    }

    private CarriageType getCarriageType(String carriageTypeCode) {
        if (!TextUtil.isBlank((String)carriageTypeCode)) {
            if (carriageTypeCode.equals("\u041b")) {
                return CarriageType.L;
            }
            if (carriageTypeCode.equals("\u041c")) {
                return CarriageType.M;
            }
            if (carriageTypeCode.equals("\u041a")) {
                return CarriageType.K;
            }
            if (carriageTypeCode.equals("\u041f")) {
                return CarriageType.P;
            }
            if (carriageTypeCode.equals("\u0421")) {
                return CarriageType.S;
            }
            if (carriageTypeCode.equals("\u041e")) {
                return CarriageType.O;
            }
        }
        return null;
    }

    private TransactionType getTransactionType(String transactionTypeCode) {
        if (!TextUtil.isBlank((String)transactionTypeCode)) {
            if (transactionTypeCode.equals("1")) {
                return TransactionType.SELL;
            }
            if (transactionTypeCode.equals("14")) {
                return TransactionType.REFUND;
            }
            if (transactionTypeCode.equals("13")) {
                return TransactionType.CANCEL;
            }
        }
        return null;
    }

    private CompartmentType getCompartmentType(String compartmentTypeCode) {
        if (!TextUtil.isBlank((String)compartmentTypeCode)) {
            if (compartmentTypeCode.equals("0")) {
                return CompartmentType.COMMON;
            }
            if (compartmentTypeCode.equals("1")) {
                return CompartmentType.MEN;
            }
            if (compartmentTypeCode.equals("2")) {
                return CompartmentType.WOMEN;
            }
        }
        return null;
    }

    private ServiceClass getServiceClass(String serviceClassCode) {
        if (!TextUtil.isBlank((String)serviceClassCode)) {
            return RzdServiceConverter.getServiceClassByName(serviceClassCode);
        }
        return null;
    }

    private PassportType getPassportType(String passportTypeCode) {
        if (!TextUtil.isBlank((String)passportTypeCode)) {
            if (passportTypeCode.equals("\u041f\u041d")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0421\u0420")) {
                return PassportType.BIRTHDAY_NOTIFICATION;
            }
            if (passportTypeCode.equals("\u0417\u041f")) {
                return PassportType.FOREIGN;
            }
            if (passportTypeCode.equals("\u0417\u0417")) {
                return PassportType.PASSPORT;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStackTrace(Exception e) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            e.printStackTrace(new PrintStream((OutputStream)baos, true, "utf-8"));
            String string = baos.toString("utf-8");
            return string;
        }
    }

    private void addFakeDocument(String user, ExchangeFile file, List<Message> messages) throws Exception {
        EntityContainer container = new EntityContainer(UFSExchangeDocument.class);
        container.setCreatedBy(user);
        container.setModifiedBy(user);
        container.setCreated(new Date());
        container.setModified(new Date());
        UFSExchangeDocument document = (UFSExchangeDocument)container.getEntity();
        document.setCreated(file.getCreated());
        document.setCheckSum(null);
        document.setLocation(file.getLocation());
        document.setContent(file.getContent());
        document.setType(file.getType());
        document.setStatus(ProcessingStatus.ERROR);
        document.setContentType(ContentType.XML);
        document.getMessages().clear();
        document.getMessages().addAll(messages);
        for (Message message : messages) {
            this.logErrorMessage(message, file.getLocation());
        }
        EntityStorage.get().save(container, true);
    }

    private void logErrorMessage(Message message, String fileName) {
        String errorString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.error(String.format("File \"%s\" was processed with error:\n%s", fileName, errorString));
            return;
        }
        this.log.error(String.format("File \"%s\" was processed with error:\n%s\nDetails: %s", fileName, errorString, message.getDetails()));
    }

    private void logWarningMessage(Message message, String fileName) {
        String warningString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.warn(String.format("File \"%s\" was processed with warning:\n%s", fileName, warningString));
            return;
        }
        this.log.debug(String.format("File \"%s\" was processed with warning:\n%s\nDetails: %s", fileName, warningString, message.getDetails()));
    }

    private static class BlankInfo {
        private Element blankElement;
        private final List<Element> passengerElements = new ArrayList<Element>();

        private BlankInfo() {
        }

        public Element getBlankElement() {
            return this.blankElement;
        }

        public void setBlankElement(Element blankElement) {
            this.blankElement = blankElement;
        }

        public List<Element> getPassengerElements() {
            return this.passengerElements;
        }
    }
}

