/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.ufs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.parsers.ExchangeProcessor;
import com.gridnine.xtrip.server.parsers.ExchangeProcessorRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UFSServlet
extends HttpServlet {
    public static final String REQUEST_BODY_ENCODING = "utf8";
    public static final String RESPONSE_SUCCEFULL_CODE = "OK";
    public static final String STORE_ENCODING = "utf8";
    private static final long serialVersionUID = 2089509337034971945L;
    protected final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dump(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            boolean authorize = false;
            try {
                LogicalStorage.get().authorizeAsSystem();
                authorize = true;
            }
            catch (Exception e) {
                this.log.error("unable to authorize on ufs online request", (Throwable)e);
            }
            if (authorize) {
                this.processRequest(request);
            }
        }
        finally {
            this.processResponse(response);
            LogicalStorage.reset();
        }
    }

    private void processRequest(HttpServletRequest request) {
        try {
            this.log.debug("ufs online request process start");
            this.log.debug("ufs online request requestHeader:\n\n" + this.createHeaderString(request));
            StringBuilder body = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "utf8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                body.append(line);
                body.append("\n");
            }
            this.log.debug("ufs online request body:\n\n" + body.toString());
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            Date date = new Date();
            String name = String.format("ufs_online_%s.xml", format.format(date));
            String content = body.toString();
            ExchangeFile exchangeFile = new ExchangeFile();
            exchangeFile.setType("UFS");
            exchangeFile.setCreated(new Date());
            exchangeFile.setLocation(name);
            exchangeFile.setContent(content.getBytes("utf8"));
            try {
                this.log.debug("ufs online exchange file register process start");
                ExchangeProcessor processor = ((ExchangeProcessorRegistry)Environment.getPublished(ExchangeProcessorRegistry.class)).get("com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument");
                processor.registerExchangeFile(exchangeFile);
                this.log.debug("ufs online exchange file register process end");
            }
            catch (Exception e) {
                this.log.error("unable to register ufs online exchange file", (Throwable)e);
            }
            this.log.debug("ufs online request process end");
        }
        catch (IOException ioe) {
            this.log.error("unable to process ufs online request", (Throwable)ioe);
        }
    }

    private void processResponse(HttpServletResponse response) throws IOException {
        this.log.debug("ufs online response process start");
        PrintWriter writer = response.getWriter();
        writer.write(RESPONSE_SUCCEFULL_CODE);
        writer.flush();
        this.log.debug("ufs online response process end");
    }

    private String createHeaderString(HttpServletRequest request) throws IOException {
        StringBuilder headerString = new StringBuilder();
        headerString.append("method = " + request.getMethod());
        headerString.append("\n");
        Enumeration headerNamesEnumerator = request.getHeaderNames();
        while (headerNamesEnumerator.hasMoreElements()) {
            String headerName = (String)headerNamesEnumerator.nextElement();
            Enumeration headersEnumerator = request.getHeaders(headerName);
            while (headersEnumerator.hasMoreElements()) {
                String headerValue = (String)headersEnumerator.nextElement();
                headerString.append(headerName + " = " + headerValue);
                headerString.append("\n");
            }
        }
        headerString.append("\n");
        return URLDecoder.decode(headerString.toString(), "utf-8");
    }

    private void dump(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        try {
            String dump = this.createDump(request);
            this.log.debug(String.format("request ok:\n%s", dump.toString()));
            writer.write("<h1>OK</h1>");
            writer.write("<hr>");
            writer.write(String.format("<pre>%s</pre>", dump.toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")));
        }
        catch (IOException e) {
            this.log.debug(String.format("request error:\n%s", e.getMessage()));
            writer.write("<h1>ERROR</h1>");
            writer.write("<hr>");
            writer.write(String.format("<pre>%s</pre>", URLDecoder.decode(e.getMessage(), "utf-8").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")));
        }
        writer.flush();
    }

    private String createDump(HttpServletRequest request) throws IOException {
        StringBuilder dump = new StringBuilder();
        dump.append("HEADER");
        dump.append("\n\n");
        Enumeration headerNamesEnumerator = request.getHeaderNames();
        dump.append("method -> " + request.getMethod());
        dump.append("\n");
        while (headerNamesEnumerator.hasMoreElements()) {
            String headerName = (String)headerNamesEnumerator.nextElement();
            Enumeration headersEnumerator = request.getHeaders(headerName);
            while (headersEnumerator.hasMoreElements()) {
                String header = (String)headersEnumerator.nextElement();
                dump.append(headerName + " -> " + header);
                dump.append("\n");
            }
        }
        dump.append("\n");
        dump.append("BODY");
        dump.append("\n\n");
        StringBuilder body = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "utf8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            body.append(line);
            body.append("\n");
        }
        String[] parameters = body.toString().split("&");
        body = new StringBuilder();
        for (String parameter : parameters) {
            String[] tokens = parameter.split("=");
            if (tokens.length > 0) {
                body.append(tokens[0]);
            }
            if (tokens.length > 1) {
                body.append(" -> " + tokens[1]);
            }
            body.append("\n");
        }
        dump.append(body.toString());
        return URLDecoder.decode(dump.toString(), "utf8");
    }

    public void init() throws ServletException {
        super.init();
    }
}

