/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.reports.prepare.agentreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayReferenceMcoHelper;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayAgentReportProductPrepareHandler
implements AgentReportProductPrepareHandler<RailwayProduct> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public AgentReportProductPrepareHandler.ProductsListProxy<RailwayProduct> getProducts(AgentReportParameters parameters, List<Message> messages) throws Exception {
        EntityReference agentReference;
        AgentReportProductPrepareHandler.ProductsListProxy proxy = new AgentReportProductPrepareHandler.ProductsListProxy();
        EntityReference agencyReference = parameters.getAgency();
        EntityStorage entityStorage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.subagency.name(), (Object)agencyReference));
        }
        if ((agentReference = parameters.getAgent()) == null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)RailwayProductIndex.Property.issueDate.name(), (Object)parameters.getPeriodBegin()), SearchCriterion.le((String)RailwayProductIndex.Property.issueDate.name(), (Object)parameters.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)RailwayProductIndex.Property.dateOfClientPayment.name(), (Object)parameters.getPeriodBegin()), SearchCriterion.le((String)RailwayProductIndex.Property.dateOfClientPayment.name(), (Object)parameters.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)RailwayProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)RailwayProductIndex.Property.cancellationDate.name(), (Object)parameters.getPeriodBegin()), SearchCriterion.le((String)RailwayProductIndex.Property.cancellationDate.name(), (Object)parameters.getPeriodEnd())})}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)RailwayProductIndex.Property.issueDate.name(), (Object)parameters.getPeriodBegin()), SearchCriterion.le((String)RailwayProductIndex.Property.issueDate.name(), (Object)parameters.getPeriodEnd()), SearchCriterion.eq((String)RailwayProductIndex.Property.agent.name(), (Object)agentReference)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)RailwayProductIndex.Property.dateOfClientPayment.name(), (Object)parameters.getPeriodBegin()), SearchCriterion.le((String)RailwayProductIndex.Property.dateOfClientPayment.name(), (Object)parameters.getPeriodEnd()), SearchCriterion.eq((String)RailwayProductIndex.Property.clientFopAgent.name(), (Object)agentReference)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)RailwayProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)RailwayProductIndex.Property.cancellationDate.name(), (Object)parameters.getPeriodBegin()), SearchCriterion.le((String)RailwayProductIndex.Property.cancellationDate.name(), (Object)parameters.getPeriodEnd())})}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.VOID_BOOKING));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        Set blankOwnerReferences = parameters.getVendors();
        HashSet<EntityContainer> blankOwnerContainers = new HashSet<EntityContainer>();
        for (Object reference : blankOwnerReferences) {
            EntityContainer container = EntityStorage.get().resolve((EntityReference)reference);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)Messages.RailwayAgentReportProductPrepareHandler_cantLoadProfile, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{reference});
                return proxy;
            }
            blankOwnerContainers.add(container);
        }
        if (!blankOwnerContainers.isEmpty()) {
            HashSet<SearchCriterion> blankOwnerCriterions = new HashSet<SearchCriterion>();
            for (EntityContainer container : blankOwnerContainers) {
                String blankOwnerCode = ((Organization)container.getEntity()).getCode();
                if (TextUtil.isBlank((String)blankOwnerCode)) {
                    SystemHelper.addMessage(messages, (String)Messages.RailwayAgentReportProductPrepareHandler_profileBlankOwnerNoCode, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{container.toReference()});
                    return proxy;
                }
                blankOwnerCriterions.add(SearchCriterion.eq((String)RailwayProductIndex.Property.blankOwnerCode.name(), (Object)blankOwnerCode));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])blankOwnerCriterions.toArray(new SearchCriterion[blankOwnerCriterions.size()])));
        }
        HashSet<String> productUidList = new HashSet<String>();
        HashSet<EntityReference> bookingFileReferences = new HashSet<EntityReference>();
        for (RailwayProductIndex index : EntityStorage.get().search(RailwayProductIndex.class, query).getData()) {
            productUidList.add(index.getNavigationKey());
            bookingFileReferences.add(index.getSource());
        }
        for (EntityReference reference : bookingFileReferences) {
            EntityContainer container = entityStorage.resolve(reference);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{reference});
                this.log.error("unable to load booking file container " + reference.getUid());
                return proxy;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation reservation : bookingFile.getReservations()) {
                block5: for (BaseProduct baseProduct : reservation.getProducts()) {
                    String uid = baseProduct.getUid();
                    for (String productUid : productUidList) {
                        if (!productUid.equals(uid) || !(baseProduct instanceof RailwayProduct) || !this.isIssuedInReportPeriod(parameters, (RailwayProduct)baseProduct) && !this.isPayedInReportPeriod(parameters, (RailwayProduct)baseProduct, true) && !this.isRefusedInReportPeriod(parameters, (RailwayProduct)baseProduct, true)) continue;
                        RailwayProduct product = (RailwayProduct)baseProduct;
                        proxy.getProducts().add(product);
                        if (product.getBlankOwnerRef() != null) {
                            proxy.getActualVendors().add(product.getBlankOwnerRef());
                        }
                        if (!this.isIssuedInReportPeriod(parameters, product) || product.getSalesPoint() == null) continue block5;
                        proxy.getActualSalesPoints().add(product.getSalesPoint());
                        continue block5;
                    }
                }
            }
        }
        return proxy;
    }

    private boolean isIssuedInReportPeriod(AgentReportParameters parameters, RailwayProduct product) {
        if (parameters.getPeriodBegin() != null && (product.getIssueDate() == null || product.getIssueDate().before(parameters.getPeriodBegin()))) {
            return false;
        }
        if (parameters.getPeriodEnd() != null && (product.getIssueDate() == null || product.getIssueDate().after(parameters.getPeriodEnd()))) {
            return false;
        }
        return parameters.getAgent() == null || parameters.getAgent().equals((Object)product.getCashier());
    }

    private boolean isIssuedInReportPeriod(AgentReportParameters parameters, RailwayReferenceMCO mco) {
        if (parameters.getPeriodBegin() != null && (mco.getIssueDate() == null || mco.getIssueDate().before(parameters.getPeriodBegin()))) {
            return false;
        }
        return parameters.getPeriodEnd() == null || mco.getIssueDate() != null && !mco.getIssueDate().after(parameters.getPeriodEnd());
    }

    private boolean isPayedInReportPeriod(AgentReportParameters parameters, RailwayProduct product, boolean checkAgent) {
        for (RailwayProductFop fop : RailwayProductHelper.getClientFops((RailwayProduct)product)) {
            if (fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)parameters.getPeriodBegin(), (Date)parameters.getPeriodEnd(), (Date)fop.getOperationDate()) || checkAgent && parameters.getAgent() != null && !parameters.getAgent().equals((Object)fop.getAgent())) continue;
            return true;
        }
        return false;
    }

    public boolean isRefusedInReportPeriod(AgentReportParameters parameters, RailwayProduct product, boolean checkAgent) {
        for (RailwayProductFop fop : RailwayProductHelper.getClientFops((RailwayProduct)product)) {
            if (!fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)parameters.getPeriodBegin(), (Date)parameters.getPeriodEnd(), (Date)fop.getOperationDate()) || checkAgent && parameters.getAgent() != null && !parameters.getAgent().equals((Object)fop.getAgent())) continue;
            return true;
        }
        return false;
    }

    public void validateProducts(Collection<RailwayProduct> products, List<Message> messages) throws Exception {
        for (RailwayProduct product : products) {
            BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)product, messages);
        }
    }

    public List<AgentReportTicket> createTickets(RailwayProduct product, Map<String, Object> data) {
        ArrayList<AgentReportTicket> tickets = new ArrayList<AgentReportTicket>();
        AgentReportTicket ticket = this.createProductTicket(product, data);
        tickets.add(ticket);
        RailwayReferenceMCO referenceMco = RailwayReferenceMcoHelper.findReferenceMco((RailwayProduct)product);
        if (referenceMco != null) {
            ticket = this.createMcoTicket(referenceMco, ticket, data);
            tickets.add(ticket);
        }
        return tickets;
    }

    private AgentReportTicket createProductTicket(RailwayProduct product, Map<String, Object> data) {
        BigDecimal otherTaxes;
        List messages = (List)data.get("key-messages");
        String retailTravellerUid = (String)data.get("RETAIL_TRAVELLER_UID");
        AgentReportParameters parameters = (AgentReportParameters)data.get("key-report-params");
        AgentReportTicket ticket = new AgentReportTicket();
        ProductStatus status = product.getStatus();
        ticket.setUid(product.getUid());
        ticket.setStatus(status);
        ticket.setTicketNumber(product.getSystemNumber());
        ticket.setBlankOwner(product.getBlankOwnerRef());
        try {
            EntityStorage.get().actualize(ticket.getBlankOwner(), new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            EntityStorage.get().actualize(RailwayProductHelper.getSupplier((BaseProduct)product), new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
        }
        catch (Exception e1) {
            this.log.error("unable to actualize reference " + ticket.getBlankOwner(), (Throwable)e1);
        }
        ticket.setGroupName(this.getGroupName((BaseProduct)product));
        BigDecimal totalEquivalentFare = product.getTotalEquivalentFare();
        if (totalEquivalentFare == null) {
            totalEquivalentFare = BigDecimal.ZERO;
        }
        if ((otherTaxes = RailwayProductHelper.calculateTaxesFare((RailwayProduct)product)) == null) {
            otherTaxes = BigDecimal.ZERO;
        }
        ticket.setEquivalentFare(status != ProductStatus.VOID ? totalEquivalentFare.subtract(otherTaxes) : BigDecimal.ZERO);
        ticket.setTicketSeries(RailwayProductHelper.getTicketSeries((RailwayProduct)product));
        ticket.setIssueDate(product.getIssueDate());
        ticket.resetFinanceFields(false);
        if (status != ProductStatus.VOID && status != ProductStatus.VOID_BOOKING && product.getReservation() != null && product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomerProfile() != null && !product.getReservation().getBookingFile().getCustomerProfile().getUid().equals(retailTravellerUid)) {
            EntityReference customerProfile = product.getReservation().getBookingFile().getCustomerProfile();
            EntityStorage.get().actualize(customerProfile, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            ticket.setRemarks(customerProfile.getCaption());
        }
        Date sellIssueDate = product.getIssueDate();
        if (status == ProductStatus.REFUND && product.getPreviousProduct() != null) {
            sellIssueDate = product.getPreviousProduct().getIssueDate();
        }
        ticket.setSellIssueDate(sellIssueDate);
        ticket.setIssuedInReportPeriod(this.isIssuedInReportPeriod(parameters, product));
        ticket.setPayedInReportPeriod(this.isPayedInReportPeriod(parameters, product, false) && !this.isIssuedInReportPeriod(parameters, product));
        ticket.setRefusedInReportPeriod(this.isRefusedInReportPeriod(parameters, product, false));
        ticket.setSortingTicketNumber(ticket.getTicketSeries() + ticket.getTicketNumber());
        if (status == ProductStatus.VOID || status == ProductStatus.VOID_BOOKING) {
            ticket.setRouteLine("VOID");
        } else {
            ticket.setRouteLine(RailwayProductHelper.getShortRouteString((RailwayProduct)product));
        }
        if (status == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.RailwayAgentReportProductPrepareHandler_ticketNoState, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            return ticket;
        }
        if (status == ProductStatus.VOID) {
            return ticket;
        }
        ticket.setOtherTaxesAmount(otherTaxes);
        List<RailwayProductFop> allFops = RailwayAgentReportProductPrepareHandler.collectProductFops(product, true, messages);
        if (allFops.isEmpty()) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.RailwayAgentReportProductPrepareHandler_ticketNoFopInfo, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            return ticket;
        }
        for (PaymentType paymentType : PaymentType.values()) {
            this.updateValue(ticket.getTotals(), allFops, paymentType, FopType.TOTAL, product, parameters.getPeriodBegin(), parameters.getPeriodEnd(), (EntityReference<Person>)parameters.getAgent(), messages);
            this.updateValue(ticket.getFees(), allFops, paymentType, FopType.FEE, product, parameters.getPeriodBegin(), parameters.getPeriodEnd(), (EntityReference<Person>)parameters.getAgent(), messages);
            this.updateValue(ticket.getFeesForRefund(), allFops, paymentType, FopType.FEE_FOR_REFUND, product, parameters.getPeriodBegin(), parameters.getPeriodEnd(), (EntityReference<Person>)parameters.getAgent(), messages);
        }
        if (status == ProductStatus.REFUND) {
            ticket.setEquivalentFare(ticket.getEquivalentFare().negate());
            ticket.setOtherTaxesAmount(ticket.getOtherTaxesAmount().negate());
            for (Map.Entry entry : ticket.getTotals().entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).negate());
            }
            for (Map.Entry entry : ticket.getFees().entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).negate());
            }
            for (Map.Entry entry : ticket.getFeesForRefund().entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).negate());
            }
        }
        return ticket;
    }

    private String getGroupName(BaseProduct product) {
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        if (GeneralProductHelper.getSupplier((BaseProduct)product) == null) {
            return handler.getBlankOwner(product) == null ? "\u0416/\u0414" : String.format("%s (\u0436/\u0434)", handler.getBlankOwner(product));
        }
        if (GeneralProductHelper.getSupplier((BaseProduct)product).equals((Object)handler.getBlankOwner(product))) {
            return String.format("%s (\u0436/\u0434)", handler.getBlankOwner(product));
        }
        return String.format("%s (\u0436/\u0434, %s)", handler.getBlankOwner(product), GeneralProductHelper.getSupplier((BaseProduct)product));
    }

    private AgentReportTicket createMcoTicket(RailwayReferenceMCO referenceMco, AgentReportTicket relatedTicket, Map<String, Object> data) {
        List messages = (List)data.get("key-messages");
        String retailTravellerUid = (String)data.get("RETAIL_TRAVELLER_UID");
        AgentReportParameters parameters = (AgentReportParameters)data.get("key-report-params");
        AgentReportTicket ticket = new AgentReportTicket();
        ProductStatus status = referenceMco.getStatus();
        ticket.setUid(referenceMco.getUid());
        ticket.setStatus(relatedTicket.getStatus());
        ticket.setTicketNumber(referenceMco.getSystemNumber());
        ticket.setBlankOwner(relatedTicket.getBlankOwner());
        if (referenceMco.getRelatedProduct() != null) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)referenceMco.getRelatedProduct());
            try {
                EntityStorage.get().actualize(handler.getBlankOwner(referenceMco.getRelatedProduct()), new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
                EntityStorage.get().actualize(GeneralProductHelper.getSupplier((BaseProduct)referenceMco.getRelatedProduct()), new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            }
            catch (Exception e1) {
                this.log.error("unable to actualize reference " + ticket.getBlankOwner(), (Throwable)e1);
            }
            ticket.setGroupName(this.getGroupName(referenceMco.getRelatedProduct()));
        }
        ticket.setTicketSeries(RailwayReferenceMcoHelper.getTicketSeries((RailwayReferenceMCO)referenceMco));
        ticket.setIssueDate(referenceMco.getIssueDate());
        if (status != ProductStatus.VOID && status != ProductStatus.VOID_BOOKING && referenceMco.getReservation() != null && referenceMco.getReservation().getBookingFile() != null && referenceMco.getReservation().getBookingFile().getCustomerProfile() != null && !referenceMco.getReservation().getBookingFile().getCustomerProfile().getUid().equals(retailTravellerUid)) {
            EntityReference customerProfile = referenceMco.getReservation().getBookingFile().getCustomerProfile();
            EntityStorage.get().actualize(customerProfile, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            ticket.setRemarks(customerProfile.getCaption());
        }
        ticket.setSortingTicketNumber(relatedTicket.getTicketSeries() + relatedTicket.getTicketNumber() + "-mco");
        ticket.setIssuedInReportPeriod(this.isIssuedInReportPeriod(parameters, referenceMco));
        if (status == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.RailwayAgentReportProductPrepareHandler_krsNoState, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{referenceMco.getSystemNumber()});
        }
        return ticket;
    }

    public static List<RailwayProductFop> collectProductFops(RailwayProduct product, boolean client, List<Message> messages) {
        if (product == null) {
            return Collections.emptyList();
        }
        ArrayList<RailwayProductFop> productFops = new ArrayList<RailwayProductFop>();
        List fops = client ? RailwayProductHelper.getClientFops((RailwayProduct)product) : RailwayProductHelper.getVendorFops((RailwayProduct)product);
        for (RailwayProductFop fop : fops) {
            if (fop == null) {
                SystemHelper.addMessage(messages, (String)Messages.RailwayAgentReportProductPrepareHandler_ticketNoFormPay, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                return null;
            }
            productFops.add(fop);
        }
        return productFops;
    }

    private void updateValue(Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> values, List<RailwayProductFop> fops, PaymentType paymentType, FopType total, RailwayProduct product, Date startDate, Date endDate, EntityReference<Person> agent, List<Message> messages) {
        BigDecimal unpayed;
        BigDecimal payedValue = this.getTotalFop(fops, paymentType, total, product, startDate, endDate, agent, true, messages);
        if (BigDecimal.ZERO.compareTo(payedValue) != 0) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(true);
            info.setPaymentType(paymentType);
            values.put(info, payedValue);
        }
        if (BigDecimal.ZERO.compareTo(unpayed = this.getTotalFop(fops, paymentType, total, product, null, null, null, false, messages).subtract(payedValue)) != 0) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(false);
            info.setPaymentType(paymentType);
            values.put(info, unpayed);
        }
    }

    private BigDecimal getTotalFop(List<RailwayProductFop> fops, PaymentType paymentType, FopType fopType, RailwayProduct product, Date startDate, Date endDate, EntityReference<Person> agent, boolean paid, List<Message> messages) {
        BigDecimal result = BigDecimal.ZERO;
        block5: for (RailwayProductFop fop : fops) {
            if (paid && fop.isRefused() || startDate != null && (fop.getOperationDate() == null || fop.getOperationDate().before(startDate)) || endDate != null && (fop.getOperationDate() == null || fop.getOperationDate().after(endDate)) || agent != null && (fop.getAgent() == null || !agent.equals((Object)fop.getAgent()))) continue;
            if (fopType != null) {
                switch (fopType) {
                    case TOTAL: {
                        if (fop.getCommissions().isEmpty()) break;
                        continue block5;
                    }
                    case FEE: {
                        if (!fop.getCommissions().isEmpty() && this.getCommissionType((GeneralProductCommission)fop.getCommissions().get(0), product, messages) == CommissionType.FEE) break;
                        continue block5;
                    }
                    case FEE_FOR_REFUND: {
                        if (!fop.getCommissions().isEmpty() && this.getCommissionType((GeneralProductCommission)fop.getCommissions().get(0), product, messages) == CommissionType.FEE_FOR_REFUND) break;
                        continue block5;
                    }
                }
            }
            if (paymentType != null && paymentType != fop.getType() || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
            result = result.add(fop.getAmount().getValue());
        }
        return result;
    }

    private CommissionType getCommissionType(GeneralProductCommission commission, RailwayProduct product, List<Message> messages) {
        FeeProperties properties;
        if (commission.getCommissionProperties() == null || !FeeProperties.class.getName().equals(commission.getCommissionProperties().getType().getName()) && !PaymentFeeProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
            return CommissionType.OTHER;
        }
        EntityContainer container = null;
        try {
            container = EntityStorage.get().resolve(commission.getCommissionProperties());
        }
        catch (Exception e) {
            SystemHelper.addExceptionMessage(messages, (String)Messages.RailwayAgentReportProductPrepareHandler_ticketCantLoad, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), commission.getCommissionProperties()});
            return CommissionType.OTHER;
        }
        if (container == null) {
            SystemHelper.addMessage(messages, (String)Messages.RailwayAgentReportProductPrepareHandler_ticketCantLoad, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), commission.getCommissionProperties()});
            return CommissionType.OTHER;
        }
        BaseCommissionProperties prop = (BaseCommissionProperties)container.getEntity();
        if (prop instanceof FeeProperties) {
            properties = (FeeProperties)prop;
            if (properties.getOperation() == null) {
                SystemHelper.addMessage(messages, (String)Messages.RailwayAgentReportProductPrepareHandler_ticketInProperty, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), commission.getCommissionProperties()});
                return CommissionType.FEE;
            }
            if (properties.getOperation() == Operation.REFUND || properties.getOperation() == Operation.EXCHANGE) {
                return CommissionType.FEE_FOR_REFUND;
            }
            if (properties.getOperation() == Operation.SELL) {
                return CommissionType.FEE;
            }
        }
        if (prop instanceof PaymentFeeProperties) {
            properties = (PaymentFeeProperties)prop;
            if (properties.isChargeOnRefund() && commission.getEquivalentAmount() != null && commission.getEquivalentAmount().doubleValue() < 0.0) {
                return CommissionType.FEE_FOR_REFUND;
            }
            return CommissionType.FEE;
        }
        return CommissionType.OTHER;
    }

    private static enum CommissionType {
        OTHER,
        FEE,
        FEE_FOR_REFUND;

    }

    private static enum FopType {
        TOTAL,
        FEE,
        FEE_FOR_REFUND;

    }
}

