/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportGeneralProductHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrDateFormatUtils;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedGeneralProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportPrepareUtil;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AviacentrConsolidatedReportRailwayPrepareHandler
implements AviacentrConsolidatedReportProductPrepareHandler<RailwayProduct> {
    private final AviacentrConsolidatedReportGeneralProductHandler<RailwayProduct, RailwayProductIndex> handler = new AviacentrConsolidatedReportGeneralProductHandler<RailwayProduct, RailwayProductIndex>(){

        public ProductType getProductType() {
            return ProductType.RAILWAY_PRODUCT;
        }

        public String getStatusIndexPropertyName() {
            return RailwayProductIndex.Property.status.name();
        }

        public String getClientNameIndexPropertyName() {
            return RailwayProductIndex.Property.client.name();
        }

        public String getCancellationDateIndexPropertyName() {
            return RailwayProductIndex.Property.cancellationDate.name();
        }

        public String getPaymentDateIndexPropertyName() {
            return RailwayProductIndex.Property.dateOfClientPayment.name();
        }

        public String getIssueDateIndexPropertyName() {
            return RailwayProductIndex.Property.issueDate.name();
        }

        public String getTicketTypeIndexPropertyName() {
            return RailwayProductIndex.Property.ticketType.name();
        }

        public Class<RailwayProductIndex> getIndexClass() {
            return RailwayProductIndex.class;
        }

        public Class<RailwayProduct> getProductClass() {
            return RailwayProduct.class;
        }

        public Date getIssueDate(RailwayProduct item) {
            return item.getIssueDate();
        }

        public List<GeneralProductFop> getClientFops(RailwayProduct item) {
            ArrayList<GeneralProductFop> clientFops = new ArrayList<GeneralProductFop>();
            for (RailwayProductFop fop : RailwayProductHelper.getClientFops((RailwayProduct)item)) {
                clientFops.add(RailwayProductHelper.toGeneralProductFop((RailwayProductFop)fop));
            }
            return clientFops;
        }

        public List<Date> getClientFopsOperationDates(RailwayProduct item) {
            ArrayList<Date> res = new ArrayList<Date>();
            for (RailwayProductFop fop : RailwayProductHelper.getClientFops((RailwayProduct)item)) {
                res.add(fop.getOperationDate());
            }
            return res;
        }

        public boolean isChecked(RailwayProduct item) {
            return item.isChecked();
        }

        public List<ValidationMessage> getValidationMessages(RailwayProduct item) {
            return item.getValidationMessages();
        }

        public String getSystemNumber(RailwayProduct item) {
            return item.getSystemNumber();
        }

        public ProductStatus getStatus(RailwayProduct item) {
            return item.getStatus();
        }

        public String getProductName(RailwayProduct item) {
            return BookingHelper.generateProductName((BaseProduct)item);
        }

        public String getUnitOfMeasureForBaseProduct() {
            return unitOfMeasureBase;
        }

        public Integer getAmountForBaseProduct(RailwayProduct item) {
            return amountBase;
        }

        public String getUnitOfMeasureForFees() {
            return "---";
        }

        public String getAmountForFees() {
            return "---";
        }

        public BigDecimal getPrice(RailwayProduct item, boolean needVat) {
            BigDecimal totalWithVat = RailwayProductHelper.calculateTotalEquivalentFare((RailwayProduct)item);
            if (!needVat) {
                return totalWithVat;
            }
            BigDecimal vat = RailwayProductHelper.calculateTotalEquivalentVat((RailwayProduct)item);
            return totalWithVat != null && vat != null ? totalWithVat.subtract(vat) : totalWithVat;
        }

        public Double getVatRate(RailwayProduct item, boolean needVat) {
            BigDecimal rate;
            if (!needVat) {
                return null;
            }
            BigDecimal vat = RailwayProductHelper.calculateTotalEquivalentVat((RailwayProduct)item);
            BigDecimal totalWithVat = RailwayProductHelper.calculateTotalEquivalentFare((RailwayProduct)item);
            if (vat != null && totalWithVat != null && !totalWithVat.equals(BigDecimal.ZERO) && (rate = vat.divide(totalWithVat, 20, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP).compareTo(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue().setScale(2, RoundingMode.HALF_UP)) == 0) {
                return AviacentrConsolidatedReportPrepareUtil.getStandardVat();
            }
            if (vat == null || BigDecimal.ZERO.equals(vat)) {
                return 0.0;
            }
            return null;
        }

        public BigDecimal getVatAmount(RailwayProduct item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            return RailwayProductHelper.calculateTotalEquivalentVat((RailwayProduct)item);
        }

        public BigDecimal getTotalPriceWithVat(RailwayProduct item) {
            return RailwayProductHelper.calculateTotalEquivalentFare((RailwayProduct)item);
        }

        public String getDatesString(RailwayProduct item) {
            StringBuilder dates = new StringBuilder();
            for (RailwaySegment seg : item.getSegments()) {
                if (seg.getDepartureDate() != null) {
                    if (dates.length() > 0) {
                        dates.append(";");
                    }
                    dates.append(AviacentrDateFormatUtils.createDf().format(seg.getDepartureDate()));
                }
                if (seg.getArriveDate() == null) continue;
                if (dates.length() > 0) {
                    dates.append("-");
                }
                dates.append(AviacentrDateFormatUtils.createDf().format(seg.getArriveDate()));
            }
            return dates.toString();
        }
    };

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<RailwayProduct> getProducts(AviacentrConsolidatedReportParameters params, List<Message> messages) throws Exception {
        return AviacentrConsolidatedGeneralProductPrepareHandler.getProducts((AviacentrConsolidatedReportParameters)params, this.handler, messages);
    }

    public void validateProducts(Collection<RailwayProduct> products, List<Message> messages) throws Exception {
        AviacentrConsolidatedGeneralProductPrepareHandler.validateProductsToReport(this.handler, products, messages);
    }

    public List<AviacentrConsolidatedReportTicket> createTickets(RailwayProduct product, Map<String, Object> data) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        AviacentrConsolidatedReportTicket t = AviacentrConsolidatedGeneralProductPrepareHandler.createTicketForMainProduct((BaseProduct)product, this.handler, data);
        res.add(t);
        res.addAll(AviacentrConsolidatedGeneralProductPrepareHandler.createTicketsForGeneralFees((List)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, null), (String)this.handler.getDatesString((BaseProduct)product), (String)this.handler.getSystemNumber((BaseProduct)product)));
        return res;
    }
}

