/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.reports.prepare.salesreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SalesReportPrepareHelper {
    public static SearchQuery createQuery(ReportParameters params) {
        SearchQuery searchQuery = SalesReportPrepareHelper.createProductQuery(params.getPeriodBegin(), params.getPeriodEnd());
        searchQuery.getPreferredProperties().add(RailwayProductIndex.Property.issueDate.name());
        if (params.getBlankOwner() != null) {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.blankOwner.name(), (Object)params.getBlankOwner()));
            searchQuery.getPreferredProperties().add(RailwayProductIndex.Property.blankOwner.name());
        }
        if (!params.getAdditionalCriterions().isEmpty()) {
            searchQuery.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        }
        if (params.getAgency() != null) {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.agency.name(), (Object)params.getAgency()));
            searchQuery.getPreferredProperties().add(RailwayProductIndex.Property.agency.name());
        }
        if (params.getSalesPoint() != null) {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.salesPoint.name(), (Object)params.getSalesPoint()));
            searchQuery.getPreferredProperties().add(RailwayProductIndex.Property.salesPoint.name());
        }
        if (params.getSubagency() != null) {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.subagency.name(), (Object)params.getSubagency()));
            searchQuery.getPreferredProperties().add(RailwayProductIndex.Property.subagency.name());
        }
        if (params.getSupplier() != null) {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.supplier.name(), (Object)params.getSupplier()));
            searchQuery.getPreferredProperties().add(RailwayProductIndex.Property.supplier.name());
        }
        return searchQuery;
    }

    public static SearchQuery createProductQuery(Date beginDate, Date endDate) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), null)}));
        SearchCriterion searchCriterion = null;
        if (beginDate != null) {
            searchCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)RailwayProductIndex.Property.issueDate.name(), (Object)MiscUtil.clearTime((Date)beginDate)), SearchCriterion.le((String)RailwayProductIndex.Property.issueDate.name(), (Object)endDate)});
        }
        if (endDate != null) {
            SearchCriterion endDateSearchCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)RailwayProductIndex.Property.dateOfVendorPayment.name(), (Object)beginDate), SearchCriterion.le((String)RailwayProductIndex.Property.dateOfVendorPayment.name(), (Object)MiscUtil.setDayEndTime((Date)endDate))});
            SearchCriterion searchCriterion2 = searchCriterion = searchCriterion != null ? SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{searchCriterion, endDateSearchCriterion}) : endDateSearchCriterion;
        }
        if (searchCriterion != null) {
            query.getCriteria().getCriterions().add(searchCriterion);
        }
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING), SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID_BOOKING)}));
        return query;
    }

    public static Set<RailwayProduct> getProducts(SearchQuery query, List<Message> messages) throws Exception {
        HashMap<EntityReference, EntityContainer> loaded = new HashMap<EntityReference, EntityContainer>();
        HashSet<RailwayProduct> products = new HashSet<RailwayProduct>();
        EntityStorage es = EntityStorage.get();
        for (RailwayProductIndex index : es.search(RailwayProductIndex.class, query).getData()) {
            EntityContainer container = (EntityContainer)loaded.get(index.getSource());
            if (container == null) {
                container = es.resolve(index.getSource());
                loaded.put(index.getSource(), container);
            }
            block1: for (Reservation res : ((BookingFile)container.getEntity()).getReservations()) {
                for (BaseProduct baseProduct : res.getProducts()) {
                    if (!(baseProduct instanceof RailwayProduct) || !index.getNavigationKey().equals(baseProduct.getUid())) continue;
                    products.add((RailwayProduct)baseProduct);
                    continue block1;
                }
            }
        }
        return products;
    }
}

