/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.reports.prepare.salesreports.spgd;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocumentIndex;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.railway.parsers.helpers.RailwayProductParsersHelper;
import com.gridnine.xtrip.common.railway.reports.render.salesreports.spgd.SPGDDivergenceReportTicket;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.railway.reports.prepare.salesreports.SalesReportPrepareHelper;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPGDFilesDivergenceReportPrepareHandler
implements ReportPrepareHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public String getId() {
        return "spgd-files-report";
    }

    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        data.put("key-messages", messages);
        this.checkReportParameters(data);
        if (this.isHasErrors(messages)) {
            return;
        }
        this.putGlobalData(data);
        List<SPGDDivergenceReportTicket> tickets = this.getData(data, messages);
        if (this.isHasErrors(messages)) {
            return;
        }
        if (tickets.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"\u0420\u0430\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b", null, (MessageType)MessageType.MESSAGE, (Object[])new Object[0]);
        }
        for (SPGDDivergenceReportTicket ticket : tickets) {
            this.addTicketToReportData(ticket, data, messages);
        }
    }

    private void checkReportParameters(Map<String, Object> data) throws Exception {
        List messages = (List)data.get("key-messages");
        if (data.get("key-report-params") == null) {
            SystemHelper.addMessage((Collection)messages, (String)"BaseSalesReportPrepareHandler_Messages_NoReportParameters", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
        } else {
            DivergenceReportParameters reportParams = (DivergenceReportParameters)data.get("key-report-params");
            if (reportParams.getPeriodBegin() == null) {
                SystemHelper.addMessage((Collection)messages, (String)"Begin date is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                this.log.error("Begin date is undefined");
            }
            if (reportParams.getPeriodEnd() == null) {
                SystemHelper.addMessage((Collection)messages, (String)"End date is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                this.log.error("End date is undefined");
            }
            if (reportParams.getAgency() == null) {
                SystemHelper.addMessage((Collection)messages, (String)"Organization is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                this.log.error("Organization is undefined");
            }
        }
    }

    private void putGlobalData(Map<String, Object> data) throws Exception {
        BaseReportParameters params = (BaseReportParameters)data.get("key-report-params");
        BaseReportPrepareHandler.putStandardReportParameters((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), data, null);
        BaseReportPrepareHandler.putStandardAgencyData((EntityReference)params.getAgency(), data, null);
    }

    public List<SPGDDivergenceReportTicket> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        List<RailwayProduct> products = this.getProductData(data, messages);
        List<SPGDArchiveExchangeDocument> documents = this.getDocumentsData(data, messages);
        if (products.isEmpty() && documents.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.SPGDFilesDivergenceReportPrepareHandler_reportNoTicketNoFile, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("There are no tickets and no documents in the report");
            return Collections.emptyList();
        }
        return this.compare(products, documents, messages);
    }

    private List<SPGDDivergenceReportTicket> compare(List<RailwayProduct> products, List<SPGDArchiveExchangeDocument> documents, List<Message> messages) {
        ArrayList<SPGDDivergenceReportTicket> divergences = new ArrayList<SPGDDivergenceReportTicket>();
        Iterator<RailwayProduct> productIterator = products.iterator();
        block0: while (productIterator.hasNext()) {
            RailwayProduct product = productIterator.next();
            String productSystemNumber = product.getSystemNumber();
            TransactionType productTransactionType = RailwayProductParsersHelper.getTransactionType((ProductStatus)product.getStatus());
            if (productSystemNumber == null || productTransactionType == null) continue;
            Iterator<SPGDArchiveExchangeDocument> documentIterator = documents.iterator();
            while (documentIterator.hasNext()) {
                SPGDArchiveExchangeDocument document = documentIterator.next();
                String documentSystemNumber = document.getSystemNumber();
                TransactionType documentTransactionType = document.getTransactionType();
                if (documentSystemNumber == null && documentTransactionType == null || !TextUtil.isSame((String)documentSystemNumber, (String)productSystemNumber) || documentTransactionType != productTransactionType) continue;
                divergences.addAll(this.compare(product, document, messages));
                productIterator.remove();
                documentIterator.remove();
                continue block0;
            }
        }
        for (RailwayProduct product : products) {
            divergences.add(new SPGDDivergenceReportTicket(product, messages));
        }
        for (SPGDArchiveExchangeDocument document : documents) {
            divergences.add(new SPGDDivergenceReportTicket(document, messages));
        }
        return divergences;
    }

    private List<SPGDDivergenceReportTicket> compare(RailwayProduct product, SPGDArchiveExchangeDocument document, List<Message> messages) {
        ArrayList<SPGDDivergenceReportTicket> tickets = new ArrayList<SPGDDivergenceReportTicket>();
        SPGDDivergenceReportTicket productTicket = new SPGDDivergenceReportTicket(product, messages);
        SPGDDivergenceReportTicket documentTicket = new SPGDDivergenceReportTicket(document, messages);
        tickets.add(productTicket);
        tickets.add(documentTicket);
        if (!TextUtil.isSame((String)productTicket.getValidatingCarrier(), (String)documentTicket.getValidatingCarrier())) {
            return tickets;
        }
        if (productTicket.getEquivalentFare().compareTo(documentTicket.getEquivalentFare()) != 0) {
            return tickets;
        }
        if (productTicket.getTaxTch().compareTo(documentTicket.getTaxTch()) != 0) {
            return tickets;
        }
        return Collections.emptyList();
    }

    private List<RailwayProduct> getProductData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        List blankOwners = ProfileDao.getProfileReferenceByCode((String)"\u04281", OrganizationIndex.class);
        if (blankOwners.size() == 0) {
            SystemHelper.addMessage(messages, (String)Messages.SPGDFilesDivergenceReportPrepareHandler_cantLoadProfile, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("unable to load profile with code \"\u04281\"");
            return Collections.emptyList();
        }
        if (blankOwners.size() > 1) {
            SystemHelper.addMessage(messages, (String)Messages.SPGDFilesDivergenceReportPrepareHandler_findedMorOneProfile, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("found more than one profiles with code \"\u04281\"");
        }
        params.setBlankOwner((EntityReference)blankOwners.iterator().next());
        SearchQuery query = SalesReportPrepareHelper.createQuery(params);
        ArrayList<RailwayProduct> products = new ArrayList<RailwayProduct>(SalesReportPrepareHelper.getProducts(query, messages));
        for (RailwayProduct product : products) {
            if (!product.isEticket() || product.getStatus() != ProductStatus.VOID) continue;
            products.remove(product);
        }
        if (products.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.SPGDFilesDivergenceReportPrepareHandler_reportNoTicket, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        } else {
            Collections.sort(products, new Comparator<RailwayProduct>(){

                @Override
                public int compare(RailwayProduct o1, RailwayProduct o2) {
                    return TextUtil.compare((String)o1.getSystemNumber(), (String)o2.getSystemNumber(), (boolean)false, (boolean)true);
                }
            });
        }
        return products;
    }

    private List<SPGDArchiveExchangeDocument> getDocumentsData(Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<SPGDArchiveExchangeDocument> result = new ArrayList<SPGDArchiveExchangeDocument>();
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityStorage entityStorage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        if (params.getAgency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SPGDArchiveExchangeDocumentIndex.Property.agency.name(), (Object)params.getAgency()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)SPGDArchiveExchangeDocumentIndex.Property.issueDate.name(), (Object)MiscUtil.clearTime((Date)params.getPeriodBegin())), SearchCriterion.le((String)SPGDArchiveExchangeDocumentIndex.Property.issueDate.name(), (Object)MiscUtil.setDayEndTime((Date)params.getPeriodEnd()))}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)SPGDArchiveExchangeDocumentIndex.Property.transactionType.name(), (Object)TransactionType.REFERENCE));
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        List indexes = entityStorage.search(SPGDArchiveExchangeDocumentIndex.class, query).getData();
        for (SPGDArchiveExchangeDocumentIndex index : indexes) {
            EntityReference documentReference = index.getSource();
            EntityContainer documentContainer = entityStorage.resolve(documentReference);
            if (documentContainer == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{documentReference});
                this.log.debug("Unable to load spgd archive file container " + documentReference.getUid() + ". All of the spgd archive files will be excluded from report");
                return Collections.emptyList();
            }
            SPGDArchiveExchangeDocument document = (SPGDArchiveExchangeDocument)documentContainer.getEntity();
            result.add(document);
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.SPGDFilesDivergenceReportPrepareHandler_reportNoFile, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("There are no SPGD archive files in the report");
        } else {
            Collections.sort(result, new Comparator<SPGDArchiveExchangeDocument>(){

                @Override
                public int compare(SPGDArchiveExchangeDocument o1, SPGDArchiveExchangeDocument o2) {
                    return TextUtil.compare((String)o1.getSystemNumber(), (String)o2.getSystemNumber(), (boolean)false, (boolean)true);
                }
            });
        }
        return result;
    }

    private void addTicketToReportData(SPGDDivergenceReportTicket ticket, Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<ReportBatchData<SPGDDivergenceReportTicket>> batchDataList = (ArrayList<ReportBatchData<SPGDDivergenceReportTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData<SPGDDivergenceReportTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        ReportBatchData<SPGDDivergenceReportTicket> batch = this.selectBatch("batch_is_spgd", batchDataList);
        batch.getTickets().add(ticket);
    }

    private ReportBatchData<SPGDDivergenceReportTicket> selectBatch(String batchId, List<ReportBatchData<SPGDDivergenceReportTicket>> batchList) {
        for (ReportBatchData<SPGDDivergenceReportTicket> batch : batchList) {
            if (!batch.getBatchId().equals(batchId)) continue;
            return batch;
        }
        ReportBatchData batch = new ReportBatchData();
        batch.setBatchId(batchId);
        batchList.add((ReportBatchData<SPGDDivergenceReportTicket>)batch);
        return batch;
    }

    private boolean isHasErrors(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return false;
        }
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }
}

