/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.reports.prepare.subagentreports;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ProductReportDocument;
import com.gridnine.xtrip.common.reports.model.ProductReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.railway.model.helpers.ProfileHelper;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwaySubagentReportPrepareHandler
implements ReportPrepareHandler {
    private static final String KEY_BEGIN_DATE = "BEGIN_DATE";
    private static final String KEY_END_DATE = "END_DATE";
    private static final String KEY_SUBAGENCY_NAME = "SUBAGENCY_NAME";
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_SUBAGENT_CONTRACT_NUMBER = "SUBAGENT_CONTRACT_NUMBER";

    public String getId() {
        return "railway-subagent-report";
    }

    public void prepareData(Map<String, Object> data) throws Exception {
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        data.put("key-messages", messages);
        ProductReportParameters productReportParameters = (ProductReportParameters)data.get("key-report-params");
        if (productReportParameters == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.RailwaySubagentReportPrepareHandler_noParamReport, (Object[])new Object[0]));
            return;
        }
        EntityStorage entityStorage = EntityStorage.get();
        EntityContainer templateDocumentContainer = EntityStorage.get().resolve(productReportParameters.getTemplate());
        if (templateDocumentContainer == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.RailwaySubagentReportPrepareHandler_cantLoadTemplate, (Object[])new Object[]{productReportParameters.getTemplate()}));
            return;
        }
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)templateDocumentContainer.getEntity()).getContent());
        Map<String, Object> parameters = this.getParameters(productReportParameters, jasperReport, entityStorage, messages);
        JRDataSource dataSource = this.getDataSource(productReportParameters, jasperReport, entityStorage, messages);
        if (parameters == null || dataSource == null) {
            return;
        }
        Date date = new Date();
        EntityContainer reportDocumentContainer = new EntityContainer(ProductReportDocument.class);
        reportDocumentContainer.setCreated(date);
        ProductReportDocument productReportDocument = (ProductReportDocument)reportDocumentContainer.getEntity();
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource, null);
        productReportDocument.setCreated(date);
        productReportDocument.setParameters(productReportParameters);
        productReportDocument.setCheckSum(MiscUtil.getCheckSum((byte[])content));
        productReportDocument.getMessages().addAll(messages);
        ReportFile reportFile = new ReportFile();
        ContentType format = (ContentType)data.get("KEY_FORMAT");
        if (format != null && format == ContentType.EXCEL) {
            content = JasperUtil.convertToExcel((byte[])content);
            reportFile.setContentType(ContentType.EXCEL);
            reportFile.setContent(content);
        } else {
            reportFile.setContentType(ContentType.JASPERPRINT);
            reportFile.setContent(content);
        }
        reportFile.setName(this.getFileName(productReportParameters, format));
        reportFile.setTitle(this.getReportTitle(productReportParameters));
        productReportDocument.setFile(reportFile);
        data.put("KEY_REPORT_DOCUMENT", reportDocumentContainer);
    }

    private Map<String, Object> getParameters(ProductReportParameters productReportParameters, JasperReport jasperReport, EntityStorage entityStorage, Set<Message> messages) throws Exception {
        Organization entity;
        EntityContainer organizationContainer;
        EntityReference organizationReference;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(KEY_BEGIN_DATE, productReportParameters.getPeriodBegin());
        parameters.put(KEY_END_DATE, productReportParameters.getPeriodEnd());
        EntityStorage entityCache = EntityStorage.get();
        if (productReportParameters.getAgency() != null) {
            organizationReference = productReportParameters.getAgency();
            organizationContainer = entityCache.resolve(organizationReference);
            if (organizationContainer != null) {
                entity = (Organization)organizationContainer.getEntity();
                parameters.put(KEY_AGENCY_NAME, ProfileHelper.getFullName(entity, LocaleHelper.getCurrentLocale(), false));
            } else {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.RailwaySubagentReportPrepareHandler_cantLoadProfileAgent, (Object[])new Object[]{organizationReference}));
            }
        }
        if (productReportParameters.getSubagency() != null) {
            organizationReference = productReportParameters.getSubagency();
            organizationContainer = entityCache.resolve(organizationReference);
            if (organizationContainer != null) {
                entity = (Organization)organizationContainer.getEntity();
                parameters.put(KEY_SUBAGENCY_NAME, ProfileHelper.getFullName(entity, LocaleHelper.getCurrentLocale(), false));
            } else {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.RailwaySubagentReportPrepareHandler_cantLoadProfileSubagent, (Object[])new Object[]{organizationReference}));
            }
        }
        if (productReportParameters.getAgency() != null && productReportParameters.getSubagency() != null) {
            List data;
            SearchQuery query = new SearchQuery();
            if (productReportParameters.getVendor() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)productReportParameters.getVendor())}));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)productReportParameters.getAgency()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)productReportParameters.getSubagency()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.SUBAGENCY));
            if (productReportParameters.getPeriodBegin() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)productReportParameters.getPeriodBegin())}));
            }
            if (productReportParameters.getPeriodEnd() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)productReportParameters.getPeriodEnd())}));
            }
            if (!(data = entityStorage.search(ContractCustomerIndex.class, query).getData()).isEmpty()) {
                if (data.size() > 1) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.RailwaySubagentReportPrepareHandler_fewSubagent, (Object[])new Object[]{productReportParameters.getAgency(), productReportParameters.getSubagency(), ((ContractCustomerIndex)data.get(0)).getNumber()}));
                }
                parameters.put(KEY_SUBAGENT_CONTRACT_NUMBER, ((ContractCustomerIndex)data.get(0)).getNumber());
            }
        }
        return parameters;
    }

    private JRDataSource getDataSource(ProductReportParameters productReportParameters, JasperReport jasperReport, EntityStorage entityStorage, Set<Message> messages) throws Exception {
        String jasperReportProperty;
        SearchQuery query = new SearchQuery();
        if (productReportParameters.getPeriodBegin() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)RailwayProductIndex.Property.issueDate.name(), (Object)MiscUtil.clearTime((Date)productReportParameters.getPeriodBegin())));
        }
        if (productReportParameters.getPeriodEnd() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)RailwayProductIndex.Property.issueDate.name(), (Object)MiscUtil.setDayEndTime((Date)productReportParameters.getPeriodEnd())));
        }
        if (productReportParameters.getAgency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.agency.name(), (Object)productReportParameters.getAgency()));
        }
        if (productReportParameters.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.subagency.name(), (Object)productReportParameters.getSubagency()));
        }
        if (productReportParameters.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.salesPoint.name(), (Object)productReportParameters.getSalesPoint()));
        }
        if (!TextUtil.isBlank((String)(jasperReportProperty = jasperReport.getProperty("xtrip.orders")))) {
            block0: for (String entry : jasperReportProperty.split(",")) {
                if (TextUtil.isBlank((String)entry)) continue;
                String propertyName = null;
                SortOrder order = null;
                int index = entry.indexOf("=");
                if (index != -1 && index < entry.length() - 1) {
                    propertyName = entry.substring(0, index).trim();
                    order = SortOrder.DESC.name().equalsIgnoreCase(entry.substring(index + 1)) ? SortOrder.DESC : SortOrder.ASC;
                }
                for (RailwayProductIndex.Property property : RailwayProductIndex.Property.values()) {
                    if (!property.name().equalsIgnoreCase(propertyName)) continue;
                    query.getCriteria().getOrders().put(propertyName, order);
                    continue block0;
                }
            }
        }
        if (productReportParameters.getSupplier() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.supplier.name(), (Object)productReportParameters.getSupplier()));
        }
        if (productReportParameters.getVendor() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)productReportParameters.getVendor()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.FAKE));
        query.setResultMode(ResultMode.COUNT_ONLY);
        int totalCount = entityStorage.search(RailwayProductIndex.class, query).getTotalCount();
        if (totalCount > 10000) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.RailwaySubagentReportPrepareHandler_reportTooManyTicket, (Object[])new Object[0]));
            return null;
        }
        if (totalCount == 0) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SPGDFilesDivergenceReportPrepareHandler_reportNoTicket, (Object[])new Object[0]));
            return null;
        }
        query.setResultMode(ResultMode.DATA_ONLY);
        final List data = entityStorage.search(RailwayProductIndex.class, query).getData();
        final Logger log = LoggerFactory.getLogger(this.getClass());
        return new JRDataSource(){
            private int rowNumber = -1;

            public Object getFieldValue(JRField jrField) {
                String name = jrField.getName();
                if (TextUtil.isBlank((String)name)) {
                    return null;
                }
                try {
                    RailwayProductIndex index = (RailwayProductIndex)data.get(this.rowNumber);
                    Object value = index.getValue(name);
                    if (value == null) {
                        IndexProperty indexProperty = (IndexProperty)((IndexType)MetaRegistry.get().getIndexes().get(RailwayProductIndex.class.getName())).getProperties().get(name);
                        if (indexProperty != null && BigDecimal.class.getName().equals(indexProperty.getType())) {
                            return BigDecimal.ZERO;
                        }
                        if (indexProperty != null && Double.class.getName().equals(indexProperty.getType())) {
                            return 0.0;
                        }
                        if (indexProperty != null && Integer.class.getName().equals(indexProperty.getType())) {
                            return 0;
                        }
                        if (indexProperty != null && Long.class.getName().equals(indexProperty.getType())) {
                            return 0L;
                        }
                        return null;
                    }
                    if (value.getClass().isEnum()) {
                        return ((Enum)value).name();
                    }
                    if (value instanceof EntityReference) {
                        ((EntityReference)value).toString();
                    }
                    if (value instanceof Iterable) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (Object object : (Iterable)value) {
                            if (object == null) continue;
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(object);
                        }
                        return stringBuilder.toString();
                    }
                    return value;
                }
                catch (Exception e) {
                    log.error("unable to read value of the field " + name, (Throwable)e);
                    return null;
                }
            }

            public boolean next() {
                ++this.rowNumber;
                return this.rowNumber < data.size();
            }
        };
    }

    private String getFileName(ProductReportParameters params, ContentType format) {
        StringBuilder stringBuilder = new StringBuilder("railway_subagent_report_");
        stringBuilder.append(params.getPeriodBegin() != null ? new SimpleDateFormat("dd.MM").format(params.getPeriodBegin()) : "?");
        stringBuilder.append('_');
        stringBuilder.append(params.getPeriodEnd() != null ? new SimpleDateFormat("dd.MM").format(params.getPeriodEnd()) : "?");
        stringBuilder.append(format == ContentType.EXCEL ? ".xls" : ".jrprint");
        return stringBuilder.toString();
    }

    private String getReportTitle(ProductReportParameters params) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(params.getTemplate());
        stringBuilder.append(" ").append(L10nResourcesManager.getStr((String)Messages.RailwaySubagentReportPrepareHandler_from, (Object[])new Object[0])).append(" ");
        stringBuilder.append(params.getPeriodBegin() != null ? new SimpleDateFormat("dd.MM").format(params.getPeriodBegin()) : "?");
        stringBuilder.append(" ").append(L10nResourcesManager.getStr((String)Messages.RailwaySubagentReportPrepareHandler_to, (Object[])new Object[0])).append(" ");
        stringBuilder.append(params.getPeriodEnd() != null ? new SimpleDateFormat("dd.MM").format(params.getPeriodEnd()) : "?");
        return stringBuilder.toString();
    }
}

