/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportParameters;
import com.gridnine.xtrip.common.reports.render.RenderHandlersRegistry;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.tasks.AsyncServerTask;
import com.gridnine.xtrip.server.reports.prepare.PrepareReportTask;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;

public class ReportScheduledTask
extends BaseScheduledTask {
    private volatile Properties config;

    public void configure(Properties config) throws Exception {
        this.config = config;
    }

    protected void doJob() throws Exception {
        String reportUid = this.config.getProperty("report-uid");
        int daysOffset = this.readInt(this.config, "day-offset", -1);
        int daysLength = this.readInt(this.config, "day-count", -1);
        int hoursOffset = this.readInt(this.config, "hour-offset", 0);
        int hoursLength = this.readInt(this.config, "hour-count", 24);
        Calendar startingDate = Calendar.getInstance();
        if (daysOffset > 0) {
            startingDate.set(11, 0);
            startingDate.set(12, 0);
            startingDate.set(13, 0);
            startingDate.set(14, 0);
            startingDate.add(5, -daysOffset);
        } else {
            startingDate.add(11, -hoursOffset);
            startingDate.set(12, 0);
            startingDate.set(13, 0);
            startingDate.set(14, 0);
        }
        Calendar finishingDate = Calendar.getInstance();
        finishingDate.setTime(startingDate.getTime());
        if (daysLength > 0) {
            finishingDate.add(5, daysLength - 1);
            finishingDate.set(11, 23);
            finishingDate.set(12, 59);
            finishingDate.set(13, 59);
            finishingDate.set(14, 999);
        } else {
            finishingDate.add(11, hoursLength - 1);
            finishingDate.set(12, 59);
            finishingDate.set(13, 59);
            finishingDate.set(14, 999);
        }
        String reportId = "index-based-template-report";
        EntityContainer report = EntityStorage.get().load(IndexBasedTemplateReportDescription.class, reportUid);
        if (report == null) {
            throw new Exception(String.format("\u041e\u0442\u0447\u0451\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. (uid: %s)", reportUid));
        }
        IndexBasedTemplateReportParameters reportParams = new IndexBasedTemplateReportParameters();
        reportParams.setReportId("index-based-template-report");
        reportParams.setDescription(report.toReference());
        reportParams.setPeriodBegin(startingDate.getTime());
        reportParams.setPeriodEnd(finishingDate.getTime());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ASYNC_TASK_REPORT_ID", "index-based-template-report");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("key-report-params", reportParams);
        parameters.put("ASYNC_TASK_REPORT_CONTEXT", context);
        ArrayList<Message> messages = new ArrayList<Message>();
        context.put("key-messages", messages);
        new PrepareReportTask().execute(new AsyncServerTask.Callback(){

            public void updateProgress(byte progress, String message) {
            }

            public void addMessage(Message message) {
                ReportScheduledTask.this.processMessage(message);
            }
        }, parameters);
        EntityContainer ctr = ((RenderHandlersRegistry)Environment.getPublished(RenderHandlersRegistry.class)).get("index-based-template-report").renderReport(context);
        if (ctr == null) {
            this.log.error("\u041f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u0442\u0447\u0435\u0442\u0430 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u043e \u043d\u0438 \u0435\u0434\u0438\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 (uid: " + String.valueOf(reportUid) + ")");
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u0442\u0447\u0435\u0442\u0430 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u043e \u043d\u0438 \u0435\u0434\u0438\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", (Object[])new Object[0]));
        } else {
            messages.addAll(((BaseReportDocument)ctr.getEntity()).getMessages());
        }
        if (ctr != null) {
            ctr.getVersionInfo().setDataSource("renderer");
            EntityStorage.get().save(ctr, true);
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041e\u0442\u0447\u0435\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d", (Object[])new Object[0]));
        } else {
            for (Message message : messages) {
                this.processMessage(message);
            }
        }
    }

    protected void processMessage(Message message) {
    }

    private int readInt(Properties props, String key, int def) {
        String val = props.getProperty(key);
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            this.log.error("unable to parse param", (Throwable)e);
            return def;
        }
    }
}

