/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.standard.ReportsRegistryConfigurator;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.setup.ModelSetupProcedure;
import com.gridnine.xtrip.server.parsers.test.ParsersTestBase;
import com.gridnine.xtrip.server.reports.ReportsHibernatePhysicalStorageConfigurator;
import com.gridnine.xtrip.server.reports.ReportsLogicalStorageConfigurator;
import com.gridnine.xtrip.server.setup.SetupHandler;
import com.gridnine.xtrip.server.setup.SetupManager;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ReportsTestBase
extends ParsersTestBase {
    protected EntityReference<Organization> agencyReference;
    protected EntityReference<Organization> subagencyReference;
    protected EntityReference<Organization> clientReference;
    protected EntityReference<Organization> tchReference;
    protected EntityReference<Organization> suReference;
    protected EntityReference<Organization> vvReference;
    protected EntityReference<Organization> fvReference;
    protected EntityReference<Organization> s7Reference;
    protected EntityReference<Organization> hyReference;
    protected EntityReference<Organization> j2Reference;
    protected EntityReference<Organization> xfReference;
    protected EntityReference<Organization> kvReference;
    protected EntityReference<Organization> u6Reference;
    protected EntityReference<Organization> naReference;
    protected EntityReference<Organization> bspReference;
    protected EntityReference<CommissionProperties> commPropRef;
    protected EntityReference<Person> directorRef;

    public void setUp() throws Exception {
        super.setUp();
        File directory = new File("./test/sales-reports/");
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("can't make directory " + directory.getCanonicalPath());
        }
        LocaleManager.get().getL10nResourceManager().registerResource(ReportsRegistryConfigurator.class.getResource("../../../reports/l10n/"));
        this.directorRef = new EntityReference("test_director_container_uid", Person.class, "Mr. Director");
        this.agencyReference = new EntityReference("agency_container", Organization.class, "Agency");
        this.subagencyReference = new EntityReference("subagency_container", Organization.class, "Subagency");
        this.tchReference = new EntityReference("TCH_container", Organization.class, "\u0422\u041a\u041f");
        this.suReference = new EntityReference("SU_container", Organization.class, "\u041e\u0410\u041e \"\u0410\u044d\u0440\u043e\u0444\u043b\u043e\u0442- \u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438\"");
        this.vvReference = new EntityReference("VV_container", Organization.class, "Aerosweet");
        this.fvReference = new EntityReference("FV_container", Organization.class, "State Transport Company of Russia");
        this.s7Reference = new EntityReference("S7_container", Organization.class, "Sibir");
        this.hyReference = new EntityReference("HY_container", Organization.class, "\u041d\u0410\u041a \"\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u043e\u043d \u0425\u0430\u0432\u0430 \u0419\u0443\u043b\u043b\u043e\u0440\u0438\"");
        this.j2Reference = new EntityReference("J2_container", Organization.class, "\u0413\u041a \"\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d \u0425\u0430\u0432\u0430 \u0419\u043e\u043b\u043b\u0430\u0440\u044b\"");
        this.xfReference = new EntityReference("XF_container", Organization.class, "\u041e\u0410\u041e \"\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a \u0410\u0432\u0438\u0430\"");
        this.kvReference = new EntityReference("KV_container", Organization.class, "\u0424\u0413\u0423\u0410\u041f \"\u041a\u0430\u0432\u043c\u0438\u043d\u0432\u043e\u0434\u044b\u0430\u0432\u0438\u0430\"");
        this.u6Reference = new EntityReference("U6_container", Organization.class, "\u0423\u0440\u0430\u043b\u044c\u0441\u043a\u0438\u0435 \u0410\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438");
        this.naReference = new EntityReference("5N_container", Organization.class, "\u041d\u043e\u0440\u0434\u0430\u0432\u0438\u0430");
        this.bspReference = new EntityReference("BSP_container", Organization.class, "BSP");
        this.clientReference = new EntityReference("test_client_container_uid", Organization.class, "testClient");
        CommissionProperties prop = new CommissionProperties();
        prop.setDisplayName("Commission");
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_1);
        this.commPropRef = EntityStorage.get().save(EntityContainer.create((BaseEntity)prop), true).toReference();
        LocaleManager.get().getL10nResourceManager().registerResource(Messages.class.getResource(ReportsTestBase.getResourceBundlePath(Messages.class)));
        LocaleManager.get().getL10nResourceManager().registerResource(Messages.class.getResource(ReportsTestBase.getResourceBundlePath(com.gridnine.xtrip.common.model.l10n.Messages.class)));
    }

    public static String getResourceBundlePath(Class<?> clss) {
        String result = clss.getPackage().getName();
        result = "/" + result.replaceAll("\\.", "/") + "/";
        return result;
    }

    protected void configureHibernateStorageRegistry(HibernatePhysicalStorageRegistry psr) {
        super.configureHibernateStorageRegistry(psr);
        new ReportsHibernatePhysicalStorageConfigurator().configure(psr);
    }

    protected void configureLogicalStorageRegistry(LogicalStorageRegistry registry) throws Exception {
        super.configureLogicalStorageRegistry(registry);
        new ReportsLogicalStorageConfigurator().configure(registry);
    }

    protected EntityReference<Organization> findBlankOwnerByCode(String code) throws Exception {
        List refs = ProfileDao.getProfileReferenceByCode((String)code, OrganizationIndex.class);
        return refs.isEmpty() ? null : (EntityReference)refs.get(0);
    }

    protected CurrencyRate createCurrencyRate(String baseCurrency, String exchangeCurrency, Date date, double rate, CurrencyRateType currencyRateType, EntityReference<Organization> blankOwner, TariffType tariffType) throws Exception {
        CurrencyRate currencyRate = new CurrencyRate();
        currencyRate.setCode(currencyRate.getUid());
        currencyRate.setBaseCurrency(baseCurrency);
        currencyRate.setCurrency(exchangeCurrency);
        currencyRate.setRate(rate);
        currencyRate.setDate(date);
        currencyRate.setType(currencyRateType);
        currencyRate.setBlankOwner(blankOwner);
        currencyRate.setTariffType(tariffType);
        this.save((BaseDictionary)currencyRate);
        return currencyRate;
    }

    protected EntityContainer<Organization> createOrganization(String code, String shortName, String fullName, Map<MetadataKey, Object> metadatas) throws Exception {
        EntityContainer organizationContainer = new EntityContainer(Organization.class);
        Organization organization = (Organization)organizationContainer.getEntity();
        organization.setActive(true);
        organization.setCode(code);
        L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)shortName.trim(), (Locale)LocaleUtil.LOCALE_EN);
        L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)shortName.trim(), (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)shortName.trim(), (Locale)LocaleUtil.LOCALE_UK);
        L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullName.trim(), (Locale)LocaleUtil.LOCALE_EN);
        L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullName.trim(), (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullName.trim(), (Locale)LocaleUtil.LOCALE_UK);
        organization.setLegalForm(null);
        for (Map.Entry<MetadataKey, Object> entry : metadatas.entrySet()) {
            MetadataKey metadataKey = entry.getKey();
            Object metadataValue = entry.getValue();
            SystemHelper.setMetadataValue((Collection)organization.getMetadata(), (MetadataKey)metadataKey, (Object)metadataValue);
        }
        this.save(organizationContainer);
        return organizationContainer;
    }

    protected EntityContainer<SalesPoint> createSalesPoint(String code, String shortName, String fullName, EntityReference<Organization> agency, List<Pcc> pccs, List<Validator> validators, Map<MetadataKey, Object> metadatas) throws Exception {
        EntityContainer salesPointContainer = new EntityContainer(SalesPoint.class);
        SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
        salesPoint.setActive(true);
        salesPoint.setCode(code);
        salesPoint.setShortName(shortName.trim());
        salesPoint.setFullName(fullName.trim());
        salesPoint.setAgency(agency);
        if (pccs != null) {
            salesPoint.getPccs().addAll(pccs);
        }
        if (validators != null) {
            salesPoint.getValidators().addAll(validators);
        }
        if (metadatas != null) {
            for (Map.Entry<MetadataKey, Object> entry : metadatas.entrySet()) {
                MetadataKey metadataKey = entry.getKey();
                Object metadataValue = entry.getValue();
                SystemHelper.setMetadataValue((Collection)salesPoint.getMetadata(), (MetadataKey)metadataKey, (Object)metadataValue);
            }
        }
        this.save(salesPointContainer);
        return salesPointContainer;
    }

    protected Validator createValidator(String number, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> agency, Date openDate, Date closeDate) throws Exception {
        return this.createValidator(number, blankOwner, supplier, agency, null, openDate, closeDate);
    }

    protected Validator createValidator(String number, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> agency, Pcc pcc, Date openDate, Date closeDate) throws Exception {
        Validator validator = new Validator();
        validator.setNumber(number);
        validator.setBlankOwner(blankOwner);
        validator.setSupplier(supplier);
        validator.setAgency(agency);
        validator.setPCC(pcc);
        validator.setOpened(openDate);
        validator.setClosed(closeDate);
        return validator;
    }

    protected Pcc createPcc(GdsName gds, String number, EntityReference<Organization> agency, Date openDate, Date closeDate) throws Exception {
        Pcc pcc = new Pcc();
        pcc.setGdsName(gds);
        pcc.setCode(number);
        pcc.setAgency(agency);
        pcc.setOpened(openDate);
        pcc.setClosed(closeDate);
        return pcc;
    }

    protected void save(EntityContainer<?> entityContainer) throws Exception {
        EntityStorage entityStorage = EntityStorage.get();
        String user = LogicalStorage.get().getUser();
        Date date = new Date();
        entityContainer.setCreated(date);
        entityContainer.setModified(date);
        entityContainer.setCreatedBy(user);
        entityContainer.setModifiedBy(user);
        entityStorage.save(entityContainer, false);
    }

    protected void save(BaseDictionary dictionaryContainer) throws Exception {
        DictionaryStorage dictionaryStorage = DictionaryStorage.get();
        String user = LogicalStorage.get().getUser();
        Date date = new Date();
        dictionaryContainer.setCreated(date);
        dictionaryContainer.setModified(date);
        dictionaryContainer.setCreatedBy(user);
        dictionaryContainer.setModifiedBy(user);
        dictionaryStorage.save(dictionaryContainer, false);
    }

    protected void registerSetupHandlers(SetupManager sm) {
        super.registerSetupHandlers(sm);
        sm.registerHandler((SetupHandler)new ModelSetupProcedure(){

            protected Collection<URL> getAssetSetupFiles() throws Exception {
                return Collections.emptyList();
            }

            protected Collection<URL> getDictionarySetupFiles() {
                return Collections.emptyList();
            }

            protected Collection<URL> getEntitySetupFiles() {
                URL url = ResourceUtil.getResource(ReportsTestBase.class, (String)"Templates.xml");
                if (null == url) {
                    throw new RuntimeException("no Templates.xml file found");
                }
                return Collections.singletonList(url);
            }
        });
    }

    private File getConfigFolder(File parent) {
        if ("server".equals(parent.getName())) {
            return parent;
        }
        for (File file : parent.listFiles()) {
            File res;
            if (!file.isDirectory() || (res = this.getConfigFolder(file)) == null) continue;
            return res;
        }
        return null;
    }

    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/reports/model/model-reports.xml"));
    }
}

