/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.AgentReportDocumentIndexData;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentReportDocumentIndexHandler
implements IndexHandler<AgentReportDocument, AgentReportDocumentIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<AgentReportDocument, AgentReportDocumentIndex>> getDataClass() {
        return AgentReportDocumentIndexData.class;
    }

    public Class<AgentReportDocumentIndex> getIndexClass() {
        return AgentReportDocumentIndex.class;
    }

    public Class<AgentReportDocument> getEntityType() {
        return AgentReportDocument.class;
    }

    public void create(EntityContainer<AgentReportDocument> etc, Collection<BaseIndexData<AgentReportDocument, AgentReportDocumentIndex>> indexes) {
        AgentReportDocument document = (AgentReportDocument)etc.getEntity();
        AgentReportDocumentIndexData index = new AgentReportDocumentIndexData();
        index.setCreated(document.getCreated());
        index.setCheckSum(document.getCheckSum());
        AgentReportParameters parameters = document.getParameters();
        HashSet<String> vendors = new HashSet<String>();
        if (parameters != null) {
            index.setAgency(parameters.getAgency());
            index.setPeriodBegin(parameters.getPeriodBegin());
            index.setPeriodEnd(parameters.getPeriodEnd());
            index.setAgent(parameters.getAgent());
            for (EntityReference vendor : parameters.getVendors()) {
                if (TextUtil.isBlank((String)vendor.toString())) continue;
                vendors.add(vendor.toString());
            }
            index.setVendors(vendors);
        }
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(document.getCreated());
        if (parameters != null) {
            aggregator.aggregate(parameters.getPeriodBegin());
            aggregator.aggregate(parameters.getPeriodEnd());
            aggregator.aggregate(vendors);
            aggregator.aggregate((Object)parameters.getAgency());
            aggregator.aggregate((Object)parameters.getAgent());
        }
        index.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<AgentReportDocument, AgentReportDocumentIndex>)index);
    }
}

