/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportDocument;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportDocumentIndexData;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.HashSet;

public class ClientDebtReportDocumentIndexHandler
implements IndexHandler<ClientDebtReportDocument, ClientDebtReportDocumentIndex> {
    public void create(EntityContainer<ClientDebtReportDocument> etc, Collection<BaseIndexData<ClientDebtReportDocument, ClientDebtReportDocumentIndex>> indexes) {
        ClientDebtReportDocument document = (ClientDebtReportDocument)etc.getEntity();
        ClientDebtReportDocumentIndexData index = new ClientDebtReportDocumentIndexData();
        index.setCreated(document.getCreated());
        index.setCheckSum(document.getCheckSum());
        ClientDebtReportParameters parameters = document.getParameters();
        HashSet<String> vendors = new HashSet<String>();
        if (parameters != null) {
            index.setAgency(parameters.getAgency());
            index.setPeriodBegin(parameters.getPeriodBegin());
            index.setPeriodEnd(parameters.getPeriodEnd());
            index.setSubagency(parameters.getSubagency());
            index.setSalesPoint(parameters.getSalesPoint());
            index.setAgent(parameters.getAgent());
            for (EntityReference vendor : parameters.getVendors()) {
                if (TextUtil.isBlank((String)vendor.toString())) continue;
                vendors.add(vendor.toString());
            }
            index.setVendors(vendors);
        }
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(document.getCreated());
        if (parameters != null) {
            aggregator.aggregate(parameters.getPeriodBegin());
            aggregator.aggregate(parameters.getPeriodEnd());
            aggregator.aggregate((Object)parameters.getAgency());
            aggregator.aggregate((Object)parameters.getSubagency());
            aggregator.aggregate((Object)parameters.getSalesPoint());
            aggregator.aggregate((Object)parameters.getAgent());
            aggregator.aggregate(vendors);
        }
        index.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<ClientDebtReportDocument, ClientDebtReportDocumentIndex>)index);
    }

    public Class<? extends BaseIndexData<ClientDebtReportDocument, ClientDebtReportDocumentIndex>> getDataClass() {
        return ClientDebtReportDocumentIndexData.class;
    }

    public Class<ClientDebtReportDocument> getEntityType() {
        return ClientDebtReportDocument.class;
    }

    public Class<ClientDebtReportDocumentIndex> getIndexClass() {
        return ClientDebtReportDocumentIndex.class;
    }
}

