/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.model.DivergenceReportDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.DivergenceReportDocumentIndexData;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DivergenceReportDocumentIndexHandler
implements IndexHandler<DivergenceReportDocument, DivergenceReportDocumentIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<DivergenceReportDocument, DivergenceReportDocumentIndex>> getDataClass() {
        return DivergenceReportDocumentIndexData.class;
    }

    public Class<DivergenceReportDocumentIndex> getIndexClass() {
        return DivergenceReportDocumentIndex.class;
    }

    public Class<DivergenceReportDocument> getEntityType() {
        return DivergenceReportDocument.class;
    }

    public void create(EntityContainer<DivergenceReportDocument> etc, Collection<BaseIndexData<DivergenceReportDocument, DivergenceReportDocumentIndex>> indexes) {
        DivergenceReportDocument document = (DivergenceReportDocument)etc.getEntity();
        DivergenceReportDocumentIndexData index = new DivergenceReportDocumentIndexData();
        List reportName = document.getFiles().stream().map(ReportFile::getTitle).collect(Collectors.toList());
        index.setCreated(document.getCreated());
        index.setCheckSum(document.getCheckSum());
        index.setReportType(document.getReportType());
        index.setReportName(reportName);
        DivergenceReportParameters parameters = document.getParameters();
        if (parameters != null) {
            index.setAgency(parameters.getAgency());
            index.setPeriodBegin(parameters.getPeriodBegin());
            index.setPeriodEnd(parameters.getPeriodEnd());
        }
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(document.getCreated());
        aggregator.aggregate(reportName);
        if (parameters != null) {
            aggregator.aggregate(parameters.getPeriodBegin());
            aggregator.aggregate(parameters.getPeriodEnd());
            aggregator.aggregate((Object)parameters.getAgency());
        }
        index.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<DivergenceReportDocument, DivergenceReportDocumentIndex>)index);
    }
}

