/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndexData;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameter;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameterBusinessType;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.Iterator;

public class IndexBasedTemplateReportDocumentIndexHandler
implements IndexHandler<BaseTemplateReportDocument, TemplateReportDocumentIndex> {
    public Class<? extends BaseIndexData<BaseTemplateReportDocument, TemplateReportDocumentIndex>> getDataClass() {
        return TemplateReportDocumentIndexData.class;
    }

    public Class<TemplateReportDocumentIndex> getIndexClass() {
        return TemplateReportDocumentIndex.class;
    }

    public Class<BaseTemplateReportDocument> getEntityType() {
        return BaseTemplateReportDocument.class;
    }

    public void create(EntityContainer<BaseTemplateReportDocument> etc, Collection<BaseIndexData<BaseTemplateReportDocument, TemplateReportDocumentIndex>> indexes) {
        BaseTemplateReportDocument entity = (BaseTemplateReportDocument)etc.getEntity();
        if (!(entity instanceof IndexBasedTemplateReportDocument)) {
            return;
        }
        TemplateReportDocumentIndexData data = new TemplateReportDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseTemplateReportDocument, TemplateReportDocumentIndex>)data);
    }

    protected void updateData(TemplateReportDocumentIndexData data, DataAggregator aggregator, EntityContainer<BaseTemplateReportDocument> etc) {
        IndexBasedTemplateReportDocument document = (IndexBasedTemplateReportDocument)etc.getEntity();
        EntityContainer descrCtr = EntityStorage.get().resolve(document.getParameters() == null ? null : document.getParameters().getDescription());
        EntityReference<?> agency = document.getParameters().getAgency();
        EntityReference<?> agent = null;
        EntityReference<?> subagency = null;
        EntityReference<?> supplier = null;
        EntityReference<?> client = null;
        EntityReference<?> salesPoint = null;
        if (descrCtr != null) {
            IndexBasedTemplateReportDescription description = (IndexBasedTemplateReportDescription)descrCtr.getEntity();
            for (RequestedParameterValue item : document.getParameters().getRequestedParameters()) {
                if (item.getKey() == null) continue;
                if (agency == null && this.isAppropriate(item.getKey(), TemplateReportRequestedParameterBusinessType.AGENCY, description)) {
                    agency = this.getReference(item.getValue());
                    continue;
                }
                if (this.isAppropriate(item.getKey(), TemplateReportRequestedParameterBusinessType.AGENT, description)) {
                    agent = this.getReference(item.getValue());
                    continue;
                }
                if (this.isAppropriate(item.getKey(), TemplateReportRequestedParameterBusinessType.CLIENT, description)) {
                    client = this.getReference(item.getValue());
                    continue;
                }
                if (this.isAppropriate(item.getKey(), TemplateReportRequestedParameterBusinessType.SUPPLIER, description)) {
                    supplier = this.getReference(item.getValue());
                    continue;
                }
                if (this.isAppropriate(item.getKey(), TemplateReportRequestedParameterBusinessType.SUBAGENCY, description)) {
                    subagency = this.getReference(item.getValue());
                    continue;
                }
                if (!this.isAppropriate(item.getKey(), TemplateReportRequestedParameterBusinessType.SALES_POINT, description)) continue;
                salesPoint = this.getReference(item.getValue());
            }
        }
        data.setSupplier(supplier);
        aggregator.aggregate(supplier);
        data.setAgency((EntityReference)agency);
        aggregator.aggregate((Object)agency);
        data.setSubagency(subagency);
        aggregator.aggregate(subagency);
        data.setClient(client);
        aggregator.aggregate(client);
        data.setSalesPoint(salesPoint);
        aggregator.aggregate(salesPoint);
        data.setAgent(agent);
        aggregator.aggregate(agent);
        data.setReportType(document.getReportType());
        aggregator.aggregate((Enum)document.getReportType());
        data.setCreated(document.getCreated());
        data.setDescription(document.getParameters().getDescription());
        aggregator.aggregate((Object)document.getParameters().getDescription());
        data.setNavigationKey(document.getUid());
        data.setPeriodBegin(document.getParameters().getPeriodBegin());
        data.setPeriodEnd(document.getParameters().getPeriodEnd());
        if (document.getFile() != null) {
            String title = document.getFile().getTitle() != null && document.getFile().getTitle().length() > 255 ? document.getFile().getTitle().substring(0, 252) + "..." : document.getFile().getTitle();
            data.setTitle(title);
            aggregator.aggregate((Object)title);
        }
    }

    private EntityReference<?> getReference(Object value) {
        Object val;
        Iterator iterator;
        if (value instanceof EntityReference) {
            return (EntityReference)value;
        }
        if (value instanceof Iterable && (iterator = ((Iterable)value).iterator()).hasNext() && (val = iterator.next()) instanceof EntityReference) {
            return (EntityReference)val;
        }
        return null;
    }

    private boolean isAppropriate(String key, TemplateReportRequestedParameterBusinessType businessType, IndexBasedTemplateReportDescription description) {
        for (TemplateReportRequestedParameter parameter : description.getRequestedParameters()) {
            if (key == null || !key.equals(parameter.getKey()) || parameter.getBusinessType() != businessType) continue;
            return true;
        }
        return false;
    }
}

