/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.MultipleFilesTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.MultipleFilesTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.reports.prepare.template.multifiles.MultipleFilesTemplateReportIndexProfileData;
import com.gridnine.xtrip.server.reports.prepare.template.multifiles.MultipleFilesTemplateReportServerHandlersRegistry;
import java.util.Collection;

public class MultipleFilesTemplateReportDocumentIndexHandler
implements IndexHandler<BaseTemplateReportDocument, TemplateReportDocumentIndex> {
    public Class<? extends BaseIndexData<BaseTemplateReportDocument, TemplateReportDocumentIndex>> getDataClass() {
        return TemplateReportDocumentIndexData.class;
    }

    public Class<TemplateReportDocumentIndex> getIndexClass() {
        return TemplateReportDocumentIndex.class;
    }

    public Class<BaseTemplateReportDocument> getEntityType() {
        return BaseTemplateReportDocument.class;
    }

    public void create(EntityContainer<BaseTemplateReportDocument> etc, Collection<BaseIndexData<BaseTemplateReportDocument, TemplateReportDocumentIndex>> indexes) {
        BaseTemplateReportDocument entity = (BaseTemplateReportDocument)etc.getEntity();
        if (!(entity instanceof MultipleFilesTemplateReportDocument)) {
            return;
        }
        MultipleFilesTemplateReportDocument document = (MultipleFilesTemplateReportDocument)entity;
        TemplateReportDocumentIndexData index = new TemplateReportDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        EntityContainer descrCtr = EntityStorage.get().resolve(document.getParameters() == null ? null : document.getParameters().getDescription());
        EntityReference<Organization> agency = null;
        EntityReference<Person> agent = null;
        EntityReference subagency = null;
        EntityReference<Organization> supplier = null;
        EntityReference<Organization> client = null;
        EntityReference<SalesPoint> salesPoint = null;
        if (descrCtr != null) {
            MultipleFilesTemplateReportDescription description = (MultipleFilesTemplateReportDescription)descrCtr.getEntity();
            for (EntityReference item : description.getDescriptions()) {
                MultipleFilesTemplateReportIndexProfileData indexData = MultipleFilesTemplateReportServerHandlersRegistry.get().getHandler(item.getType()).createIndexData(item, document.getParameters().getRequestedParameters());
                if (agency == null) {
                    agency = indexData.getAgency();
                }
                if (agent == null) {
                    agent = indexData.getAgent();
                }
                if (supplier == null) {
                    supplier = indexData.getSupplier();
                }
                if (client == null) {
                    client = indexData.getClient();
                }
                if (salesPoint != null) continue;
                salesPoint = indexData.getSalesPoint();
            }
        }
        index.setSupplier(supplier);
        aggregator.aggregate(supplier);
        index.setAgency(agency);
        aggregator.aggregate(agency);
        index.setSubagency(subagency);
        aggregator.aggregate(subagency);
        index.setClient(client);
        aggregator.aggregate(client);
        index.setSalesPoint(salesPoint);
        aggregator.aggregate(salesPoint);
        index.setAgent(agent);
        aggregator.aggregate(agent);
        index.setReportType(document.getReportType());
        aggregator.aggregate((Enum)document.getReportType());
        index.setCreated(document.getCreated());
        index.setDescription(document.getParameters().getDescription());
        aggregator.aggregate((Object)document.getParameters().getDescription());
        index.setNavigationKey(document.getUid());
        index.setPeriodBegin(document.getParameters().getPeriodBegin());
        index.setPeriodEnd(document.getParameters().getPeriodEnd());
        String title = document.getTitle() != null && document.getTitle().length() > 255 ? document.getTitle().substring(0, 252) + "..." : document.getTitle();
        index.setTitle(title);
        aggregator.aggregate((Object)title);
        index.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseTemplateReportDocument, TemplateReportDocumentIndex>)index);
    }
}

