/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.model.ProductReportDocument;
import com.gridnine.xtrip.common.reports.model.ProductReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.ProductReportDocumentIndexData;
import com.gridnine.xtrip.common.reports.model.ProductReportParameters;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class ProductReportDocumentIndexHandler
implements IndexHandler<ProductReportDocument, ProductReportDocumentIndex> {
    public Class<? extends BaseIndexData<ProductReportDocument, ProductReportDocumentIndex>> getDataClass() {
        return ProductReportDocumentIndexData.class;
    }

    public Class<ProductReportDocumentIndex> getIndexClass() {
        return ProductReportDocumentIndex.class;
    }

    public Class<ProductReportDocument> getEntityType() {
        return ProductReportDocument.class;
    }

    public void create(EntityContainer<ProductReportDocument> etc, Collection<BaseIndexData<ProductReportDocument, ProductReportDocumentIndex>> indexes) {
        ProductReportDocument document = (ProductReportDocument)etc.getEntity();
        ProductReportDocumentIndexData index = new ProductReportDocumentIndexData();
        index.setCreated(document.getCreated());
        index.setCheckSum(document.getCheckSum());
        ProductReportParameters parameters = document.getParameters();
        DataAggregator aggregator = new DataAggregator();
        if (parameters != null) {
            index.setAgency(parameters.getAgency());
            index.setPeriodBegin(parameters.getPeriodBegin());
            index.setPeriodEnd(parameters.getPeriodEnd());
            index.setSubagency(parameters.getSubagency());
            index.setSalesPoint(parameters.getSalesPoint());
            index.setSupplier(parameters.getSupplier());
            index.setVendor(parameters.getVendor());
            aggregator.aggregate((Object)parameters.getAgency());
            aggregator.aggregate((Object)parameters.getSubagency());
            aggregator.aggregate((Object)parameters.getSalesPoint());
            aggregator.aggregate((Object)parameters.getSupplier());
            aggregator.aggregate((Object)parameters.getVendor());
        }
        aggregator.aggregate(document.getCreated());
        if (parameters != null) {
            aggregator.aggregate(parameters.getPeriodBegin());
            aggregator.aggregate(parameters.getPeriodEnd());
        }
        index.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<ProductReportDocument, ProductReportDocumentIndex>)index);
    }
}

