/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.SalesReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.SalesReportDocumentIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDocumentIndexHandler
implements IndexHandler<ReportDocument, SalesReportDocumentIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<ReportDocument, SalesReportDocumentIndex>> getDataClass() {
        return SalesReportDocumentIndexData.class;
    }

    public Class<SalesReportDocumentIndex> getIndexClass() {
        return SalesReportDocumentIndex.class;
    }

    public Class<ReportDocument> getEntityType() {
        return ReportDocument.class;
    }

    public void create(EntityContainer<ReportDocument> etc, Collection<BaseIndexData<ReportDocument, SalesReportDocumentIndex>> indexes) {
        ReportDocument document = (ReportDocument)etc.getEntity();
        SalesReportDocumentIndexData index = new SalesReportDocumentIndexData();
        index.setCreated(document.getCreated());
        index.setCheckSum(document.getCheckSum());
        ReportParameters parameters = document.getParameters();
        if (parameters != null) {
            index.setAgency(parameters.getAgency());
            index.setPeriodBegin(parameters.getPeriodBegin());
            index.setPeriodEnd(parameters.getPeriodEnd());
            index.setSubagency(parameters.getSubagency());
            index.setSalesPoint(parameters.getSalesPoint());
            index.setSupplier(parameters.getSupplier());
        }
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(document.getCreated());
        if (parameters != null) {
            aggregator.aggregate(parameters.getPeriodBegin());
            aggregator.aggregate(parameters.getPeriodEnd());
        }
        index.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<ReportDocument, SalesReportDocumentIndex>)index);
    }
}

