/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.model.TripartiteReportDocument;
import com.gridnine.xtrip.common.reports.model.TripartiteReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.TripartiteReportDocumentIndexData;
import com.gridnine.xtrip.common.reports.model.TripartiteReportParameters;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripartiteReportDocumentIndexHandler
implements IndexHandler<TripartiteReportDocument, TripartiteReportDocumentIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<TripartiteReportDocument, TripartiteReportDocumentIndex>> getDataClass() {
        return TripartiteReportDocumentIndexData.class;
    }

    public Class<TripartiteReportDocumentIndex> getIndexClass() {
        return TripartiteReportDocumentIndex.class;
    }

    public Class<TripartiteReportDocument> getEntityType() {
        return TripartiteReportDocument.class;
    }

    public void create(EntityContainer<TripartiteReportDocument> etc, Collection<BaseIndexData<TripartiteReportDocument, TripartiteReportDocumentIndex>> indexes) {
        TripartiteReportDocument document = (TripartiteReportDocument)etc.getEntity();
        TripartiteReportDocumentIndexData index = new TripartiteReportDocumentIndexData();
        index.setCreated(document.getCreated());
        index.setCheckSum(document.getCheckSum());
        TripartiteReportParameters parameters = document.getParameters();
        HashSet vendors = new HashSet();
        if (parameters != null) {
            index.setAgency(parameters.getAgency());
            index.setPeriodBegin(parameters.getPeriodBegin());
            index.setPeriodEnd(parameters.getPeriodEnd());
            index.setClient(parameters.getClient());
            index.setContract(parameters.getContract());
            index.setTourCode(parameters.getTourCode());
            index.setBlankOwner(parameters.getBlankOwner());
        }
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(document.getCreated());
        if (parameters != null) {
            aggregator.aggregate(parameters.getPeriodBegin());
            aggregator.aggregate(parameters.getPeriodEnd());
            aggregator.aggregate(vendors);
            aggregator.aggregate((Object)parameters.getAgency());
            aggregator.aggregate((Object)parameters.getClient());
            aggregator.aggregate((Object)parameters.getContract());
            aggregator.aggregate((Object)parameters.getTourCode());
            aggregator.aggregate((Object)parameters.getBlankOwner());
        }
        index.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<TripartiteReportDocument, TripartiteReportDocumentIndex>)index);
    }
}

