/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.ValidationMessageDict;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseReportPrepareHandler
implements ReportPrepareHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = (ArrayList<Message>)data.get("key-messages");
        if (messages == null) {
            messages = new ArrayList<Message>();
            data.put("key-messages", messages);
        }
        this.checkReportParameters(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.putGlobalData(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        ArrayList<Product> products = new ArrayList<Product>(this.getData(data, messages));
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        for (Product product : products) {
            this.validateProductToReport(product, data, messages);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.sortProducts(products, data);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        for (Product product : products) {
            this.addProductProxyTicket(product, data, messages);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        ArrayList<AgencyMemoProduct> agencyMemoProducts = new ArrayList<AgencyMemoProduct>(this.getAgencyMemoProductData(data, messages));
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        for (AgencyMemoProduct agencyMemoProduct : agencyMemoProducts) {
            this.validateAgencyMemoProductToReport(agencyMemoProduct, data, messages);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.sortAgencyMemoProducts(agencyMemoProducts, data);
        for (AgencyMemoProduct agencyMemoProduct : agencyMemoProducts) {
            this.addAgencyMemoProductProxyTicket(agencyMemoProduct, data, messages);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.afterFillDataLists(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
    }

    protected void sortProducts(List<Product> products, Map<String, Object> data) {
        Collections.sort(products, new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                return TextUtil.compare((String)o1.getSystemNumber(), (String)o2.getSystemNumber(), (boolean)false, (boolean)true);
            }
        });
    }

    protected void sortBaseProducts(List<BaseProduct> products, Map<String, Object> data) {
        products.sort((o1, o2) -> {
            String systemNumber1 = GeneralProductHelper.getSystemNumber((BaseProduct)o1);
            String systemNumber2 = GeneralProductHelper.getSystemNumber((BaseProduct)o2);
            return TextUtil.compare((String)systemNumber1, (String)systemNumber2, (boolean)false, (boolean)true);
        });
    }

    protected void sortAgencyMemoProducts(List<AgencyMemoProduct> agencyMemoProducts, Map<String, Object> data) {
        Collections.sort(agencyMemoProducts, new Comparator<AgencyMemoProduct>(){

            @Override
            public int compare(AgencyMemoProduct o1, AgencyMemoProduct o2) {
                return TextUtil.compare((String)o1.getSystemNumber(), (String)o2.getSystemNumber(), (boolean)false, (boolean)true);
            }
        });
    }

    protected void validateProductToReport(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)product, messages);
    }

    protected void validateAgencyMemoProductToReport(AgencyMemoProduct agencyMemoProduct, Map<String, Object> data, List<Message> messages) throws Exception {
        BaseReportPrepareHandler.baseValidateAgencyMemoProductToReport(agencyMemoProduct, messages);
    }

    protected abstract Collection<? extends Product> getData(Map<String, Object> var1, List<Message> var2) throws Exception;

    protected Collection<? extends AgencyMemoProduct> getAgencyMemoProductData(Map<String, Object> data, List<Message> messages) throws Exception {
        return Collections.emptySet();
    }

    protected abstract void putGlobalData(Map<String, Object> var1, List<Message> var2) throws Exception;

    protected void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        if (data.get("key-report-params") == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoReportParameters", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
            return;
        }
    }

    protected abstract void addProductProxyTicket(Product var1, Map<String, Object> var2, List<Message> var3) throws Exception;

    protected void addAgencyMemoProductProxyTicket(AgencyMemoProduct agencyMemoProduct, Map<String, Object> data, List<Message> messages) throws Exception {
    }

    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
    }

    public static void putStandardReportParameters(Date periodBegin, Date periodEnd, Map<String, Object> data, List<Message> messages) {
        String reportPeriod = "";
        String reportFileName = "";
        SimpleDateFormat df = new SimpleDateFormat("dd", new Locale("ru", "RU"));
        SimpleDateFormat df2 = new SimpleDateFormat("dd.MM.yy", new Locale("ru", "RU"));
        if (periodBegin != null && periodEnd != null) {
            if (periodBegin.getDate() == periodEnd.getDate() && periodBegin.getMonth() == periodEnd.getMonth() && periodBegin.getYear() == periodEnd.getYear()) {
                reportPeriod = df2.format(periodEnd);
                reportFileName = reportFileName + "_" + df2.format(periodEnd);
            } else if (periodBegin.getMonth() == periodEnd.getMonth() && periodBegin.getYear() == periodEnd.getYear()) {
                reportPeriod = df.format(periodBegin) + "-" + df2.format(periodEnd);
                reportFileName = reportFileName + "_" + df2.format(periodBegin) + "-" + df2.format(periodEnd);
            } else {
                reportPeriod = df2.format(periodBegin) + "-" + df2.format(periodEnd);
                reportFileName = reportFileName + "_" + df2.format(periodBegin) + "-" + df2.format(periodEnd);
            }
        }
        data.put("REPORT_PERIOD", reportPeriod);
        data.put("KEY_REPORT_FILENAME", reportFileName);
    }

    public static void baseValidateProductToReport(BaseProduct product, List<Message> messages) throws Exception {
        boolean hasWarnings = false;
        if (!GeneralProductHelper.isChecked((BaseProduct)product)) {
            for (ValidationMessage message : GeneralProductHelper.getValidationMessages((BaseProduct)product)) {
                ValidationMessageSeverity severity = BaseReportPrepareHandler.getSeverity(message);
                if (severity == ValidationMessageSeverity.MESSAGE || message.getCategory() != ValidationMessageCategory.OTHER && message.getCategory() != ValidationMessageCategory.RULES) continue;
                if (severity == ValidationMessageSeverity.WARNING) {
                    hasWarnings = true;
                }
                if (severity != ValidationMessageSeverity.ERROR) continue;
                String errorMessage = String.format("product %s has validation error: %s", GeneralProductHelper.getSystemNumber((BaseProduct)product), message.getMessage() != null ? message.getMessage().toString() : "");
                LoggerFactory.getLogger(BaseReportPrepareHandler.class).error(errorMessage);
                SystemHelper.addMessage(messages, (String)Messages.BaseReportPrepareHandler_productHasValidationError, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{GeneralProductHelper.getSystemNumber((BaseProduct)product), message.getMessage() != null ? message.getMessage().toString() : ""});
            }
        }
        if (hasWarnings) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_ProductHasWarnings", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{GeneralProductHelper.getSystemNumber((BaseProduct)product), GeneralProductHelper.getStatus((BaseProduct)product)});
        }
    }

    public static ValidationMessageSeverity getSeverity(ValidationMessage message) {
        List messageDicts = DictHelper.findValidationMessagesByErrorCode((String)message.getErrorCode());
        if (messageDicts.size() != 1 || ((ValidationMessageDict)messageDicts.get(0)).getSeverity() == null) {
            return message.getSeverity();
        }
        return ((ValidationMessageDict)messageDicts.get(0)).getSeverity();
    }

    public static void baseValidateAgencyMemoProductToReport(AgencyMemoProduct agencyMemoProduct, List<Message> messages) throws Exception {
        boolean hasWarnings = false;
        boolean hasErrors = false;
        if (!agencyMemoProduct.isChecked()) {
            for (ValidationMessage message : agencyMemoProduct.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.MESSAGE) continue;
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    hasWarnings = true;
                    continue;
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                hasErrors = true;
            }
        }
        if (hasWarnings) {
            SystemHelper.addMessage(messages, (String)Messages.BaseReportPrepareHandler_ticketWarning, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{agencyMemoProduct.getSystemNumber()});
        }
        if (hasErrors) {
            SystemHelper.addMessage(messages, (String)Messages.BaseReportPrepareHandler_ticketError, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{agencyMemoProduct.getSystemNumber()});
        }
        if (agencyMemoProduct.getAcceptDate() == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseReportPrepareHandler_claimsDateValidation, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{agencyMemoProduct.getSystemNumber()});
        }
        if (agencyMemoProduct.getItemGroups().isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.BaseReportPrepareHandler_claimsValidationComponent, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{agencyMemoProduct.getSystemNumber()});
        }
    }

    public static void putStandardAgencyData(EntityReference<Organization> agencyRef, Map<String, Object> data, List<Message> messages) throws Exception {
        List com;
        Organization agency;
        Logger log = LoggerFactory.getLogger(BaseReportPrepareHandler.class);
        EntityContainer ac = EntityStorage.get().resolve(agencyRef);
        if (agencyRef != null && ac == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{agencyRef});
            log.debug("Could not find entity in database");
            return;
        }
        EntityReference agencyReference = ac != null ? ac.toReference() : null;
        Organization organization = agency = ac != null ? (Organization)ac.getEntity() : null;
        if (agency != null) {
            List addresses = ProfileHelper.getOrganizationAddresses((Organization)agency);
            data.put("AGENCY_NAME", ProfileHelper.getFullName((Organization)agency, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            data.put("AGENCY_CODE_", agency.getCode());
            data.put("AGENT_LOCATION", ProfileHelper.buildFullAddress((Address)(addresses.isEmpty() ? null : (Address)addresses.get(0)), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            data.put("AGENCY_INN", agency.getRegistrationId());
            for (Metadata metadata : agency.getMetadata()) {
                if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_CONTRACT_NO.name())) continue;
                data.put("CONTRACT_NO", metadata.getValue());
                data.put("AGREEMENT_NO", metadata.getRemarks());
                break;
            }
        }
        List employees = ProfileDao.getEmployees((EntityReference)agencyReference, (ManagerType[])new ManagerType[0], (Date)new Date());
        for (Person employee : employees) {
            String fullName = ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            Set standardPositions = ProfileHelper.getStandardPositions((List)employee.getEmployments(), (EntityReference)agencyReference);
            for (ManagerType standardPosition : standardPositions) {
                if (standardPosition == ManagerType.DIRECTOR) {
                    data.put("AGENCY_DIRECTOR", fullName);
                    continue;
                }
                if (standardPosition == ManagerType.CHIEF_ACCOUNTANT) {
                    data.put("AGENCY_ACCOUNTANT", fullName);
                    continue;
                }
                if (standardPosition != ManagerType.CHIEF_MUTUAL) continue;
                data.put("AGENCY_CHIEF_MUTUAL", fullName);
            }
        }
        List list = com = agency != null ? agency.getCommunications() : Collections.emptyList();
        if (!com.isEmpty()) {
            String phone = "";
            String email = "";
            for (Communication communication : com) {
                String sense = communication.getSense() != null && !communication.getSense().isEmpty() ? communication.getSense() : "";
                switch (communication.getType()) {
                    case HOME_PHONE: 
                    case WORK_PHONE: 
                    case MOBILE: {
                        phone = sense;
                        break;
                    }
                    case EMAIL: {
                        email = sense;
                        break;
                    }
                }
            }
            data.put("AGENCY_PHONE", phone);
            data.put("AGENCY_EMAIL", email);
        } else {
            data.put("AGENCY_PHONE", "-");
            data.put("AGENCY_EMAIL", "-");
        }
    }

    protected boolean useInitialsForAgencyManagers() {
        return false;
    }
}

