/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareHandlersRegistry
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ReportPrepareHandler> handlers = new HashMap<String, ReportPrepareHandler>();

    public PrepareHandlersRegistry() {
        this.registerStandardHandlers();
    }

    protected void registerStandardHandlers() {
        PluginManager pm = PluginManager.lookup(this.getClass());
        if (pm == null) {
            return;
        }
        for (Extension ext : pm.getRegistry().getExtensionPoint("com.gridnine.xtrip.server.reports", "ReportPrepareHandlers").getConnectedExtensions()) {
            Collection parameters = ext.getParameters("class");
            for (Extension.Parameter param : parameters) {
                try {
                    this.register((ReportPrepareHandler)JpfUtil.getClass((Extension.Parameter)param).newInstance());
                }
                catch (Exception e) {
                    this.log.error("failed registering handler from " + param, (Throwable)e);
                }
            }
        }
    }

    public void dispose() {
        this.handlers.clear();
    }

    public void register(ReportPrepareHandler handler) {
        this.handlers.put(handler.getId(), handler);
        this.log.info("registered handler " + handler);
    }

    public ReportPrepareHandler get(String id) {
        ReportPrepareHandler result = this.handlers.get(id);
        if (result == null) {
            throw new IllegalArgumentException("unknown handler ID - " + id);
        }
        return result;
    }
}

