/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.MultiException;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.usage.IndexUsageSource;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.model.tasks.AsyncServerTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseAsyncServerTask;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.PrepareReportCallback;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class PrepareReportTask
extends BaseAsyncServerTask {
    public Object execute(AsyncServerTask.Callback callback, Object parameters) throws Exception {
        Map context = (Map)parameters;
        String reportId = (String)context.get("ASYNC_TASK_REPORT_ID");
        Object execute = EntityStorageThreadContext.execute(() -> {
            EntityStorageThreadContext.setDefaultDataSource((String)("PrepareReportTask " + reportId));
            return this.getParams(context, reportId, callback);
        });
        return execute;
    }

    private Object getParams(Map<String, Object> context, String reportId, final AsyncServerTask.Callback callback) throws Exception {
        Map params = (Map)context.get("ASYNC_TASK_REPORT_CONTEXT");
        ReportPrepareHandler handler = ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get(reportId);
        if (handler == null) {
            ArrayList<Message> messages = (ArrayList<Message>)params.get("key-messages");
            if (messages == null) {
                messages = new ArrayList<Message>();
                params.put("key-messages", messages);
            }
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043f\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0443 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u0438 \u043e\u0434\u0438\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043e\u0442\u0447\u0435\u0442\u0430", (Object[])new Object[]{reportId}));
            return params;
        }
        params.put("KEY_PREPARE_REPORT_CALLBACK", new PrepareReportCallback(){

            @Override
            public void updateProgress(byte progress, String message) {
                callback.updateProgress(progress, message);
            }

            @Override
            public boolean isToBeStopped() {
                return PrepareReportTask.this.isToBeStopped();
            }
        });
        EntityStorage entityStorage = EntityStorage.get();
        if (entityStorage instanceof IrrelevanceTolerantEntityStorage) {
            ((IrrelevanceTolerantEntityStorage)entityStorage).setTolerant(true);
            this.log.debug("storage irrelevance tolerant mode turned on");
        }
        try {
            IndexUsageHandler.wrapAndExecute((IndexUsageHandler.IndexUsageContext)this.createUsageContext(reportId, params), () -> {
                handler.prepareData(params);
                return null;
            });
        }
        catch (Exception e) {
            MultiException multiException = new MultiException();
            multiException.addException((Throwable)e);
            try {
                PrepareReportTask.enrichException(e, reportId, params.get("key-report-params"));
            }
            catch (Exception ex) {
                multiException.addException((Throwable)ex);
            }
            throw multiException;
        }
        finally {
            if (entityStorage instanceof IrrelevanceTolerantEntityStorage) {
                ((IrrelevanceTolerantEntityStorage)entityStorage).setTolerant(false);
                this.log.debug("storage irrelevance tolerant mode turned off");
            }
        }
        params.remove("KEY_PREPARE_REPORT_CALLBACK");
        return params;
    }

    private IndexUsageHandler.IndexUsageContext createUsageContext(String reportId, Map<String, Object> params) {
        EntityReference descrRef;
        EntityType et;
        Object reportParameters = params.get("key-report-params");
        String descriptionUid = null;
        if (reportParameters instanceof Introspectable && (et = MetaRegistryHelper.getEntityType((String)reportParameters.getClass().getName())).getProperties().containsKey("description") && (descrRef = (EntityReference)((Introspectable)reportParameters).getValue("description")) != null) {
            descriptionUid = descrRef.getUid();
        }
        return new IndexUsageHandler.IndexUsageContext(IndexUsageSource.REPORT, reportId, descriptionUid);
    }

    public static void enrichException(Exception e, String reportId, Object reportParameters) throws Exception {
        if (reportParameters instanceof Introspectable) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            Exception getParamsException = null;
            try {
                requestParameters.putAll(PrepareReportTask.getRequestParameters(reportParameters));
            }
            catch (Exception ex) {
                getParamsException = ex;
            }
            EntityType et = MetaRegistryHelper.getEntityType((String)reportParameters.getClass().getName());
            if (et.getProperties().containsKey("description")) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length + 3 + requestParameters.keySet().size()];
                newStackTrace[0] = new StackTraceElement("<<Context>>", "ReportId", reportId, -1);
                newStackTrace[1] = new StackTraceElement("<<Context>>", "Description caption", MiscUtil.toString((Object)((Introspectable)reportParameters).getValue("description")), -1);
                EntityReference descrRef = (EntityReference)((Introspectable)reportParameters).getValue("description");
                newStackTrace[2] = new StackTraceElement("<<Context>>", "Description uid", descrRef == null ? "" : descrRef.getUid(), -1);
                Iterator parmsIter = requestParameters.keySet().iterator();
                for (int i = 0; i < requestParameters.keySet().size(); ++i) {
                    String key;
                    newStackTrace[i + 3] = new StackTraceElement("<<Context>>", key, requestParameters.get(key = (String)parmsIter.next()) == null ? "" : (String)requestParameters.get(key), -1);
                }
                System.arraycopy(stackTrace, 0, newStackTrace, 3 + requestParameters.keySet().size(), stackTrace.length);
                e.setStackTrace(newStackTrace);
                if (Objects.nonNull(getParamsException)) {
                    throw getParamsException;
                }
                return;
            }
        }
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length + 1];
        newStackTrace[0] = new StackTraceElement("<<Context>>", "ReportId", reportId, -1);
        System.arraycopy(stackTrace, 0, newStackTrace, 1, stackTrace.length);
        e.setStackTrace(newStackTrace);
    }

    private static Map<String, String> getRequestParameters(Object reportParameters) throws Exception {
        HashMap<String, String> reqParamMap = new HashMap<String, String>();
        Object reqParamsObject = ((Introspectable)reportParameters).getValue("requestedParameters");
        if (Objects.nonNull(reqParamsObject) && Iterable.class.isAssignableFrom(reqParamsObject.getClass())) {
            Iterable iterableReq = (Iterable)reqParamsObject;
            for (Object next : iterableReq) {
                if (Objects.isNull(next) || !Introspectable.class.isAssignableFrom(next.getClass())) continue;
                Introspectable element = (Introspectable)next;
                String key = "InputParameter: key = " + element.getValue("key");
                String value = "";
                value = element instanceof XSSerializable ? value + XSUtil.toString((XSSerializable)((RequestedParameterValue)element)).replaceAll(System.lineSeparator(), "") : value + element.toString();
                reqParamMap.put(key, value);
            }
        }
        return reqParamMap;
    }
}

