/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.agentreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentReportAirPrepareHandler
implements AgentReportProductPrepareHandler<Product> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public List<AgentReportTicket> createTickets(Product product, Map<String, Object> data) {
        List messages = (List)data.get("key-messages");
        String retailTravellerUid = (String)data.get("RETAIL_TRAVELLER_UID");
        AgentReportParameters params = (AgentReportParameters)data.get("key-report-params");
        ArrayList<AgentReportTicket> result = new ArrayList<AgentReportTicket>();
        for (int n = 0; n <= product.getConjCount(); ++n) {
            boolean hasExchange;
            BigDecimal feeAmount;
            AgentReportTicket ticket = new AgentReportTicket();
            result.add(ticket);
            ProductStatus status = product.getStatus();
            ticket.setStatus(status);
            ticket.setMcoCategory(product.getMcoCategory());
            ticket.setProductCategory(product.getProductCategory());
            ticket.setUid(product.getUid());
            ticket.setTicketNumber(product.getSystemNumber());
            ticket.setBlankOwner(product.getBlankOwnerRef());
            try {
                EntityStorage.get().actualize(ticket.getBlankOwner(), new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            }
            catch (Exception e1) {
                this.log.error("unable to actualize reference " + ticket.getBlankOwner(), (Throwable)e1);
            }
            String groupName = ticket.getBlankOwner() != null ? ticket.getBlankOwner().getCaption() : null;
            String airlines = (String)data.get("SPECIAL_BSP_CARRIERS");
            if ("BSP".equals(product.getBlankOwnerNumber()) && !TextUtil.isBlank((String)airlines) && product.getCarrier() != null) {
                airlines = airlines.toUpperCase().trim();
                Airline airline = (Airline)DictionaryCache.get().resolveReference(product.getCarrier());
                boolean found = false;
                for (String code : airline.getCodeVariants().values()) {
                    if (!airlines.contains(code)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    groupName = groupName + " - " + airline.toString();
                }
            }
            if (AirProductHelper.getSupplier((Product)product) != null && product.getBlankOwnerRef() != null && !AirProductHelper.getSupplier((Product)product).equals((Object)product.getBlankOwnerRef())) {
                try {
                    EntityStorage.get().actualize(AirProductHelper.getSupplier((Product)product), new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
                    groupName = groupName + String.format("(%s)", AirProductHelper.getSupplier((Product)product));
                }
                catch (Exception e1) {
                    this.log.error("unable to actualize reference " + AirProductHelper.getSupplier((Product)product), (Throwable)e1);
                }
            }
            ticket.setGroupName(groupName);
            ticket.setEquivalentFare(status != ProductStatus.VOID ? AirProductHelper.getEquivalentFare((Product)product) : BigDecimal.ZERO);
            ticket.setTicketSeries(AirProductHelper.getTicketSeries((Product)product));
            ticket.setIssueDate(product.getIssueDate());
            ticket.resetFinanceFields(false);
            if (!ProductStatusHandler.getAllVoidStatuses().contains(status) && product.getReservation() != null && product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomerProfile() != null && !product.getReservation().getBookingFile().getCustomerProfile().getUid().equals(retailTravellerUid)) {
                EntityReference customerProfile = product.getReservation().getBookingFile().getCustomerProfile();
                EntityStorage.get().actualize(customerProfile, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
                ticket.setRemarks(customerProfile.getCaption());
            }
            boolean avianovaTicket = false;
            try {
                EntityContainer ctr = EntityStorage.get().resolve(product.getBlankOwnerRef());
                avianovaTicket = ((Organization)ctr.getEntity()).getAirline() != null && "AO".equals(((Organization)ctr.getEntity()).getAirline().getCode());
            }
            catch (Throwable e1) {
                this.log.error("unable to resolve " + product.getBlankOwnerRef(), e1);
            }
            if (avianovaTicket) {
                String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation());
                ticket.setRemarks(ticket.getRemarks() != null ? String.format("%s (%s)", ticket.getRemarks(), recordLocator) : recordLocator);
            }
            ticket.setSellIssueDate(ticket.getIssueDate());
            if (status == ProductStatus.REFUND && product.getPreviousProduct() != null) {
                ticket.setSellIssueDate(product.getPreviousProduct().getIssueDate());
            }
            ticket.setPayedInReportPeriod(this.isPayedInReportPeriod(params, product, false) && !this.isIssuedInReportPeriod(params, product));
            ticket.setRefusedInReportPeriod(this.isRefusedInReportPeriod(params, product, false));
            ticket.setIssuedInReportPeriod(this.isIssuedInReportPeriod(params, product));
            ticket.setSortingTicketNumber(ticket.getTicketSeries() + ticket.getTicketNumber());
            if (status == ProductStatus.VOID || status == ProductStatus.VOID_BOOKING) {
                ticket.setRouteLine("VOID");
            } else {
                ticket.setRouteLine(AirProductHelper.getRouteLine((Product)product, null, (boolean)true, (CodeSystem)CodeSystem.IATA));
            }
            if (ticket.getEquivalentFare() == null) {
                ticket.setEquivalentFare(BigDecimal.ZERO);
            }
            if (status == null) {
                SystemHelper.addMessage((Collection)messages, (String)Messages.GeneralProductAgentReportPrepareHelper_ticketNoState, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                continue;
            }
            if (status == ProductStatus.VOID) continue;
            ProductCategory productCategory = ticket.getProductCategory();
            MCOCategory mcoCategory = ticket.getMcoCategory();
            if (productCategory == ProductCategory.MCO && (mcoCategory == MCOCategory.PENALTY || mcoCategory == MCOCategory.INFORMATION)) {
                if (mcoCategory == MCOCategory.PENALTY) {
                    ticket.setPenaltyAmount(AirProductHelper.getEquivalentFare((Product)product));
                    ticket.setEquivalentFare(BigDecimal.ZERO);
                } else {
                    ticket.resetFinanceFields(true);
                }
                Product prod = AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
                if (prod == null) {
                    SystemHelper.addMessage((Collection)messages, (String)Messages.AgentReportAirPrepareHandler_ticketNoState, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), ProductStatus.REFUND});
                    continue;
                }
                if (mcoCategory == MCOCategory.PENALTY) {
                    if (prod.getStatus() == ProductStatus.REFUND) {
                        ticket.setRefundPenaltyMCO(true);
                    } else {
                        ticket.setExchangePenaltyMCO(true);
                    }
                } else if (prod.getStatus() == ProductStatus.REFUND) {
                    ticket.setRefundReceiptMCO(true);
                } else {
                    ticket.setExchangeReceiptMCO(true);
                }
                ticket.setSortingTicketNumber(AirProductHelper.getTicketSeries((Product)prod) + prod.getSystemNumber());
            }
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            BigDecimal totalAmount = BigDecimal.ZERO;
            VatAmount fullPrice = handler.calculateProductPrice((BaseProduct)product, ContractType.CLIENT);
            if (fullPrice != null) {
                totalAmount = fullPrice.getTotal();
            }
            if ((feeAmount = GeneralProductHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.CLIENT)) != null) {
                totalAmount = totalAmount.add(feeAmount);
            }
            if (ticket.isRefundReceiptMCO() || ticket.isExchangeReceiptMCO() || totalAmount.compareTo(BigDecimal.ZERO) == 0) {
                ticket.resetFinanceFields(true);
                continue;
            }
            boolean bl = hasExchange = productCategory == ProductCategory.AIR && status == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            if (product.getPenalty() != null && Math.abs(product.getPenalty().doubleValue()) > 0.0) {
                if (status == ProductStatus.REFUND && this.hasRelatedPenaltyMCO(product)) {
                    ticket.setPenaltyAmount(null);
                } else if (hasExchange && this.hasRelatedPenaltyMCO(product.getPreviousProduct())) {
                    ticket.setPenaltyAmount(null);
                } else {
                    ticket.setPenaltyAmount(product.getPenalty());
                }
            }
            ticket.setRuTaxAmount(AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)product));
            ticket.setOtherTaxesAmount(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product).subtract(ticket.getRuTaxAmount()));
            List allFops = BaseReportTicket.collectFops((Product)product, (boolean)true, (List)messages);
            if (allFops == null) continue;
            if (allFops.isEmpty() && !MCOCategory.INFORMATION.equals((Object)ticket.getMcoCategory())) {
                SystemHelper.addMessage((Collection)messages, (String)Messages.GeneralProductAgentReportPrepareHelper_ticketNoFop, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                continue;
            }
            for (PaymentType ptype : PaymentType.values()) {
                this.updateValue(ticket.getTotals(), allFops, ptype, FopType.TOTAL, product, params.getPeriodBegin(), params.getPeriodEnd(), (EntityReference<Person>)params.getAgent(), messages);
                this.updateValue(ticket.getFees(), allFops, ptype, FopType.FEE, product, params.getPeriodBegin(), params.getPeriodEnd(), (EntityReference<Person>)params.getAgent(), messages);
                this.updateValue(ticket.getFeesForRefund(), allFops, ptype, FopType.FEE_FOR_REFUND, product, params.getPeriodBegin(), params.getPeriodEnd(), (EntityReference<Person>)params.getAgent(), messages);
            }
            if (status == ProductStatus.REFUND) {
                ticket.setOtherTaxesAmount(ticket.getOtherTaxesAmount().negate());
                ticket.setRuTaxAmount(ticket.getRuTaxAmount().negate());
                ticket.setEquivalentFare(ticket.getEquivalentFare().negate());
                for (Map.Entry entry : ticket.getTotals().entrySet()) {
                    entry.setValue(((BigDecimal)entry.getValue()).negate());
                }
                for (Map.Entry entry : ticket.getFees().entrySet()) {
                    entry.setValue(((BigDecimal)entry.getValue()).negate());
                }
                for (Map.Entry entry : ticket.getFeesForRefund().entrySet()) {
                    entry.setValue(((BigDecimal)entry.getValue()).negate());
                }
            }
            if (hasExchange) {
                ticket.setRelatedSellNumber(product.getPreviousProduct().getSystemNumber());
                AgentReportTicket exchange = this.createTickets(product.getPreviousProduct(), data).get(0);
                for (PaymentType pType : PaymentType.values()) {
                    this.updateValuesFromExchange(pType, ticket.getTotals(), exchange.getTotals(), false);
                    this.updateValuesFromExchange(pType, ticket.getFees(), exchange.getFees(), false);
                    this.updateValuesFromExchange(pType, ticket.getFeesForRefund(), exchange.getFeesForRefund(), true);
                }
                ticket.setEquivalentFare(ticket.getEquivalentFare().subtract(exchange.getEquivalentFare()));
                ticket.setOtherTaxesAmount(ticket.getOtherTaxesAmount().subtract(exchange.getOtherTaxesAmount()));
                ticket.setRuTaxAmount(ticket.getRuTaxAmount().subtract(exchange.getRuTaxAmount()));
                ticket.setPenaltyAmount(ticket.getPenaltyAmount().add(exchange.getPenaltyAmount()));
            }
            if (n <= 0) continue;
            ticket.setConjunction(true);
            if (!TextUtil.isBlank((String)ticket.getTicketNumber())) {
                try {
                    ticket.setTicketNumber(FormattedNumberUtil.add((String)product.getSystemNumber(), (long)n));
                    if (productCategory == ProductCategory.AIR) {
                        ticket.setSortingTicketNumber(ticket.getTicketSeries() + ticket.getTicketNumber());
                    }
                }
                catch (Exception e) {
                    SystemHelper.addExceptionMessage((List)messages, (String)Messages.AgentReportAirPrepareHandler_ticketCantGenNumber, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                    this.log.error(String.format("unable to generate conjunction \"%s\" for product with number \"%s\"", Integer.toString(n), ticket.getTicketNumber()), (Throwable)e);
                }
            }
            ticket.resetFinanceFields(true);
        }
        return result;
    }

    @Override
    public AgentReportProductPrepareHandler.ProductsListProxy<Product> getProducts(AgentReportParameters params, List<Message> messages) throws Exception {
        AgentReportProductPrepareHandler.ProductsListProxy<Product> result = new AgentReportProductPrepareHandler.ProductsListProxy<Product>();
        EntityReference agentReference = params.getAgent();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        if (agentReference == null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)ProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)ProductIndex.Property.agent.name(), (Object)agentReference)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)ProductIndex.Property.clientFopAgent.name(), (Object)agentReference)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)ProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID_BOOKING));
        EntityReference agencyReference = params.getAgency();
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)agencyReference));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        if (!params.getVendors().isEmpty()) {
            HashSet<SearchCriterion> vendorCriterions = new HashSet<SearchCriterion>();
            for (Object ref : params.getVendors()) {
                vendorCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)ref));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])vendorCriterions.toArray(new SearchCriterion[vendorCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (ProductIndex index : EntityStorage.get().search(ProductIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<EntityReference> salesPoints = new HashSet<EntityReference>();
        HashSet<EntityReference> vendors = new HashSet<EntityReference>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block4: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof Product) || !this.isIssuedInReportPeriod(params, (Product)prod) && !this.isPayedInReportPeriod(params, (Product)prod, true) && !this.isRefusedInReportPeriod(params, (Product)prod, true)) continue;
                        Product product = (Product)prod;
                        result.getProducts().add(product);
                        if (product.getBlankOwnerRef() != null) {
                            vendors.add(product.getBlankOwnerRef());
                        }
                        if (!this.isIssuedInReportPeriod(params, (Product)prod) || product.getSalesPoint() == null) continue block4;
                        salesPoints.add(product.getSalesPoint());
                        continue block4;
                    }
                }
            }
        }
        result.getActualVendors().addAll(vendors);
        result.getActualSalesPoints().addAll(salesPoints);
        return result;
    }

    public boolean isRefusedInReportPeriod(AgentReportParameters params, Product prod, boolean checkAgent) {
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            if (!fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate()) || checkAgent && params.getAgent() != null && !params.getAgent().equals((Object)fop.getAgent())) continue;
            return true;
        }
        return false;
    }

    private boolean isPayedInReportPeriod(AgentReportParameters params, Product prod, boolean checkAgent) {
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            if (fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate()) || checkAgent && params.getAgent() != null && !params.getAgent().equals((Object)fop.getAgent())) continue;
            return true;
        }
        return false;
    }

    private boolean isIssuedInReportPeriod(AgentReportParameters params, Product prod) {
        if (params.getPeriodBegin() != null && (prod.getIssueDate() == null || prod.getIssueDate().before(params.getPeriodBegin()))) {
            return false;
        }
        if (params.getPeriodEnd() != null && (prod.getIssueDate() == null || prod.getIssueDate().after(params.getPeriodEnd()))) {
            return false;
        }
        return params.getAgent() == null || params.getAgent().equals((Object)prod.getCashier());
    }

    private boolean hasRelatedPenaltyMCO(Product product) {
        for (Product prod : AirProductHelper.getMcoByRelatedProduct((Product)product)) {
            if (prod.getMcoCategory() != MCOCategory.PENALTY) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateProducts(Collection<Product> products, List<Message> messages) throws Exception {
        for (Product prod : products) {
            BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)prod, messages);
        }
    }

    private void updateValuesFromExchange(PaymentType pType, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> sellValues, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> exchangeValues, boolean add) {
        this.updateValuesFromExchange(pType, sellValues, exchangeValues, add, true);
        this.updateValuesFromExchange(pType, sellValues, exchangeValues, add, false);
    }

    private void updateValuesFromExchange(PaymentType pType, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> sellValues, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> exchangeValues, boolean add, boolean isPayed) {
        BigDecimal value;
        BigDecimal exchangeValue;
        AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
        info.setPaymentType(pType);
        info.setPayed(isPayed);
        BigDecimal sellValue = sellValues.get(info);
        if (sellValue == null) {
            sellValue = BigDecimal.ZERO;
        }
        if ((exchangeValue = exchangeValues.get(info)) == null) {
            exchangeValue = BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = value = add ? sellValue.add(exchangeValue) : sellValue.subtract(exchangeValue);
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            sellValues.remove(info);
            return;
        }
        sellValues.put(info, value);
    }

    private void updateValue(Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> values, List<ProductFop> allFops, PaymentType ptype, FopType total, Product ticket, Date startDate, Date endDate, EntityReference<Person> agent, List<Message> messages) {
        BigDecimal unpayed;
        BigDecimal payedValue = this.getTotalFop(allFops, ptype, total, ticket, startDate, endDate, agent, true, messages);
        if (BigDecimal.ZERO.compareTo(payedValue) != 0) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(true);
            info.setPaymentType(ptype);
            values.put(info, payedValue);
        }
        if (BigDecimal.ZERO.compareTo(unpayed = this.getTotalFop(allFops, ptype, total, ticket, null, null, null, false, messages).subtract(payedValue)) != 0) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(false);
            info.setPaymentType(ptype);
            values.put(info, unpayed);
        }
    }

    private CommissionType getCommissionType(Commission commission, Product product, List<Message> messages) {
        FeeProperties properties;
        if (commission.getCommissionProperties() == null || !FeeProperties.class.getName().equals(commission.getCommissionProperties().getType().getName()) && !PaymentFeeProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
            return CommissionType.OTHER;
        }
        EntityContainer container = null;
        try {
            container = EntityStorage.get().resolve(commission.getCommissionProperties());
        }
        catch (Exception e) {
            SystemHelper.addExceptionMessage(messages, (String)Messages.AgentReportAirPrepareHandler_ticketCantLoadCommittee, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), commission.getCommissionProperties()});
            return CommissionType.OTHER;
        }
        if (container == null) {
            SystemHelper.addMessage(messages, (String)Messages.AgentReportAirPrepareHandler_ticketCantLoadCommittee, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), commission.getCommissionProperties()});
            return CommissionType.OTHER;
        }
        BaseCommissionProperties prop = (BaseCommissionProperties)container.getEntity();
        if (prop instanceof FeeProperties) {
            properties = (FeeProperties)prop;
            if (properties.getOperation() == null) {
                SystemHelper.addMessage(messages, (String)Messages.AgentReportAirPrepareHandler_ticketCommitteeNoOp, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), commission.getCommissionProperties()});
                return CommissionType.FEE;
            }
            if (properties.getOperation() == Operation.REFUND) {
                return CommissionType.FEE_FOR_REFUND;
            }
            if (properties.getOperation() == Operation.SELL || properties.getOperation() == Operation.EXCHANGE) {
                return CommissionType.FEE;
            }
        }
        if (prop instanceof PaymentFeeProperties) {
            properties = (PaymentFeeProperties)prop;
            if (properties.isChargeOnRefund() && commission.getEquivalentAmount() != null && commission.getEquivalentAmount().doubleValue() < 0.0) {
                return CommissionType.FEE_FOR_REFUND;
            }
            return CommissionType.FEE;
        }
        return CommissionType.OTHER;
    }

    private BigDecimal getTotalFop(List<ProductFop> fops, PaymentType type, FopType fopType, Product ticket, Date startDate, Date endDate, EntityReference<Person> agent, boolean paid, List<Message> messages) {
        BigDecimal result = BigDecimal.ZERO;
        block5: for (ProductFop fop : fops) {
            if (paid && fop.isRefused() || startDate != null && (fop.getOperationDate() == null || fop.getOperationDate().before(startDate)) || endDate != null && (fop.getOperationDate() == null || fop.getOperationDate().after(endDate)) || agent != null && (fop.getAgent() == null || !agent.equals((Object)fop.getAgent()))) continue;
            if (fopType != null) {
                switch (fopType) {
                    case TOTAL: {
                        if (AirProductHelper.isServiceFop((ProductFop)fop)) break;
                        continue block5;
                    }
                    case FEE: {
                        if (!AirProductHelper.isServiceFop((ProductFop)fop) && this.getCommissionType((Commission)fop.getCommissions().get(0), ticket, messages) == CommissionType.FEE) break;
                        continue block5;
                    }
                    case FEE_FOR_REFUND: {
                        if (!AirProductHelper.isServiceFop((ProductFop)fop) && this.getCommissionType((Commission)fop.getCommissions().get(0), ticket, messages) == CommissionType.FEE_FOR_REFUND) break;
                        continue block5;
                    }
                }
            }
            if (type != null && type != fop.getType() || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
            result = result.add(fop.getAmount().getValue());
        }
        return result;
    }

    private static enum CommissionType {
        OTHER,
        FEE,
        FEE_FOR_REFUND;

    }

    private static enum FopType {
        TOTAL,
        FEE,
        FEE_FOR_REFUND;

    }
}

