/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.agentreports;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandlersRegistry;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentReportPrepareHandler
implements ReportPrepareHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        data.put("key-messages", messages);
        AgentReportParameters params = (AgentReportParameters)data.get("key-report-params");
        if (params == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoReportParameters", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
            return;
        }
        this.putGlobalData(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        LinkedHashMap<Class<BaseProduct>, List<BaseProduct>> productMap = new LinkedHashMap<Class<BaseProduct>, List<BaseProduct>>();
        HashSet<EntityReference<Organization>> actualBlankOwners = new HashSet<EntityReference<Organization>>();
        HashSet<EntityReference<SalesPoint>> actualSalesPoints = new HashSet<EntityReference<SalesPoint>>();
        for (AgentReportProductPrepareHandler<BaseProduct> agentReportProductPrepareHandler : ((AgentReportProductPrepareHandlersRegistry)Environment.getPublished(AgentReportProductPrepareHandlersRegistry.class)).getAllHandlers()) {
            AgentReportProductPrepareHandler.ProductsListProxy<BaseProduct> result = agentReportProductPrepareHandler.getProducts(params, messages);
            actualBlankOwners.addAll(result.getActualVendors());
            actualSalesPoints.addAll(result.getActualSalesPoints());
            if (result.getProducts().isEmpty()) continue;
            productMap.put(agentReportProductPrepareHandler.getProductClass(), result.getProducts());
        }
        if (productMap.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        data.put("ACTUAL_VENDORS", actualBlankOwners);
        data.put("KEY_ACTUAL_SALES_POINTS", this.generateNames(actualSalesPoints));
        for (Map.Entry entry : productMap.entrySet()) {
            ((AgentReportProductPrepareHandlersRegistry)Environment.getPublished(AgentReportProductPrepareHandlersRegistry.class)).findHandler((Class)entry.getKey()).validateProducts((Collection)entry.getValue(), messages);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        ArrayList<AgentReportTicket> bufList = new ArrayList<AgentReportTicket>();
        for (Map.Entry entry : productMap.entrySet()) {
            AgentReportProductPrepareHandler<BaseProduct> handler = ((AgentReportProductPrepareHandlersRegistry)Environment.getPublished(AgentReportProductPrepareHandlersRegistry.class)).findHandler((Class)entry.getKey());
            for (BaseProduct bp : (List)entry.getValue()) {
                if (bp == null) continue;
                List<AgentReportTicket> tickets = handler.createTickets(bp, data);
                bufList.addAll(tickets);
                for (AgentReportTicket ticket : tickets) {
                    ProductStatus status = ticket.getStatus();
                    String batchId = "SELL";
                    if (status == ProductStatus.REFUND || ticket.isRefundPenaltyMCO() || ticket.isRefundReceiptMCO()) {
                        batchId = "REFUND";
                    } else if (ticket.isIssuedMCOFeeInReportPeriod()) {
                        batchId = "MCOFEES";
                    }
                    this.addTicket(data, ticket, batchId);
                }
            }
        }
        Collections.sort(bufList, new Comparator<AgentReportTicket>(){

            @Override
            public int compare(AgentReportTicket o1, AgentReportTicket o2) {
                return o1.getSortingTicketNumber().compareTo(o2.getSortingTicketNumber());
            }
        });
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.collectActualPaymentTypes(data, messages);
    }

    private String generateNames(Set<EntityReference<SalesPoint>> actualSalesPoints) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (EntityReference<SalesPoint> spRef : actualSalesPoints) {
            EntityContainer spCtr = EntityStorage.get().resolve(spRef);
            if (spCtr == null) {
                this.log.error("unable to load container " + spRef);
                continue;
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ProfileHelper.getFullName((SalesPoint)((SalesPoint)spCtr.getEntity())));
        }
        return sb.toString();
    }

    private void addTicket(Map<String, Object> data, AgentReportTicket ticket, String batchId) {
        ArrayList<ReportBatchData> batchDataList = (ArrayList<ReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData>();
            ReportBatchData sellList = new ReportBatchData();
            sellList.setBatchId("SELL");
            batchDataList.add(sellList);
            ReportBatchData refundList = new ReportBatchData();
            refundList.setBatchId("REFUND");
            batchDataList.add(refundList);
            ReportBatchData mcoFeesList = new ReportBatchData();
            mcoFeesList.setBatchId("MCOFEES");
            batchDataList.add(mcoFeesList);
            data.put("key-batch-data-list", batchDataList);
        }
        for (ReportBatchData batchData : batchDataList) {
            if (!batchData.getBatchId().equals(batchId)) continue;
            batchData.getTickets().add(ticket);
            return;
        }
    }

    private void collectActualPaymentTypes(Map<String, Object> data, List<Message> messages) throws Exception {
        HashSet actualSellPaymentTypes = new HashSet();
        HashSet actualRefundPaymentTypes = new HashSet();
        HashSet actualSellPayedAfterPaymentTypes = new HashSet();
        HashSet actualRefundPayedAfterPaymentTypes = new HashSet();
        HashSet actualSellRefusedPaymentTypes = new HashSet();
        HashSet actualRefundRefusedPaymentTypes = new HashSet();
        HashSet<PaymentType> actualMcoFeesPaymentTypes = new HashSet<PaymentType>();
        List list = (List)data.get("key-batch-data-list");
        for (ReportBatchData batch : list) {
            for (AgentReportTicket ticket : batch.getTickets()) {
                HashSet infos = new HashSet(ticket.getTotals().keySet());
                infos.addAll(ticket.getFees().keySet());
                infos.addAll(ticket.getFeesForRefund().keySet());
                HashSet<PaymentType> pTypes = new HashSet<PaymentType>();
                for (AgentReportTicket.PaymentTypeInfo info : infos) {
                    pTypes.add(info.getPaymentType());
                }
                if (ticket.isRefusedInReportPeriod()) {
                    if (this.isSell(ticket)) {
                        actualSellRefusedPaymentTypes.addAll(pTypes);
                    } else {
                        actualRefundRefusedPaymentTypes.addAll(pTypes);
                    }
                }
                if (ticket.isPayedInReportPeriod()) {
                    if (this.isSell(ticket)) {
                        actualSellPayedAfterPaymentTypes.addAll(pTypes);
                        continue;
                    }
                    actualRefundPayedAfterPaymentTypes.addAll(pTypes);
                    continue;
                }
                if (ticket.isIssuedInReportPeriod()) {
                    if (this.isSell(ticket)) {
                        actualSellPaymentTypes.addAll(infos);
                    } else {
                        actualRefundPaymentTypes.addAll(infos);
                    }
                }
                if (!ticket.isIssuedMCOFeeInReportPeriod()) continue;
                for (PaymentType p : pTypes) {
                    if (p == null) continue;
                    actualMcoFeesPaymentTypes.add(p);
                }
            }
        }
        ArrayList sellList = new ArrayList(actualSellPaymentTypes);
        ArrayList refundList = new ArrayList(actualRefundPaymentTypes);
        ArrayList sellPayedAfterList = new ArrayList(actualSellPayedAfterPaymentTypes);
        ArrayList refundPayedAfterList = new ArrayList(actualRefundPayedAfterPaymentTypes);
        ArrayList sellRefusedList = new ArrayList(actualSellRefusedPaymentTypes);
        ArrayList refundRefusedList = new ArrayList(actualRefundRefusedPaymentTypes);
        ArrayList mcoFeesList = new ArrayList(actualMcoFeesPaymentTypes);
        Collections.sort(sellList, AgentReportTicket.paymentTypeInfosComparator);
        Collections.sort(refundList, AgentReportTicket.paymentTypeInfosComparator);
        Collections.sort(sellPayedAfterList, AgentReportTicket.paymentTypesComparator);
        Collections.sort(refundPayedAfterList, AgentReportTicket.paymentTypesComparator);
        Collections.sort(sellRefusedList, AgentReportTicket.paymentTypesComparator);
        Collections.sort(refundRefusedList, AgentReportTicket.paymentTypesComparator);
        Collections.sort(mcoFeesList, AgentReportTicket.paymentTypesComparator);
        data.put("ACTUAL_SELL_PAYMENT_TYPES", sellList);
        data.put("ACTUAL_REFUND_PAYMENT_TYPES", refundList);
        data.put("ACTUAL_SELL_PAYED_AFTER_PAYMENT_TYPES", sellPayedAfterList);
        data.put("ACTUAL_REFUND_PAYED_AFTER_PAYMENT_TYPES", refundPayedAfterList);
        data.put("ACTUAL_SELL_REFUSED_PAYMENT_TYPES", sellRefusedList);
        data.put("ACTUAL_REFUND_REFUSED_PAYMENT_TYPES", refundRefusedList);
        data.put("ACTUAL_MCO_FEES_PAYMENT_TYPES", mcoFeesList);
        if (sellList.isEmpty() && refundList.isEmpty() && sellPayedAfterList.isEmpty() && sellRefusedList.isEmpty() && refundRefusedList.isEmpty() && mcoFeesList.isEmpty()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AgentReportPrepareHandler_reportNoDoc, (Object[])new Object[0]));
        }
    }

    private boolean isSell(AgentReportTicket ticket) {
        return ticket.getStatus() == ProductStatus.SELL && !ticket.isRefundPenaltyMCO() && !ticket.isRefundReceiptMCO();
    }

    private void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        AgentReportParameters params = (AgentReportParameters)data.get("key-report-params");
        BaseReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        EntityStorage es = EntityStorage.get();
        EntityContainer ctr = EntityStorage.get().resolve(params.getTemplate());
        if (ctr == null || ((TemplateDocument)ctr.getEntity()).getContent() == null) {
            SystemHelper.addMessage(messages, (String)Messages.AgentReportPrepareHandler_templateReportAgent, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        data.put("REPORT_TEMPLATE", ((TemplateDocument)ctr.getEntity()).getContent());
        data.put("SPECIAL_BSP_CARRIERS", SystemHelper.findMetadataAsString((Collection)((TemplateDocument)ctr.getEntity()).getMetadata(), (MetadataKey)MetadataKey.AGENT_REPORT_BSP_SPECIAL_CARRIERS));
        ctr = EntityStorage.get().resolve(params.getAgency());
        if (ctr == null) {
            SystemHelper.addMessage(messages, (String)Messages.AgentReportPrepareHandler_cantLoadProfileAgency, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgency()});
            return;
        }
        data.put("AGENCY_NAME", ProfileHelper.getFullName((Organization)((Organization)ctr.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        ctr = EntityStorage.get().resolve(params.getAgent());
        if (ctr == null) {
            SystemHelper.addMessage(messages, (String)Messages.AgentReportPrepareHandler_cantLoadProfileAgent, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgent()});
            return;
        }
        data.put("AGENT_NAME", PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((PersonalLocalizableName)ctr.getEntity()), (boolean)true, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        data.put("REPORT_NUMBER", new DecimalFormat("0000000").format(es.search(AgentReportDocumentIndex.class, query).getTotalCount() + 1));
        String code = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE, null);
        if (code != null) {
            SearchQuery query2 = new SearchQuery();
            query2.getPreferredProperties().add(OrganizationIndex.Property.name.name());
            query2.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code));
            query2.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT));
            List refs = StorageHelper.getEntityReferences((SearchQuery)query2, OrganizationIndex.class);
            if (!refs.isEmpty()) {
                EntityReference client = (EntityReference)refs.get(0);
                if (refs.size() > 1) {
                    SystemHelper.addMessage(messages, (String)Messages.AgentReportPrepareHandler_findedFewProfile, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{code, client});
                }
                data.put("RETAIL_TRAVELLER_UID", client.getUid());
            } else {
                SystemHelper.addMessage(messages, (String)Messages.AgentReportPrepareHandler_cantLoadProfileCode, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{code});
            }
        } else {
            SystemHelper.addMessage(messages, (String)Messages.AgentReportPrepareHandler_cantFindProfileCode, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
        }
    }

    @Override
    public String getId() {
        return "agent-report";
    }
}

