/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.agentreports;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.render.agentreport.clientdebt.ClientDebtData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ClientDebtReportPrepareHandler
extends BaseReportPrepareHandler {
    private static Map<String, String> clientsCache = new HashMap<String, String>();
    private static Map<EntityReference<Organization>, String> vendorsCache = new HashMap<EntityReference<Organization>, String>();

    @Override
    protected void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        super.checkReportParameters(data, messages);
        ClientDebtReportParameters params = (ClientDebtReportParameters)data.get("key-report-params");
        if (params.getAgency() == null) {
            SystemHelper.addMessage(messages, (String)Messages.ClientDebtReportPrepareHandler_organizationIsUndefined, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Organization is undefined");
        }
        if (params.getVendors().isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.ClientDebtReportPrepareHandler_noOneVendor, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("No one vendor is selected");
        }
    }

    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        this.addProductProxyTicket((BaseProduct)product, data);
    }

    protected void addProductProxyTicket(BaseProduct product, Map<String, Object> data) throws Exception {
        int sign;
        EntityReference blankOwner;
        ClientDebtReportParameters params = (ClientDebtReportParameters)data.get("key-report-params");
        HashMap<String, ClientDebtData> clientDebtDataList = (HashMap<String, ClientDebtData>)data.get("key-batch-data-list");
        if (clientDebtDataList == null) {
            clientDebtDataList = new HashMap<String, ClientDebtData>();
            data.put("key-batch-data-list", clientDebtDataList);
        }
        if ((blankOwner = GeneralProductHelper.getBlankOwner((BaseProduct)product)) == null) {
            return;
        }
        String vendorName = this.getVendorName((EntityReference<Organization>)blankOwner);
        BookingFile bf = product.getReservation().getBookingFile();
        if (bf.getCustomerProfile() == null) {
            return;
        }
        String clientName = this.getClientName((EntityReference<Organization>)bf.getCustomerProfile(), GeneralProductHelper.getTraveller((BaseProduct)product));
        ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)product);
        int n = sign = status == ProductStatus.SELL ? 1 : -1;
        if (vendorName != null && clientName != null) {
            String key = vendorName + clientName + status.name();
            ClientDebtData clientDebtData = (ClientDebtData)clientDebtDataList.get(key);
            if (clientDebtData == null) {
                clientDebtData = new ClientDebtData(vendorName, clientName, sign);
                clientDebtDataList.put(key, clientDebtData);
            }
            this.updateClientDebtData(product, clientDebtData, params.getPeriodEnd());
        }
    }

    @Override
    protected Collection<? extends Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        return this.selectProducts(data, messages);
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        EntityContainer ctr;
        ClientDebtReportParameters params = (ClientDebtReportParameters)data.get("key-report-params");
        ClientDebtReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        EntityStorage entityCache = EntityStorage.get();
        if (params.getAgency() != null) {
            ctr = entityCache.resolve(params.getAgency());
            data.put("AGENCY_NAME", ProfileHelper.getFullName((Organization)((Organization)ctr.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        }
        if (params.getSubagency() != null) {
            ctr = entityCache.resolve(params.getSubagency());
            data.put("SUBAGENCY_TITLE", ProfileHelper.getFullName((Organization)((Organization)ctr.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        }
        if (params.getSalesPoint() != null) {
            ctr = entityCache.resolve(params.getSalesPoint());
            data.put("SALEPOINT_ADDRESS", ((SalesPoint)ctr.getEntity()).getFullName());
        }
        if (params.getAgent() != null) {
            ctr = entityCache.resolve(params.getAgent());
            data.put("AGENT_NAME", ((Person)ctr.getEntity()).toString());
        }
    }

    @Override
    public String getId() {
        return "agent-client-debt-report";
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ClientDebtReportParameters params = (ClientDebtReportParameters)data.get("key-report-params");
        if (params.isAllProducts()) {
            this.prepareAllProductsData(data);
        } else {
            super.prepareData(data);
        }
    }

    public void prepareAllProductsData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = (ArrayList<Message>)data.get("key-messages");
        if (messages == null) {
            messages = new ArrayList<Message>();
            data.put("key-messages", messages);
        }
        this.checkReportParameters(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.putGlobalData(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        ArrayList<BaseProduct> products = new ArrayList<BaseProduct>(this.selectAllProducts(data, messages));
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        for (BaseProduct product : products) {
            ClientDebtReportPrepareHandler.baseValidateProductToReport(product, messages);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.sortBaseProducts(products, data);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        for (BaseProduct product : products) {
            this.addProductProxyTicket(product, data);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.afterFillDataLists(data, messages);
    }

    protected Collection<? extends Product> selectProducts(Map<String, Object> data, List<Message> messages) throws Exception {
        ClientDebtReportParameters params = (ClientDebtReportParameters)data.get("key-report-params");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        SearchCriterion sc1 = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())});
        SearchCriterion sc2 = SearchCriterion.eq((String)ProductIndex.Property.dateOfClientPayment.name(), null);
        SearchCriterion sc3 = SearchCriterion.gt((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd());
        SearchCriterion sc4 = SearchCriterion.eq((String)ProductIndex.Property.hasClientDebt.name(), (Object)Boolean.TRUE);
        SearchCriterion sc5 = SearchCriterion.eq((String)ProductIndex.Property.cancellationDate.name(), null);
        SearchCriterion sc = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc1, SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{sc2, sc3, sc4}), sc5});
        query.getCriteria().getCriterions().add(sc);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), (Object)params.getAgency()));
        if (params.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)params.getSubagency()));
        }
        if (params.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.salesPoint.name(), (Object)params.getSalesPoint()));
        }
        if (params.getAgent() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agent.name(), (Object)params.getAgent()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.REFUND)}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        HashSet<SearchCriterion> vendorCriterions = new HashSet<SearchCriterion>();
        for (EntityReference org : params.getVendors()) {
            vendorCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)org));
        }
        if (!vendorCriterions.isEmpty()) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])vendorCriterions.toArray(new SearchCriterion[vendorCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (ProductIndex index : EntityStorage.get().search(ProductIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<Product> result = new HashSet<Product>();
        HashSet<EntityReference> vendors = new HashSet<EntityReference>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = EntityStorage.get().resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return Collections.emptySet();
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    if (!productIndexList.contains(uid) || !(prod instanceof Product)) continue;
                    Product product = (Product)prod;
                    result.add(product);
                    if (product.getBlankOwnerRef() == null) continue;
                    vendors.add(product.getBlankOwnerRef());
                }
            }
        }
        data.put("ACTUAL_VENDORS", vendors);
        return result;
    }

    private Collection<BaseProduct> selectAllProducts(Map<String, Object> data, List<Message> messages) throws Exception {
        ClientDebtReportParameters params = (ClientDebtReportParameters)data.get("key-report-params");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)CommonProductIndex.Property.ticketType.name(), null)}));
        SearchCriterion sc1 = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)CommonProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())});
        SearchCriterion sc2 = SearchCriterion.eq((String)CommonProductIndex.Property.dateOfClientPayment.name(), null);
        SearchCriterion sc3 = SearchCriterion.gt((String)CommonProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd());
        SearchCriterion sc4 = SearchCriterion.eq((String)CommonProductIndex.Property.hasClientDebt.name(), (Object)Boolean.TRUE);
        SearchCriterion sc5 = SearchCriterion.eq((String)CommonProductIndex.Property.cancellationDate.name(), null);
        SearchCriterion sc = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc1, SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{sc2, sc3, sc4}), sc5});
        query.getCriteria().getCriterions().add(sc);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), (Object)params.getAgency()));
        if (params.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), (Object)params.getSubagency()));
        }
        if (params.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.salesPoint.name(), (Object)params.getSalesPoint()));
        }
        if (params.getAgent() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.agent.name(), (Object)params.getAgent()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.REFUND)}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        HashSet<SearchCriterion> vendorCriterions = new HashSet<SearchCriterion>();
        for (EntityReference org : params.getVendors()) {
            vendorCriterions.add(SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), (Object)org));
        }
        if (!vendorCriterions.isEmpty()) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])vendorCriterions.toArray(new SearchCriterion[vendorCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfRefs = new HashSet<EntityReference>();
        for (CommonProductIndex index : EntityStorage.get().search(CommonProductIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfRefs.add(index.getSource());
        }
        HashSet<BaseProduct> result = new HashSet<BaseProduct>();
        HashSet<EntityReference> vendors = new HashSet<EntityReference>();
        for (EntityReference bfRef : bfRefs) {
            EntityContainer container = EntityStorage.get().resolve(bfRef);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfRef});
                this.log.debug("Unable to load booking file container " + bfRef.getUid() + ". All products of the booking will be excluded from report.");
                return Collections.emptySet();
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                for (BaseProduct prod : res.getProducts()) {
                    if (!productIndexList.contains(prod.getUid())) continue;
                    result.add(prod);
                    EntityReference blankOwner = GeneralProductHelper.getBlankOwner((BaseProduct)prod);
                    if (blankOwner == null) continue;
                    vendors.add(blankOwner);
                }
            }
        }
        data.put("ACTUAL_VENDORS", vendors);
        return result;
    }

    private String getVendorName(EntityReference<Organization> airlineRef) throws Exception {
        if (airlineRef == null) {
            return null;
        }
        if (vendorsCache.containsKey(airlineRef)) {
            return vendorsCache.get(airlineRef);
        }
        EntityContainer ctr = EntityStorage.get().resolve(airlineRef);
        String vendorName = null;
        if (ctr != null && TextUtil.isBlank((String)(vendorName = L10nStringHelper.getValue((L10nString)((Organization)ctr.getEntity()).getShortName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false)))) {
            vendorName = ((Organization)ctr.getEntity()).toString();
        }
        vendorsCache.put(airlineRef, vendorName);
        return vendorName;
    }

    private String getClientName(EntityReference<Organization> clientRef, Traveller passanger) throws Exception {
        EntityContainer ctr;
        if (clientRef == null) {
            return "";
        }
        String clientName = clientsCache.get(clientRef.getUid());
        if (clientName == null && (ctr = EntityStorage.get().resolve(clientRef)) != null) {
            clientName = L10nStringHelper.getValue((L10nString)((Organization)ctr.getEntity()).getShortName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            if (TextUtil.isBlank((String)clientName)) {
                clientName = ((Organization)ctr.getEntity()).toString();
            }
            clientsCache.put(clientRef.getUid(), clientName);
        }
        return clientName;
    }

    private void updateClientDebtData(BaseProduct product, ClientDebtData data, Date endDate) {
        block3: for (GeneralProductFop fop : GeneralProductHelper.getClientContractRelation((BaseProduct)product).getFops()) {
            if (fop.getType() == null || fop.getEquivalentAmount() == null || fop.getEquivalentAmount() == null || fop.getOperationDate() != null && !fop.getOperationDate().after(endDate)) continue;
            switch (fop.getType()) {
                case CASH: 
                case CREDIT_CARD: 
                case INVOICE: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            if (ClientDebtReportPrepareHandler.isFeeFop(fop)) {
                data.add(0.0, (double)data.getSign() * fop.getEquivalentAmount().doubleValue(), fop.getType());
                continue;
            }
            data.add((double)data.getSign() * fop.getEquivalentAmount().doubleValue(), 0.0, fop.getType());
        }
    }

    private static boolean isFeeFop(GeneralProductFop fop) {
        for (GeneralProductCommission com : fop.getCommissions()) {
            if (!com.getCommissionProperties().getType().getName().equals(FeeProperties.class.getName())) continue;
            return true;
        }
        return false;
    }
}

