/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.agentreports;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.GeneralProductAgentReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryAgentReportPrepareHandler
implements AgentReportProductPrepareHandler<Delivery> {
    private final GeneralProductAgentReportPrepareHelper.GeneralProductAgentReportHandler<Delivery, DeliveryIndex> handler = new GeneralProductAgentReportPrepareHelper.GeneralProductAgentReportHandler<Delivery, DeliveryIndex>(){

        @Override
        public EntityReference<Organization> getBlankOwner(Delivery item) {
            return item.getAgency();
        }

        @Override
        public String getBlankOwnerIndexPropertyName() {
            return null;
        }

        @Override
        public String getCancellationDateIndexPropertyName() {
            return null;
        }

        @Override
        public List<GeneralProductFop> getClientFops(Delivery item) {
            return item.getClientFops();
        }

        @Override
        public BigDecimal getEquivalentFare(Delivery item) {
            return BigDecimal.ZERO;
        }

        @Override
        public String getFopAgentIndexPropertyName() {
            return null;
        }

        @Override
        public String getGroupName(EntityReference<Organization> blankOwner) {
            return L10nResourcesManager.getStr((String)Messages.DeliveryAgentReportPrepareHandler_delivery, (Object[])new Object[0]);
        }

        @Override
        public Date getIssueDate(Delivery item) {
            return item.getIssueDate();
        }

        @Override
        public String getIssueDateIndexPropertyName() {
            return null;
        }

        @Override
        public EntityReference<Person> getIssuingAgent(Delivery item) {
            return item.getAgent();
        }

        @Override
        public String getIssuingAgentIndexPropertyName() {
            return null;
        }

        @Override
        public String getPaymentDateIndexPropertyName() {
            return null;
        }

        @Override
        public BigDecimal getPenalty(Delivery item) {
            return null;
        }

        @Override
        public Delivery getPreviousProduct(Delivery item) {
            return item.getPreviousProduct();
        }

        @Override
        public Class<Delivery> getProductClass() {
            return Delivery.class;
        }

        @Override
        public String getRouteLine(Delivery item) {
            return null;
        }

        @Override
        public EntityReference<SalesPoint> getSalesPoint(Delivery item) {
            return item.getSalesPoint();
        }

        @Override
        public ProductStatus getStatus(Delivery item) {
            ProductStatus status = DeliveryHelper.getProductStatus((Delivery)item);
            return status == ProductStatus.BOOKING ? ProductStatus.SELL : status;
        }

        @Override
        public String getStatusIndexPropertyName() {
            return null;
        }

        @Override
        public String getSubagencyIndexPropertyName() {
            return null;
        }

        @Override
        public String getSystemNumber(Delivery item) {
            return item.getSystemNumber();
        }

        @Override
        public List<GeneralProductTax> getTaxes(Delivery item) {
            return Collections.emptyList();
        }

        @Override
        public String getTicketTypeIndexPropertyName() {
            return null;
        }

        @Override
        public List<ValidationMessage> getValidationMessages(Delivery item) {
            return item.getValidationMessages();
        }

        @Override
        public boolean isChecked(Delivery item) {
            return item.isChecked();
        }

        @Override
        public Class<DeliveryIndex> getIndexClass() {
            return null;
        }

        @Override
        public DictionaryReference<BlankType> getBlankType(Delivery item) {
            return null;
        }

        @Override
        public List<String> getProductProperties() {
            ArrayList<String> res = new ArrayList<String>();
            for (DeliveryIndex.Property p : DeliveryIndex.Property.values()) {
                res.add(p.name());
            }
            return res;
        }
    };
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<Delivery> getProductClass() {
        return Delivery.class;
    }

    @Override
    public List<AgentReportTicket> createTickets(Delivery product, Map<String, Object> data) {
        return GeneralProductAgentReportPrepareHelper.createTickets(product, this.handler, data);
    }

    @Override
    public AgentReportProductPrepareHandler.ProductsListProxy<Delivery> getProducts(AgentReportParameters params, List<Message> messages) throws Exception {
        AgentReportProductPrepareHandler.ProductsListProxy<Delivery> result = new AgentReportProductPrepareHandler.ProductsListProxy<Delivery>();
        EntityReference agentReference = params.getAgent();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)DeliveryIndex.Property.clientFopAmount.name(), (Object)BigDecimal.ZERO));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)DeliveryIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        if (agentReference == null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)DeliveryIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)DeliveryIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)DeliveryIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)DeliveryIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)DeliveryIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)DeliveryIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)DeliveryIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)DeliveryIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)DeliveryIndex.Property.issueDate.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)DeliveryIndex.Property.agent.name(), (Object)agentReference)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)DeliveryIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)DeliveryIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)DeliveryIndex.Property.clientFopAgent.name(), (Object)agentReference)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)DeliveryIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)DeliveryIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)DeliveryIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (DeliveryIndex index : EntityStorage.get().search(DeliveryIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<EntityReference<SalesPoint>> salesPoints = new HashSet<EntityReference<SalesPoint>>();
        HashSet<EntityReference<Organization>> vendors = new HashSet<EntityReference<Organization>>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block3: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !this.handler.getProductClass().equals(prod.getClass()) || !GeneralProductAgentReportPrepareHelper.isIssuedInReportPeriod(params, this.handler, (Delivery)prod) && !GeneralProductAgentReportPrepareHelper.isPayedInReportPeriod(params, this.handler, (Delivery)prod, true) && !GeneralProductAgentReportPrepareHelper.isRefusedInReportPeriod(params, this.handler, (Delivery)prod, true)) continue;
                        Delivery product = (Delivery)prod;
                        result.getProducts().add(product);
                        if (this.handler.getBlankOwner(product) != null) {
                            vendors.add(this.handler.getBlankOwner(product));
                        }
                        if (this.handler.getSalesPoint(product) == null || !GeneralProductAgentReportPrepareHelper.isIssuedInReportPeriod(params, this.handler, (Delivery)prod)) continue block3;
                        salesPoints.add(this.handler.getSalesPoint(product));
                        continue block3;
                    }
                }
            }
        }
        result.getActualVendors().addAll(vendors);
        result.getActualSalesPoints().addAll(salesPoints);
        return result;
    }

    @Override
    public void validateProducts(Collection<Delivery> products, List<Message> messages) throws Exception {
        GeneralProductAgentReportPrepareHelper.validateProductsToReport(this.handler, products, messages);
    }
}

