/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.agentreports;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GeneralProductAgentReportPrepareHelper {
    private static final Logger log = LoggerFactory.getLogger(GeneralProductAgentReportPrepareHelper.class);

    static <T extends BaseProduct, I extends EntityIndex<BookingFile>> List<AgentReportTicket> createTickets(T product, GeneralProductAgentReportHandler<T, I> handler, Map<String, Object> data) {
        List messages = (List)data.get("key-messages");
        String retailTravellerUid = (String)data.get("RETAIL_TRAVELLER_UID");
        AgentReportParameters params = (AgentReportParameters)data.get("key-report-params");
        String[] ruTaxCodes = new String[]{"RU", "\u0420\u0423"};
        if (product.getReservation() != null && CommonReservationGdsNameInfoHelper.containsGds((Reservation)product.getReservation(), (GdsName)GdsName.SIRENA)) {
            try {
                EntityContainer ctr = EntityStorage.get().resolve(handler.getBlankOwner(product));
                if (ctr != null && "\u04281".equals(((Organization)ctr.getEntity()).getCode())) {
                    ruTaxCodes = new String[]{"ZZ"};
                }
            }
            catch (Exception e) {
                log.error("unable to resolve blankowner " + handler.getBlankOwner(product), (Throwable)e);
            }
        }
        AgentReportTicket ticket = new AgentReportTicket();
        ArrayList<AgentReportTicket> result = new ArrayList<AgentReportTicket>();
        result.add(ticket);
        ProductStatus status = handler.getStatus(product);
        ticket.setStatus(status);
        ticket.setUid(product.getUid());
        ticket.setTicketNumber(handler.getSystemNumber(product));
        ticket.setBlankOwner(handler.getBlankOwner(product));
        try {
            EntityStorage.get().actualize(ticket.getBlankOwner(), new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
        }
        catch (Exception e1) {
            log.error("unable to actualize reference " + ticket.getBlankOwner(), (Throwable)e1);
        }
        ticket.setGroupName(handler.getGroupName((EntityReference<Organization>)ticket.getBlankOwner()));
        ticket.setEquivalentFare(status != ProductStatus.VOID ? handler.getEquivalentFare(product) : BigDecimal.ZERO);
        ticket.setIssueDate(handler.getIssueDate(product));
        ticket.resetFinanceFields(false);
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(handler.getBlankType(product));
        if (blankType != null) {
            ticket.setTicketSeries(blankType.getName());
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(status) && product.getReservation() != null && product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomerProfile() != null && !product.getReservation().getBookingFile().getCustomerProfile().getUid().equals(retailTravellerUid)) {
            EntityReference customerProfile = product.getReservation().getBookingFile().getCustomerProfile();
            EntityStorage.get().actualize(customerProfile, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            ticket.setRemarks(customerProfile.getCaption());
        }
        ticket.setSellIssueDate(ticket.getIssueDate());
        if (status == ProductStatus.REFUND && handler.getPreviousProduct(product) != null) {
            ticket.setSellIssueDate(handler.getIssueDate(handler.getPreviousProduct(product)));
        }
        ticket.setPayedInReportPeriod(GeneralProductAgentReportPrepareHelper.isPayedInReportPeriod(params, handler, product, false) && !GeneralProductAgentReportPrepareHelper.isIssuedInReportPeriod(params, handler, product));
        ticket.setRefusedInReportPeriod(GeneralProductAgentReportPrepareHelper.isRefusedInReportPeriod(params, handler, product, false));
        ticket.setIssuedInReportPeriod(GeneralProductAgentReportPrepareHelper.isIssuedInReportPeriod(params, handler, product));
        ticket.setSortingTicketNumber(ticket.getTicketSeries() + ticket.getTicketNumber());
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            ticket.setRouteLine("VOID");
        } else {
            ticket.setRouteLine(handler.getRouteLine(product));
        }
        if (ticket.getEquivalentFare() == null) {
            ticket.setEquivalentFare(BigDecimal.ZERO);
        }
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        String productTitle = productHandler.generateShortProductName(product);
        if (status == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.GeneralProductAgentReportPrepareHelper_ticketNoState, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle});
            return result;
        }
        if (status == ProductStatus.VOID) {
            return result;
        }
        ticket.setPenaltyAmount(handler.getPenalty(product));
        boolean hasExchange = status == ProductStatus.SELL && handler.getPreviousProduct(product) != null && handler.getStatus(handler.getPreviousProduct(product)) == ProductStatus.EXCHANGE;
        ticket.setRuTaxAmount(GeneralProductHelper.getEquivalentTaxAmount(handler.getTaxes(product), (boolean)true, (String[])ruTaxCodes));
        ticket.setOtherTaxesAmount(GeneralProductHelper.getEquivalentTaxAmount(handler.getTaxes(product), (boolean)false, (String[])ruTaxCodes));
        List<GeneralProductFop> allFops = GeneralProductAgentReportPrepareHelper.collectFops(handler, product, messages);
        if (allFops == null) {
            return result;
        }
        if (allFops.isEmpty() && !MCOCategory.INFORMATION.equals((Object)ticket.getMcoCategory())) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.GeneralProductAgentReportPrepareHelper_ticketNoFop, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle});
            return result;
        }
        for (PaymentType ptype : PaymentType.values()) {
            GeneralProductAgentReportPrepareHelper.updateValue(ticket.getTotals(), allFops, ptype, FopType.TOTAL, product, params.getPeriodBegin(), params.getPeriodEnd(), (EntityReference<Person>)params.getAgent(), messages);
            GeneralProductAgentReportPrepareHelper.updateValue(ticket.getFees(), allFops, ptype, FopType.FEE, product, params.getPeriodBegin(), params.getPeriodEnd(), (EntityReference<Person>)params.getAgent(), messages);
            GeneralProductAgentReportPrepareHelper.updateValue(ticket.getFeesForRefund(), allFops, ptype, FopType.FEE_FOR_REFUND, product, params.getPeriodBegin(), params.getPeriodEnd(), (EntityReference<Person>)params.getAgent(), messages);
        }
        if (status == ProductStatus.REFUND) {
            ticket.setOtherTaxesAmount(ticket.getOtherTaxesAmount().negate());
            ticket.setRuTaxAmount(ticket.getRuTaxAmount().negate());
            ticket.setEquivalentFare(ticket.getEquivalentFare().negate());
            for (Map.Entry entry : ticket.getTotals().entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).negate());
            }
            for (Map.Entry entry : ticket.getFees().entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).negate());
            }
            for (Map.Entry entry : ticket.getFeesForRefund().entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).negate());
            }
        }
        if (hasExchange) {
            ticket.setRelatedSellNumber(handler.getSystemNumber(handler.getPreviousProduct(product)));
            AgentReportTicket exchange = GeneralProductAgentReportPrepareHelper.createTickets(handler.getPreviousProduct(product), handler, data).get(0);
            for (PaymentType pType : PaymentType.values()) {
                GeneralProductAgentReportPrepareHelper.updateValuesFromExchange(pType, ticket.getTotals(), exchange.getTotals(), false);
                GeneralProductAgentReportPrepareHelper.updateValuesFromExchange(pType, ticket.getFees(), exchange.getFees(), false);
                GeneralProductAgentReportPrepareHelper.updateValuesFromExchange(pType, ticket.getFeesForRefund(), exchange.getFeesForRefund(), true);
            }
            ticket.setEquivalentFare(ticket.getEquivalentFare().subtract(exchange.getEquivalentFare()));
            ticket.setOtherTaxesAmount(ticket.getOtherTaxesAmount().subtract(exchange.getOtherTaxesAmount()));
            ticket.setRuTaxAmount(ticket.getRuTaxAmount().subtract(exchange.getRuTaxAmount()));
            ticket.setPenaltyAmount(ticket.getPenaltyAmount().add(exchange.getPenaltyAmount()));
        }
        return result;
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> boolean isIssuedInReportPeriod(AgentReportParameters params, GeneralProductAgentReportHandler<T, I> handler, T prod) {
        Date issueDate = handler.getIssueDate(prod);
        if (params.getPeriodBegin() != null && (issueDate == null || issueDate.before(params.getPeriodBegin()))) {
            return false;
        }
        if (params.getPeriodEnd() != null && (issueDate == null || issueDate.after(params.getPeriodEnd()))) {
            return false;
        }
        return params.getAgent() == null || params.getAgent().equals(handler.getIssuingAgent(prod));
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> boolean isRefusedInReportPeriod(AgentReportParameters params, GeneralProductAgentReportHandler<T, I> handler, T prod, boolean checkAgent) {
        for (GeneralProductFop fop : handler.getClientFops(prod)) {
            if (!fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate()) || checkAgent && params.getAgent() != null && !params.getAgent().equals((Object)fop.getAgent())) continue;
            return true;
        }
        return false;
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> boolean isPayedInReportPeriod(AgentReportParameters params, GeneralProductAgentReportHandler<T, I> handler, T prod, boolean checkAgent) {
        for (GeneralProductFop fop : handler.getClientFops(prod)) {
            if (fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate()) || checkAgent && params.getAgent() != null && !params.getAgent().equals((Object)fop.getAgent())) continue;
            return true;
        }
        return false;
    }

    private static <T extends BaseProduct, I extends EntityIndex<BookingFile>> List<GeneralProductFop> collectFops(GeneralProductAgentReportHandler<T, I> handler, T product, List<Message> messages) {
        if (product == null) {
            return new ArrayList<GeneralProductFop>();
        }
        ArrayList<GeneralProductFop> result = new ArrayList<GeneralProductFop>();
        List<GeneralProductFop> fops = handler.getClientFops(product);
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        String productTitle = productHandler.generateShortProductName(product);
        for (GeneralProductFop fop : fops) {
            if (fop == null) {
                SystemHelper.addMessage(messages, (String)Messages.GeneralProductAgentReportPrepareHelper_noFormPayment, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle});
                return null;
            }
            if (handler.getStatus(product) != ProductStatus.VOID && PaymentType.TICKET == fop.getType()) {
                if (handler.getPreviousProduct(product) == null) {
                    SystemHelper.addMessage(messages, (String)Messages.GeneralProductAgentReportPrepareHelper_noTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle});
                    return null;
                }
                PaymentType ptype = GeneralProductAgentReportPrepareHelper.findRelatedPaymentType(fop, handler.getClientFops(handler.getPreviousProduct(product)));
                if (ptype == null) {
                    SystemHelper.addMessage(messages, (String)Messages.GeneralProductAgentReportPrepareHelper_cantFindFOP, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle, PaymentType.TICKET, fop.getEquivalentAmount() != null ? fop.getEquivalentAmount() : BigDecimal.ZERO});
                    return null;
                }
                GeneralProductFop fop2 = new GeneralProductFop();
                try {
                    XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)fop2, (boolean)true);
                }
                catch (Exception e) {
                    SystemHelper.addMessage(messages, (String)Messages.GeneralProductAgentReportPrepareHelper_iternalError, (String)TextUtil.getExceptionStackTrace((Throwable)e), (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle});
                    LoggerFactory.getLogger(BaseReportTicket.class).error("unable to copy FOP", (Throwable)e);
                    return null;
                }
                fop2.setType(ptype);
                fop2.setAgent(fop.getAgent());
                result.add(fop2);
                continue;
            }
            result.add(fop);
        }
        return result;
    }

    private static PaymentType findRelatedPaymentType(GeneralProductFop fop, Collection<GeneralProductFop> rfops) {
        if (rfops.size() == 1) {
            return rfops.iterator().next().getType();
        }
        if (fop.getEquivalentAmount() == null) {
            return null;
        }
        for (GeneralProductFop fp : rfops) {
            if (fp.getEquivalentAmount() == null || !(Math.abs(fp.getEquivalentAmount().subtract(fop.getEquivalentAmount()).doubleValue()) < 1.0E-4)) continue;
            return fp.getType();
        }
        return null;
    }

    private static void updateValuesFromExchange(PaymentType pType, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> sellValues, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> exchangeValues, boolean add) {
        GeneralProductAgentReportPrepareHelper.updateValuesFromExchange(pType, sellValues, exchangeValues, add, true);
        GeneralProductAgentReportPrepareHelper.updateValuesFromExchange(pType, sellValues, exchangeValues, add, false);
    }

    private static void updateValuesFromExchange(PaymentType pType, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> sellValues, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> exchangeValues, boolean add, boolean isPayed) {
        BigDecimal value;
        BigDecimal exchangeValue;
        AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
        info.setPaymentType(pType);
        info.setPayed(isPayed);
        BigDecimal sellValue = sellValues.get(info);
        if (sellValue == null) {
            sellValue = BigDecimal.ZERO;
        }
        if ((exchangeValue = exchangeValues.get(info)) == null) {
            exchangeValue = BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = value = add ? sellValue.add(exchangeValue) : sellValue.subtract(exchangeValue);
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            sellValues.remove(info);
            return;
        }
        sellValues.put(info, value);
    }

    private static <T extends BaseProduct> void updateValue(Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> values, List<GeneralProductFop> allFops, PaymentType ptype, FopType total, T ticket, Date startDate, Date endDate, EntityReference<Person> agent, List<Message> messages) {
        BigDecimal unpayed;
        BigDecimal payedValue = GeneralProductAgentReportPrepareHelper.getTotalFop(allFops, ptype, total, ticket, startDate, endDate, agent, true, messages);
        if (BigDecimal.ZERO.compareTo(payedValue) != 0) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(true);
            info.setPaymentType(ptype);
            values.put(info, payedValue);
        }
        if (BigDecimal.ZERO.compareTo(unpayed = GeneralProductAgentReportPrepareHelper.getTotalFop(allFops, ptype, total, ticket, null, null, null, false, messages).subtract(payedValue)) != 0) {
            AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
            info.setPayed(false);
            info.setPaymentType(ptype);
            values.put(info, unpayed);
        }
    }

    private static <T extends BaseProduct> CommissionType getCommissionType(GeneralProductCommission commission, T product, List<Message> messages) {
        FeeProperties properties;
        if (commission.getCommissionProperties() == null || !FeeProperties.class.getName().equals(commission.getCommissionProperties().getType().getName()) && !PaymentFeeProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
            return CommissionType.OTHER;
        }
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        String productTitle = handler.generateShortProductName(product);
        EntityContainer container = null;
        try {
            container = EntityStorage.get().resolve(commission.getCommissionProperties());
        }
        catch (Exception e) {
            SystemHelper.addExceptionMessage(messages, (String)Messages.AgentReportAirPrepareHandler_ticketCantLoadCommittee, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle, commission.getCommissionProperties()});
            return CommissionType.OTHER;
        }
        if (container == null) {
            SystemHelper.addMessage(messages, (String)Messages.AgentReportAirPrepareHandler_ticketCantLoadCommittee, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle, commission.getCommissionProperties()});
            return CommissionType.OTHER;
        }
        BaseCommissionProperties prop = (BaseCommissionProperties)container.getEntity();
        if (prop instanceof FeeProperties) {
            properties = (FeeProperties)prop;
            if (properties.getOperation() == null) {
                SystemHelper.addMessage(messages, (String)Messages.AgentReportAirPrepareHandler_ticketCommitteeNoOp, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{productTitle, commission.getCommissionProperties()});
                return CommissionType.FEE;
            }
            if (properties.getOperation() == Operation.REFUND) {
                return CommissionType.FEE_FOR_REFUND;
            }
            if (properties.getOperation() == Operation.SELL || properties.getOperation() == Operation.EXCHANGE) {
                return CommissionType.FEE;
            }
        }
        if (prop instanceof PaymentFeeProperties) {
            properties = (PaymentFeeProperties)prop;
            if (properties.isChargeOnRefund() && commission.getEquivalentAmount() != null && commission.getEquivalentAmount().doubleValue() < 0.0) {
                return CommissionType.FEE_FOR_REFUND;
            }
            return CommissionType.FEE;
        }
        return CommissionType.OTHER;
    }

    private static <T extends BaseProduct> BigDecimal getTotalFop(List<GeneralProductFop> fops, PaymentType type, FopType fopType, T ticket, Date startDate, Date endDate, EntityReference<Person> agent, boolean paid, List<Message> messages) {
        BigDecimal result = BigDecimal.ZERO;
        block5: for (GeneralProductFop fop : fops) {
            if (paid && fop.isRefused() || startDate != null && (fop.getOperationDate() == null || fop.getOperationDate().before(startDate)) || endDate != null && (fop.getOperationDate() == null || fop.getOperationDate().after(endDate)) || agent != null && (fop.getAgent() == null || !agent.equals((Object)fop.getAgent()))) continue;
            if (fopType != null) {
                switch (fopType) {
                    case TOTAL: {
                        if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) break;
                        continue block5;
                    }
                    case FEE: {
                        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop) && GeneralProductAgentReportPrepareHelper.getCommissionType((GeneralProductCommission)fop.getCommissions().get(0), ticket, messages) == CommissionType.FEE) break;
                        continue block5;
                    }
                    case FEE_FOR_REFUND: {
                        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop) && GeneralProductAgentReportPrepareHelper.getCommissionType((GeneralProductCommission)fop.getCommissions().get(0), ticket, messages) == CommissionType.FEE_FOR_REFUND) break;
                        continue block5;
                    }
                }
            }
            if (type != null && type != fop.getType() || fop.getEquivalentAmount() == null) continue;
            result = result.add(fop.getEquivalentAmount());
        }
        return result;
    }

    static <T extends BaseProduct, I extends EntityIndex<BookingFile>> AgentReportProductPrepareHandler.ProductsListProxy<T> getProducts(AgentReportParameters params, GeneralProductAgentReportHandler<T, I> handler, List<Message> messages) throws Exception {
        AgentReportProductPrepareHandler.ProductsListProxy result = new AgentReportProductPrepareHandler.ProductsListProxy();
        EntityReference agentReference = params.getAgent();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)handler.getTicketTypeIndexPropertyName(), (Object)TicketType.OWN), SearchCriterion.eq((String)handler.getTicketTypeIndexPropertyName(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)handler.getTicketTypeIndexPropertyName(), null)}));
        if (agentReference == null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)handler.getIssueDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getIssueDateIndexPropertyName(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)handler.getPaymentDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getPaymentDateIndexPropertyName(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)handler.getCancellationDateIndexPropertyName(), null), SearchCriterion.ge((String)handler.getCancellationDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getCancellationDateIndexPropertyName(), (Object)params.getPeriodEnd())})}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)handler.getIssueDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getIssueDateIndexPropertyName(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)handler.getIssuingAgentIndexPropertyName(), (Object)agentReference)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)handler.getPaymentDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getPaymentDateIndexPropertyName(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)handler.getFopAgentIndexPropertyName(), (Object)agentReference)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)handler.getCancellationDateIndexPropertyName(), null), SearchCriterion.ge((String)handler.getCancellationDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getCancellationDateIndexPropertyName(), (Object)params.getPeriodEnd())})}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)handler.getStatusIndexPropertyName(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)handler.getStatusIndexPropertyName(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        EntityReference agencyReference = params.getAgency();
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)handler.getSubagencyIndexPropertyName(), (Object)agencyReference));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)handler.getStatusIndexPropertyName(), (Object)ProductStatus.EXCHANGE));
        for (Object sc : params.getAdditionalCriterions()) {
            List<String> propertiesInCriterion = GeneralProductAgentReportPrepareHelper.getPropertiesFromCriterion((SearchCriterion)sc);
            List<String> propertiesInProduct = handler.getProductProperties();
            boolean allowedToBeAdded = true;
            for (String prop : propertiesInCriterion) {
                if (propertiesInProduct.contains(prop)) continue;
                allowedToBeAdded = false;
                break;
            }
            if (!allowedToBeAdded) continue;
            query.getCriteria().getCriterions().add(sc);
        }
        if (!params.getVendors().isEmpty()) {
            HashSet<SearchCriterion> vendorCriterions = new HashSet<SearchCriterion>();
            for (Object ref : params.getVendors()) {
                vendorCriterions.add(SearchCriterion.eq((String)handler.getBlankOwnerIndexPropertyName(), (Object)ref));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])vendorCriterions.toArray(new SearchCriterion[vendorCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (EntityIndex index : EntityStorage.get().search(handler.getIndexClass(), query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<EntityReference<SalesPoint>> salesPoints = new HashSet<EntityReference<SalesPoint>>();
        HashSet<EntityReference<Organization>> vendors = new HashSet<EntityReference<Organization>>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block6: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !handler.getProductClass().equals(prod.getClass()) || !GeneralProductAgentReportPrepareHelper.isIssuedInReportPeriod(params, handler, prod) && !GeneralProductAgentReportPrepareHelper.isPayedInReportPeriod(params, handler, prod, true) && !GeneralProductAgentReportPrepareHelper.isRefusedInReportPeriod(params, handler, prod, true)) continue;
                        BaseProduct product = prod;
                        result.getProducts().add(product);
                        if (handler.getBlankOwner(product) != null) {
                            vendors.add(handler.getBlankOwner(product));
                        }
                        if (handler.getSalesPoint(product) == null || !GeneralProductAgentReportPrepareHelper.isIssuedInReportPeriod(params, handler, prod)) continue block6;
                        salesPoints.add(handler.getSalesPoint(product));
                        continue block6;
                    }
                }
            }
        }
        result.getActualVendors().addAll(vendors);
        result.getActualSalesPoints().addAll(salesPoints);
        return result;
    }

    private static List<String> getPropertiesFromCriterion(SearchCriterion sc) {
        ArrayList<String> res = new ArrayList<String>();
        if (sc instanceof SearchCriterion.JunctionCriterion) {
            for (SearchCriterion sc2 : ((SearchCriterion.JunctionCriterion)sc).getCriterions()) {
                res.addAll(GeneralProductAgentReportPrepareHelper.getPropertiesFromCriterion(sc2));
            }
        } else if (sc instanceof SearchCriterion.NotCriterion) {
            res.addAll(GeneralProductAgentReportPrepareHelper.getPropertiesFromCriterion(((SearchCriterion.NotCriterion)sc).getCriterion()));
        } else if (sc instanceof SearchCriterion.BetweenCriterion) {
            res.add(((SearchCriterion.BetweenCriterion)sc).getProperty());
        } else if (sc instanceof SearchCriterion.NotBetweenCriterion) {
            res.add(((SearchCriterion.NotBetweenCriterion)sc).getProperty());
        } else if (sc instanceof SearchCriterion.CheckCriterion) {
            res.add(((SearchCriterion.CheckCriterion)sc).getProperty());
        } else if (sc instanceof SearchCriterion.InCriterion) {
            res.add(((SearchCriterion.InCriterion)sc).getProperty());
        } else if (sc instanceof SearchCriterion.SimpleCriterion) {
            res.add(((SearchCriterion.SimpleCriterion)sc).getProperty());
        }
        return res;
    }

    static <T extends BaseProduct, I extends EntityIndex<BookingFile>> void validateProductsToReport(GeneralProductValidationMessageHandler<T> handler, Collection<T> products, List<Message> messages) throws Exception {
        for (BaseProduct product : products) {
            boolean hasWarnings = false;
            boolean hasErrors = false;
            if (!handler.isChecked(product)) {
                for (ValidationMessage message : handler.getValidationMessages(product)) {
                    ValidationMessageSeverity severity = BaseReportPrepareHandler.getSeverity(message);
                    if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL || severity == ValidationMessageSeverity.MESSAGE) continue;
                    if (severity == ValidationMessageSeverity.WARNING) {
                        hasWarnings = true;
                    }
                    if (severity != ValidationMessageSeverity.ERROR) continue;
                    hasErrors = true;
                }
            }
            if (hasWarnings) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_ProductHasWarnings", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{handler.getSystemNumber(product), handler.getStatus(product)});
            }
            if (!hasErrors) continue;
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_ProductHasErrors", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{handler.getSystemNumber(product), handler.getStatus(product)});
        }
    }

    private GeneralProductAgentReportPrepareHelper() {
    }

    static interface GeneralProductAgentReportHandler<T extends BaseProduct, I extends EntityIndex<BookingFile>>
    extends GeneralProductValidationMessageHandler<T> {
        public EntityReference<Organization> getBlankOwner(T var1);

        public List<String> getProductProperties();

        public EntityReference<Person> getIssuingAgent(T var1);

        public EntityReference<SalesPoint> getSalesPoint(T var1);

        public String getTicketTypeIndexPropertyName();

        public String getStatusIndexPropertyName();

        public String getSubagencyIndexPropertyName();

        public String getIssueDateIndexPropertyName();

        public String getCancellationDateIndexPropertyName();

        public String getPaymentDateIndexPropertyName();

        public String getIssuingAgentIndexPropertyName();

        public String getFopAgentIndexPropertyName();

        public String getBlankOwnerIndexPropertyName();

        public String getRouteLine(T var1);

        public BigDecimal getEquivalentFare(T var1);

        public BigDecimal getPenalty(T var1);

        public Date getIssueDate(T var1);

        public T getPreviousProduct(T var1);

        public String getGroupName(EntityReference<Organization> var1);

        public List<GeneralProductFop> getClientFops(T var1);

        public List<GeneralProductTax> getTaxes(T var1);

        public Class<T> getProductClass();

        public Class<I> getIndexClass();

        public DictionaryReference<BlankType> getBlankType(T var1);
    }

    static interface GeneralProductValidationMessageHandler<T extends BaseProduct> {
        public List<ValidationMessage> getValidationMessages(T var1);

        public boolean isChecked(T var1);

        public String getSystemNumber(T var1);

        public ProductStatus getStatus(T var1);
    }

    private static enum CommissionType {
        OTHER,
        FEE,
        FEE_FOR_REFUND;

    }

    private static enum FopType {
        TOTAL,
        FEE,
        FEE_FOR_REFUND;

    }
}

