/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.agentreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.MCOFeesType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.GeneralProductAgentReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCOFeesAgentReportPrepareHandler
implements AgentReportProductPrepareHandler<MCOFees> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<AgentReportTicket> createTickets(MCOFees product, Map<String, Object> data) {
        BlankType blankType;
        AgentReportTicket ticket = new AgentReportTicket();
        ArrayList<AgentReportTicket> result = new ArrayList<AgentReportTicket>();
        result.add(ticket);
        ProductStatus status = product.getStatus();
        ticket.setStatus(status);
        ticket.setUid(product.getUid());
        ticket.setTicketNumber(product.getScn());
        ticket.setBlankOwner(product.getAgency());
        ticket.setGroupName("\u041a\u0420\u0421");
        ticket.setIssueDate(product.getIssueDate());
        ticket.resetFinanceFields(true);
        ticket.setEquivalentFare(BigDecimal.ZERO);
        String retailTravellerUid = (String)data.get("RETAIL_TRAVELLER_UID");
        if (!ProductStatusHandler.getAllVoidStatuses().contains(status) && product.getReservation() != null && product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomerProfile() != null && !product.getReservation().getBookingFile().getCustomerProfile().getUid().equals(retailTravellerUid)) {
            EntityReference customerProfile = product.getReservation().getBookingFile().getCustomerProfile();
            EntityStorage.get().actualize(customerProfile, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            ticket.setRemarks(customerProfile.getCaption());
        }
        if ((blankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType())) != null) {
            ticket.setTicketSeries(blankType.getName());
        }
        ticket.setSellIssueDate(ticket.getIssueDate());
        if (status == ProductStatus.REFUND && product.getPreviousMCO() != null) {
            ticket.setSellIssueDate(product.getPreviousMCO().getIssueDate());
        }
        ticket.setPayedInReportPeriod(false);
        ticket.setRefusedInReportPeriod(false);
        if (MCOFeesType.FEES.equals((Object)product.getType())) {
            ticket.setIssuedInReportPeriod(false);
            ticket.setIssuedMCOFeeInReportPeriod(true);
        } else {
            ticket.setIssuedInReportPeriod(true);
            ticket.setIssuedMCOFeeInReportPeriod(false);
        }
        ticket.setSortingTicketNumber(ticket.getTicketNumber());
        String routeLine = "";
        ArrayList<Product> airProducts = new ArrayList<Product>();
        ArrayList<String> ticketNumbers = new ArrayList<String>();
        StringBuilder ticketNumbersStr = new StringBuilder();
        for (MCOFeesSource src : product.getSources()) {
            if (!src.isActive() || ticketNumbers.contains(src.getTicketNumber())) continue;
            ticketNumbers.add(src.getTicketNumber());
            ticketNumbersStr.append(ticketNumbersStr.length() > 0 ? ", " + src.getTicketNumber() : src.getTicketNumber());
        }
        ticket.setAirTicketNumbers(ticketNumbersStr.toString());
        if (ticketNumbers.size() > 0) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BookingFileIndex.Property.ticketNumbers.name(), ticketNumbers.get(0)));
            EntityContainer bfCont = null;
            try {
                List bfiList = EntityStorage.get().search(BookingFileIndex.class, query).getData();
                if (bfiList != null && bfiList.size() > 0) {
                    bfCont = EntityStorage.get().resolve(((BookingFileIndex)bfiList.get(0)).getSource());
                }
            }
            catch (Exception bfiList) {
                // empty catch block
            }
            if (bfCont != null) {
                BookingFile bf = (BookingFile)bfCont.getEntity();
                for (Reservation res : bf.getReservations()) {
                    for (BaseProduct p : res.getProducts()) {
                        if (!(p instanceof Product) || !product.getRelatedProductsUids().contains(p.getUid())) continue;
                        airProducts.add((Product)p);
                    }
                }
            }
        }
        for (Product p : airProducts) {
            String route = AirProductHelper.getRouteLine((Product)p, null, (boolean)true, (CodeSystem)CodeSystem.IATA);
            routeLine = routeLine + (routeLine.length() > 0 ? ", " + route : route);
        }
        ticket.setRouteLine(routeLine);
        AgentReportTicket.PaymentTypeInfo info = new AgentReportTicket.PaymentTypeInfo();
        info.setPayed(true);
        info.setPaymentType(product.getPaymentType());
        ticket.getTotals().put(info, product.getTotal());
        return result;
    }

    @Override
    public Class<MCOFees> getProductClass() {
        return MCOFees.class;
    }

    @Override
    public AgentReportProductPrepareHandler.ProductsListProxy<MCOFees> getProducts(AgentReportParameters params, List<Message> messages) throws Exception {
        EntityReference agencyReference;
        AgentReportProductPrepareHandler.ProductsListProxy<MCOFees> result = new AgentReportProductPrepareHandler.ProductsListProxy<MCOFees>();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)MCOFeesIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)MCOFeesIndex.Property.issueDate.name(), (Object)params.getPeriodEnd()));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)MCOFeesIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        EntityReference agentReference = params.getAgent();
        if (agentReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)MCOFeesIndex.Property.agent.name(), (Object)params.getAgent()));
        }
        if ((agencyReference = params.getAgency()) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)MCOFeesIndex.Property.agency.name(), (Object)agencyReference));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (MCOFeesIndex index : EntityStorage.get().search(MCOFeesIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<EntityReference> salesPoints = new HashSet<EntityReference>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block3: for (BaseProduct prod : res.getProducts()) {
                    if (!(prod instanceof MCOFees)) continue;
                    MCOFees mco = (MCOFees)prod;
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !MCOFees.class.equals(prod.getClass())) continue;
                        result.getProducts().add(mco);
                        if (mco.getSalesPoint() == null) continue block3;
                        salesPoints.add(mco.getSalesPoint());
                        continue block3;
                    }
                }
            }
        }
        result.getActualSalesPoints().addAll(salesPoints);
        return result;
    }

    @Override
    public void validateProducts(Collection<MCOFees> products, List<Message> messages) throws Exception {
        GeneralProductAgentReportPrepareHelper.validateProductsToReport(new GeneralProductAgentReportPrepareHelper.GeneralProductValidationMessageHandler<MCOFees>(){

            @Override
            public ProductStatus getStatus(MCOFees item) {
                return item.getStatus();
            }

            @Override
            public String getSystemNumber(MCOFees item) {
                return item.getScn();
            }

            @Override
            public List<ValidationMessage> getValidationMessages(MCOFees item) {
                return item.getValidationMessages();
            }

            @Override
            public boolean isChecked(MCOFees item) {
                return item.isChecked();
            }
        }, products, messages);
    }
}

