/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.agentreports;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SamaraAgentReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SamaraClientData;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SamaraReportHelper;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class SamaraAgentReportPrepareHandler
extends BaseReportPrepareHandler {
    private static DateFormat createSdf() {
        return new SimpleDateFormat("ddMMyy");
    }

    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        AgentReportParameters params = (AgentReportParameters)data.get("key-report-params");
        if (product.getStatus() == ProductStatus.EXCHANGE) {
            return;
        }
        for (int n = 0; n <= product.getConjCount(); ++n) {
            SamaraAgentReportTicket ticket = new SamaraAgentReportTicket(product, n, params, messages);
            this.updateByContractor(ticket, product, messages);
            this.updateByPassanger(ticket, product, messages);
            if (!ticket.isIssuedBefore()) {
                this.addTicket(data, ticket, "SELL");
            }
            if (n != 0) continue;
            this.updatePayoffData(ticket, data);
        }
    }

    private void updateByPassanger(SamaraAgentReportTicket ticket, Product product, List<Message> messages) {
        Organization bookingCorpClient = null;
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomerProfile() != null) {
            try {
                bookingCorpClient = (Organization)this.getEntity(product.getReservation().getBookingFile().getCustomerProfile());
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        String clientProfile = null;
        if (product.getTraveller() != null) {
            Passport passport = product.getTraveller().getPassport();
            if (passport != null && !TextUtil.isBlank((String)passport.getLastName())) {
                ticket.setPassangerLastName(this.firstLetterToUpperCase(passport.getLastName()));
            } else {
                String name = product.getTraveller().getName();
                name = this.fetchFirstWord(name);
                ticket.setPassangerLastName(this.firstLetterToUpperCase(name));
            }
        }
        if (bookingCorpClient != null) {
            clientProfile = this.isPrivatePerson(bookingCorpClient) ? "\u0424\u041b" : L10nStringHelper.getValue((L10nString)bookingCorpClient.getShortName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            ticket.setClientProfile(clientProfile);
        }
    }

    private void addTicket(Map<String, Object> data, SamaraAgentReportTicket ticket, String batchId) {
        ArrayList<ReportBatchData> batchDataList = (ArrayList<ReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData>();
            ReportBatchData sellList = new ReportBatchData();
            sellList.setBatchId("SELL");
            batchDataList.add(sellList);
            data.put("key-batch-data-list", batchDataList);
        }
        for (ReportBatchData batchData : batchDataList) {
            if (!batchData.getBatchId().equals(batchId)) continue;
            batchData.getTickets().add(ticket);
            return;
        }
    }

    @Override
    public String getId() {
        return "agent-report-samara";
    }

    @Override
    protected Collection<? extends Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        AgentReportParameters params = (AgentReportParameters)data.get("key-report-params");
        EntityReference agentReference = params.getAgent();
        if (agentReference == null) {
            SystemHelper.addMessage(messages, (String)Messages.SamaraAgentReportPrepareHandler_noAgent, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return Collections.emptySet();
        }
        EntityReference agencyReference = params.getAgency();
        if (agencyReference == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseSsodDivergenceReportPrepareHandler_noAgency, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return Collections.emptySet();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        SearchCriterion sc1 = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)ProductIndex.Property.agent.name(), (Object)agentReference)});
        SearchCriterion sc2 = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.agent.name(), (Object)agentReference), SearchCriterion.eq((String)ProductIndex.Property.dateOfClientPayment.name(), null), SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID)});
        SearchCriterion sc3 = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)ProductIndex.Property.clientFopAgent.name(), (Object)agentReference)});
        SearchCriterion sc4 = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.lt((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{sc2, sc3})});
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{sc1, sc4}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.cancellationDate.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)ProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)agencyReference));
        Set vendorReferences = params.getVendors();
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        if (!vendorReferences.isEmpty()) {
            HashSet<SearchCriterion> vendorCriterions = new HashSet<SearchCriterion>();
            for (Object vrfr : vendorReferences) {
                vendorCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)vrfr));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])vendorCriterions.toArray(new SearchCriterion[vendorCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (ProductIndex index : EntityStorage.get().search(ProductIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<Product> result = new HashSet<Product>();
        HashSet<EntityReference> vendors = new HashSet<EntityReference>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = EntityStorage.get().resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return Collections.emptySet();
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block4: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof Product)) continue;
                        Product product = (Product)prod;
                        result.add(product);
                        if (product.getBlankOwnerRef() == null) continue block4;
                        vendors.add(product.getBlankOwnerRef());
                        continue block4;
                    }
                }
            }
        }
        data.put("ACTUAL_VENDORS", vendors);
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
        }
        return result;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        AgentReportParameters params = (AgentReportParameters)data.get("key-report-params");
        SamaraAgentReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        EntityStorage entityCache = EntityStorage.get();
        EntityContainer ctr = entityCache.resolve(params.getAgency());
        if (ctr == null) {
            SystemHelper.addMessage(messages, (String)Messages.SamaraAgentReportPrepareHandler_cantLoadProfileAgency, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgency()});
            return;
        }
        data.put("AGENCY_NAME", ProfileHelper.getFullName((Organization)((Organization)ctr.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        ctr = entityCache.resolve(params.getAgent());
        if (ctr == null) {
            SystemHelper.addMessage(messages, (String)Messages.SamaraAgentReportPrepareHandler_cantLoadProfileAgent, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgent()});
            return;
        }
        data.put("AGENT_NAME", PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((PersonalLocalizableName)ctr.getEntity()), (boolean)true, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        String addressString = null;
        if (((Person)ctr.getEntity()).getSalesPoints().size() > 0) {
            PlaceOfSales sp = (PlaceOfSales)((Person)ctr.getEntity()).getSalesPoints().get(0);
            EntityContainer ect = entityCache.resolve(sp.getSalesPoint());
            if (ect != null) {
                if (((SalesPoint)ect.getEntity()).getAddresses().size() == 1) {
                    addressString = ProfileHelper.buildFullAddress((Address)((Address)((SalesPoint)ect.getEntity()).getAddresses().get(0)), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
                }
                for (Address address : ((SalesPoint)ect.getEntity()).getAddresses()) {
                    if (address.getAddressType() != AddressType.CONTACT) continue;
                    addressString = ProfileHelper.buildFullAddress((Address)address, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
                    break;
                }
            } else {
                SystemHelper.addMessage(messages, (String)Messages.SamaraAgentReportPrepareHandler_cantLoadProfilePointSale, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{sp.getSalesPoint() != null ? sp.getSalesPoint().getCaption() : sp.toString()});
            }
        }
        if (!TextUtil.isBlank(addressString)) {
            data.put("SALEPOINT_ADDRESS", addressString);
        }
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        data.put("REPORT_NUMBER", new DecimalFormat("0000000").format(EntityStorage.get().search(AgentReportDocumentIndex.class, query).getTotalCount() + 1));
    }

    private boolean isPrivatePerson(Organization entity) {
        String privatePersonCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE, null);
        return !TextUtil.isBlank((String)privatePersonCode) && privatePersonCode.equals(entity.getCode());
    }

    private <E extends BaseEntity> E getEntity(EntityReference<E> ref) throws Exception {
        return (E)EntityStorage.get().resolve(ref).getEntity();
    }

    private void updatePayoffData(SamaraAgentReportTicket ticket, Map<String, Object> data) {
        SamaraClientData debt;
        String key;
        String date;
        String clientTitle;
        TreeMap<String, SamaraClientData> clientDebtData = (TreeMap<String, SamaraClientData>)data.get(SamaraReportHelper.PayoffStatus.DEBT.name());
        TreeMap<String, SamaraClientData> clientPaymentData = (TreeMap<String, SamaraClientData>)data.get(SamaraReportHelper.PayoffStatus.PAYED.name());
        if (clientDebtData == null) {
            clientDebtData = new TreeMap<String, SamaraClientData>();
            data.put(SamaraReportHelper.PayoffStatus.DEBT.name(), clientDebtData);
        }
        if (clientPaymentData == null) {
            clientPaymentData = new TreeMap<String, SamaraClientData>();
            data.put(SamaraReportHelper.PayoffStatus.PAYED.name(), clientPaymentData);
        }
        String string = clientTitle = "\u0424\u041b".equals(ticket.getClientProfile()) ? ticket.getClientProfile() + "(" + ticket.getPassangerLastName() + ")" : ticket.getClientProfile();
        if (TextUtil.isBlank((String)clientTitle)) {
            return;
        }
        String string2 = date = ticket.getIssueDate() != null ? SamaraAgentReportPrepareHandler.createSdf().format(ticket.getIssueDate()) : "";
        if (ticket.getTicketSumDebtAmount() != null && !BigDecimal.ZERO.equals(ticket.getTicketSumDebtAmount())) {
            BigDecimal ticketSumDebtAmount;
            key = SamaraReportHelper.PayoffType.TICKET.name() + clientTitle + ticket.getStatus().name() + date;
            debt = (SamaraClientData)clientDebtData.get(key);
            BigDecimal bigDecimal = ticketSumDebtAmount = ticket.getClientEquivalentDiscount() == null ? ticket.getTicketSumDebtAmount() : ticket.getTicketSumDebtAmount().add(ticket.getClientEquivalentDiscount());
            if (debt == null) {
                debt = new SamaraClientData(clientTitle, MiscUtil.clearTime((Date)ticket.getIssueDate()), ticketSumDebtAmount, SamaraReportHelper.PayoffType.TICKET);
                clientDebtData.put(key, debt);
            } else {
                debt.update(MiscUtil.clearTime((Date)ticket.getIssueDate()), ticketSumDebtAmount);
            }
        }
        if (ticket.getFeeSumDebtAmount() != null && !BigDecimal.ZERO.equals(ticket.getFeeSumDebtAmount())) {
            key = SamaraReportHelper.PayoffType.FEE.name() + clientTitle + ticket.getStatus().name() + date;
            debt = (SamaraClientData)clientDebtData.get(key);
            if (debt == null) {
                debt = new SamaraClientData(clientTitle, MiscUtil.clearTime((Date)ticket.getIssueDate()), ticket.getFeeSumDebtAmount(), SamaraReportHelper.PayoffType.FEE);
                clientDebtData.put(key, debt);
            } else {
                debt.update(MiscUtil.clearTime((Date)ticket.getIssueDate()), ticket.getFeeSumDebtAmount());
            }
        }
        if (ticket.isIssuedBefore() && ticket.getTicketSumPaymentAmount() != null && !ticket.getTicketSumPaymentAmount().equals(BigDecimal.ZERO)) {
            key = SamaraReportHelper.PayoffType.TICKET.name() + clientTitle + ticket.getStatus().name() + date;
            SamaraClientData ticketSumPaymentAmount = (SamaraClientData)clientPaymentData.get(key);
            if (ticketSumPaymentAmount == null) {
                ticketSumPaymentAmount = new SamaraClientData(clientTitle, MiscUtil.clearTime((Date)ticket.getIssueDate()), ticket.getTicketSumPaymentAmount(), SamaraReportHelper.PayoffType.TICKET);
                clientPaymentData.put(key, ticketSumPaymentAmount);
            } else {
                ticketSumPaymentAmount.update(MiscUtil.clearTime((Date)ticket.getIssueDate()), ticket.getTicketSumPaymentAmount());
            }
        }
        if (ticket.isIssuedBefore() && ticket.getFeeSumPaymentAmount() != null && !ticket.getFeeSumPaymentAmount().equals(BigDecimal.ZERO)) {
            key = SamaraReportHelper.PayoffType.FEE.name() + clientTitle + ticket.getStatus().name() + date;
            SamaraClientData feeSumPaymentAmount = (SamaraClientData)clientPaymentData.get(key);
            if (feeSumPaymentAmount == null) {
                feeSumPaymentAmount = new SamaraClientData(clientTitle, MiscUtil.clearTime((Date)ticket.getIssueDate()), ticket.getFeeSumPaymentAmount(), SamaraReportHelper.PayoffType.FEE);
                clientPaymentData.put(key, feeSumPaymentAmount);
            } else {
                feeSumPaymentAmount.update(MiscUtil.clearTime((Date)ticket.getIssueDate()), ticket.getFeeSumPaymentAmount());
            }
        }
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList batchDataList = (ArrayList)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList();
            data.put("key-batch-data-list", batchDataList);
        }
    }

    private String firstLetterToUpperCase(String word) {
        return word == null ? null : word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
    }

    private String fetchFirstWord(String sentence) {
        StringTokenizer st = new StringTokenizer(sentence, " /");
        return st.nextToken();
    }

    private void updateByContractor(SamaraAgentReportTicket ticket, Product product, List<Message> messages) {
        ValidatorIndex index = null;
        EntityReference supplier = null;
        EntityReference blankOwner = product.getBlankOwnerRef();
        if (!TextUtil.isBlank((String)product.getValidatorCode())) {
            try {
                index = ValidatorHelper.findValidator((String)product.getValidatorCode(), (EntityReference)blankOwner, (Date)product.getIssueDate());
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
            if (index != null) {
                supplier = index.getSupplier();
            }
        }
        ticket.setContractor(supplier == null ? "" : supplier.toString());
    }
}

