/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.agentreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.GeneralProductAgentReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductAgentReportPrepareHandler
implements AgentReportProductPrepareHandler<UniversalProduct> {
    private final GeneralProductAgentReportPrepareHelper.GeneralProductAgentReportHandler<UniversalProduct, UniversalProductIndex> handler = new GeneralProductAgentReportPrepareHelper.GeneralProductAgentReportHandler<UniversalProduct, UniversalProductIndex>(){

        @Override
        public EntityReference<Organization> getBlankOwner(UniversalProduct item) {
            return item.getBlankOwner();
        }

        @Override
        public String getBlankOwnerIndexPropertyName() {
            return UniversalProductIndex.Property.blankOwner.name();
        }

        @Override
        public String getCancellationDateIndexPropertyName() {
            return UniversalProductIndex.Property.cancellationDate.name();
        }

        @Override
        public List<GeneralProductFop> getClientFops(UniversalProduct item) {
            return UniversalProductHelper.getClientFops((UniversalProduct)item);
        }

        @Override
        public BigDecimal getEquivalentFare(UniversalProduct item) {
            return item.getEquivalentFare();
        }

        @Override
        public String getFopAgentIndexPropertyName() {
            return UniversalProductIndex.Property.clientFopAgent.name();
        }

        @Override
        public String getGroupName(EntityReference<Organization> blankOwner) {
            return "error";
        }

        @Override
        public Date getIssueDate(UniversalProduct item) {
            return item.getIssueDate();
        }

        @Override
        public String getIssueDateIndexPropertyName() {
            return UniversalProductIndex.Property.issueDate.name();
        }

        @Override
        public EntityReference<Person> getIssuingAgent(UniversalProduct item) {
            return item.getAgent();
        }

        @Override
        public String getIssuingAgentIndexPropertyName() {
            return UniversalProductIndex.Property.agent.name();
        }

        @Override
        public String getPaymentDateIndexPropertyName() {
            return UniversalProductIndex.Property.dateOfClientPayment.name();
        }

        @Override
        public BigDecimal getPenalty(UniversalProduct item) {
            return item.getPenalty();
        }

        @Override
        public UniversalProduct getPreviousProduct(UniversalProduct item) {
            return item.getPreviousProduct();
        }

        @Override
        public Class<UniversalProduct> getProductClass() {
            return UniversalProduct.class;
        }

        @Override
        public String getRouteLine(UniversalProduct item) {
            return UniversalProductHelper.getRouteLine((UniversalProduct)item);
        }

        @Override
        public EntityReference<SalesPoint> getSalesPoint(UniversalProduct item) {
            return item.getSalesPoint();
        }

        @Override
        public ProductStatus getStatus(UniversalProduct item) {
            return item.getStatus();
        }

        @Override
        public String getStatusIndexPropertyName() {
            return UniversalProductIndex.Property.status.name();
        }

        @Override
        public String getSubagencyIndexPropertyName() {
            return UniversalProductIndex.Property.subagency.name();
        }

        @Override
        public String getSystemNumber(UniversalProduct item) {
            return item.getSystemNumber();
        }

        @Override
        public List<GeneralProductTax> getTaxes(UniversalProduct item) {
            return Collections.emptyList();
        }

        @Override
        public String getTicketTypeIndexPropertyName() {
            return UniversalProductIndex.Property.ticketType.name();
        }

        @Override
        public List<ValidationMessage> getValidationMessages(UniversalProduct item) {
            return item.getValidationMessages();
        }

        @Override
        public boolean isChecked(UniversalProduct item) {
            return item.isChecked();
        }

        @Override
        public Class<UniversalProductIndex> getIndexClass() {
            return UniversalProductIndex.class;
        }

        @Override
        public DictionaryReference<BlankType> getBlankType(UniversalProduct item) {
            return item.getBlankType();
        }

        @Override
        public List<String> getProductProperties() {
            ArrayList<String> res = new ArrayList<String>();
            for (UniversalProductIndex.Property p : UniversalProductIndex.Property.values()) {
                res.add(p.name());
            }
            return res;
        }
    };

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public List<AgentReportTicket> createTickets(UniversalProduct product, Map<String, Object> data) {
        Logger log = LoggerFactory.getLogger(UniversalProductAgentReportPrepareHandler.class);
        List<AgentReportTicket> tickets = GeneralProductAgentReportPrepareHelper.createTickets(product, this.handler, data);
        UniversalProductDescription description = null;
        try {
            EntityContainer ctr = EntityStorage.get().resolve(product.getDescription());
            if (ctr != null) {
                description = (UniversalProductDescription)ctr.getEntity();
            }
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + product.getDescription(), (Throwable)e);
        }
        if (description == null) {
            log.error(String.format("product %s: description is null", product.getSystemNumber()));
        }
        for (AgentReportTicket ticket : tickets) {
            if (description == null) continue;
            ticket.setGroupName(description.isBlankOwnerAndSupplierAreAgency() ? description.getName() : String.format("%s (%s)", ticket.getBlankOwner(), description.getName()));
        }
        return tickets;
    }

    @Override
    public AgentReportProductPrepareHandler.ProductsListProxy<UniversalProduct> getProducts(AgentReportParameters params, List<Message> messages) throws Exception {
        return GeneralProductAgentReportPrepareHelper.getProducts(params, this.handler, messages);
    }

    @Override
    public void validateProducts(Collection<UniversalProduct> products, List<Message> messages) throws Exception {
        GeneralProductAgentReportPrepareHelper.validateProductsToReport(this.handler, products, messages);
    }
}

