/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportGeneralProductHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportPrepareUtil;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AviacentrConsolidatedGeneralProductPrepareHandler {
    private static final Logger log = LoggerFactory.getLogger(AviacentrConsolidatedGeneralProductPrepareHandler.class);
    private static DecimalFormat df = new DecimalFormat("0.##");

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> AviacentrConsolidatedReportTicket createTicketForMainProduct(T product, AviacentrConsolidatedReportGeneralProductHandler<T, I> handler, Map<String, Object> data) {
        AviacentrConsolidatedReportTicket t = new AviacentrConsolidatedReportTicket();
        t.setProductName(handler.getProductName(product));
        t.setUnitOfMeasure(handler.getUnitOfMeasureForBaseProduct());
        Integer amount = handler.getAmountForBaseProduct(product);
        t.setAmount(amount);
        t.setAmountStr(amount != null ? amount.toString() : "---");
        Object needVatParam = data.get("NEED_VAT_FOR_CLIENT");
        boolean needVat = needVatParam != null && !Boolean.FALSE.equals(needVatParam);
        BigDecimal price = handler.getPrice(product, needVat);
        t.setPrice(price);
        t.setPriceStr(price != null ? price.setScale(2, RoundingMode.HALF_UP).toString() : "---");
        BigDecimal totalPrice = t.getPrice() != null && t.getAmount() != null ? t.getPrice().multiply(BigDecimal.valueOf(t.getAmount().longValue())) : null;
        t.setTotalPrice(totalPrice);
        t.setTotalPriceStr(totalPrice != null ? totalPrice.setScale(2, RoundingMode.HALF_UP).toString() : "---");
        Double vatRate = handler.getVatRate(product, needVat);
        t.setVatRate(vatRate);
        t.setVatRateStr(vatRate != null ? df.format(vatRate) + "%" : "---");
        BigDecimal vatAmount = handler.getVatAmount(product, needVat);
        t.setVatAmount(vatAmount);
        t.setVatAmountStr(vatAmount != null ? vatAmount.setScale(2, RoundingMode.HALF_UP).toString() : "---");
        BigDecimal totalWithVat = handler.getTotalPriceWithVat(product);
        t.setTotalWithVat(totalWithVat);
        t.setTotalWithVatStr(totalWithVat != null ? totalWithVat.setScale(2, RoundingMode.HALF_UP).toString() : "---");
        return t;
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> List<AviacentrConsolidatedReportTicket> createTicketsForGeneralFees(List<GeneralProductCommission> commissions, String datesString, String systemNumber) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        for (GeneralProductCommission c : commissions) {
            EntityContainer commCont = EntityStorage.get().resolve(c.getCommissionProperties());
            if (commCont == null || !(commCont.getEntity() instanceof FeeProperties)) continue;
            FeeProperties fee = (FeeProperties)commCont.getEntity();
            AviacentrConsolidatedReportTicket f = AviacentrConsolidatedReportPrepareUtil.createTicketForFee(fee, c.getEquivalentAmount(), datesString, systemNumber);
            res.add(f);
        }
        return res;
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> List<AviacentrConsolidatedReportTicket> createTicketsForAirFees(List<Commission> commissions, String datesString, String systemNumber) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        for (Commission c : commissions) {
            EntityContainer commCont = EntityStorage.get().resolve(c.getCommissionProperties());
            if (commCont == null || !(commCont.getEntity() instanceof FeeProperties)) continue;
            FeeProperties fee = (FeeProperties)commCont.getEntity();
            AviacentrConsolidatedReportTicket f = AviacentrConsolidatedReportPrepareUtil.createTicketForFee(fee, c.getEquivalentAmount(), datesString, systemNumber);
            res.add(f);
        }
        return res;
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<T> getProducts(AviacentrConsolidatedReportParameters params, AviacentrConsolidatedReportGeneralProductHandler<T, I> handler, List<Message> messages) throws Exception {
        AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy result = new AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy();
        if (!params.getProductsIncluded().contains(handler.getProductType())) {
            return result;
        }
        EntityReference clientReference = params.getClient();
        if (clientReference == null) {
            SystemHelper.addMessage(messages, (String)Messages.S7TripartiteReportPrepareHandler_noClient, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return result;
        }
        EntityReference agencyReference = params.getAgency();
        if (agencyReference == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseSsodDivergenceReportPrepareHandler_noAgency, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return result;
        }
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        if (handler.getTicketTypeIndexPropertyName() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)handler.getTicketTypeIndexPropertyName(), (Object)TicketType.OWN), SearchCriterion.eq((String)handler.getTicketTypeIndexPropertyName(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)handler.getTicketTypeIndexPropertyName(), null)}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)handler.getIssueDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getIssueDateIndexPropertyName(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)handler.getPaymentDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getPaymentDateIndexPropertyName(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)handler.getCancellationDateIndexPropertyName(), null), SearchCriterion.ge((String)handler.getCancellationDateIndexPropertyName(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)handler.getCancellationDateIndexPropertyName(), (Object)params.getPeriodEnd())})}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)handler.getClientNameIndexPropertyName(), (Object)clientReference));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)handler.getStatusIndexPropertyName(), (Object)ProductStatus.BOOKING), SearchCriterion.ne((String)handler.getStatusIndexPropertyName(), (Object)ProductStatus.VOID_BOOKING), SearchCriterion.ne((String)handler.getStatusIndexPropertyName(), (Object)ProductStatus.EXCHANGE)}));
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (EntityIndex index : EntityStorage.get().search(handler.getIndexClass(), query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    if (!productIndexList.contains(uid) || !handler.getProductClass().equals(prod.getClass()) || !AviacentrConsolidatedGeneralProductPrepareHandler.isIssuedInReportPeriod(params, handler, prod) && !AviacentrConsolidatedGeneralProductPrepareHandler.isPayedInReportPeriod(params, handler, prod, true) && !AviacentrConsolidatedGeneralProductPrepareHandler.isRefusedInReportPeriod(params, handler, prod, true)) continue;
                    BaseProduct product = prod;
                    result.getProducts().add(product);
                }
            }
        }
        return result;
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> void validateProductsToReport(AviacentrConsolidatedReportGeneralProductHandler<T, I> handler, Collection<T> products, List<Message> messages) throws Exception {
        for (BaseProduct product : products) {
            boolean hasWarnings = false;
            boolean hasErrors = false;
            if (!handler.isChecked(product)) {
                for (ValidationMessage message : handler.getValidationMessages(product)) {
                    ValidationMessageSeverity severity = BaseReportPrepareHandler.getSeverity(message);
                    if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL || severity == ValidationMessageSeverity.MESSAGE) continue;
                    if (severity == ValidationMessageSeverity.WARNING) {
                        hasWarnings = true;
                    }
                    if (severity != ValidationMessageSeverity.ERROR) continue;
                    hasErrors = true;
                }
            }
            if (hasWarnings) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_ProductHasWarnings", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{handler.getSystemNumber(product), handler.getStatus(product)});
            }
            if (!hasErrors) continue;
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_ProductHasErrors", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{handler.getSystemNumber(product), handler.getStatus(product)});
        }
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> boolean isIssuedInReportPeriod(AviacentrConsolidatedReportParameters params, AviacentrConsolidatedReportGeneralProductHandler<T, I> handler, T prod) {
        Date issueDate = handler.getIssueDate(prod);
        if (params.getPeriodBegin() != null && (issueDate == null || issueDate.before(params.getPeriodBegin()))) {
            return false;
        }
        return params.getPeriodEnd() == null || issueDate != null && !issueDate.after(params.getPeriodEnd());
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> boolean isRefusedInReportPeriod(AviacentrConsolidatedReportParameters params, AviacentrConsolidatedReportGeneralProductHandler<T, I> handler, T prod, boolean checkAgent) {
        for (GeneralProductFop fop : handler.getClientFops(prod)) {
            if (!fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate())) continue;
            return true;
        }
        return false;
    }

    public static <T extends BaseProduct, I extends EntityIndex<BookingFile>> boolean isPayedInReportPeriod(AviacentrConsolidatedReportParameters params, AviacentrConsolidatedReportGeneralProductHandler<T, I> handler, T prod, boolean checkAgent) {
        for (Date fopDate : handler.getClientFopsOperationDates(prod)) {
            if (params.getPeriodBegin() != null && (fopDate == null || fopDate.before(params.getPeriodBegin())) || params.getPeriodEnd() != null && (fopDate == null || fopDate.after(params.getPeriodEnd()))) continue;
            return true;
        }
        return false;
    }
}

