/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportGeneralProductHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrDateFormatUtils;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedGeneralProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportPrepareUtil;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AviacentrConsolidatedReportAeroexpressPrepareHandler
implements AviacentrConsolidatedReportProductPrepareHandler<AeroexpressTicket> {
    private final AviacentrConsolidatedReportGeneralProductHandler<AeroexpressTicket, AeroexpressTicketIndex> handler = new AviacentrConsolidatedReportGeneralProductHandler<AeroexpressTicket, AeroexpressTicketIndex>(){

        public ProductType getProductType() {
            return ProductType.AEROEXPRESS;
        }

        public String getStatusIndexPropertyName() {
            return AeroexpressTicketIndex.Property.status.name();
        }

        public String getClientNameIndexPropertyName() {
            return AeroexpressTicketIndex.Property.client.name();
        }

        public String getCancellationDateIndexPropertyName() {
            return AeroexpressTicketIndex.Property.cancellationDate.name();
        }

        public String getPaymentDateIndexPropertyName() {
            return AeroexpressTicketIndex.Property.dateOfClientPayment.name();
        }

        public String getIssueDateIndexPropertyName() {
            return AeroexpressTicketIndex.Property.issueDate.name();
        }

        public String getTicketTypeIndexPropertyName() {
            return AeroexpressTicketIndex.Property.ticketType.name();
        }

        public Class<AeroexpressTicketIndex> getIndexClass() {
            return AeroexpressTicketIndex.class;
        }

        public Class<AeroexpressTicket> getProductClass() {
            return AeroexpressTicket.class;
        }

        public Date getIssueDate(AeroexpressTicket item) {
            return item.getIssueDate();
        }

        public List<GeneralProductFop> getClientFops(AeroexpressTicket item) {
            return AeroexpressTicketHelper.getClientFops((AeroexpressTicket)item);
        }

        public List<Date> getClientFopsOperationDates(AeroexpressTicket item) {
            ArrayList<Date> res = new ArrayList<Date>();
            for (GeneralProductFop fop : AeroexpressTicketHelper.getClientFops((AeroexpressTicket)item)) {
                res.add(fop.getOperationDate());
            }
            return res;
        }

        public boolean isChecked(AeroexpressTicket item) {
            return item.isChecked();
        }

        public List<ValidationMessage> getValidationMessages(AeroexpressTicket item) {
            return item.getValidationMessages();
        }

        public String getSystemNumber(AeroexpressTicket item) {
            return item.getSystemNumber();
        }

        public ProductStatus getStatus(AeroexpressTicket item) {
            return item.getStatus();
        }

        public String getProductName(AeroexpressTicket item) {
            return BookingHelper.generateProductName((BaseProduct)item);
        }

        public String getUnitOfMeasureForBaseProduct() {
            return unitOfMeasureBase;
        }

        public Integer getAmountForBaseProduct(AeroexpressTicket item) {
            return amountBase;
        }

        public String getUnitOfMeasureForFees() {
            return "---";
        }

        public String getAmountForFees() {
            return "---";
        }

        public BigDecimal getPrice(AeroexpressTicket item, boolean needVat) {
            if (!needVat) {
                return item.getEquivalentFare();
            }
            BigDecimal vat = item.getEquivalentFare().multiply(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue());
            return vat != null && item.getEquivalentFare() != null ? item.getEquivalentFare().subtract(vat) : item.getEquivalentFare();
        }

        public Double getVatRate(AeroexpressTicket item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            return AviacentrConsolidatedReportPrepareUtil.getStandardVat();
        }

        public BigDecimal getVatAmount(AeroexpressTicket item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            if (item.getEquivalentFare() != null) {
                return item.getEquivalentFare().multiply(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue());
            }
            return null;
        }

        public BigDecimal getTotalPriceWithVat(AeroexpressTicket item) {
            return item.getEquivalentFare();
        }

        public String getDatesString(AeroexpressTicket item) {
            if (item.getDepartureDate() != null) {
                return AviacentrDateFormatUtils.createDf().format(item.getDepartureDate());
            }
            return "";
        }
    };

    @Override
    public Class<AeroexpressTicket> getProductClass() {
        return AeroexpressTicket.class;
    }

    @Override
    public AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<AeroexpressTicket> getProducts(AviacentrConsolidatedReportParameters params, List<Message> messages) throws Exception {
        return AviacentrConsolidatedGeneralProductPrepareHandler.getProducts(params, this.handler, messages);
    }

    @Override
    public void validateProducts(Collection<AeroexpressTicket> products, List<Message> messages) throws Exception {
        AviacentrConsolidatedGeneralProductPrepareHandler.validateProductsToReport(this.handler, products, messages);
    }

    @Override
    public List<AviacentrConsolidatedReportTicket> createTickets(AeroexpressTicket product, Map<String, Object> data) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        AviacentrConsolidatedReportTicket t = AviacentrConsolidatedGeneralProductPrepareHandler.createTicketForMainProduct(product, this.handler, data);
        res.add(t);
        res.addAll(AviacentrConsolidatedGeneralProductPrepareHandler.createTicketsForGeneralFees(AeroexpressTicketHelper.getUnmodifiableCommissions((AeroexpressTicket)product, null), this.handler.getDatesString((BaseProduct)product), this.handler.getSystemNumber((BaseProduct)product)));
        return res;
    }
}

