/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportGeneralProductHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrDateFormatUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedGeneralProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportPrepareUtil;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AviacentrConsolidatedReportAirPrepareHandler
implements AviacentrConsolidatedReportProductPrepareHandler<Product> {
    private final AviacentrConsolidatedReportGeneralProductHandler<Product, ProductIndex> handler = new AviacentrConsolidatedReportGeneralProductHandler<Product, ProductIndex>(){

        public ProductType getProductType() {
            return ProductType.AIR_TICKET;
        }

        public String getStatusIndexPropertyName() {
            return ProductIndex.Property.status.name();
        }

        public String getClientNameIndexPropertyName() {
            return ProductIndex.Property.client.name();
        }

        public String getCancellationDateIndexPropertyName() {
            return ProductIndex.Property.cancellationDate.name();
        }

        public String getPaymentDateIndexPropertyName() {
            return ProductIndex.Property.dateOfClientPayment.name();
        }

        public String getIssueDateIndexPropertyName() {
            return ProductIndex.Property.issueDate.name();
        }

        public String getTicketTypeIndexPropertyName() {
            return ProductIndex.Property.ticketType.name();
        }

        public Class<ProductIndex> getIndexClass() {
            return ProductIndex.class;
        }

        public Class<Product> getProductClass() {
            return Product.class;
        }

        public Date getIssueDate(Product item) {
            return item.getIssueDate();
        }

        public List<GeneralProductFop> getClientFops(Product item) {
            ArrayList<GeneralProductFop> clientFops = new ArrayList<GeneralProductFop>();
            for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)item).getFops()) {
                clientFops.add(AirProductHelper.toGeneralProductFop((ProductFop)fop));
            }
            return clientFops;
        }

        public List<Date> getClientFopsOperationDates(Product item) {
            ArrayList<Date> res = new ArrayList<Date>();
            for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)item).getFops()) {
                res.add(fop.getOperationDate());
            }
            return res;
        }

        public boolean isChecked(Product item) {
            return item.isChecked();
        }

        public List<ValidationMessage> getValidationMessages(Product item) {
            return item.getValidationMessages();
        }

        public String getSystemNumber(Product item) {
            return item.getSystemNumber();
        }

        public ProductStatus getStatus(Product item) {
            return item.getStatus();
        }

        public String getProductName(Product item) {
            StringBuilder sb = new StringBuilder();
            sb.append(L10nResourcesManager.getStr((String)Messages.AviacentrConsolidatedReportAirPrepareHandler_ab, (Object[])new Object[0]));
            String route = AirProductHelper.getLocalizedRouteLine((Product)item);
            if (route != null) {
                sb.append(route);
            }
            if (item.getTraveller() != null) {
                String title;
                String name;
                String string = name = item.getTraveller().getName() != null ? item.getTraveller().getName().toUpperCase() : null;
                if (name != null) {
                    sb.append(" " + name);
                }
                String string2 = Gender.MALE.equals((Object)item.getTraveller().getGender()) ? L10nResourcesManager.getStr((String)Messages.AviacentrConsolidatedReportAirPrepareHandler_gentleman, (Object[])new Object[0]) : (title = Gender.FEMALE.equals((Object)item.getTraveller().getGender()) ? L10nResourcesManager.getStr((String)Messages.AviacentrConsolidatedReportAirPrepareHandler_lady, (Object[])new Object[0]) : null);
                if (title != null) {
                    sb.append(" " + title);
                }
            }
            if (!TextUtil.isBlank((String)item.getCarrierNumber())) {
                sb.append(" " + item.getCarrierNumber());
            }
            if (item.getSystemNumber() != null) {
                sb.append(" " + item.getSystemNumber());
            }
            String flights = AviacentrConsolidatedReportPrepareUtil.getFlightsNoStringForAir(item);
            String dates = this.getDatesString(item);
            if (dates.length() > 0) {
                sb.append(" (" + dates.toString() + ")");
            }
            if (flights.length() > 0) {
                sb.append(" ").append(L10nResourcesManager.getStr((String)Messages.AviacentrConsolidatedReportAirPrepareHandler_flight, (Object[])new Object[0])).append(" ").append(flights.toString());
            }
            return sb.toString();
        }

        public String getUnitOfMeasureForBaseProduct() {
            return unitOfMeasureBase;
        }

        public Integer getAmountForBaseProduct(Product item) {
            return amountBase;
        }

        public String getUnitOfMeasureForFees() {
            return "---";
        }

        public String getAmountForFees() {
            return "---";
        }

        public BigDecimal getPrice(Product item, boolean needVat) {
            BigDecimal totalWithVat = AirProductHelper.calculateTotalEquivalentFare((Product)item);
            if (!needVat) {
                return totalWithVat;
            }
            BigDecimal vat = item.getTotalVendorEquivalentVatAmount();
            return totalWithVat != null && vat != null ? totalWithVat.subtract(vat) : totalWithVat;
        }

        public BigDecimal getVatAmount(Product item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            return item.getTotalVendorEquivalentVatAmount();
        }

        public BigDecimal getTotalPriceWithVat(Product item) {
            return AirProductHelper.calculateTotalEquivalentFare((Product)item);
        }

        public Double getVatRate(Product item, boolean needVat) {
            BigDecimal rate;
            if (!needVat) {
                return null;
            }
            BigDecimal vat = item.getTotalVendorEquivalentVatAmount();
            BigDecimal totalWithVat = AirProductHelper.calculateTotalEquivalentFare((Product)item);
            if (vat != null && totalWithVat != null && !totalWithVat.equals(BigDecimal.ZERO) && (rate = vat.divide(totalWithVat, 20, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP).compareTo(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue().setScale(2, RoundingMode.HALF_UP)) == 0) {
                return AviacentrConsolidatedReportPrepareUtil.getStandardVat();
            }
            if (vat == null || BigDecimal.ZERO.equals(vat)) {
                return 0.0;
            }
            return null;
        }

        public String getDatesString(Product item) {
            StringBuilder dates = new StringBuilder();
            for (SegmentTariff st : item.getSegmentTariffs()) {
                for (Segment seg : st.getSegments()) {
                    if (seg.getStartDate() == null) continue;
                    if (dates.length() > 0) {
                        dates.append("-");
                    }
                    dates.append(AviacentrDateFormatUtils.createDf().format(seg.getStartDate()));
                }
            }
            return dates.toString();
        }
    };

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<Product> getProducts(AviacentrConsolidatedReportParameters params, List<Message> messages) throws Exception {
        return AviacentrConsolidatedGeneralProductPrepareHandler.getProducts(params, this.handler, messages);
    }

    @Override
    public void validateProducts(Collection<Product> products, List<Message> messages) throws Exception {
        AviacentrConsolidatedGeneralProductPrepareHandler.validateProductsToReport(this.handler, products, messages);
    }

    @Override
    public List<AviacentrConsolidatedReportTicket> createTickets(Product product, Map<String, Object> data) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        AviacentrConsolidatedReportTicket t = AviacentrConsolidatedGeneralProductPrepareHandler.createTicketForMainProduct(product, this.handler, data);
        res.add(t);
        res.addAll(AviacentrConsolidatedGeneralProductPrepareHandler.createTicketsForAirFees(AirProductHelper.getUnmodifiableCommissions((Product)product, null), this.handler.getDatesString((BaseProduct)product), this.handler.getSystemNumber((BaseProduct)product)));
        return res;
    }
}

