/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportGeneralProductHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedGeneralProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AviacentrConsolidatedReportDeliveryPrepareHandler
implements AviacentrConsolidatedReportProductPrepareHandler<Delivery> {
    private final AviacentrConsolidatedReportGeneralProductHandler<Delivery, DeliveryIndex> handler = new AviacentrConsolidatedReportGeneralProductHandler<Delivery, DeliveryIndex>(){

        public ProductType getProductType() {
            return ProductType.DELIVERY;
        }

        public String getStatusIndexPropertyName() {
            return DeliveryIndex.Property.status.name();
        }

        public String getClientNameIndexPropertyName() {
            return DeliveryIndex.Property.addressee.name();
        }

        public String getCancellationDateIndexPropertyName() {
            return DeliveryIndex.Property.cancellationDate.name();
        }

        public String getPaymentDateIndexPropertyName() {
            return DeliveryIndex.Property.dateOfClientPayment.name();
        }

        public String getIssueDateIndexPropertyName() {
            return DeliveryIndex.Property.issueDate.name();
        }

        public String getTicketTypeIndexPropertyName() {
            return null;
        }

        public Class<DeliveryIndex> getIndexClass() {
            return DeliveryIndex.class;
        }

        public Class<Delivery> getProductClass() {
            return Delivery.class;
        }

        public Date getIssueDate(Delivery item) {
            return item.getIssueDate();
        }

        public List<GeneralProductFop> getClientFops(Delivery item) {
            return item.getClientFops();
        }

        public List<Date> getClientFopsOperationDates(Delivery item) {
            ArrayList<Date> res = new ArrayList<Date>();
            for (GeneralProductFop fop : item.getClientFops()) {
                res.add(fop.getOperationDate());
            }
            return res;
        }

        public boolean isChecked(Delivery item) {
            return item.isChecked();
        }

        public List<ValidationMessage> getValidationMessages(Delivery item) {
            return item.getValidationMessages();
        }

        public String getSystemNumber(Delivery item) {
            return item.getSystemNumber();
        }

        public ProductStatus getStatus(Delivery item) {
            return item.getStatus() == DeliveryStatus.VOID ? ProductStatus.VOID : ProductStatus.SELL;
        }

        public String getProductName(Delivery item) {
            return BookingHelper.generateProductName((BaseProduct)item);
        }

        public String getUnitOfMeasureForBaseProduct() {
            return unitOfMeasureBase;
        }

        public Integer getAmountForBaseProduct(Delivery item) {
            return amountBase;
        }

        public String getUnitOfMeasureForFees() {
            return "---";
        }

        public String getAmountForFees() {
            return "---";
        }

        public BigDecimal getPrice(Delivery item, boolean needVat) {
            return null;
        }

        public Double getVatRate(Delivery item, boolean needVat) {
            if (Boolean.FALSE.equals(needVat)) {
                return null;
            }
            return null;
        }

        public BigDecimal getVatAmount(Delivery item, boolean needVat) {
            if (Boolean.FALSE.equals(needVat)) {
                return null;
            }
            return null;
        }

        public BigDecimal getTotalPriceWithVat(Delivery item) {
            return null;
        }

        public String getDatesString(Delivery item) {
            return null;
        }
    };

    @Override
    public Class<Delivery> getProductClass() {
        return Delivery.class;
    }

    @Override
    public AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<Delivery> getProducts(AviacentrConsolidatedReportParameters params, List<Message> messages) throws Exception {
        return AviacentrConsolidatedGeneralProductPrepareHandler.getProducts(params, this.handler, messages);
    }

    @Override
    public void validateProducts(Collection<Delivery> products, List<Message> messages) throws Exception {
        AviacentrConsolidatedGeneralProductPrepareHandler.validateProductsToReport(this.handler, products, messages);
    }

    @Override
    public List<AviacentrConsolidatedReportTicket> createTickets(Delivery product, Map<String, Object> data) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        AviacentrConsolidatedReportTicket t = AviacentrConsolidatedGeneralProductPrepareHandler.createTicketForMainProduct(product, this.handler, data);
        res.add(t);
        return res;
    }
}

