/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportGeneralProductHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrDateFormatUtils;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedGeneralProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportPrepareUtil;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AviacentrConsolidatedReportInsuranceAccidentPrepareHandler
implements AviacentrConsolidatedReportProductPrepareHandler<InsuranceAccident> {
    private final AviacentrConsolidatedReportGeneralProductHandler<InsuranceAccident, InsuranceAccidentIndex> handler = new AviacentrConsolidatedReportGeneralProductHandler<InsuranceAccident, InsuranceAccidentIndex>(){

        public ProductType getProductType() {
            return ProductType.INSURANCE_ACCIDENT;
        }

        public String getStatusIndexPropertyName() {
            return InsuranceAccidentIndex.Property.status.name();
        }

        public String getClientNameIndexPropertyName() {
            return InsuranceAccidentIndex.Property.client.name();
        }

        public String getCancellationDateIndexPropertyName() {
            return InsuranceAccidentIndex.Property.cancellationDate.name();
        }

        public String getPaymentDateIndexPropertyName() {
            return InsuranceAccidentIndex.Property.dateOfClientPayment.name();
        }

        public String getIssueDateIndexPropertyName() {
            return InsuranceAccidentIndex.Property.issueDate.name();
        }

        public String getTicketTypeIndexPropertyName() {
            return InsuranceAccidentIndex.Property.ticketType.name();
        }

        public Class<InsuranceAccidentIndex> getIndexClass() {
            return InsuranceAccidentIndex.class;
        }

        public Class<InsuranceAccident> getProductClass() {
            return InsuranceAccident.class;
        }

        public Date getIssueDate(InsuranceAccident item) {
            return item.getIssueDate();
        }

        public List<GeneralProductFop> getClientFops(InsuranceAccident item) {
            return InsuranceAccidentHelper.getClientFops((InsuranceAccident)item);
        }

        public List<Date> getClientFopsOperationDates(InsuranceAccident item) {
            ArrayList<Date> res = new ArrayList<Date>();
            for (GeneralProductFop fop : InsuranceAccidentHelper.getClientFops((InsuranceAccident)item)) {
                res.add(fop.getOperationDate());
            }
            return res;
        }

        public boolean isChecked(InsuranceAccident item) {
            return item.isChecked();
        }

        public List<ValidationMessage> getValidationMessages(InsuranceAccident item) {
            return item.getValidationMessages();
        }

        public String getSystemNumber(InsuranceAccident item) {
            return item.getSystemNumber();
        }

        public ProductStatus getStatus(InsuranceAccident item) {
            return item.getStatus();
        }

        public String getProductName(InsuranceAccident item) {
            return BookingHelper.generateProductName((BaseProduct)item);
        }

        public String getUnitOfMeasureForBaseProduct() {
            return unitOfMeasureBase;
        }

        public Integer getAmountForBaseProduct(InsuranceAccident item) {
            return amountBase;
        }

        public String getUnitOfMeasureForFees() {
            return "---";
        }

        public String getAmountForFees() {
            return "---";
        }

        public BigDecimal getPrice(InsuranceAccident item, boolean needVat) {
            if (!needVat) {
                return item.getEquivalentSum();
            }
            BigDecimal vat = item.getEquivalentSum().multiply(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue());
            return vat != null && item.getEquivalentSum() != null ? item.getEquivalentSum().subtract(vat) : item.getEquivalentSum();
        }

        public Double getVatRate(InsuranceAccident item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            return AviacentrConsolidatedReportPrepareUtil.getStandardVat();
        }

        public BigDecimal getVatAmount(InsuranceAccident item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            if (item.getEquivalentSum() != null) {
                return item.getEquivalentSum().multiply(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue());
            }
            return null;
        }

        public BigDecimal getTotalPriceWithVat(InsuranceAccident item) {
            return item.getEquivalentSum();
        }

        public String getDatesString(InsuranceAccident item) {
            if (item.getDepartureDate() != null) {
                return AviacentrDateFormatUtils.createDf().format(item.getDepartureDate());
            }
            return "";
        }
    };

    @Override
    public Class<InsuranceAccident> getProductClass() {
        return InsuranceAccident.class;
    }

    @Override
    public AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<InsuranceAccident> getProducts(AviacentrConsolidatedReportParameters params, List<Message> messages) throws Exception {
        return AviacentrConsolidatedGeneralProductPrepareHandler.getProducts(params, this.handler, messages);
    }

    @Override
    public void validateProducts(Collection<InsuranceAccident> products, List<Message> messages) throws Exception {
        AviacentrConsolidatedGeneralProductPrepareHandler.validateProductsToReport(this.handler, products, messages);
    }

    @Override
    public List<AviacentrConsolidatedReportTicket> createTickets(InsuranceAccident product, Map<String, Object> data) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        AviacentrConsolidatedReportTicket t = AviacentrConsolidatedGeneralProductPrepareHandler.createTicketForMainProduct(product, this.handler, data);
        res.add(t);
        res.addAll(AviacentrConsolidatedGeneralProductPrepareHandler.createTicketsForGeneralFees(InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, null), this.handler.getDatesString((BaseProduct)product), this.handler.getSystemNumber((BaseProduct)product)));
        return res;
    }
}

