/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportGeneralProductHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrDateFormatUtils;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedGeneralProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportPrepareUtil;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AviacentrConsolidatedReportInsuranceTouristicPrepareHandler
implements AviacentrConsolidatedReportProductPrepareHandler<InsuranceTouristic> {
    private final AviacentrConsolidatedReportGeneralProductHandler<InsuranceTouristic, InsuranceTouristicIndex> handler = new AviacentrConsolidatedReportGeneralProductHandler<InsuranceTouristic, InsuranceTouristicIndex>(){

        public ProductType getProductType() {
            return ProductType.INSURANCE_TOURISTIC;
        }

        public String getStatusIndexPropertyName() {
            return InsuranceTouristicIndex.Property.status.name();
        }

        public String getClientNameIndexPropertyName() {
            return InsuranceTouristicIndex.Property.client.name();
        }

        public String getCancellationDateIndexPropertyName() {
            return InsuranceTouristicIndex.Property.cancellationDate.name();
        }

        public String getPaymentDateIndexPropertyName() {
            return InsuranceTouristicIndex.Property.dateOfClientPayment.name();
        }

        public String getIssueDateIndexPropertyName() {
            return InsuranceTouristicIndex.Property.issueDate.name();
        }

        public String getTicketTypeIndexPropertyName() {
            return InsuranceTouristicIndex.Property.ticketType.name();
        }

        public Class<InsuranceTouristicIndex> getIndexClass() {
            return InsuranceTouristicIndex.class;
        }

        public Class<InsuranceTouristic> getProductClass() {
            return InsuranceTouristic.class;
        }

        public Date getIssueDate(InsuranceTouristic item) {
            return item.getIssueDate();
        }

        public List<GeneralProductFop> getClientFops(InsuranceTouristic item) {
            return InsuranceTouristicHelper.getClientFops((InsuranceTouristic)item);
        }

        public List<Date> getClientFopsOperationDates(InsuranceTouristic item) {
            ArrayList<Date> res = new ArrayList<Date>();
            for (GeneralProductFop fop : InsuranceTouristicHelper.getClientFops((InsuranceTouristic)item)) {
                res.add(fop.getOperationDate());
            }
            return res;
        }

        public boolean isChecked(InsuranceTouristic item) {
            return item.isChecked();
        }

        public List<ValidationMessage> getValidationMessages(InsuranceTouristic item) {
            return item.getValidationMessages();
        }

        public String getSystemNumber(InsuranceTouristic item) {
            return item.getSystemNumber();
        }

        public ProductStatus getStatus(InsuranceTouristic item) {
            return item.getStatus();
        }

        public String getProductName(InsuranceTouristic item) {
            return BookingHelper.generateProductName((BaseProduct)item);
        }

        public String getUnitOfMeasureForBaseProduct() {
            return unitOfMeasureBase;
        }

        public Integer getAmountForBaseProduct(InsuranceTouristic item) {
            return amountBase;
        }

        public String getUnitOfMeasureForFees() {
            return "---";
        }

        public String getAmountForFees() {
            return "---";
        }

        public BigDecimal getPrice(InsuranceTouristic item, boolean needVat) {
            if (!needVat) {
                return item.getEquivalentSum();
            }
            BigDecimal vat = item.getEquivalentSum().multiply(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue());
            return vat != null && item.getEquivalentSum() != null ? item.getEquivalentSum().subtract(vat) : item.getEquivalentSum();
        }

        public Double getVatRate(InsuranceTouristic item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            return AviacentrConsolidatedReportPrepareUtil.getStandardVat();
        }

        public BigDecimal getVatAmount(InsuranceTouristic item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            if (item.getEquivalentSum() != null) {
                return item.getEquivalentSum().multiply(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue());
            }
            return null;
        }

        public BigDecimal getTotalPriceWithVat(InsuranceTouristic item) {
            return item.getEquivalentSum();
        }

        public String getDatesString(InsuranceTouristic item) {
            StringBuilder sb = new StringBuilder();
            DateFormat df = AviacentrDateFormatUtils.createDf();
            if (item.getStartDate() != null) {
                sb.append(df.format(item.getStartDate()));
            }
            if (item.getEndDate() != null) {
                if (sb.length() > 0) {
                    sb.append("-");
                }
                sb.append(df.format(item.getEndDate()));
            }
            return sb.toString();
        }
    };

    @Override
    public Class<InsuranceTouristic> getProductClass() {
        return InsuranceTouristic.class;
    }

    @Override
    public AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<InsuranceTouristic> getProducts(AviacentrConsolidatedReportParameters params, List<Message> messages) throws Exception {
        return AviacentrConsolidatedGeneralProductPrepareHandler.getProducts(params, this.handler, messages);
    }

    @Override
    public void validateProducts(Collection<InsuranceTouristic> products, List<Message> messages) throws Exception {
        AviacentrConsolidatedGeneralProductPrepareHandler.validateProductsToReport(this.handler, products, messages);
    }

    @Override
    public List<AviacentrConsolidatedReportTicket> createTickets(InsuranceTouristic product, Map<String, Object> data) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        AviacentrConsolidatedReportTicket t = AviacentrConsolidatedGeneralProductPrepareHandler.createTicketForMainProduct(product, this.handler, data);
        res.add(t);
        res.addAll(AviacentrConsolidatedGeneralProductPrepareHandler.createTicketsForGeneralFees(InsuranceTouristicHelper.getUnmodifiableCommissions((InsuranceTouristic)product, null), this.handler.getDatesString((BaseProduct)product), this.handler.getSystemNumber((BaseProduct)product)));
        return res;
    }
}

