/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandlersRegistry;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AviacentrConsolidatedReportPrepareHandler
implements ReportPrepareHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getId() {
        return "aviacentr-consolidated-report";
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        data.put("key-messages", messages);
        AviacentrConsolidatedReportParameters params = (AviacentrConsolidatedReportParameters)data.get("key-report-params");
        if (params == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoReportParameters", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
            return;
        }
        this.putGlobalData(data, params, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        LinkedHashMap<Class<BaseProduct>, List<BaseProduct>> productMap = new LinkedHashMap<Class<BaseProduct>, List<BaseProduct>>();
        for (AviacentrConsolidatedReportProductPrepareHandler<BaseProduct> aviacentrConsolidatedReportProductPrepareHandler : ((AviacentrConsolidatedReportProductPrepareHandlersRegistry)Environment.getPublished(AviacentrConsolidatedReportProductPrepareHandlersRegistry.class)).getAllHandlers()) {
            AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<BaseProduct> result = aviacentrConsolidatedReportProductPrepareHandler.getProducts(params, messages);
            if (result.getProducts().isEmpty()) continue;
            productMap.put(aviacentrConsolidatedReportProductPrepareHandler.getProductClass(), result.getProducts());
        }
        if (productMap.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        for (Map.Entry entry : productMap.entrySet()) {
            ((AviacentrConsolidatedReportProductPrepareHandlersRegistry)Environment.getPublished(AviacentrConsolidatedReportProductPrepareHandlersRegistry.class)).findHandler((Class)entry.getKey()).validateProducts((Collection)entry.getValue(), messages);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        for (Map.Entry entry : productMap.entrySet()) {
            AviacentrConsolidatedReportProductPrepareHandler<BaseProduct> handler = ((AviacentrConsolidatedReportProductPrepareHandlersRegistry)Environment.getPublished(AviacentrConsolidatedReportProductPrepareHandlersRegistry.class)).findHandler((Class)entry.getKey());
            for (BaseProduct bp : (List)entry.getValue()) {
                List<AviacentrConsolidatedReportTicket> tickets = handler.createTickets(bp, data);
                for (AviacentrConsolidatedReportTicket ticket : tickets) {
                    ProductStatus status = ticket.getStatus();
                    String batchId = "SELL";
                    this.addTicket(data, ticket, batchId);
                }
            }
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
    }

    private void addTicket(Map<String, Object> data, AviacentrConsolidatedReportTicket ticket, String batchId) {
        ArrayList<ReportBatchData> batchDataList = (ArrayList<ReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData>();
            ReportBatchData sellList = new ReportBatchData();
            sellList.setBatchId("SELL");
            batchDataList.add(sellList);
            data.put("key-batch-data-list", batchDataList);
        }
        for (ReportBatchData batchData : batchDataList) {
            if (!batchData.getBatchId().equals(batchId)) continue;
            batchData.getTickets().add(ticket);
            return;
        }
    }

    private void putGlobalData(Map<String, Object> data, AviacentrConsolidatedReportParameters params, List<Message> messages) throws Exception {
        EntityContainer ctrClient;
        BaseReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        data.put("STARTDATE", params.getPeriodBegin());
        data.put("ENDDATE", params.getPeriodEnd());
        data.put("REPORTDATE", params.getReportDate());
        EntityStorage es = EntityStorage.get();
        EntityContainer ctr = es.resolve(params.getTemplate());
        if (ctr == null || ((TemplateDocument)ctr.getEntity()).getContent() == null) {
            SystemHelper.addMessage(messages, (String)Messages.AviacentrConsolidatedReportPrepareHandler_noTemplateAccountInBD, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        data.put("REPORT_TEMPLATE", ((TemplateDocument)ctr.getEntity()).getContent());
        EntityContainer ctrAgency = es.resolve(params.getAgency());
        if (ctrAgency == null) {
            SystemHelper.addMessage(messages, (String)Messages.AviacentrConsolidatedReportPrepareHandler_cantLoadProfileAgent, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgency()});
            return;
        }
        Organization agency = (Organization)ctrAgency.getEntity();
        data.put("AGENCYNAME", ProfileHelper.getFullName((Organization)agency, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        Address addr = null;
        for (Address a : ProfileHelper.getOrganizationAddresses((Organization)agency)) {
            if (!AddressType.BUSINESS.equals((Object)a.getAddressType()) && !AddressType.LEGAL.equals((Object)a.getAddressType()) && !AddressType.FACTUAL.equals((Object)a.getAddressType())) continue;
            addr = a;
            break;
        }
        data.put("AGENCYADDRESS", ProfileHelper.buildFullAddress(addr, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        data.put("AGENCYINN", agency.getRegistrationId());
        data.put("AGENCYKPP", agency.getKpp());
        data.put("ACCEPTOR", ProfileHelper.getFullName((Organization)agency, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        if (params.isNeedImageSignatures()) {
            data.put("AGENCY_STAMP", agency.getStampImage());
        }
        BankAccount bank = null;
        if (agency.getBankAccounts().size() == 1) {
            bank = (BankAccount)agency.getBankAccounts().get(0);
        } else if (agency.getBankAccounts().size() > 1) {
            BankAccount bankAccountFromDocuments = agency.getFinanceDocumentProperties() != null ? agency.getFinanceDocumentProperties().getBankAccount() : null;
            bank = (BankAccount)agency.getBankAccounts().get(0);
            for (BankAccount ba : agency.getBankAccounts()) {
                if (ba == null || !ba.equals((Object)bankAccountFromDocuments)) continue;
                bank = ba;
                break;
            }
        }
        if (bank != null) {
            data.put("BANK", bank.getBankName());
            data.put("ACCOUNTNUMBER", bank.getSettlementAccount());
            data.put("BIKNUMBER", bank.getBik());
            data.put("CORRACCOUNT", bank.getCorrespondentAccount());
        }
        if ((ctrClient = es.resolve(params.getClient())) == null) {
            SystemHelper.addMessage(messages, (String)Messages.AviacentrConsolidatedReportPrepareHandler_cantLoadProfileClient, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getClient()});
            return;
        }
        Organization client = (Organization)ctrClient.getEntity();
        StringBuilder clientDetails = new StringBuilder();
        clientDetails.append(ProfileHelper.getFullName((Organization)client, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        if (!TextUtil.isBlank((String)client.getRegistrationId())) {
            clientDetails.append(" " + client.getRegistrationId());
            if (!TextUtil.isBlank((String)client.getKpp())) {
                clientDetails.append("/" + client.getKpp());
            }
        }
        data.put("CLIENTNAME", clientDetails.toString());
        data.put("PAYERNAME", clientDetails.toString());
        boolean needVat = false;
        for (Metadata m : client.getMetadata()) {
            if (m.getKey() == null || !m.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_NEED_VAT_FOR_CONSOLIDATED_REPORT.name()) || m.getValue() == null || !(m.getValue() instanceof Boolean) || !((Boolean)m.getValue()).booleanValue()) continue;
            needVat = true;
            break;
        }
        if (needVat) {
            data.put("NEED_VAT_FOR_CLIENT", Boolean.TRUE);
        } else {
            data.put("NEED_VAT_FOR_CLIENT", Boolean.FALSE);
        }
        data.put("CONTRACTNUMBERDATE", this.buildContractString((EntityReference<Organization>)ctrAgency.toReference(), (EntityReference<Organization>)ctrClient.toReference()));
        List employees = ProfileDao.getEmployees((EntityReference)ctrAgency.toReference(), (ManagerType[])new ManagerType[]{ManagerType.DIRECTOR, ManagerType.CHIEF_ACCOUNTANT}, (Date)new Date());
        for (Person employee : employees) {
            Set standardPositions = ProfileHelper.getStandardPositions((List)employee.getEmployments(), (EntityReference)ctrAgency.toReference());
            if (standardPositions.contains(ManagerType.DIRECTOR)) {
                data.put("DIRECTOR", ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
                if (params.isNeedImageSignatures()) {
                    data.put("DIRECTOR_SIGNATURE", employee.getSignatureImage());
                }
            }
            if (!standardPositions.contains(ManagerType.CHIEF_ACCOUNTANT)) continue;
            data.put("CHIEFACCOUNTANT", ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            if (!params.isNeedImageSignatures()) continue;
            data.put("CHIEF_ACCOUNTANT_SIGNATURE", employee.getSignatureImage());
        }
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        int count = es.search(AviacentrConsolidatedReportDocumentIndex.class, query).getTotalCount();
        data.put("REPORTNUMBER", new DecimalFormat("0000000").format(count + 1));
        data.put("PAYMENTCURRENCY", DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null));
        data.put("REPORTMAKER", params.getCreatorPerson() != null ? params.getCreatorPerson().getCaption() : params.getCreatorLogin());
    }

    private Object buildContractString(EntityReference<Organization> agencyRef, EntityReference<Organization> customerRef) {
        StringBuilder res = new StringBuilder();
        boolean hasContract = false;
        SearchQuery q = new SearchQuery();
        q.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        q.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), agencyRef));
        q.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), customerRef));
        q.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)new Date())}));
        q.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)new Date())}));
        List ctrList = EntityStorage.get().search(ContractCustomerIndex.class, q).getData();
        if (ctrList.size() > 0) {
            hasContract = true;
            ContractCustomerIndex ctrInd = (ContractCustomerIndex)ctrList.get(0);
            res.append(ctrInd.getNumber());
            if (ctrInd.getIssueDate() != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                res.append(" ").append(L10nResourcesManager.getStr((String)Messages.AviacentrConsolidatedReportPrepareHandler_from, (Object[])new Object[0]) + sdf.format(ctrInd.getIssueDate())).append(" ");
            }
        }
        return hasContract ? res.toString() : "";
    }
}

