/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class AviacentrConsolidatedReportPrepareUtil {
    static final ThreadLocal<DecimalFormat> decimalFormat = ThreadLocal.withInitial(() -> new DecimalFormat("0.##"));

    public static String getFlightsNoStringForAir(Product item) {
        StringBuilder flights = new StringBuilder();
        for (SegmentTariff st : item.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (TextUtil.isBlank((String)seg.getFlightNo())) continue;
                if (flights.length() > 0) {
                    flights.append("; ");
                }
                flights.append(seg.getFlightNo());
            }
        }
        return flights.toString();
    }

    public static String getNameForFee(FeeProperties fee, String dateString, String systemNumber) {
        StringBuilder name = new StringBuilder();
        if (!TextUtil.isBlank((String)fee.getFinanceName())) {
            name.append(fee.getFinanceName());
        }
        if (!TextUtil.isBlank((String)systemNumber)) {
            name.append(" ").append(systemNumber);
        }
        if (dateString.length() > 0) {
            name.append(" (").append(dateString).append(")");
        }
        return name.toString().trim();
    }

    public static AviacentrConsolidatedReportTicket createTicketForFee(FeeProperties fee, BigDecimal equivalentAmount, String datesString, String systemNumber) {
        AviacentrConsolidatedReportTicket f = new AviacentrConsolidatedReportTicket();
        f.setProductName(AviacentrConsolidatedReportPrepareUtil.getNameForFee(fee, datesString, systemNumber));
        f.setUnitOfMeasure("---");
        f.setAmount(null);
        f.setAmountStr("---");
        BigDecimal valueWithVat = equivalentAmount;
        f.setPrice(null);
        f.setPriceStr("---");
        f.setTotalPrice(valueWithVat != null ? valueWithVat.divide(BigDecimal.valueOf((100.0 + AviacentrConsolidatedReportPrepareUtil.getStandardVat()) / 100.0), 2, RoundingMode.HALF_UP) : null);
        f.setTotalPriceStr(f.getTotalPrice() != null ? f.getTotalPrice().setScale(2, RoundingMode.HALF_UP).toString() : "---");
        f.setVatRate(AviacentrConsolidatedReportPrepareUtil.getStandardVat());
        f.setVatRateStr(f.getVatRate() != null ? decimalFormat.get().format(f.getVatRate()) + "%" : "---");
        f.setVatAmount(valueWithVat != null ? valueWithVat.multiply(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue()) : null);
        f.setVatAmountStr(f.getVatAmount() != null ? f.getVatAmount().setScale(2, RoundingMode.HALF_UP).toString() : "---");
        f.setTotalWithVat(valueWithVat);
        f.setTotalWithVatStr(f.getTotalWithVat() != null ? f.getTotalWithVat().setScale(2, RoundingMode.HALF_UP).toString() : "---");
        return f;
    }

    public static Double getStandardVat() {
        double standardVat = 0.0;
        try {
            BigDecimal vat = DictHelper.getDefaultVat();
            standardVat = vat != null ? vat.doubleValue() : 18.0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return standardVat;
    }

    public static BigDecimal getVatRateForValue() {
        Double vat = AviacentrConsolidatedReportPrepareUtil.getStandardVat();
        return BigDecimal.valueOf(vat).divide(BigDecimal.valueOf(100.0 + vat), 20, RoundingMode.HALF_UP);
    }
}

