/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.aviacentr;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportGeneralProductHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrDateFormatUtils;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedGeneralProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportPrepareUtil;
import com.gridnine.xtrip.server.reports.prepare.aviacentr.AviacentrConsolidatedReportProductPrepareHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AviacentrConsolidatedReportUniversalPrepareHandler
implements AviacentrConsolidatedReportProductPrepareHandler<UniversalProduct> {
    private final AviacentrConsolidatedReportGeneralProductHandler<UniversalProduct, UniversalProductIndex> handler = new AviacentrConsolidatedReportGeneralProductHandler<UniversalProduct, UniversalProductIndex>(){

        public ProductType getProductType() {
            return ProductType.MISC_PRODUCT;
        }

        public String getStatusIndexPropertyName() {
            return UniversalProductIndex.Property.status.name();
        }

        public String getClientNameIndexPropertyName() {
            return UniversalProductIndex.Property.client.name();
        }

        public String getCancellationDateIndexPropertyName() {
            return UniversalProductIndex.Property.cancellationDate.name();
        }

        public String getPaymentDateIndexPropertyName() {
            return UniversalProductIndex.Property.dateOfClientPayment.name();
        }

        public String getIssueDateIndexPropertyName() {
            return UniversalProductIndex.Property.issueDate.name();
        }

        public String getTicketTypeIndexPropertyName() {
            return UniversalProductIndex.Property.ticketType.name();
        }

        public Class<UniversalProductIndex> getIndexClass() {
            return UniversalProductIndex.class;
        }

        public Class<UniversalProduct> getProductClass() {
            return UniversalProduct.class;
        }

        public Date getIssueDate(UniversalProduct item) {
            return item.getIssueDate();
        }

        public List<GeneralProductFop> getClientFops(UniversalProduct item) {
            return UniversalProductHelper.getClientFops((UniversalProduct)item);
        }

        public List<Date> getClientFopsOperationDates(UniversalProduct item) {
            ArrayList<Date> res = new ArrayList<Date>();
            for (GeneralProductFop fop : UniversalProductHelper.getClientFops((UniversalProduct)item)) {
                res.add(fop.getOperationDate());
            }
            return res;
        }

        public boolean isChecked(UniversalProduct item) {
            return item.isChecked();
        }

        public List<ValidationMessage> getValidationMessages(UniversalProduct item) {
            return item.getValidationMessages();
        }

        public String getSystemNumber(UniversalProduct item) {
            return item.getSystemNumber();
        }

        public ProductStatus getStatus(UniversalProduct item) {
            return item.getStatus();
        }

        public String getProductName(UniversalProduct item) {
            return BookingHelper.generateProductName((BaseProduct)item);
        }

        public String getUnitOfMeasureForBaseProduct() {
            return unitOfMeasureBase;
        }

        public Integer getAmountForBaseProduct(UniversalProduct item) {
            return amountBase;
        }

        public String getUnitOfMeasureForFees() {
            return "---";
        }

        public String getAmountForFees() {
            return "---";
        }

        public BigDecimal getPrice(UniversalProduct item, boolean needVat) {
            if (!needVat) {
                return item.getEquivalentFare();
            }
            BigDecimal vat = item.getTotalVat();
            return vat != null && item.getEquivalentFare() != null ? item.getEquivalentFare().subtract(vat) : item.getEquivalentFare();
        }

        public Double getVatRate(UniversalProduct item, boolean needVat) {
            BigDecimal rate;
            if (!needVat) {
                return null;
            }
            BigDecimal vat = item.getTotalVat();
            BigDecimal totalWithVat = item.getEquivalentFare();
            if (vat != null && totalWithVat != null && !totalWithVat.equals(BigDecimal.ZERO) && (rate = vat.divide(totalWithVat, 20, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP).compareTo(AviacentrConsolidatedReportPrepareUtil.getVatRateForValue().setScale(2, RoundingMode.HALF_UP)) == 0) {
                return AviacentrConsolidatedReportPrepareUtil.getStandardVat();
            }
            if (vat == null || BigDecimal.ZERO.equals(vat)) {
                return 0.0;
            }
            return null;
        }

        public BigDecimal getVatAmount(UniversalProduct item, boolean needVat) {
            if (!needVat) {
                return null;
            }
            return item.getTotalVat();
        }

        public BigDecimal getTotalPriceWithVat(UniversalProduct item) {
            return item.getEquivalentFare();
        }

        public String getDatesString(UniversalProduct item) {
            if (item.getIssueDate() != null) {
                return AviacentrDateFormatUtils.createDf().format(item.getIssueDate());
            }
            return "";
        }
    };

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public AviacentrConsolidatedReportProductPrepareHandler.ProductsListProxy<UniversalProduct> getProducts(AviacentrConsolidatedReportParameters params, List<Message> messages) throws Exception {
        return AviacentrConsolidatedGeneralProductPrepareHandler.getProducts(params, this.handler, messages);
    }

    @Override
    public void validateProducts(Collection<UniversalProduct> products, List<Message> messages) throws Exception {
        AviacentrConsolidatedGeneralProductPrepareHandler.validateProductsToReport(this.handler, products, messages);
    }

    @Override
    public List<AviacentrConsolidatedReportTicket> createTickets(UniversalProduct product, Map<String, Object> data) {
        ArrayList<AviacentrConsolidatedReportTicket> res = new ArrayList<AviacentrConsolidatedReportTicket>();
        AviacentrConsolidatedReportTicket t = AviacentrConsolidatedGeneralProductPrepareHandler.createTicketForMainProduct(product, this.handler, data);
        res.add(t);
        return res;
    }
}

