/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndex;
import com.gridnine.xtrip.common.model.finance.CreditBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.support.reports.ReportCreditBankTransferOrderInfo;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class BaseSalesReportPrepareHandler<T extends BaseSalesReportTicket>
extends BaseReportPrepareHandler {
    protected abstract MetadataKey getAgencyReportCode(BaseReportParameters var1);

    protected String getAgentFullName() throws Exception {
        String user = LogicalStorage.get().getUser();
        if (TextUtil.isBlank((String)user)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)user));
        List data = EntityStorage.get().search(PersonIndex.class, query).getData();
        if (data.size() == 0) {
            return null;
        }
        return ((PersonIndex)data.get(0)).getName();
    }

    protected Set<Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityStorage es = EntityStorage.get();
        EntityReference salesPointReference = params.getSalesPoint();
        EntityReference agencyReference = params.getAgency();
        EntityReference subagencyReference = params.getSubagency();
        List<ProductIndex> allData = SalesReportPrepareHelper.selectProducts(data);
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (ProductIndex index : allData) {
            if (params.getBlankOwner() != null && !params.getBlankOwner().equals((Object)index.getBlankOwner()) || !SalesReportPrepareHelper.isHasAppropriateReportAgency(index, (EntityReference<Organization>)agencyReference, data, messages) || !this.isHasAppropriateSalesPoint(index, (EntityReference<SalesPoint>)salesPointReference, data, messages) || !this.isHasAppropriateSubagency(index, (EntityReference<Organization>)subagencyReference, data, messages) || params.getSupplier() != null && !params.getSupplier().equals((Object)index.getSupplier())) continue;
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<Product> result = new HashSet<Product>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return Collections.emptySet();
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block3: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof Product)) continue;
                        result.add((Product)prod);
                        continue block3;
                    }
                }
            }
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        }
        return result;
    }

    @Deprecated
    protected boolean isHasAppropriateSalesPoint(ProductIndex index, EntityReference<SalesPoint> salesPointReference, Map<String, Object> data, List<Message> messages) throws Exception {
        String ticketNumber;
        String string = ticketNumber = !index.getTicketNumbers().isEmpty() ? (String)index.getTicketNumbers().iterator().next() : "";
        if (salesPointReference == null) {
            return true;
        }
        EntityReference spRef = index.getSalesPoint();
        if (spRef == null) {
            String validatorCode = index.getValidatorCode();
            if (TextUtil.isBlank((String)validatorCode)) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoSalesPointAndValidator", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber});
                return false;
            }
            List spcs = ProfileDao.findSalesPointsByValidatorAndPCC((String)validatorCode, null, (Date)index.getIssueDate());
            if (spcs.isEmpty()) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoSalesPoints", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber, validatorCode});
                return false;
            }
            if (spcs.size() > 1) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_FewSalesPoints", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber, validatorCode});
                return false;
            }
            spRef = new EntityReference((EntityContainer)spcs.get(0));
        }
        return spRef.equals(salesPointReference);
    }

    @Deprecated
    protected boolean isHasAppropriateSubagency(ProductIndex index, EntityReference<Organization> subagencyReference, Map<String, Object> data, List<Message> messages) throws Exception {
        if (subagencyReference == null) {
            return true;
        }
        String ticketNumber = !index.getTicketNumbers().isEmpty() ? (String)index.getTicketNumbers().iterator().next() : "";
        EntityReference subagRef = index.getSubagency();
        if (subagRef == null) {
            String validatorCode = index.getValidatorCode();
            if (TextUtil.isBlank((String)validatorCode)) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoSubagencyValidator", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber});
                return false;
            }
            List spcs = ProfileDao.findSalesPointsByValidatorAndPCC((String)validatorCode, null, (Date)index.getIssueDate());
            if (spcs.isEmpty()) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoSalesPointsSubagency", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber, validatorCode});
                return false;
            }
            if (spcs.size() > 1) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_FewSalesPointsSubagency", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber, validatorCode});
                return false;
            }
            EntityContainer spc = (EntityContainer)spcs.get(0);
            subagRef = ((SalesPoint)spc.getEntity()).getAgency();
            if (subagRef == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoAgencyInSalesPoint", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber, ((SalesPoint)spc.getEntity()).getShortName()});
                return false;
            }
        }
        return subagRef.equals(subagencyReference);
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        Organization vendor;
        List addresses;
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        data.put("REPORT_PERIOD_NO", "000");
        data.put("AGENT_NAME", this.getAgentFullName());
        BaseSalesReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        EntityContainer boc = EntityStorage.get().resolve(params.getBlankOwner());
        if (boc != null) {
            data.put("key-vendor", boc.getEntity());
        }
        BaseReportPrepareHandler.putStandardAgencyData((EntityReference<Organization>)params.getAgency(), data, messages);
        EntityContainer ac = EntityStorage.get().resolve(params.getAgency());
        if (ac == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgency()});
            this.log.debug("Could not find entity in database");
            return;
        }
        Organization agency = (Organization)ac.getEntity();
        MetadataKey agencyReportCodeKey = this.getAgencyReportCode((BaseReportParameters)((ReportParameters)data.get("key-report-params")));
        String agencyCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)agencyReportCodeKey);
        if (agencyCode != null && agencyCode.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"BaseStockControlReportPrepareHandler_Message_AgencyCodeIsEmpty", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{agency.getFullName(), boc != null ? ((Organization)boc.getEntity()).toString() : null});
        }
        data.put("AGENCY_IATA_CODE", agencyCode);
        if (agencyReportCodeKey != null && agencyReportCodeKey.equals((Object)MetadataKey.KEY_SU_2013_AGENCY_CODE) && !TextUtil.isBlank((String)agencyCode)) {
            String oldSuAgencyCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_SU_AGENCY_CODE);
            data.put("KEY_SU_2013_AGENCY_CODE", oldSuAgencyCode);
        }
        if ((addresses = ProfileHelper.getOrganizationAddresses((Organization)agency)) != null && addresses.iterator().hasNext()) {
            Address address = (Address)addresses.get(0);
            data.put("AGENT_LOCATION", ProfileHelper.buildShortAddress((Address)address, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            data.put("AGENCY_CITY", address.getCity() != null ? address.getCity().toString() : null);
        }
        if ((vendor = (Organization)data.get("key-vendor")) != null) {
            String fullName;
            addresses = ProfileHelper.getOrganizationAddresses((Organization)vendor);
            if (addresses != null && addresses.iterator().hasNext()) {
                Address address = (Address)addresses.get(0);
                data.put("VENDOR_LOCATION", ProfileHelper.buildShortAddress((Address)address, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            }
            if (vendor.getKpp() != null) {
                data.put("VENDOR_KPP", vendor.getKpp());
            }
            if ((fullName = DictHelper.getShortLegalForm((DictionaryReference)vendor.getLegalForm(), null)) == null) {
                fullName = "";
            }
            fullName = fullName + (vendor.getFullName() != null ? " \"" + vendor.getFullName() + "\"" : "");
            data.put("VENDOR_NAME", fullName);
        }
        this.prepareContractData(data, (EntityContainer<Organization>)boc, messages);
    }

    protected void prepareContractData(Map<String, Object> data, EntityContainer<Organization> vendor, List<Message> messages) throws Exception {
        List indexes;
        if (vendor == null) {
            return;
        }
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        if (params == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_Internal_error", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("internal report handler error: in getAppropriateContracts(...) params is empty");
            return;
        }
        EntityReference agency = params.getAgency();
        if (agency == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_Internal_error", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("internal report handler error: in getAppropriateContracts(...) agency is empty");
            return;
        }
        EntityReference supplier = params.getSupplier();
        if (supplier == null) {
            supplier = vendor.toReference();
        }
        if (supplier == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_Internal_error", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("internal report handler error: in getAppropriateContracts(...) unable to define supplier");
            return;
        }
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.VENDOR), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)vendor.getUid()), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)supplier.getUid()), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)agency.getUid())}));
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        if (startDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)startDate)}));
        }
        if (endDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)endDate)}));
        }
        if ((indexes = es.search(ContractCustomerIndex.class, query).getData()).isEmpty()) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoContracts", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.debug("No contracts found for the report parameters");
            return;
        }
        Collections.sort(indexes, new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                return MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }
        });
        data.put("CONTRACT_NO", ((ContractCustomerIndex)indexes.get(0)).getNumber());
        data.put("CONTRACT_ISSUE_DATE", ((ContractCustomerIndex)indexes.get(0)).getIssueDate());
    }

    protected void putCreditBankTransferOrderInfo(Map<String, Object> data, List<Message> messages) {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        EntityReference blankOwner = params.getBlankOwner();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BasicPaymentDocumentIndex.Property.endOfVendorReportDecade.name(), (Object)MiscUtil.clearTime((Date)startDate)));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)BasicPaymentDocumentIndex.Property.endOfVendorReportDecade.name(), (Object)MiscUtil.setDayEndTime((Date)endDate)));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicPaymentDocumentIndex.Property.documentType.name(), (Object)PaymentDocumentType.CREDIT_BANK_TRANSFER_ORDER));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicPaymentDocumentIndex.Property.payer.name(), (Object)blankOwner));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicPaymentDocumentIndex.Property.organization.name(), (Object)params.getAgency()));
        query.getPreferredProperties().add(BasicPaymentDocumentIndex.Property.number.name());
        ArrayList<ReportCreditBankTransferOrderInfo> orders = new ArrayList<ReportCreditBankTransferOrderInfo>();
        for (BasicPaymentDocumentIndex idx : EntityStorage.get().search(BasicPaymentDocumentIndex.class, query).getData()) {
            CreditBankTransferOrder order = (CreditBankTransferOrder)EntityStorage.get().resolve(idx.getSource()).getEntity();
            ReportCreditBankTransferOrderInfo orderInfo = new ReportCreditBankTransferOrderInfo();
            orderInfo.setAmount(order.getTotalAmount() == null ? BigDecimal.ZERO : MiscUtil.guarded((BigDecimal)order.getTotalAmount().getValue()));
            orderInfo.setDate(order.getDate());
            orderInfo.setName(this.getCreditOrderName(order));
            orderInfo.setPaymentType(order.getVendorReportData().getPaymentType());
            orderInfo.setEndOfDecade(order.getVendorReportData().getEndOfDecade());
            orders.add(orderInfo);
        }
        data.put("key-bank-transfer-orders-list", orders);
    }

    protected String getCreditOrderName(CreditBankTransferOrder order) {
        return order.getName();
    }
}

