/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SalesReportPrepareHelper {
    public static SearchQuery createProductQuery(Date beginDate, Date endDate, String datePropertyName) {
        if (TextUtil.isBlank((String)datePropertyName)) {
            datePropertyName = ProductIndex.Property.issueDate.name();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        if (beginDate != null || endDate != null) {
            ArrayList<SearchCriterion> vendorCriterions = new ArrayList<SearchCriterion>();
            ArrayList<SearchCriterion> issueCriterions = new ArrayList<SearchCriterion>();
            issueCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.dateOfVendorPayment.name(), null));
            if (beginDate != null) {
                vendorCriterions.add(SearchCriterion.ge((String)ProductIndex.Property.dateOfVendorPayment.name(), (Object)MiscUtil.clearTime((Date)beginDate)));
                issueCriterions.add(SearchCriterion.ge((String)datePropertyName, (Object)MiscUtil.clearTime((Date)beginDate)));
            }
            if (endDate != null) {
                vendorCriterions.add(SearchCriterion.le((String)ProductIndex.Property.dateOfVendorPayment.name(), (Object)MiscUtil.setDayEndTime((Date)endDate)));
                issueCriterions.add(SearchCriterion.le((String)datePropertyName, (Object)MiscUtil.setDayEndTime((Date)endDate)));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{vendorCriterions.size() == 1 ? (SearchCriterion)vendorCriterions.get(0) : SearchCriterion.and((SearchCriterion[])vendorCriterions.toArray(new SearchCriterion[vendorCriterions.size()])), SearchCriterion.and((SearchCriterion[])issueCriterions.toArray(new SearchCriterion[issueCriterions.size()]))}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING), SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID_BOOKING)}));
        return query;
    }

    public static SearchQuery createQuery(ReportParameters params) {
        return SalesReportPrepareHelper.createQuery(params, false);
    }

    public static SearchQuery createQuery(ReportParameters params, boolean ignoreIssueDate) {
        return SalesReportPrepareHelper.createQuery(params, ignoreIssueDate, null);
    }

    public static SearchQuery createQuery(ReportParameters params, boolean ignoreIssueDate, String datePropertyName) {
        SearchQuery result = ignoreIssueDate ? new SearchQuery() : SalesReportPrepareHelper.createProductQuery(params.getPeriodBegin(), params.getPeriodEnd(), datePropertyName);
        result.getPreferredProperties().add(ProductIndex.Property.issueDate.name());
        if (params.getBlankOwner() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)params.getBlankOwner()));
            result.getPreferredProperties().add(ProductIndex.Property.blankOwner.name());
        }
        if (!params.getAdditionalCriterions().isEmpty()) {
            result.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        }
        if (params.getAgency() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), (Object)params.getAgency()));
            result.getPreferredProperties().add(ProductIndex.Property.agency.name());
        }
        if (params.getSalesPoint() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.salesPoint.name(), (Object)params.getSalesPoint()));
            result.getPreferredProperties().add(ProductIndex.Property.salesPoint.name());
        }
        if (params.getSubagency() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)params.getSubagency()));
            result.getPreferredProperties().add(ProductIndex.Property.subagency.name());
        }
        if (params.getSupplier() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.supplier.name(), (Object)params.getSupplier()));
            result.getPreferredProperties().add(ProductIndex.Property.supplier.name());
        }
        return result;
    }

    public static Set<Product> getProducts(SearchQuery query, List<Message> messages) throws Exception {
        HashMap<EntityReference, EntityContainer> loaded = new HashMap<EntityReference, EntityContainer>();
        HashSet<Product> result = new HashSet<Product>();
        EntityStorage es = EntityStorage.get();
        for (ProductIndex index : es.search(ProductIndex.class, query).getData()) {
            EntityContainer ctr = (EntityContainer)loaded.get(index.getSource());
            if (ctr == null) {
                ctr = es.resolve(index.getSource());
                loaded.put(index.getSource(), ctr);
            }
            block1: for (Reservation res : ((BookingFile)ctr.getEntity()).getReservations()) {
                for (BaseProduct prod : res.getProducts()) {
                    if (!(prod instanceof Product) || !index.getNavigationKey().equals(prod.getUid())) continue;
                    result.add((Product)prod);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Deprecated
    public static List<ProductIndex> selectProducts(Map<String, Object> data) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityStorage es = EntityStorage.get();
        SearchQuery query = SalesReportPrepareHelper.createProductQuery(params.getPeriodBegin(), params.getPeriodEnd(), null);
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        if (params.getBlankOwner() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)params.getBlankOwner()));
        }
        return es.search(ProductIndex.class, query).getData();
    }

    @Deprecated
    public static boolean isHasAppropriateReportAgency(ProductIndex index, EntityReference<Organization> agencyReference, Map<String, Object> data, List<Message> messages) throws Exception {
        String ticketNumber;
        if (agencyReference == null) {
            return true;
        }
        EntityReference indexAgencyRef = index.getAgency();
        if (indexAgencyRef != null) {
            return indexAgencyRef.equals(agencyReference);
        }
        String validatorCode = index.getValidatorCode();
        String string = ticketNumber = !index.getTicketNumbers().isEmpty() ? (String)index.getTicketNumbers().iterator().next() : "";
        if (TextUtil.isBlank((String)validatorCode)) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoAgencyValidator", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber});
            return false;
        }
        EntityContainer spc = EntityStorage.get().resolve(index.getSalesPoint());
        if (spc == null) {
            List spcs = ProfileDao.findSalesPointsByValidatorAndPCC((String)validatorCode, null, (Date)index.getIssueDate());
            if (spcs.isEmpty()) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoSalesPointsAgency", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber, validatorCode});
                return false;
            }
            if (spcs.size() > 1) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_FewSalesPointsAgency", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber, validatorCode});
                return false;
            }
            spc = (EntityContainer)spcs.get(0);
        }
        EntityReference aRef = null;
        SalesPoint salesPoint = (SalesPoint)spc.getEntity();
        for (Validator val : salesPoint.getValidators()) {
            if (!validatorCode.equals(val.getNumber())) continue;
            aRef = salesPoint.getAgency();
            break;
        }
        if (aRef == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoAgencyInValidator", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketNumber, validatorCode, salesPoint.getShortName()});
            return false;
        }
        return aRef.equals(agencyReference);
    }

    private SalesReportPrepareHelper() {
    }
}

