/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.bsp;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.LHBSPReportData;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.LHBSPReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.MoneyUtil;
import com.gridnine.xtrip.server.model.handlers.rules.TchRulesHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.BaseSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LHBSPSalesReportPrepareHandler
extends BaseSalesReportPrepareHandler<LHBSPReportTicket> {
    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        LHBSPReportTicket ticket = new LHBSPReportTicket(product, data);
        ProductStatus status = ticket.getStatus();
        if (status == null) {
            SystemHelper.addMessage(messages, (String)Messages.LHBSPSalesReportPrepareHandler_ticketNoState, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            return;
        }
        ArrayList<ReportBatchData> batchDataList = (ArrayList<ReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData>();
            ReportBatchData reportList = new ReportBatchData();
            reportList.setBatchId("Report");
            batchDataList.add(reportList);
            data.put("key-batch-data-list", batchDataList);
        }
        ((ReportBatchData)batchDataList.get(0)).getTickets().add(ticket);
        if (status == ProductStatus.VOID || ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.INFORMATION) {
            return;
        }
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        super.afterFillDataLists(data, messages);
        LHBSPReportData repData = (LHBSPReportData)data.get("KEY_LH_BSP_REPORT_DATA");
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal totalCommission = BigDecimal.ZERO;
        for (LHBSPReportTicket ticket : ((ReportBatchData)((List)data.get("key-batch-data-list")).get(0)).getTickets()) {
            total = total.add(ticket.getTotal());
            totalCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalCommission, ticket.getCommissionValue()});
        }
        Locale loc = new Locale("ru");
        String currency = "RUB";
        repData.setTotalCommissionStr(MoneyUtil.money2str((Locale)loc, (String)currency, (double)totalCommission.doubleValue(), (boolean)true));
        repData.setTotalStr(MoneyUtil.money2str((Locale)loc, (String)currency, (double)total.doubleValue(), (boolean)true));
    }

    @Override
    public String getId() {
        return "lh-bsp-sales-report";
    }

    @Override
    protected Set<Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        SearchQuery query;
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityContainer ctr = EntityStorage.get().resolve(params.getBlankOwner());
        EntityReference bspRef = null;
        if (ctr != null) {
            if ("BSP".equals(((Organization)ctr.getEntity()).getCode())) {
                bspRef = ctr.toReference();
            }
            if (bspRef == null && ((Organization)ctr.getEntity()).getAirline() != null && "BSP".equals(((Organization)ctr.getEntity()).getAirline().getCode())) {
                bspRef = ctr.toReference();
            }
        }
        if (bspRef == null) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)"BSP"), SearchCriterion.eq((String)OrganizationIndex.Property.airline.name(), (Object)new AirlineReference("BSP"))}));
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
            List list = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            if (list.isEmpty()) {
                SystemHelper.addMessage(messages, (String)Messages.LHBSPSalesReportPrepareHandler_noProfileInBD, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                return Collections.emptySet();
            }
            if (list.size() != 1) {
                SystemHelper.addMessage(messages, (String)Messages.LHBSPSalesReportPrepareHandler_fewProfileInBD, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                return Collections.emptySet();
            }
            bspRef = ((OrganizationIndex)list.get(0)).getSource();
        }
        params.setBlankOwner(bspRef);
        query = SalesReportPrepareHelper.createQuery(params);
        this.addCarrierRestriction(query);
        Set<Product> products = SalesReportPrepareHelper.getProducts(query, messages);
        if (products.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
        }
        for (Product prod : products) {
            TchRulesHelper.correctFops((Product)prod);
        }
        return products;
    }

    protected void addCarrierRestriction(SearchQuery query) {
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.carrier.name(), (Object)new AirlineReference("LH")));
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return null;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        super.putGlobalData(data, messages);
        EntityContainer ctr = EntityStorage.get().resolve(params.getTemplate());
        if (ctr == null || ((TemplateDocument)ctr.getEntity()).getContent() == null) {
            this.addNoTemplateMessage(messages);
            return;
        }
        data.put("KEY_TEMPLATE_DATA", ((TemplateDocument)ctr.getEntity()).getContent());
        LHBSPReportData repData = new LHBSPReportData();
        data.put("KEY_LH_BSP_REPORT_DATA", repData);
        repData.setAgencyDirectorName((String)data.get("AGENCY_DIRECTOR"));
        repData.setAgencyName((String)data.get("AGENCY_NAME"));
        repData.setAgentName((String)data.get("AGENT_NAME"));
        Date contractIssueDate = (Date)data.get("CONTRACT_ISSUE_DATE");
        repData.setContractIssueDateStr(this.formatDate(contractIssueDate));
        repData.setCurrentDateStr(this.formatDate(this.getCurrentDate()));
        if (params.getPeriodBegin() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(params.getPeriodBegin());
            repData.setReportYear(Integer.toString(cal.get(1)));
            repData.setReportMonth(this.getMonthName(cal.get(2), false));
        }
        repData.setReportPeriodStr(String.format("\u0441 %s \u043f\u043e %s", this.formatDate(params.getPeriodBegin()), this.formatDate(params.getPeriodEnd())));
    }

    protected Date getCurrentDate() {
        return new Date();
    }

    protected void addNoTemplateMessage(List<Message> messages) {
        SystemHelper.addMessage(messages, (String)Messages.LHBSPSalesReportPrepareHandler_onTemplateReport, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "???";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String day = new DecimalFormat("00").format(cal.get(5));
        String monthName = this.getMonthName(cal.get(2), true);
        String year = Integer.toString(cal.get(1));
        return String.format("\"%s\" %s %s\u0433.", day, monthName, year);
    }

    private String getMonthName(int monthIndex, boolean mod) {
        switch (monthIndex) {
            case 0: {
                return mod ? "\u044f\u043d\u0432\u0430\u0440\u044f" : "\u044f\u043d\u0432\u0430\u0440\u044c";
            }
            case 1: {
                return mod ? "\u0444\u0435\u0432\u0440\u0430\u043b\u044f" : "\u0444\u0435\u0432\u0440\u0430\u043b\u044c";
            }
            case 2: {
                return mod ? "\u043c\u0430\u0440\u0442\u0430" : "\u043c\u0430\u0440\u0442";
            }
            case 3: {
                return mod ? "\u0430\u043f\u0440\u0435\u043b\u044f" : "\u0430\u043f\u0440\u0435\u043b\u044c";
            }
            case 4: {
                return mod ? "\u043c\u0430\u044f" : "\u043c\u0430\u0439";
            }
            case 5: {
                return mod ? "\u0438\u044e\u043d\u044f" : "\u0438\u044e\u043d\u044c";
            }
            case 6: {
                return mod ? "\u0438\u044e\u043b\u044f" : "\u0438\u044e\u043b\u044c";
            }
            case 7: {
                return mod ? "\u0430\u0432\u0433\u0443\u0441\u0442\u0430" : "\u0430\u0432\u0433\u0443\u0441\u0442";
            }
            case 8: {
                return mod ? "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f" : "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c";
            }
            case 9: {
                return mod ? "\u043e\u043a\u0442\u044f\u0431\u0440\u044f" : "\u043e\u043a\u0442\u044f\u0431\u0440\u044c";
            }
            case 10: {
                return mod ? "\u043d\u043e\u044f\u0431\u0440\u044f" : "\u043d\u043e\u044f\u0431\u0440\u044c";
            }
        }
        return mod ? "\u0434\u0435\u043a\u0430\u0431\u0440\u044f" : "\u0434\u0435\u043a\u0430\u0431\u0440\u044c";
    }
}

