/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.bsp;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.UNBSPReportData;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.UNBSPReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.handlers.rules.TchRulesHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.BaseSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UNBSPSalesReportPrepareHandler
extends BaseSalesReportPrepareHandler<TchTicket> {
    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        UNBSPReportTicket ticket = new UNBSPReportTicket(product, data);
        ProductStatus status = ticket.getStatus();
        if (status == null) {
            SystemHelper.addMessage(messages, (String)Messages.AgentReportAirPrepareHandler_ticketCantLoadCommittee, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            return;
        }
        ArrayList<ReportBatchData> batchDataList = (ArrayList<ReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData>();
            ReportBatchData mvlSellRegistryList = new ReportBatchData();
            mvlSellRegistryList.setBatchId("RegistrySellMVL");
            batchDataList.add(mvlSellRegistryList);
            ReportBatchData mvlRefundRegistryList = new ReportBatchData();
            mvlRefundRegistryList.setBatchId("RegistryRefundMVL");
            batchDataList.add(mvlRefundRegistryList);
            ReportBatchData vvlSellRegistryList = new ReportBatchData();
            vvlSellRegistryList.setBatchId("RegistrySellVVL");
            batchDataList.add(vvlSellRegistryList);
            ReportBatchData vvlRefundRegistryList = new ReportBatchData();
            vvlRefundRegistryList.setBatchId("RegistryRefundVVL");
            batchDataList.add(vvlRefundRegistryList);
            data.put("key-batch-data-list", batchDataList);
        }
        for (ReportBatchData lst : batchDataList) {
            if ("RegistrySellMVL".equals(lst.getBatchId()) && !ticket.isVatIncluded() && ticket.getStatus() != ProductStatus.REFUND) {
                lst.getTickets().add(ticket);
            }
            if ("RegistryRefundMVL".equals(lst.getBatchId()) && !ticket.isVatIncluded() && ticket.getStatus() == ProductStatus.REFUND) {
                lst.getTickets().add(ticket);
            }
            if ("RegistrySellVVL".equals(lst.getBatchId()) && ticket.isVatIncluded() && ticket.getStatus() != ProductStatus.REFUND) {
                lst.getTickets().add(ticket);
            }
            if (!"RegistryRefundVVL".equals(lst.getBatchId()) || !ticket.isVatIncluded() || ticket.getStatus() != ProductStatus.REFUND) continue;
            lst.getTickets().add(ticket);
        }
        if (status == ProductStatus.VOID || ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.INFORMATION) {
            return;
        }
        UNBSPReportData repData = (UNBSPReportData)data.get("KEY_UN_BSP_REPORT_DATA");
        this.updateReportData(repData, ticket.getStatus(), ticket.isVatIncluded(), PaymentType.CASH, ticket.getFareCash(), ticket.getTaxCA(), ticket.getPenaltyCA(), ticket.getCommissionCA());
        this.updateReportData(repData, ticket.getStatus(), ticket.isVatIncluded(), PaymentType.CREDIT_CARD, ticket.getFareCC(), ticket.getTaxCC(), ticket.getPenaltyCC(), BigDecimal.ZERO);
    }

    private void updateReportData(UNBSPReportData repData, ProductStatus status, boolean vatIncluded, PaymentType paymentType, BigDecimal fare, BigDecimal tax, BigDecimal penalty, BigDecimal commission) {
        if (BigDecimal.ZERO.compareTo(fare) == 0 && BigDecimal.ZERO.compareTo(tax) == 0 && BigDecimal.ZERO.compareTo(penalty) == 0 && BigDecimal.ZERO.compareTo(commission) == 0) {
            return;
        }
        UNBSPReportData.UNBSPSubBatchKey key = new UNBSPReportData.UNBSPSubBatchKey();
        key.setMvl(!vatIncluded);
        key.setPaymentType(paymentType);
        key.setRefund(status == ProductStatus.REFUND);
        UNBSPReportData.UNBSPSubBatchData batchData = (UNBSPReportData.UNBSPSubBatchData)repData.getBatches().get(key);
        if (batchData == null) {
            batchData = new UNBSPReportData.UNBSPSubBatchData();
            repData.getBatches().put(key, batchData);
        }
        batchData.setPenalty(status == ProductStatus.EXCHANGE ? batchData.getPenalty().subtract(penalty) : batchData.getPenalty().add(penalty));
        batchData.setFare(status == ProductStatus.EXCHANGE ? batchData.getFare().subtract(fare) : batchData.getFare().add(fare));
        batchData.setTax(status == ProductStatus.EXCHANGE ? batchData.getTax().subtract(tax) : batchData.getTax().add(tax));
        batchData.setCommission(status == ProductStatus.EXCHANGE ? batchData.getCommission().subtract(commission) : batchData.getCommission().add(commission));
    }

    @Override
    public String getId() {
        return "un-bsp-sales-report";
    }

    @Override
    protected Set<Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        SearchQuery query;
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityContainer ctr = EntityStorage.get().resolve(params.getBlankOwner());
        EntityReference bspRef = null;
        if (ctr != null) {
            if ("BSP".equals(((Organization)ctr.getEntity()).getCode())) {
                bspRef = ctr.toReference();
            }
            if (bspRef == null && ((Organization)ctr.getEntity()).getAirline() != null && "BSP".equals(((Organization)ctr.getEntity()).getAirline().getCode())) {
                bspRef = ctr.toReference();
            }
        }
        if (bspRef == null) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)"BSP"), SearchCriterion.eq((String)OrganizationIndex.Property.airline.name(), (Object)new AirlineReference("BSP"))}));
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
            List list = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            if (list.isEmpty()) {
                SystemHelper.addMessage(messages, (String)Messages.LHBSPSalesReportPrepareHandler_noProfileInBD, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                return Collections.emptySet();
            }
            if (list.size() != 1) {
                SystemHelper.addMessage(messages, (String)Messages.LHBSPSalesReportPrepareHandler_fewProfileInBD, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                return Collections.emptySet();
            }
            bspRef = ((OrganizationIndex)list.get(0)).getSource();
        }
        params.setBlankOwner(bspRef);
        query = SalesReportPrepareHelper.createQuery(params);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.carrier.name(), (Object)new AirlineReference("UN")));
        Set<Product> products = SalesReportPrepareHelper.getProducts(query, messages);
        if (products.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
        }
        for (Product prod : products) {
            TchRulesHelper.correctFops((Product)prod);
        }
        return products;
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_UN_AGENCY_CODE;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        super.putGlobalData(data, messages);
        EntityContainer ctr = EntityStorage.get().resolve(params.getTemplate());
        if (ctr == null || ((TemplateDocument)ctr.getEntity()).getContent() == null) {
            SystemHelper.addMessage(messages, (String)Messages.UNBSPSalesReportPrepareHandler_templateReportTransair, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        data.put("KEY_TEMPLATE_DATA", ((TemplateDocument)ctr.getEntity()).getContent());
        UNBSPReportData repData = new UNBSPReportData();
        data.put("KEY_UN_BSP_REPORT_DATA", repData);
        repData.setAgencyAccounantName((String)data.get("AGENCY_ACCOUNTANT"));
        repData.setAgencyDirectorName((String)data.get("AGENCY_DIRECTOR"));
        repData.setAgencyName((String)data.get("AGENCY_NAME"));
        repData.setAgencyPhone((String)data.get("AGENCY_PHONE"));
        repData.setAgentName((String)data.get("AGENT_NAME"));
        repData.setContractNumber((String)data.get("CONTRACT_NO"));
        Date contractIssueDate = (Date)data.get("CONTRACT_ISSUE_DATE");
        repData.setContractIssueDateStr(this.formatDate(contractIssueDate));
        String startDateStr = "???";
        DecimalFormat df = new DecimalFormat("00");
        if (params.getPeriodBegin() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(params.getPeriodBegin());
            startDateStr = df.format(cal.get(5));
        }
        String endDateStr = this.formatDate(params.getPeriodEnd());
        repData.setReportPeriodStr(String.format("\u0441 %s \u043f\u043e %s.", startDateStr, endDateStr));
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "???";
        }
        return new SimpleDateFormat("dd'.'MM'.'yyyy'\u0433'").format(date);
    }
}

