/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.ccc;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.OBFee;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocumentIndex;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.ComparisonResult;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.DivergenceSegmentsReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.rules.TchRulesHelper;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.tch.TchSalesReportPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCCFilesDivergenceReportPrepareHandler
implements ReportPrepareHandler {
    private static final Locale ruLocale = new Locale("RU");
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        data.put("key-messages", messages);
        this.checkReportParameters(data, messages);
        if (this.isHasErrors(messages)) {
            return;
        }
        this.putGlobalData(data);
        List<List<DivergenceSegmentsReportTicket>> filteredData = this.getData(data, messages);
        if (this.isHasErrors(messages)) {
            return;
        }
        int i = 1;
        for (List<DivergenceSegmentsReportTicket> list : filteredData) {
            for (DivergenceSegmentsReportTicket ticket : list) {
                ticket.setItemNum(i);
                this.addTicketToReportData(ticket, data, messages);
            }
            ++i;
        }
        if (filteredData.isEmpty()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.reportNoTicket, (Object[])new Object[0]));
            data.put("DIVERGENCE_REPORT_NOT_FOUND", Boolean.TRUE);
        }
    }

    private void putGlobalData(Map<String, Object> data) throws Exception {
        BaseReportParameters params = (BaseReportParameters)data.get("key-report-params");
        BaseReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, null);
        BaseReportPrepareHandler.putStandardAgencyData((EntityReference<Organization>)params.getAgency(), data, null);
        EntityContainer ctr = EntityStorage.get().resolve(params.getAgency());
        if (ctr != null) {
            Organization agency = (Organization)ctr.getEntity();
            data.put("key-tch-agency-code", SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE));
        }
    }

    public List<List<DivergenceSegmentsReportTicket>> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        List<Object> tickets;
        List<Product> productSet = this.getProductData(data, messages);
        List<CCCExchangeDocument> cccFilesSet = this.getCCCFilesData(data, messages);
        ArrayList<List<DivergenceSegmentsReportTicket>> divergenceList = new ArrayList<List<DivergenceSegmentsReportTicket>>();
        LinkedHashMap<String, Product> productMap = new LinkedHashMap<String, Product>();
        for (Product product : productSet) {
            productMap.put(this.getKey(product), product);
        }
        ArrayList cccFilesPackageSet = new ArrayList();
        String lastKey = null;
        ArrayList<CCCExchangeDocument> nextCCCFilesPackage = null;
        for (CCCExchangeDocument cCCExchangeDocument : cccFilesSet) {
            String currKey = this.getKey(cCCExchangeDocument);
            if (!currKey.equals(lastKey)) {
                nextCCCFilesPackage = new ArrayList<CCCExchangeDocument>();
                cccFilesPackageSet.add(nextCCCFilesPackage);
                lastKey = currKey;
            }
            if (nextCCCFilesPackage == null) {
                this.log.error("internal error: nextCCCFilesPackage is null");
                SystemHelper.addMessage(messages, (String)Messages.CCCFilesDivergenceReportPrepareHandler_internalError, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                continue;
            }
            nextCCCFilesPackage.add(cCCExchangeDocument);
        }
        for (List list : cccFilesPackageSet) {
            Product product = (Product)productMap.remove(this.getKey((CCCExchangeDocument)list.get(0)));
            Collections.sort(list, new Comparator<CCCExchangeDocument>(){

                @Override
                public int compare(CCCExchangeDocument o1, CCCExchangeDocument o2) {
                    return TextUtil.compare((String)o1.getTransferSegment(), (String)o2.getTransferSegment(), (boolean)false, (boolean)true);
                }
            });
            if (product != null) {
                tickets = this.compareTicketAndCCC(product, list, messages);
                if (tickets.isEmpty()) continue;
                divergenceList.add(tickets);
                this.validateProductToReport(product, data, messages);
                continue;
            }
            tickets = new ArrayList();
            for (CCCExchangeDocument doc : list) {
                DivergenceSegmentsReportTicket cccTicket = new DivergenceSegmentsReportTicket(doc, null, messages);
                tickets.add(cccTicket);
            }
            if (tickets.isEmpty()) continue;
            divergenceList.add(tickets);
        }
        for (Product product : productMap.values()) {
            DivergenceSegmentsReportTicket abcTicket = new DivergenceSegmentsReportTicket(product, messages);
            tickets = new ArrayList<DivergenceSegmentsReportTicket>();
            tickets.add(abcTicket);
            divergenceList.add(tickets);
            this.validateProductToReport(product, data, messages);
        }
        return divergenceList;
    }

    private String getKey(Product product) {
        String status = null;
        if (product.getStatus() != null) {
            switch (product.getStatus()) {
                case REFUND: {
                    status = ProductStatus.REFUND.name();
                    break;
                }
                case EXCHANGE: {
                    status = ProductStatus.EXCHANGE.name();
                    break;
                }
                case VOID: 
                case VOID_BOOKING: {
                    if (product.getMcoCategory() == MCOCategory.INFORMATION) {
                        status = ProductStatus.SELL.name();
                        break;
                    }
                    status = ProductStatus.VOID.name();
                    break;
                }
                case SELL: 
                case BOOKING: {
                    status = ProductStatus.SELL.name();
                }
            }
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = status;
        objectArray[1] = product.getUid().startsWith("TCH_VIRTUAL:") ? (product.getCarrier() != null ? product.getCarrier().getCode() : null) : null;
        objectArray[2] = product.getSystemNumber();
        return String.format("%s_%s_%s", objectArray);
    }

    private String getKey(CCCExchangeDocument doc) {
        Airline airline;
        String status = null;
        if (doc.getTransaction() != null) {
            switch (doc.getTransaction()) {
                case REFUND: {
                    status = ProductStatus.REFUND.name();
                    break;
                }
                case EXCHANGE: {
                    status = ProductStatus.EXCHANGE.name();
                    break;
                }
                case CANCEL: {
                    status = ProductStatus.VOID.name();
                    break;
                }
                default: {
                    status = ProductStatus.SELL.name();
                }
            }
        }
        String carrier = null;
        if (("99A".equalsIgnoreCase(doc.getValidatingCarrierNumber()) || "99\u0410".equalsIgnoreCase(doc.getValidatingCarrierNumber())) && (airline = DictHelper.findAirlineByAnyCode((String)doc.getSegmentCarrierCode(), (Date)doc.getIssued())) != null) {
            carrier = airline.getCode();
        }
        return String.format("%s_%s_%s", status, carrier, doc.getTicketNumber());
    }

    private void addTicketToReportData(DivergenceSegmentsReportTicket ticket, Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<ReportBatchData<DivergenceSegmentsReportTicket>> batchDataList = (ArrayList<ReportBatchData<DivergenceSegmentsReportTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData<DivergenceSegmentsReportTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        ReportBatchData<DivergenceSegmentsReportTicket> batch = this.selectBatch("CCC", batchDataList);
        batch.getTickets().add(ticket);
    }

    private ReportBatchData<DivergenceSegmentsReportTicket> selectBatch(String batchId, List<ReportBatchData<DivergenceSegmentsReportTicket>> batchList) {
        for (ReportBatchData<DivergenceSegmentsReportTicket> batch : batchList) {
            if (!batch.getBatchId().equals(batchId)) continue;
            return batch;
        }
        ReportBatchData batch = new ReportBatchData();
        batch.setBatchId(batchId);
        batchList.add((ReportBatchData<DivergenceSegmentsReportTicket>)batch);
        return batch;
    }

    private List<DivergenceSegmentsReportTicket> compareTicketAndCCC(Product product, List<CCCExchangeDocument> cccFilesPackage, List<Message> messages) throws Exception {
        DivergenceSegmentsReportTicket abcTicket = null;
        DivergenceSegmentsReportTicket cccTicket = null;
        HashMap<String, CCCExchangeDocument> cccFilesMap = new HashMap<String, CCCExchangeDocument>();
        for (CCCExchangeDocument doc : cccFilesPackage) {
            cccFilesMap.put(doc.getTransferSegment(), doc);
        }
        ComparisonResult comparisonResult = this.compare(product, cccFilesPackage, messages);
        if (comparisonResult.isEquals()) {
            return Collections.emptyList();
        }
        ArrayList<DivergenceSegmentsReportTicket> result = new ArrayList<DivergenceSegmentsReportTicket>();
        if (product.getProductCategory() == ProductCategory.MCO && product.getMcoCategory() == MCOCategory.PENALTY || product.getProductCategory() == ProductCategory.MCO && product.getMcoCategory() == MCOCategory.REBOOKING || product.getProductCategory() == ProductCategory.MCO && product.getMcoCategory() == MCOCategory.INFORMATION || product.getProductCategory() == ProductCategory.EXCESS_BAGAGE) {
            CCCExchangeDocument doc = (CCCExchangeDocument)cccFilesMap.remove("1");
            if (doc != null) {
                result.add(new DivergenceSegmentsReportTicket(product, null, doc, comparisonResult, false, messages));
                result.add(new DivergenceSegmentsReportTicket(doc, comparisonResult, messages));
            } else {
                abcTicket = new DivergenceSegmentsReportTicket(product, null, null, null, false, messages);
                result.add(abcTicket);
            }
        } else {
            for (int n = 0; n < product.getSegmentTariffs().size(); ++n) {
                SegmentTariff st = (SegmentTariff)product.getSegmentTariffs().get(n);
                for (int m = 0; m < st.getSegments().size(); ++m) {
                    Segment seg = (Segment)st.getSegments().get(m);
                    CCCExchangeDocument doc = (CCCExchangeDocument)cccFilesMap.remove(seg.getRecordNumber() + "");
                    if (doc != null) {
                        result.add(new DivergenceSegmentsReportTicket(product, seg, doc, comparisonResult, n != 0 || m != 0, messages));
                        result.add(new DivergenceSegmentsReportTicket(doc, comparisonResult, messages));
                        continue;
                    }
                    abcTicket = new DivergenceSegmentsReportTicket(product, seg, null, null, n != 0 || m != 0, messages);
                    result.add(abcTicket);
                }
            }
        }
        for (CCCExchangeDocument doc : cccFilesMap.values()) {
            cccTicket = new DivergenceSegmentsReportTicket(doc, null, messages);
            result.add(cccTicket);
        }
        Collections.sort(result, new Comparator<DivergenceSegmentsReportTicket>(){

            @Override
            public int compare(DivergenceSegmentsReportTicket o1, DivergenceSegmentsReportTicket o2) {
                int res = TextUtil.compare((String)o1.getTicketNumber(), (String)o2.getTicketNumber(), (boolean)false, (boolean)false);
                if (res != 0) {
                    return res;
                }
                if (!TextUtil.isSame((String)o1.getDatacode(), (String)o2.getDatacode())) {
                    return DivergenceSegmentsReportTicket.cccDataCode.equals(o1.getDatacode()) ? -1 : 1;
                }
                if (("99A".equalsIgnoreCase(o1.getValidatingAirlineNumber()) || "99\u0410".equalsIgnoreCase(o1.getValidatingAirlineNumber())) && (res = TextUtil.compare((String)o1.getSegmentAirlineCode(), (String)o2.getSegmentAirlineCode(), (boolean)false, (boolean)false)) != 0) {
                    return res;
                }
                return TextUtil.compare((String)o1.getTransferNum(), (String)o2.getTransferNum(), (boolean)false, (boolean)false);
            }
        });
        return result;
    }

    private ComparisonResult compare(Product product, List<CCCExchangeDocument> cccFilesPackage, List<Message> messages) {
        ComparisonResult result = new ComparisonResult();
        if (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING) {
            return result;
        }
        if (product.getProductCategory() == ProductCategory.AIR || product.getProductCategory() == ProductCategory.MCO && product.getMcoCategory() == MCOCategory.PTA) {
            result.setDiffersInSegmentCarriers(!this.equalsBySegmentCarriers(product, cccFilesPackage));
        }
        if (product.getProductCategory() != ProductCategory.MCO || product.getMcoCategory() != MCOCategory.INFORMATION) {
            result.setDiffersInValidatingCarrier(!this.equalsByValidatingCarrier(product, cccFilesPackage));
            result.setDiffersInEquivalentFare(!this.equalsByEquivalentFare(product, cccFilesPackage));
            result.setDiffersInAgsTax(!this.equalsByAgsTax(product, cccFilesPackage));
            result.setDiffersInTchTax(!this.equalsByTchTax(product, cccFilesPackage));
            result.setDiffersInPenalty(!this.equalsByPenalty(product, cccFilesPackage));
            result.setDiffersInCommission(!this.equalsByCommission(product, cccFilesPackage));
            result.setDiffersInPaymentType(!this.equalsByPaymentType(product, cccFilesPackage));
        }
        return result;
    }

    private boolean equalsByCommission(Product product, List<CCCExchangeDocument> cccFilesPackage) {
        BigDecimal prodValue = DivergenceSegmentsReportTicket.calculate((Product)product, (DivergenceSegmentsReportTicket.CCCCalculateCallback)new DivergenceSegmentsReportTicket.CCCCalculateCallback(){

            public BigDecimal calculate(Product prod) {
                try {
                    return AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)prod, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionPropertyTypes, null, null));
                }
                catch (Exception e) {
                    CCCFilesDivergenceReportPrepareHandler.this.log.error(String.format("unable to calculate commission: product = %s", prod.getSystemNumber()), (Throwable)e);
                    return null;
                }
            }
        });
        if (prodValue == null) {
            prodValue = BigDecimal.ZERO;
        }
        BigDecimal docValue = BigDecimal.ZERO;
        for (CCCExchangeDocument doc : cccFilesPackage) {
            if (doc.getCommissionValue() == null) continue;
            docValue = docValue.add(doc.getCommissionValue());
        }
        return Math.abs(docValue.subtract(prodValue).doubleValue()) < 0.01;
    }

    private boolean equalsByPenalty(Product product, List<CCCExchangeDocument> cccFilesPackage) {
        BigDecimal prodValue = null;
        if (product.getProductCategory() == ProductCategory.MCO && (product.getMcoCategory() == MCOCategory.PENALTY || product.getMcoCategory() == MCOCategory.REBOOKING)) {
            prodValue = AirProductHelper.getEquivalentFare((Product)product);
        } else if (product.getPenalty() != null) {
            boolean hasRelatedMco = false;
            for (Product prod : AirProductHelper.getMcoByRelatedProduct((Product)product)) {
                if (prod.getMcoCategory() != MCOCategory.PENALTY) continue;
                hasRelatedMco = true;
                break;
            }
            if (!hasRelatedMco) {
                prodValue = product.getPenalty();
            }
        }
        if (prodValue == null) {
            prodValue = BigDecimal.ZERO;
        }
        BigDecimal docValue = BigDecimal.ZERO;
        for (CCCExchangeDocument doc : cccFilesPackage) {
            if (doc.getPenalty() == null) continue;
            docValue = docValue.add(doc.getPenalty());
        }
        return Math.abs(docValue.subtract(prodValue).doubleValue()) < 0.001;
    }

    private boolean equalsByPaymentType(Product product, List<CCCExchangeDocument> cccFilesPackage) {
        PaymentType prodValue = null;
        for (ProductFop fop : AirProductHelper.getVendorFops((Product)product)) {
            if (fop.getType() == PaymentType.CREDIT_CARD) {
                prodValue = PaymentType.CREDIT_CARD;
                break;
            }
            if (fop.getType() != PaymentType.CREDIT_CARD_TCH) continue;
            prodValue = PaymentType.CREDIT_CARD_TCH;
            break;
        }
        if (prodValue == null) {
            prodValue = PaymentType.CASH;
        }
        PaymentType docValue = null;
        for (CCCExchangeDocument doc : cccFilesPackage) {
            if (doc.getPaymentType() == PaymentType.CREDIT_CARD) {
                docValue = PaymentType.CREDIT_CARD;
                break;
            }
            if (doc.getPaymentType() != PaymentType.CREDIT_CARD_TCH) continue;
            docValue = PaymentType.CREDIT_CARD_TCH;
            break;
        }
        if (docValue == null) {
            docValue = PaymentType.CASH;
        }
        return docValue == prodValue;
    }

    private boolean equalsByTchTax(Product product, List<CCCExchangeDocument> cccFilesPackage) {
        BigDecimal prodValue = DivergenceSegmentsReportTicket.calculate((Product)product, (DivergenceSegmentsReportTicket.CCCCalculateCallback)new DivergenceSegmentsReportTicket.CCCCalculateCallback(){

            public BigDecimal calculate(Product prod) {
                return AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)prod);
            }
        });
        BigDecimal docValue = BigDecimal.ZERO;
        for (CCCExchangeDocument doc : cccFilesPackage) {
            if (doc.getTchTax() == null) continue;
            docValue = docValue.add(doc.getTchTax());
        }
        return Math.abs(docValue.subtract(prodValue).doubleValue()) < 0.001;
    }

    private boolean equalsByAgsTax(Product product, List<CCCExchangeDocument> cccFilesPackage) {
        BigDecimal prodValue = DivergenceSegmentsReportTicket.calculate((Product)product, (DivergenceSegmentsReportTicket.CCCCalculateCallback)new DivergenceSegmentsReportTicket.CCCCalculateCallback(){

            public BigDecimal calculate(Product prod) {
                BigDecimal result = AirProductTaxHelper.getEquivalentTaxesAmount((Product)prod).subtract(AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)prod));
                for (OBFee obFee : prod.getObFees()) {
                    if (obFee.getAmount() == null) continue;
                    result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, obFee.getAmount().getValue()});
                }
                return result;
            }
        });
        BigDecimal docValue = BigDecimal.ZERO;
        for (CCCExchangeDocument doc : cccFilesPackage) {
            if (doc.getAgsTax() == null) continue;
            docValue = docValue.add(doc.getAgsTax());
        }
        return Math.abs(docValue.subtract(prodValue).doubleValue()) < 0.001;
    }

    private boolean equalsByEquivalentFare(Product product, List<CCCExchangeDocument> cccFilesPackage) {
        BigDecimal prodValue = null;
        prodValue = product.getMcoCategory() == MCOCategory.PENALTY || product.getMcoCategory() == MCOCategory.REBOOKING ? BigDecimal.ZERO : DivergenceSegmentsReportTicket.calculate((Product)product, (DivergenceSegmentsReportTicket.CCCCalculateCallback)new DivergenceSegmentsReportTicket.CCCCalculateCallback(){

            public BigDecimal calculate(Product prod) {
                return AirProductHelper.getEquivalentFare((Product)prod);
            }
        });
        if (prodValue == null) {
            prodValue = BigDecimal.ZERO;
        }
        BigDecimal docValue = BigDecimal.ZERO;
        for (CCCExchangeDocument doc : cccFilesPackage) {
            if (doc.getEquivalentFare() == null) continue;
            docValue = docValue.add(doc.getEquivalentFare());
        }
        return Math.abs(docValue.subtract(prodValue).doubleValue()) < 0.001;
    }

    private boolean equalsBySegmentCarriers(Product product, List<CCCExchangeDocument> cccFilesPackage) {
        HashSet<String> docValues = new HashSet<String>();
        for (CCCExchangeDocument doc : cccFilesPackage) {
            if (doc.getSegmentCarrierCode() == null) {
                return false;
            }
            Airline airline = DictHelper.findAirlineByAnyCode((String)doc.getSegmentCarrierCode(), (Date)product.getIssueDate());
            docValues.add(airline != null ? airline.getCode().toUpperCase(ruLocale) : doc.getSegmentCarrierCode().trim().toUpperCase(ruLocale));
        }
        HashSet<String> prodValues = new HashSet<String>();
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (seg.getAirline() == null) {
                    return false;
                }
                prodValues.add(seg.getAirline().getCode().toUpperCase(ruLocale));
            }
        }
        return CollectionUtil.equals(docValues, prodValues, (boolean)true);
    }

    private boolean equalsByValidatingCarrier(Product product, List<CCCExchangeDocument> cccFilesPackage) {
        if (product.getCarrierNumber() == null) {
            return false;
        }
        HashSet<String> docValues = new HashSet<String>();
        for (CCCExchangeDocument doc : cccFilesPackage) {
            if (doc.getValidatingCarrierNumber() == null) {
                return false;
            }
            docValues.add(doc.getValidatingCarrierNumber().trim().toLowerCase(ruLocale));
        }
        return CollectionUtil.equals(Collections.singleton(product.getCarrierNumber().trim().toLowerCase(ruLocale)), docValues, (boolean)true);
    }

    public List<CCCExchangeDocument> getCCCFilesData(Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<CCCExchangeDocument> result = new ArrayList<CCCExchangeDocument>();
        DivergenceReportParameters params = (DivergenceReportParameters)data.get("key-report-params");
        EntityReference agencyReference = params.getAgency();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CCCExchangeDocumentIndex.Property.issued.name(), (Object)MiscUtil.clearTime((Date)params.getPeriodBegin())), SearchCriterion.le((String)CCCExchangeDocumentIndex.Property.issued.name(), (Object)MiscUtil.setDayEndTime((Date)params.getPeriodEnd()))}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CCCExchangeDocumentIndex.Property.agency.name(), (Object)agencyReference));
        if (params.getSupplier() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CCCExchangeDocumentIndex.Property.supplier.name(), (Object)params.getSupplier()));
        }
        List cccs = es.search(CCCExchangeDocumentIndex.class, query).getData();
        for (CCCExchangeDocumentIndex index : cccs) {
            EntityReference docRef = index.getSource();
            EntityContainer docContainer = es.resolve(docRef);
            if (docContainer == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{docRef});
                this.log.debug("Unable to load ccc file container " + docRef.getUid() + ". All of the ccc files will be excluded from report.");
                return Collections.emptyList();
            }
            CCCExchangeDocument doc = (CCCExchangeDocument)docContainer.getEntity();
            result.add(doc);
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"\u0412 \u043e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u043e\u043f\u0430\u043b\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e ccc \u0444\u0430\u0439\u043b\u0430", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("There are no ccc files in the report");
        }
        Collections.sort(result, new Comparator<CCCExchangeDocument>(){

            @Override
            public int compare(CCCExchangeDocument o1, CCCExchangeDocument o2) {
                int res;
                if (o1.getTransaction() != o2.getTransaction()) {
                    return (o1.getTransaction() != null ? o1.getTransaction().ordinal() : 0) - (o2.getTransaction() != null ? o2.getTransaction().ordinal() : 0);
                }
                if (("99A".equalsIgnoreCase(o1.getValidatingCarrierNumber()) || "99\u0410".equalsIgnoreCase(o1.getValidatingCarrierNumber())) && (res = TextUtil.compare((String)o1.getSegmentCarrierCode(), (String)o2.getSegmentCarrierCode(), (boolean)false, (boolean)false)) != 0) {
                    return res;
                }
                return TextUtil.compare((String)o1.getTicketNumber(), (String)o2.getTicketNumber(), (boolean)false, (boolean)true);
            }
        });
        return result;
    }

    public List<Product> getProductData(Map<String, Object> data, List<Message> messages) throws Exception {
        DivergenceReportParameters params = (DivergenceReportParameters)data.get("key-report-params");
        List blankOwners = ProfileDao.getProfileReferenceByCode((String)"\u04281", OrganizationIndex.class);
        if (blankOwners.size() != 1) {
            SystemHelper.addMessage(messages, (String)"\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0412\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u043e\u0432 \u0441 \u043a\u043e\u0434\u043e\u043c \"\u04281\"", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("unable to load profile with code \"\u04281\"");
            return Collections.emptyList();
        }
        params.setBlankOwner((EntityReference)blankOwners.get(0));
        SearchQuery query = SalesReportPrepareHelper.createQuery((ReportParameters)params, false, params.getDatePropertyName());
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)ProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        if (params.isExcludePaperTickets()) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.eticket.name(), (Object)Boolean.TRUE));
        }
        ArrayList<Product> result = new ArrayList<Product>(CCCFilesDivergenceReportPrepareHandler.getTchData(SalesReportPrepareHelper.getProducts(query, messages), messages));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Product product = (Product)it.next();
            if (product.isEticket() && product.getStatus() == ProductStatus.VOID) {
                it.remove();
            }
            if (("99A".equals(product.getCarrierNumber()) || "99\u0410".equals(product.getCarrierNumber())) && product.getSegmentTariffs().size() > 1 && !product.getUid().startsWith("TCH_VIRTUAL:")) {
                it.remove();
                continue;
            }
            if (!product.getUid().startsWith("TCH_VIRTUAL:")) continue;
            product.setCarrierNumber("99A");
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"\u0412 \u043e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u043e\u043f\u0430\u043b\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0431\u0438\u043b\u0435\u0442\u0430", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        }
        Collections.sort(result, new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                return TextUtil.compare((String)o1.getSystemNumber(), (String)o2.getSystemNumber(), (boolean)false, (boolean)true);
            }
        });
        return result;
    }

    protected String getBlankOwnerCode() {
        return "\u04281";
    }

    @Override
    public String getId() {
        return "ccc-files-report";
    }

    protected void validateProductToReport(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)product, messages);
    }

    private void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        DivergenceReportParameters params;
        if (data.get("key-report-params") == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoReportParameters", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
        }
        if ((params = (DivergenceReportParameters)data.get("key-report-params")).getAgency() == null) {
            SystemHelper.addMessage(messages, (String)"Organization is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Organization is undefined");
        }
        if (params.getPeriodBegin() == null) {
            SystemHelper.addMessage(messages, (String)"Begin date is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Begin date is undefined");
        }
        if (params.getPeriodEnd() == null) {
            SystemHelper.addMessage(messages, (String)"End date is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("End date is undefined");
        }
    }

    protected boolean isHasErrors(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return false;
        }
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    public static Set<Product> getTchData(Collection<Product> tickets, List<Message> messages) throws Exception {
        HashSet<Product> result = new HashSet<Product>();
        for (Product prod : tickets) {
            if (ProductStatusHandler.getAllVoidStatuses().contains(prod.getStatus()) && prod.isEticket()) continue;
            result.add(prod);
            if (!"99A".equals(prod.getCarrierNumber()) && !"99\u0410".equals(prod.getCarrierNumber()) || prod.getSegmentTariffs().size() <= 1) continue;
            ArrayList lst = new ArrayList();
            TchRulesHelper.virtualize((Product)prod, lst);
            boolean first = true;
            for (Product product : lst) {
                if (prod == product) continue;
                AirProductHelper.clearCommissions((Product)product);
                DictionaryReference airlineRef = null;
                block2: for (SegmentTariff st : product.getSegmentTariffs()) {
                    for (Segment seg : st.getSegments()) {
                        DictionaryReference airline = seg.getAirline();
                        if (airline == null) continue;
                        airlineRef = airline;
                        break block2;
                    }
                }
                if (airlineRef == null) {
                    SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_ticketCantGetSegmentAir, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                }
                TchSalesReportPrepareHandler.copyCommissions(product, prod, airlineRef, first, messages);
                result.add(product);
                first = false;
            }
        }
        return result;
    }
}

