/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.divergence;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.hot.DivergenceObjectsReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HOTFilesDivergenceReportPrepareHandler
implements ReportPrepareHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        data.put("key-messages", messages);
        this.checkReportParameters(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        List<Object[]> filteredData = this.getData(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        int i = 1;
        for (Object[] pair : filteredData) {
            this.addPair((Product)pair[0], (HotExchangeDocument)pair[1], data, i, messages);
            ++i;
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
    }

    private void addPair(Product product, HotExchangeDocument doc, Map<String, Object> data, int itemNum, List<Message> messages) throws Exception {
        DivergenceObjectsReportTicket ticket = null;
        if (product != null) {
            BigDecimal ef;
            Commission productCommission = BookingHelper.getTotalBspCommission((Product)product);
            Double bspCommissionRate = productCommission.getRate();
            if (bspCommissionRate == null && productCommission.getEquivalentAmount() != null && (ef = AirProductHelper.getEquivalentFare((Product)product)) != null && BigDecimal.ZERO.compareTo(ef) != 0) {
                bspCommissionRate = productCommission.getEquivalentAmount().divide(ef, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue();
            }
            ticket = new DivergenceObjectsReportTicket(product, bspCommissionRate, productCommission.getEquivalentAmount(), messages);
            ticket.setItemNum(itemNum);
            this.addTicketToReportData(ticket, data, messages);
        }
        DivergenceObjectsReportTicket hot = null;
        if (doc != null) {
            hot = new DivergenceObjectsReportTicket(doc, messages);
            hot.setItemNum(itemNum);
            this.addTicketToReportData(hot, data, messages);
        }
        if (ticket != null && hot != null) {
            this.removeEqualFields(ticket, hot);
        }
    }

    private void removeEqualFields(DivergenceObjectsReportTicket ticket, DivergenceObjectsReportTicket hot) {
        if (this.isEquals(ticket.getIssueDate(), hot.getIssueDate())) {
            ticket.setIssueDate(null);
            hot.setIssueDate(null);
        }
        if (TextUtil.isSame((String)ticket.getTravellerName(), (String)hot.getTravellerName())) {
            ticket.setTravellerName(null);
            hot.setTravellerName(null);
        }
        if (MiscUtil.equals((Object)ticket.getBspCommissionRate(), (Object)hot.getBspCommissionRate())) {
            ticket.setBspCommissionRate(null);
            hot.setBspCommissionRate(null);
        }
        if (this.isEquals(ticket.getBspCommissionAmount(), hot.getBspCommissionAmount())) {
            ticket.setBspCommissionAmount(null);
            hot.setBspCommissionAmount(null);
        }
        if (ticket.getStatus() == ProductStatus.REFUND && hot.getBaseFare() == null || this.isEquals(ticket.getBaseFare(), hot.getBaseFare())) {
            ticket.setBaseFare(null);
            hot.setBaseFare(null);
        }
        if (this.isEquals(ticket.getEquivalentFare(), hot.getEquivalentFare())) {
            ticket.setEquivalentFare(null);
            hot.setEquivalentFare(null);
        }
        if (this.isEquals(this.collectTaxes(ticket.getTaxes()), this.collectTaxes(hot.getTaxes()))) {
            ticket.getTaxes().clear();
            hot.getTaxes().clear();
        }
        if (this.isEquals(ticket.getPenalty(), hot.getPenalty())) {
            ticket.setPenalty(null);
            hot.setPenalty(null);
        }
    }

    protected String getBlankOwnerCode() {
        return "BSP";
    }

    @Override
    public String getId() {
        return "hot-files-report";
    }

    protected void validateProductToReport(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)product, messages);
    }

    public List<Object[]> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        this.putGlobalData(data);
        List<Product> productSet = this.getProductData(data, messages);
        List<HotExchangeDocument> hotFilesSet = this.getHotFilesData(data, messages);
        ArrayList<Object[]> divergenceList = new ArrayList<Object[]>();
        HashMap<String, Product> productMap = new HashMap<String, Product>();
        for (Product product : productSet) {
            if (product.getSystemNumber() == null) continue;
            productMap.put((product.getStatus() == ProductStatus.REFUND ? ProductStatus.REFUND.name() : "") + product.getSystemNumber(), product);
        }
        for (HotExchangeDocument doc : hotFilesSet) {
            if (doc.getTicketNumber() == null) continue;
            Product product = (Product)productMap.remove((doc.getTransaction() == TransactionType.REFUND ? ProductStatus.REFUND.name() : "") + doc.getTicketNumber());
            if (product != null) {
                if (this.isEquals(product, doc)) continue;
                divergenceList.add(new Object[]{product, doc});
                continue;
            }
            divergenceList.add(new Object[]{null, doc});
        }
        for (Product product : productMap.values()) {
            divergenceList.add(new Object[]{product, null});
        }
        if (divergenceList.isEmpty()) {
            data.put("DIVERGENCE_REPORT_NOT_FOUND", Boolean.TRUE);
        }
        return divergenceList;
    }

    private void putGlobalData(Map<String, Object> data) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        BaseReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, null);
        EntityContainer ctr = EntityStorage.get().resolve(params.getAgency());
        if (ctr != null) {
            data.put("AGENCY_NAME", ProfileHelper.getFullName((Organization)((Organization)ctr.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        }
    }

    private boolean isEquals(Product product, HotExchangeDocument doc) throws Exception {
        if (product.getStatus() == ProductStatus.VOID) {
            return this.isEqualsByOperation(product, doc) && this.isEqualsByIssueDate(product, doc);
        }
        return this.isEqualsByBSPCommissions(product, doc) && (product.getStatus() == ProductStatus.REFUND && (doc.getBaseFare() == null || BigDecimal.ZERO.compareTo(doc.getBaseFare().getValue()) == 0) || this.isEquals(doc.getBaseFare(), AirProductHelper.getBaseFare((Product)product))) && this.isEquals(doc.getEquivalentFare(), this.getEquivalentFare(product)) && this.isEqualsByAirline(product, doc) && this.isEqualsByTraveller(product, doc) && this.isEquals(this.getTaxes(product), this.collectTaxes(doc.getTaxes())) && this.isEqualsByIssueDate(product, doc) && this.isEqualsByPenalty(product, doc) && this.isEqualsByOperation(product, doc);
    }

    private Map<String, BigDecimal> getTaxes(Product product) {
        Map<String, BigDecimal> result = this.collectTaxes(product.getTaxes());
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            Map<String, BigDecimal> exchangeTaxes = this.collectTaxes(product.getPreviousProduct().getTaxes());
            for (Map.Entry<String, BigDecimal> entry : exchangeTaxes.entrySet()) {
                BigDecimal taxAmount = MiscUtil.sub((BigDecimal)result.get(entry.getKey()), (BigDecimal[])new BigDecimal[]{entry.getValue()});
                result.put(entry.getKey(), taxAmount);
                if (BigDecimal.ZERO.compareTo(taxAmount) != 0) continue;
                result.remove(entry.getKey());
            }
        }
        return result;
    }

    private Map<String, BigDecimal> collectTaxes(Collection<Tax> taxes) {
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>();
        for (Tax tax : taxes) {
            String taxCode = tax.getCode() == null ? "" : tax.getCode();
            result.put(taxCode, MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)result.get(taxCode), tax.getEquivalentAmount()}));
        }
        return result;
    }

    private BigDecimal getEquivalentFare(Product product) {
        BigDecimal result = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product));
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            result = result.subtract(MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct())));
        }
        return result;
    }

    private boolean isEquals(BigDecimal value1, BigDecimal value2) {
        if (value1 == null || Math.abs(value1.doubleValue()) < 0.001) {
            return value2 == null || Math.abs(value2.doubleValue()) < 0.001;
        }
        if (value2 == null) {
            return false;
        }
        return Math.abs(Math.abs(value1.doubleValue()) - Math.abs(value2.doubleValue())) < 0.001;
    }

    private boolean isEqualsByBSPCommissions(Product product, HotExchangeDocument doc) throws Exception {
        Double docRate = doc.getBSPCommissionRate();
        BigDecimal docValue = doc.getBSPCommissionValue();
        if (docRate == null || docValue == null) {
            return false;
        }
        Commission productCommission = BookingHelper.getTotalBspCommission((Product)product);
        BigDecimal prodValue = productCommission.getEquivalentAmount();
        if (!this.isEquals(prodValue, docValue)) {
            return false;
        }
        if (productCommission.getRate() == null) {
            return true;
        }
        return (double)Math.abs(Math.abs(Math.round(docRate * 100.0)) - Math.abs(Math.round(docRate * 100.0))) < 0.001;
    }

    private boolean isEqualsByPenalty(Product product, HotExchangeDocument doc) throws Exception {
        if (product.getPenalty() == null || product.getPenalty().compareTo(BigDecimal.ZERO) == 0) {
            return doc.getPenalty() == null || doc.getPenalty().compareTo(BigDecimal.ZERO) == 0;
        }
        if (doc.getPenalty() == null || doc.getPenalty().compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        return doc.getPenalty().compareTo(product.getPenalty()) == 0;
    }

    private boolean isEquals(Money prodBaseFare, Money docBaseFare) {
        if (prodBaseFare == null) {
            return docBaseFare == null || docBaseFare.getValue() == null || Math.abs(docBaseFare.getValue().doubleValue()) < 0.001;
        }
        if (docBaseFare == null) {
            return prodBaseFare.getValue() == null || Math.abs(prodBaseFare.getValue().doubleValue()) < 0.001;
        }
        if (!MiscUtil.equals((Object)prodBaseFare.getCurrency(), (Object)docBaseFare.getCurrency())) {
            return false;
        }
        return this.isEquals(prodBaseFare.getValue(), docBaseFare.getValue());
    }

    private boolean isEqualsByAirline(Product product, HotExchangeDocument doc) {
        DictionaryReference docAirlineRef = doc.getTicketingAirline();
        DictionaryReference productAirlineRef = product.getCarrier();
        return docAirlineRef != null && productAirlineRef != null && docAirlineRef.equals((Object)productAirlineRef);
    }

    private boolean isEqualsByTraveller(Product product, HotExchangeDocument doc) {
        String prodTravellerName;
        String docTravellerName = doc.getTravellerName();
        String string = prodTravellerName = product.getTraveller() != null ? product.getTraveller().getName() : null;
        if (TextUtil.isBlank((String)docTravellerName) || prodTravellerName == null) {
            return false;
        }
        return DivergenceObjectsReportTicket.getTraveller((String)prodTravellerName).equalsIgnoreCase(DivergenceObjectsReportTicket.getTraveller((String)docTravellerName));
    }

    private boolean isEquals(Map<String, BigDecimal> prodAmounts, Map<String, BigDecimal> docAmounts) {
        if (docAmounts.size() != prodAmounts.size()) {
            return false;
        }
        for (Map.Entry<String, BigDecimal> entry : docAmounts.entrySet()) {
            if (this.isEquals(entry.getValue(), prodAmounts.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualsByIssueDate(Product product, HotExchangeDocument doc) {
        Date prodDate = product.getIssueDate();
        Date hotDate = doc.getIssued();
        if (prodDate == null || hotDate == null) {
            return false;
        }
        return this.isEquals(prodDate, hotDate);
    }

    private boolean isEquals(Date prodDate, Date hotDate) {
        if (prodDate == null) {
            return hotDate == null;
        }
        if (hotDate == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(prodDate);
        int prodYear = calendar.get(1);
        int prodMonth = calendar.get(2);
        int prodDay = calendar.get(5);
        calendar.setTime(hotDate);
        int hotYear = calendar.get(1);
        int hotMonth = calendar.get(2);
        int hotDay = calendar.get(5);
        return prodYear == hotYear && prodMonth == hotMonth && prodDay == hotDay;
    }

    private boolean isEqualsByOperation(Product product, HotExchangeDocument doc) {
        if (product.getStatus() == null || doc.getTransaction() == null) {
            return false;
        }
        switch (product.getStatus()) {
            case SELL: {
                if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    return doc.getTransaction() == TransactionType.EXCHANGE;
                }
                return doc.getTransaction() == TransactionType.SELL;
            }
            case REFUND: {
                return doc.getTransaction() == TransactionType.REFUND;
            }
            case VOID: {
                return doc.getTransaction() == TransactionType.CANCEL;
            }
        }
        return false;
    }

    public List<HotExchangeDocument> getHotFilesData(Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<HotExchangeDocument> result = new ArrayList<HotExchangeDocument>();
        DivergenceReportParameters params = (DivergenceReportParameters)data.get("key-report-params");
        EntityReference agencyReference = params.getAgency();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        SearchCriterion sc1 = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)HotExchangeDocumentIndex.Property.issued.name(), (Object)MiscUtil.clearTime((Date)params.getPeriodBegin())), SearchCriterion.le((String)HotExchangeDocumentIndex.Property.issued.name(), (Object)MiscUtil.setDayEndTime((Date)params.getPeriodEnd()))});
        SearchCriterion sc2 = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)HotExchangeDocumentIndex.Property.agency.name(), (Object)agencyReference)});
        query.getCriteria().getCriterions().add(sc1);
        query.getCriteria().getCriterions().add(sc2);
        if (!TextUtil.isBlank((String)params.getValidator())) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)HotExchangeDocumentIndex.Property.validator.name(), (Object)params.getValidator()));
        }
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        List hots = es.search(HotExchangeDocumentIndex.class, query).getData();
        for (HotExchangeDocumentIndex index : hots) {
            EntityReference docRef = index.getSource();
            EntityContainer docContainer = es.resolve(docRef);
            if (docContainer == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{docRef});
                this.log.error("Unable to load hot file container " + docRef.getUid() + ". All of the hot files will be excluded from report.");
                return Collections.emptyList();
            }
            HotExchangeDocument doc = (HotExchangeDocument)docContainer.getEntity();
            result.add(doc);
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"\u0412 \u043e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u043e\u043f\u0430\u043b\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e hot \u0444\u0430\u0439\u043b\u0430", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("There are no hot files in the report");
        }
        Collections.sort(result, new Comparator<HotExchangeDocument>(){

            @Override
            public int compare(HotExchangeDocument o1, HotExchangeDocument o2) {
                return TextUtil.compare((String)o1.getTicketNumber(), (String)o2.getTicketNumber(), (boolean)false, (boolean)true);
            }
        });
        return result;
    }

    public List<Product> getProductData(Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<Product> result;
        DivergenceReportParameters params = (DivergenceReportParameters)data.get("key-report-params");
        List profiles = ProfileDao.getProfileReferenceByCode((String)"BSP", OrganizationIndex.class);
        if (profiles.size() != 1) {
            SystemHelper.addMessage(messages, (String)"\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c BSP", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("unable to load BSP profile");
            return Collections.emptyList();
        }
        params.setBlankOwner((EntityReference)profiles.get(0));
        SearchQuery query = SalesReportPrepareHelper.createQuery((ReportParameters)params);
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)ProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        if (!TextUtil.isBlank((String)params.getValidator())) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.validatorCode.name(), (Object)params.getValidator()));
        }
        if ((result = new ArrayList<Product>(SalesReportPrepareHelper.getProducts(query, messages))).isEmpty()) {
            SystemHelper.addMessage(messages, (String)"\u0412 \u043e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u043e\u043f\u0430\u043b\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0431\u0438\u043b\u0435\u0442\u0430", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        }
        Collections.sort(result, new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                return TextUtil.compare((String)o1.getSystemNumber(), (String)o2.getSystemNumber(), (boolean)false, (boolean)true);
            }
        });
        return result;
    }

    private void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        DivergenceReportParameters params;
        if (data.get("key-report-params") == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoReportParameters", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
        }
        if ((params = (DivergenceReportParameters)data.get("key-report-params")).getAgency() == null) {
            SystemHelper.addMessage(messages, (String)"Organization is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Organization is undefined");
        }
        if (params.getPeriodBegin() == null) {
            SystemHelper.addMessage(messages, (String)"Begin date is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Begin date is undefined");
        }
        if (params.getPeriodEnd() == null) {
            SystemHelper.addMessage(messages, (String)"End date is undefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("End date is undefined");
        }
    }

    private void addTicketToReportData(DivergenceObjectsReportTicket ticket, Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<ReportBatchData> batchDataList = (ArrayList<ReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData>();
            data.put("key-batch-data-list", batchDataList);
        }
        ReportBatchData batch = null;
        for (ReportBatchData aBatch : batchDataList) {
            if (!"SALE".equals(aBatch.getBatchId())) continue;
            batch = aBatch;
            break;
        }
        if (batch == null) {
            batch = new ReportBatchData();
            batch.setBatchId("SALE");
            batchDataList.add(batch);
        }
        batch.getTickets().add(ticket);
    }
}

