/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.divergence.common;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.BaseSsodExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.RetExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.common.BaseSsodDivergenceReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.common.BaseSsodDivergenceTicketWrapper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSsodDivergenceReportPrepareHandler<E extends BaseSsodExchangeDocument, I extends EntityIndex<E>, W extends BaseSsodDivergenceTicketWrapper<E>, T extends BaseSsodDivergenceReportTicket<E, W>>
implements ReportPrepareHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        data.put("key-messages", messages);
        this.checkReportParameters(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        this.putGlobalParameters(data, (DivergenceReportParameters)data.get("key-report-params"), messages);
        List<Product> products = this.getProducts((DivergenceReportParameters)data.get("key-report-params"), messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        HashMap<String, Object> productWrappers = new HashMap<String, Object>();
        for (Product prod : products) {
            W wrapper = this.createWrapper(prod, false, prod.getSystemNumber(), messages);
            productWrappers.put(String.format("%s_%s", wrapper.getItemType(), wrapper.getTicketNumber()), wrapper);
            for (int n = 0; n < prod.getConjCount(); ++n) {
                String systemNumber = FormattedNumberUtil.add((String)prod.getSystemNumber(), (long)(n + 1));
                Iterator<Object> wrapper2 = this.createWrapper(prod, true, systemNumber, messages);
                productWrappers.put(String.format("%s_%s", wrapper2.getItemType(), systemNumber), wrapper2);
            }
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        ArrayList unmatchedProducts = new ArrayList(productWrappers.values());
        List<E> documents = this.getDocuments((DivergenceReportParameters)data.get("key-report-params"), messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        DivergenceReportParameters parameters = (DivergenceReportParameters)data.get("key-report-params");
        ArrayList<T> tickets = new ArrayList<T>();
        this.updateDocuments(documents);
        for (BaseSsodExchangeDocument doc : documents) {
            W wrapper = this.createWrapper(doc, messages);
            BaseSsodDivergenceTicketWrapper ticketWrapper = (BaseSsodDivergenceTicketWrapper)productWrappers.get(String.format("%s_%s", wrapper.getItemType(), wrapper.getTicketNumber()));
            if (ticketWrapper == null) {
                if (this.isNullableTicket(wrapper, parameters.isExcludeNullableTickets())) continue;
                tickets.add(this.createTicket(null, wrapper));
                continue;
            }
            unmatchedProducts.remove(ticketWrapper);
            DivergenceReportParameters divParam = (DivergenceReportParameters)data.get("key-report-params");
            if (ticketWrapper.isEqualsByAllParameters(wrapper, divParam)) continue;
            tickets.add(this.createTicket(ticketWrapper, wrapper));
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        for (BaseSsodDivergenceTicketWrapper item : unmatchedProducts) {
            if (this.isNullableTicket(item, parameters.isExcludeNullableTickets())) continue;
            tickets.add(this.createTicket(item, null));
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        if (products.isEmpty() && documents.isEmpty()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.reportNoTicket, (Object[])new Object[0]));
            data.put("DIVERGENCE_REPORT_NOT_FOUND", Boolean.TRUE);
            return;
        }
        Collections.sort(tickets, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int res = this.getCompletenessIndex(o1) - this.getCompletenessIndex(o2);
                if (res != 0) {
                    return res;
                }
                BaseSsodDivergenceTicketWrapper wrapper1 = ((BaseSsodDivergenceReportTicket)o1).documentWrapper == null ? ((BaseSsodDivergenceReportTicket)o1).ticketWrapper : ((BaseSsodDivergenceReportTicket)o1).documentWrapper;
                BaseSsodDivergenceTicketWrapper wrapper2 = ((BaseSsodDivergenceReportTicket)o2).documentWrapper == null ? ((BaseSsodDivergenceReportTicket)o2).ticketWrapper : ((BaseSsodDivergenceReportTicket)o2).documentWrapper;
                res = this.getItemTypeIndex(wrapper1) - this.getItemTypeIndex(wrapper2);
                if (res != 0) {
                    return res;
                }
                return TextUtil.compare((String)wrapper1.getTicketNumber(), (String)wrapper2.getTicketNumber(), (boolean)false, (boolean)false);
            }

            private int getItemTypeIndex(W o1) {
                BaseSsodDivergenceTicketWrapper.ItemType type = o1.getItemType();
                switch (type) {
                    case VOID: {
                        return 0;
                    }
                    case SELL: {
                        return 1;
                    }
                    case EXCHANGE: {
                        return 2;
                    }
                    case REFUND: {
                        return 3;
                    }
                }
                return 4;
            }

            private int getCompletenessIndex(T o1) {
                if (((BaseSsodDivergenceReportTicket)o1).documentWrapper != null && ((BaseSsodDivergenceReportTicket)o1).ticketWrapper != null) {
                    return 0;
                }
                if (((BaseSsodDivergenceReportTicket)o1).ticketWrapper != null) {
                    return 1;
                }
                return 2;
            }
        });
        ReportBatchData batch = new ReportBatchData();
        batch.setBatchId("TICKETS");
        batch.getTickets().addAll(tickets);
        data.put("key-batch-data-list", Collections.singletonList(batch));
    }

    private boolean isNullableTicket(W ticket, boolean exclude) {
        return exclude && MiscUtil.isZero((BigDecimal)ticket.getEquivalentFare(), (boolean)true) && MiscUtil.isZero((BigDecimal)ticket.getPenalty(), (boolean)true) && MiscUtil.isZero((BigDecimal)AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Collection)ticket.getTaxes(), (boolean)false, (String[])new String[0]), (boolean)true);
    }

    private void putGlobalParameters(Map<String, Object> data, DivergenceReportParameters divergenceReportParameters, List<Message> messages) throws Exception {
        BaseReportPrepareHandler.putStandardReportParameters(divergenceReportParameters.getPeriodBegin(), divergenceReportParameters.getPeriodEnd(), data, messages);
        BaseReportPrepareHandler.putStandardAgencyData((EntityReference<Organization>)divergenceReportParameters.getAgency(), data, messages);
    }

    private List<E> getDocuments(DivergenceReportParameters divergenceReportParameters, List<Message> messages) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)RetExchangeDocumentIndex.Property.issued.name(), (Object)MiscUtil.clearTime((Date)divergenceReportParameters.getPeriodBegin())));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)RetExchangeDocumentIndex.Property.issued.name(), (Object)MiscUtil.setDayEndTime((Date)divergenceReportParameters.getPeriodEnd())));
        if (divergenceReportParameters.getAgency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RetExchangeDocumentIndex.Property.agency.name(), (Object)divergenceReportParameters.getAgency()));
        }
        if (divergenceReportParameters.getSupplier() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RetArchiveExchangeDocumentIndex.Property.supplier.name(), (Object)divergenceReportParameters.getSupplier()));
        }
        if (divergenceReportParameters.getBlankOwner() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RetArchiveExchangeDocumentIndex.Property.blankOwner.name(), (Object)divergenceReportParameters.getBlankOwner()));
        }
        List documents = EntityStorage.get().search(this.getIndexClass(), query).getData();
        ArrayList<BaseSsodExchangeDocument> result = new ArrayList<BaseSsodExchangeDocument>();
        for (EntityIndex item : documents) {
            EntityContainer ctr = EntityStorage.get().resolve(item.getSource());
            if (ctr == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseSsodDivergenceReportPrepareHandler_couldNotLoadFileExchange, (Object[])new Object[]{item.getSource()}));
                continue;
            }
            BaseSsodExchangeDocument document = (BaseSsodExchangeDocument)ctr.getEntity();
            if (document.getTransaction() != TransactionType.EXCHANGE && document.getTransaction() != TransactionType.SELL && document.getTransaction() != TransactionType.REFUND && document.getTransaction() != TransactionType.MCO_PENALTY && document.getTransaction() != TransactionType.REFERENCE && document.getTransaction() != TransactionType.CANCEL) continue;
            result.add(document);
        }
        return result;
    }

    private List<Product> getProducts(DivergenceReportParameters divergenceReportParameters, List<Message> messages) throws Exception {
        SearchQuery query = SalesReportPrepareHelper.createQuery((ReportParameters)divergenceReportParameters);
        if (divergenceReportParameters.isExcludePaperTickets()) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.eticket.name(), (Object)Boolean.TRUE));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.REFUND), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID_BOOKING)}));
        List products = EntityStorage.get().search(ProductIndex.class, query).getData();
        ArrayList<Product> result = new ArrayList<Product>();
        HashMap<EntityReference, BookingFile> bookings = new HashMap<EntityReference, BookingFile>();
        for (ProductIndex item : products) {
            Product product;
            EntityReference bookingReference = item.getSource();
            BookingFile bookingFile = (BookingFile)bookings.get(bookingReference);
            if (bookingFile == null) {
                EntityContainer ctr = EntityStorage.get().resolve(bookingReference);
                if (ctr == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseSsodDivergenceReportPrepareHandler_couldLoadOrder, (Object[])new Object[]{bookingReference}));
                    continue;
                }
                bookingFile = (BookingFile)ctr.getEntity();
                bookings.put(bookingReference, bookingFile);
            }
            if ((product = (Product)BookingHelper.findProductByUid((String)item.getNavigationKey(), (BookingFile)bookingFile)) == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseSsodDivergenceReportPrepareHandler_couldLoadProduct, (Object[])new Object[]{bookingReference}));
                continue;
            }
            result.add(product);
        }
        return result;
    }

    protected void correctProductsQuery(SearchQuery query) {
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.mcoCategory.name(), null), SearchCriterion.eq((String)ProductIndex.Property.mcoCategory.name(), (Object)MCOCategory.PENALTY), SearchCriterion.eq((String)ProductIndex.Property.mcoCategory.name(), (Object)MCOCategory.INFORMATION)}));
    }

    protected void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        DivergenceReportParameters params;
        if (data.get("key-report-params") == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoReportParameters", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
        }
        if ((params = (DivergenceReportParameters)data.get("key-report-params")).getPeriodBegin() == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseSsodDivergenceReportPrepareHandler_noDateStart, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Begin date is undefined");
        }
        if (params.getPeriodEnd() == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseSsodDivergenceReportPrepareHandler_noDateEnd, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("End date is undefined");
        }
    }

    protected abstract W createWrapper(Product var1, boolean var2, String var3, List<Message> var4);

    protected abstract W createWrapper(E var1, List<Message> var2);

    protected abstract T createTicket(W var1, W var2);

    protected abstract Class<I> getIndexClass();

    protected abstract GdsName getGds();

    protected void updateDocuments(List<E> documents) {
    }
}

