/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.divergence.ret;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocumentIndex;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ret.RetDivergenceReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ret.RetDivergenceTicketWrapper;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.divergence.common.BaseSsodDivergenceReportPrepareHandler;
import java.math.BigDecimal;
import java.util.List;

public class RetDivergenceReportPrepareHandler
extends BaseSsodDivergenceReportPrepareHandler<RetArchiveExchangeDocument, RetArchiveExchangeDocumentIndex, RetDivergenceTicketWrapper, RetDivergenceReportTicket> {
    @Override
    public String getId() {
        return "ret-comparison-report";
    }

    @Override
    protected RetDivergenceTicketWrapper createWrapper(Product ticket, boolean conj, String systemNumber, List<Message> message) {
        return new RetDivergenceTicketWrapper(ticket, conj, systemNumber, message);
    }

    @Override
    protected RetDivergenceTicketWrapper createWrapper(RetArchiveExchangeDocument document, List<Message> messages) {
        return new RetDivergenceTicketWrapper(document, messages);
    }

    @Override
    protected RetDivergenceReportTicket createTicket(RetDivergenceTicketWrapper ticket, RetDivergenceTicketWrapper document) {
        return new RetDivergenceReportTicket(ticket, document);
    }

    @Override
    protected Class<RetArchiveExchangeDocumentIndex> getIndexClass() {
        return RetArchiveExchangeDocumentIndex.class;
    }

    @Override
    protected GdsName getGds() {
        return GdsName.GABRIEL;
    }

    @Override
    protected void updateDocuments(List<RetArchiveExchangeDocument> documents) {
        super.updateDocuments(documents);
        for (RetArchiveExchangeDocument document : documents) {
            if (!document.isConjuction()) continue;
            this.updateConjunction(documents, document);
        }
    }

    private void updateConjunction(List<RetArchiveExchangeDocument> tickets, RetArchiveExchangeDocument conjunctionTicket) {
        if (TextUtil.isBlank((String)conjunctionTicket.getTicketNumber())) {
            return;
        }
        RetArchiveExchangeDocument mainTicket = this.getMainTicket(tickets, conjunctionTicket.getTicketNumber());
        if (mainTicket == null) {
            return;
        }
        this.updateMainTicket(mainTicket, conjunctionTicket);
    }

    private RetArchiveExchangeDocument getMainTicket(List<RetArchiveExchangeDocument> tickets, String conjunctionTicketNumber) {
        String previousConjunctionTicketNumber = FormattedNumberUtil.subtract((String)conjunctionTicketNumber, (long)1L);
        if (TextUtil.isBlank((String)previousConjunctionTicketNumber)) {
            return null;
        }
        RetArchiveExchangeDocument previousConjunctionTicket = tickets.stream().filter(ticket -> previousConjunctionTicketNumber.equals(ticket.getTicketNumber())).findFirst().orElse(null);
        if (previousConjunctionTicket == null) {
            return null;
        }
        if (previousConjunctionTicket.isConjuction()) {
            return this.getMainTicket(tickets, previousConjunctionTicket.getTicketNumber());
        }
        return previousConjunctionTicket;
    }

    private void updateMainTicket(RetArchiveExchangeDocument mainTicket, RetArchiveExchangeDocument conjunction) {
        if (mainTicket.getBaseFare() == null) {
            mainTicket.setBaseFare(conjunction.getBaseFare());
        } else if (MiscUtil.isZero((BigDecimal)mainTicket.getBaseFare().getValue(), (boolean)true)) {
            mainTicket.getBaseFare().setValue(conjunction.getBaseFare().getValue());
        }
        if (MiscUtil.isZero((BigDecimal)mainTicket.getEquivalentFare(), (boolean)true)) {
            mainTicket.setEquivalentFare(conjunction.getEquivalentFare());
        }
        if (MiscUtil.isZero((BigDecimal)mainTicket.getPenalty(), (boolean)true)) {
            mainTicket.setPenalty(conjunction.getPenalty());
        }
    }
}

