/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.fv;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.PaymentCardHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.fv.FvRegistryLetterItem;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.BaseSuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SUBCReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FvSalesReportPrepareHandler
extends BaseSuSalesReportPrepareHandler {
    @Override
    protected String getVendorCode() {
        return "FV";
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        super.putGlobalData(data, messages);
        Organization vendor = (Organization)data.get("key-vendor");
        if (vendor != null) {
            String contractNoStr = SystemHelper.findMetadataAsString((Collection)vendor.getMetadata(), (MetadataKey)MetadataKey.KEY_BLOCK_CHARTER_CONTRACT_NO);
            String contractClientIdStr = SystemHelper.findMetadataAsString((Collection)vendor.getMetadata(), (MetadataKey)MetadataKey.KEY_BLOCK_CHARTER_CONTRACT_CLIENT_ID);
            if (contractNoStr == null) {
                contractNoStr = "";
            }
            if (contractClientIdStr == null) {
                contractClientIdStr = "";
            }
            data.put("KEY_BLOCK_CHARTER_CONTRACT_CLIENT_ID", contractClientIdStr);
            data.put("KEY_BLOCK_CHARTER_CONTRACT_NO", contractNoStr);
        }
        data.put("client_list", this.getClients((Organization)data.get("key-vendor")));
        HashSet<String> agencyProfileCodes = new HashSet<String>();
        EntityStorage es = EntityStorage.get();
        List agencies = es.search(OrganizationIndex.class, new SearchQuery()).getData();
        for (OrganizationIndex index : agencies) {
            agencyProfileCodes.add(index.getCode());
        }
        data.put("AGENCY_CODES_LIST", agencyProfileCodes);
        data.put("AGENCY_CODES_LIST", agencyProfileCodes);
    }

    @Override
    public String getId() {
        return "fv-sales-report";
    }

    @Override
    protected String getFuelTaxCode() {
        return "YQ";
    }

    private Map<String, FvRegistryLetterItem> getRegistryLettersItems(Map<String, Object> data) {
        TreeMap items = (TreeMap)data.get("key-registry-letters-data");
        if (items == null) {
            items = new TreeMap();
            data.put("key-registry-letters-data", items);
        }
        return items;
    }

    private FvRegistryLetterItem getFvRegistryLetterItem(Map<String, FvRegistryLetterItem> items, ProductStatus opType, TransportationType tranType, FvRegistryLetterItem.FieldDefinition fieldDef) {
        FvRegistryLetterItem item = items.get(tranType.name() + opType.name() + fieldDef.name());
        if (item == null) {
            item = new FvRegistryLetterItem();
            item.fieldDef = fieldDef;
            items.put(tranType.name() + opType.name() + fieldDef.name(), item);
        }
        return item;
    }

    private void addToRegItem(BigDecimal value, Map<String, FvRegistryLetterItem> items, ProductStatus opType, TransportationType tranType, FvRegistryLetterItem.FieldDefinition fieldDef) {
        FvRegistryLetterItem item = this.getFvRegistryLetterItem(items, opType, tranType, fieldDef);
        item.sum += value.doubleValue();
    }

    private void addToRegItem(double value, Map<String, FvRegistryLetterItem> items, ProductStatus opType, TransportationType tranType, FvRegistryLetterItem.FieldDefinition fieldDef) {
        FvRegistryLetterItem item = this.getFvRegistryLetterItem(items, opType, tranType, fieldDef);
        item.sum += value;
    }

    private void addToRegItem(int value, Map<String, FvRegistryLetterItem> items, ProductStatus opType, TransportationType tranType, FvRegistryLetterItem.FieldDefinition fieldDef) {
        FvRegistryLetterItem item = this.getFvRegistryLetterItem(items, opType, tranType, fieldDef);
        item.cnt += value;
    }

    @Override
    protected void addProductProxyTicket(Product prod, Map<String, Object> data, List<Message> messages) throws Exception {
        SuTicket ticket = null;
        if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.ADDITIONAL_SERVICES) {
            return;
        }
        try {
            if (prod.getMcoCategory() == MCOCategory.GROUP_PENALTY) {
                ticket = this.getTicketInstance(this.copyAsMcoGroupPenalty(prod), messages);
            } else {
                if (ProductStatus.EXCHANGE.equals((Object)prod.getStatus())) {
                    return;
                }
                if (prod.getPreviousProduct() != null && ProductStatus.EXCHANGE.equals((Object)prod.getPreviousProduct().getStatus())) {
                    BigDecimal baseFare;
                    Product exchangeProduct = prod.getPreviousProduct();
                    SuTicket exchangeTicket = this.getTicketInstance(exchangeProduct, messages);
                    ticket = this.getTicketInstance(prod, messages);
                    if (ticket.getBaseFare() != null && ticket.getBaseFare().getValue() != null && exchangeTicket.getBaseFare() != null && exchangeTicket.getBaseFare().getValue() != null) {
                        baseFare = ticket.getBaseFare().getValue().subtract(exchangeTicket.getBaseFare().getValue());
                        ticket.getBaseFare().setValue(baseFare);
                    }
                    if (ticket.getEquivalentFare() != null && exchangeTicket.getBaseFare() != null) {
                        BigDecimal eqFare = ticket.getEquivalentFare().subtract(exchangeTicket.getEquivalentFare());
                        ticket.setEquivalentFare(eqFare);
                    }
                    if (ticket.getVendorEquivalentCommission() != null && exchangeTicket.getVendorEquivalentCommission() != null) {
                        baseFare = ticket.getVendorEquivalentCommission().subtract(exchangeTicket.getVendorEquivalentCommission());
                        ticket.setVendorEquivalentCommission(baseFare);
                    }
                    List newTaxes = SalesReportHelper.calculateTaxesDifference((Collection)ticket.getTaxes(), (Collection)exchangeTicket.getTaxes());
                    ticket.getTaxes().clear();
                    ticket.getTaxes().addAll(newTaxes);
                    BigDecimal fopAmountEq = BigDecimal.ZERO;
                    fopAmountEq = fopAmountEq.add(ticket.getEquivalentFare());
                    for (Tax t : ticket.getTaxes()) {
                        if (t == null || t.getEquivalentAmount() == null) continue;
                        fopAmountEq = fopAmountEq.add(t.getEquivalentAmount());
                    }
                    if (ticket.getPenalty() != null) {
                        fopAmountEq = fopAmountEq.add(ticket.getPenalty());
                    }
                    boolean fopSet = false;
                    Iterator iter = ticket.getFops().iterator();
                    while (iter.hasNext()) {
                        ProductFop f = (ProductFop)iter.next();
                        if (!PaymentType.TICKET.equals((Object)f.getType()) && !PaymentType.MCO.equals((Object)f.getType())) {
                            if (!fopSet && f.getAmount() != null) {
                                f.getAmount().setValue(fopAmountEq);
                                fopSet = true;
                                continue;
                            }
                            iter.remove();
                            continue;
                        }
                        if (PaymentType.MCO.equals((Object)f.getType())) continue;
                        iter.remove();
                    }
                } else {
                    ticket = this.getTicketInstance(prod, messages);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Can't create SuTicket for product \"" + prod.getSystemNumber() + "\"", (Throwable)e);
            return;
        }
        if (ticket.getStatus() != ProductStatus.VOID && !this.checkFopTypes(ticket)) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FopTypeIsNotSet", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.error("Fop type is not set for ticket " + ticket.getTicketNumber());
            return;
        }
        if (ticket.getStatus() != ProductStatus.VOID && this.isCreditCardUsed(ticket) && PaymentCardHelper.isPaymentCardMasked((Collection)ticket.getFops())) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_PaymentCardNumberIsMasked", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.error("Payment card number is masked for " + ticket.getTicketNumber());
            return;
        }
        this.setSpecificTicketData(ticket, prod, data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityReference agencyReference = params.getAgency();
        ArrayList<SuSalesReportBatchData<SuTicket>> batchDataList = (ArrayList<SuSalesReportBatchData<SuTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<SuSalesReportBatchData<SuTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        if (!(ticket.getTariffType() != TariffType.BLOCKCHARTER && ticket.getTariffType() != TariffType.CHARTER || MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory()))) {
            SUBCReportPrepareHelper.addProductProxyTicket(prod, data, messages);
        }
        SuSalesReportBatchData<SuTicket> batch = null;
        batch = this.selectBatch(ticket.getBatchId(), ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
        if (batch.getBatchId().equals("SALE")) {
            if (!(prod.getProductCategory() != ProductCategory.MCO || prod.getMcoCategory() != MCOCategory.REBOOKING && prod.getMcoCategory() != MCOCategory.STICKER || prod.getRelatedProducts().isEmpty())) {
                Product relProd = (Product)prod.getRelatedProducts().get(0);
                ticket.setVendorCommissionRate(Double.valueOf(0.0));
                if (ticket.getBaseFare() != null) {
                    ticket.getBaseFare().setValue(BigDecimal.ZERO);
                }
                ticket.setEquivalentFare(BigDecimal.ZERO);
                ticket.setVendorEquivalentCommission(BigDecimal.ZERO);
                if (prod.getMcoCategory() == MCOCategory.STICKER && relProd != null && relProd.getStatus() == ProductStatus.SELL) {
                    SuTicket sticker = this.createSticker(prod, messages);
                    batch.getTickets().add(sticker);
                    this.updateTicketRegistryLetterData(sticker, batch.getBatchId(), data);
                }
            }
            if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.RETURN_FARE_DIFFERENCE && !prod.getRelatedProducts().isEmpty()) {
                SuTicket returnFareDifferenceAsRefund = this.createReturnFareDifferenceAsRefund(prod, messages);
                SuSalesReportBatchData<SuTicket> refundBatch = this.selectBatch("REFUND", ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
                refundBatch.getTickets().add(returnFareDifferenceAsRefund);
                this.updateTicketRegistryLetterData(returnFareDifferenceAsRefund, refundBatch.getBatchId(), data);
                ticket.setEquivalentFare(BigDecimal.ZERO);
                ticket.setVendorEquivalentCommission(BigDecimal.ZERO);
                for (ProductFop productFop : ticket.getFops()) {
                    productFop.getAmount().setValue(BigDecimal.ZERO);
                }
                ticket.getBaseFare().setValue(BigDecimal.ZERO);
            }
        }
        batch.getTickets().add(ticket);
        if (!MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory())) {
            this.updateTicketRegistryLetterData(ticket, batch.getBatchId(), data);
        }
    }

    @Override
    protected void updateTicketRegistryLetterData(SuTicket ticket, String batchId, Map<String, Object> data) {
        if (ticket.getStatus() == null) {
            return;
        }
        TransportationType tranType = TransportationType.DOMESTIC;
        if (ticket.getTransportationType() != TransportationType.DOMESTIC) {
            tranType = TransportationType.INTERNATIONAL;
        }
        Map<String, FvRegistryLetterItem> items = this.getRegistryLettersItems(data);
        FareCommissionInfo taxInfo = this.getFareTaxInfo(ticket);
        if (batchId.equals("SALE") || batchId.equals("EXC")) {
            this.addToRegItem(taxInfo.getFare(), items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.Fare);
            this.addToRegItem(taxInfo.getTaxYQ(), items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.YqTax);
            this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.OtherTax);
            this.addToRegItem(taxInfo.getCommission(), items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.Comm);
            this.addToRegItem(taxInfo.getSellPenalty(), items, ProductStatus.SELL, TransportationType.DOMESTIC, FvRegistryLetterItem.FieldDefinition.Penalty);
            this.addToRegItem(1, items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.Tickets);
            if (ticket.isEticket()) {
                this.addToRegItem(1, items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.ETickets);
            }
            this.addToRegItem(taxInfo.getCashFop(), items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.CashFop);
            this.addToRegItem(taxInfo.getOtherFop(), items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.OtherFop);
        }
        if (batchId.equals("REFUND")) {
            if (ticket.getMcoCategory() == MCOCategory.PENALTY) {
                this.addToRegItem(ticket.getVendorEquivalentCommission(), items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.Comm);
                this.addToRegItem(1, items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.Tickets);
                if (ticket.isEticket()) {
                    this.addToRegItem(1, items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.ETickets);
                }
                return;
            }
            this.addToRegItem(ticket.getEquivalentFare(), items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.Fare);
            this.addToRegItem(taxInfo.getTaxYQ(), items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.YqTax);
            this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.OtherTax);
            this.addToRegItem(taxInfo.getCommission(), items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.Comm);
            this.addToRegItem(taxInfo.getMcoFare(), items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.Mco);
            this.addToRegItem(taxInfo.getRefPenalty(), items, ProductStatus.SELL, TransportationType.DOMESTIC, FvRegistryLetterItem.FieldDefinition.Penalty);
            this.addToRegItem(taxInfo.getCashFop(), items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.CashFop);
            this.addToRegItem(taxInfo.getOtherFop(), items, ProductStatus.SELL, tranType, FvRegistryLetterItem.FieldDefinition.OtherFop);
            this.addToRegItem(1, items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.Tickets);
            if (ticket.isEticket()) {
                this.addToRegItem(1, items, ProductStatus.REFUND, tranType, FvRegistryLetterItem.FieldDefinition.ETickets);
            }
        }
        if (batchId.equals("CANCEL")) {
            this.addToRegItem(1, items, ProductStatus.VOID, tranType, FvRegistryLetterItem.FieldDefinition.CancTickets);
            if (ticket.isEticket()) {
                this.addToRegItem(1, items, ProductStatus.VOID, tranType, FvRegistryLetterItem.FieldDefinition.CancTickets);
            }
        }
    }

    private FareCommissionInfo getFareTaxInfo(SuTicket ticket) {
        BigDecimal cashFop;
        FareCommissionInfo result = new FareCommissionInfo();
        ProductCategory productCategory = ticket.getProductCategory();
        MCOCategory mcoCategory = ticket.getMcoCategory();
        boolean hasPta = SalesReportHelper.isHasFop((Collection)ticket.getFops(), (PaymentType)PaymentType.PTA);
        double equivalentFare = ticket.getEquivalentFare() == null ? 0.0 : ticket.getEquivalentFare().doubleValue();
        switch (ticket.getStatus()) {
            case SELL: {
                switch (productCategory) {
                    case AIR: {
                        if (ticket.getPenalty() == null) break;
                        result.setSellPenalty(ticket.getPenalty().doubleValue());
                        break;
                    }
                    case MCO: {
                        if (mcoCategory != MCOCategory.REBOOKING) break;
                        result.setSellPenalty(equivalentFare);
                    }
                }
                result.setFare(equivalentFare);
                break;
            }
            case REFUND: 
            case EXCHANGE: {
                if (productCategory == ProductCategory.MCO && (hasPta || mcoCategory == MCOCategory.REBOOKING || mcoCategory == MCOCategory.RETURN_FARE_DIFFERENCE)) {
                    result.setMcoFare(equivalentFare);
                    break;
                }
                result.setFare(equivalentFare);
                break;
            }
            case VOID: {
                return result;
            }
        }
        double otherTax = 0.0;
        if (productCategory != ProductCategory.MCO || mcoCategory != MCOCategory.PENALTY) {
            Collection taxes = ticket.getTaxes();
            for (Tax tax : taxes) {
                double amount = tax.getEquivalentAmount() == null ? 0.0 : tax.getEquivalentAmount().doubleValue();
                String code = tax.getCode();
                if (ticket.getStatus() == ProductStatus.REFUND) {
                    if (code.equals("YQ")) {
                        result.setTaxYQ(amount);
                        continue;
                    }
                    if ("P1".equals(code)) {
                        result.setRefPenalty(amount);
                        continue;
                    }
                    otherTax += amount;
                    continue;
                }
                if (code.equals("YQ")) {
                    result.setTaxYQ(amount);
                    continue;
                }
                if ("P2".equals(code)) continue;
                otherTax += amount;
            }
        }
        double cashFopDouble = (cashFop = SalesReportHelper.getFopAmount((PaymentType)PaymentType.CASH, (BaseSalesReportTicket)ticket, null)) == null ? 0.0 : cashFop.doubleValue();
        result.setCashFop(cashFopDouble);
        result.setOtherFop(SalesReportHelper.getFopAmount(null, (BaseSalesReportTicket)ticket, null).doubleValue() - cashFopDouble);
        result.setOtherTax(otherTax);
        Money vendorComm = ticket.getVendorCommissionValue();
        double commission = 0.0;
        if (vendorComm != null && vendorComm.getValue() != null) {
            commission = vendorComm.getValue().doubleValue();
        }
        result.setCommission(commission);
        return result;
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_FV_AGENCY_CODE;
    }

    @Override
    protected String getStockControlReportUid() {
        return "fv-stock-control-report";
    }

    private class FareCommissionInfo {
        private double fare;
        private double taxYQ;
        private double otherTax;
        private double commission;
        private double refPenalty;
        private double sellPenalty;
        private double cashFop;
        private double otherFop;
        private double mcoFare;

        private FareCommissionInfo() {
        }

        public double getCommission() {
            return this.commission;
        }

        public void setCommission(double value) {
            this.commission = value;
        }

        public double getFare() {
            return this.fare;
        }

        public void setFare(double value) {
            this.fare = value;
        }

        public double getTaxYQ() {
            return this.taxYQ;
        }

        public void setTaxYQ(double value) {
            this.taxYQ = value;
        }

        public double getOtherTax() {
            return this.otherTax;
        }

        public void setOtherTax(double value) {
            this.otherTax = value;
        }

        public double getRefPenalty() {
            return this.refPenalty;
        }

        public void setRefPenalty(double value) {
            this.refPenalty = value;
        }

        public double getSellPenalty() {
            return this.sellPenalty;
        }

        public void setSellPenalty(double value) {
            this.sellPenalty = value;
        }

        public double getCashFop() {
            return this.cashFop;
        }

        public void setCashFop(double value) {
            this.cashFop = value;
        }

        public double getOtherFop() {
            return this.otherFop;
        }

        public void setOtherFop(double value) {
            this.otherFop = value;
        }

        public double getMcoFare() {
            return this.mcoFare;
        }

        public void setMcoFare(double value) {
            this.mcoFare = value;
        }
    }
}

