/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.kv;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVSalesSummaryReportItem;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class KVSalesReportPrepareHandler
extends BaseReportPrepareHandler {
    private ReportBatchData<KVSalesReportTicket> vvlSellBatchDataList = null;
    private ReportBatchData<KVSalesReportTicket> mvlSellBatchDataList = null;
    private ReportBatchData<KVSalesReportTicket> vvlExchangeBatchDataList = null;
    private ReportBatchData<KVSalesReportTicket> mvlExchangeBatchDataList = null;
    private ReportBatchData<KVSalesReportTicket> vvlRefundBatchDataList = null;
    private ReportBatchData<KVSalesReportTicket> mvlRefundBatchDataList = null;
    private Map<String, KVSalesSummaryReportItem> salesSummaryItems = null;

    @Override
    public String getId() {
        return "kv-sales-report";
    }

    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<Object> batchDataList = (ArrayList<Object>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<Object>();
            data.put("key-batch-data-list", batchDataList);
            this.vvlSellBatchDataList = new ReportBatchData();
            this.vvlSellBatchDataList.setBatchId("VVL_SALE");
            batchDataList.add(this.vvlSellBatchDataList);
            this.mvlSellBatchDataList = new ReportBatchData();
            this.mvlSellBatchDataList.setBatchId("MVL_SALE");
            batchDataList.add(this.mvlSellBatchDataList);
            this.vvlExchangeBatchDataList = new ReportBatchData();
            this.vvlExchangeBatchDataList.setBatchId("VVL_EXCHANGE");
            batchDataList.add(this.vvlExchangeBatchDataList);
            this.mvlExchangeBatchDataList = new ReportBatchData();
            this.mvlExchangeBatchDataList.setBatchId("MVL_EXCHANGE");
            batchDataList.add(this.mvlExchangeBatchDataList);
            this.vvlRefundBatchDataList = new ReportBatchData();
            this.vvlRefundBatchDataList.setBatchId("VVL_REFUND");
            batchDataList.add(this.vvlRefundBatchDataList);
            this.mvlRefundBatchDataList = new ReportBatchData();
            this.mvlRefundBatchDataList.setBatchId("MVL_REFUND");
            batchDataList.add(this.mvlRefundBatchDataList);
            ReportBatchData summaryInfoBatchDataList = new ReportBatchData();
            summaryInfoBatchDataList.setBatchId("SUMMARY_INFO");
            batchDataList.add(summaryInfoBatchDataList);
            this.salesSummaryItems = new HashMap<String, KVSalesSummaryReportItem>();
            data.put("SUMMARY_INFO", this.salesSummaryItems);
            for (KVSalesSummaryReportItem.Definition item : KVSalesSummaryReportItem.Definition.values()) {
                this.salesSummaryItems.put(item.name(), new KVSalesSummaryReportItem());
            }
        }
        KVSalesReportTicket ticket = new KVSalesReportTicket(product, messages);
        switch (product.getProductCategory()) {
            case AIR: {
                if (ticket.isExchangeTicket()) {
                    if (ticket.isVVL()) {
                        this.vvlExchangeBatchDataList.getTickets().add(ticket);
                        break;
                    }
                    if (!ticket.isMVL()) break;
                    this.mvlExchangeBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (ticket.isRefundTicket()) {
                    if (ticket.isVVL()) {
                        this.vvlRefundBatchDataList.getTickets().add(ticket);
                        break;
                    }
                    if (!ticket.isMVL()) break;
                    this.mvlRefundBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (!ticket.isSellTicket() && !ticket.isVoidTicket()) break;
                if (ticket.isVVL()) {
                    this.vvlSellBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (!ticket.isMVL()) break;
                this.mvlSellBatchDataList.getTickets().add(ticket);
                break;
            }
        }
        this.calculateSummaryInfo(data, ticket);
    }

    @Override
    protected Collection<? extends Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.productCategory.name(), (Object)ProductCategory.AIR));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.REFUND)}));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.supplier.name(), (Object)params.getSupplier()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), (Object)params.getAgency()));
        EntityStorage es = EntityStorage.get();
        HashSet<Product> result = new HashSet<Product>();
        EntityContainer ctr = null;
        for (ProductIndex productIndex : es.search(ProductIndex.class, query).getData()) {
            ctr = es.resolve(productIndex.getSource());
            result.add((Product)BookingHelper.findProduct((BookingFile)((BookingFile)ctr.getEntity()), (String)productIndex.getNavigationKey()));
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        }
        return result;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        KVSalesReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        KVSalesReportPrepareHandler.putStandardAgencyData((EntityReference<Organization>)params.getAgency(), data, messages);
        String supplierName = L10nStringHelper.getValue((L10nString)((Organization)EntityStorage.get().resolve(params.getSupplier()).getEntity()).getFullName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        data.put("AIRLINE_NAME", supplierName);
        Organization agency = (Organization)EntityStorage.get().resolve(params.getAgency()).getEntity();
        for (Communication communication : agency.getCommunications()) {
            if (!communication.getType().equals((Object)CommunicationType.WORK_PHONE)) continue;
            data.put("AGENCY_PHONE", communication.getSense());
        }
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.VENDOR), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)params.getSupplier()), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)params.getSupplier()), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)params.getAgency())}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)params.getPeriodBegin())}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)params.getPeriodEnd())}));
        List contractCustomerIndexes = es.search(ContractCustomerIndex.class, query).getData();
        if (contractCustomerIndexes.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoContracts", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.debug("No contracts found for the report parameters");
            return;
        }
        Collections.sort(contractCustomerIndexes, new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                return MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }
        });
        data.put("CONTRACT_NO", ((ContractCustomerIndex)contractCustomerIndexes.get(0)).getNumber());
        data.put("CONTRACT_ISSUE_DATE", ((ContractCustomerIndex)contractCustomerIndexes.get(0)).getIssueDate());
    }

    @Override
    protected void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        super.checkReportParameters(data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        if (params.getPeriodBegin() == null) {
            SystemHelper.addMessage(messages, (String)Messages.HySalesReportPrepareHandler_noStartDate, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("Start date is empty");
        }
        if (params.getPeriodEnd() == null) {
            SystemHelper.addMessage(messages, (String)Messages.U6SalesReportPrepareHandler_noDatePeriodEnd, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("End date is empty");
        }
        if (params.getSupplier() == null) {
            SystemHelper.addMessage(messages, (String)Messages.HySalesReportPrepareHandler_noSupplier, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("Supplier is empty");
        }
        if (params.getAgency() == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseSsodDivergenceReportPrepareHandler_noAgency, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("Agency is empty");
        }
    }

    private void calculateSummaryInfo(Map<String, Object> data, KVSalesReportTicket ticket) {
        if (ticket.isDuplicate()) {
            return;
        }
        KVSalesSummaryReportItem item = null;
        switch (ticket.getProductCategory()) {
            case AIR: {
                if (ticket.isSellTicket() || ticket.isExchangeTicket()) {
                    if (ticket.isVVL()) {
                        item = this.salesSummaryItems.get(KVSalesSummaryReportItem.Definition.VVL_SELL.name());
                        break;
                    }
                    if (!ticket.isMVL()) break;
                    item = this.salesSummaryItems.get(KVSalesSummaryReportItem.Definition.MVL_SELL.name());
                    break;
                }
                if (!ticket.isRefundTicket()) break;
                if (ticket.isVVL()) {
                    item = this.salesSummaryItems.get(KVSalesSummaryReportItem.Definition.VVL_REFUND.name());
                    break;
                }
                if (!ticket.isMVL()) break;
                item = this.salesSummaryItems.get(KVSalesSummaryReportItem.Definition.MVL_REFUND.name());
                break;
            }
        }
        if (item != null) {
            if (ticket.getEquivalentFare() != null) {
                item.addTariff(ticket.getEquivalentFare().doubleValue());
            }
            if (ticket.getMcoPenalty() != null) {
                item.addMCOPenalty(ticket.getMcoPenalty().doubleValue());
            }
            if (ticket.getAirlineFee() != null) {
                item.addAirlineFee(ticket.getAirlineFee().doubleValue());
            }
            if (ticket.getFee() != null) {
                item.addFee(ticket.getFee().doubleValue());
            }
            if (ticket.getCommission() != null && ticket.getCommission().getEquivalentAmount() != null) {
                item.addCommission(ticket.getCommission().getEquivalentAmount().doubleValue());
            }
            if (ticket.isRefundTicket() && ticket.getPenalty() != null) {
                item.addPenalty(ticket.getPenalty().doubleValue());
            }
            if (!ticket.isVoidTicket() && !ticket.isExchangeTicket()) {
                item.incrementTicketsQuantity();
            }
        }
    }
}

