/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.na;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSummaryReportItem;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;

public class NaSalesReportPrepareHandler
extends SuSalesReportPrepareHandler {
    private static String[] carrierTaxes = new String[]{"XP", "ER", "KS", "SA", "Y1", "P4", "P7", "P8", "P9", "E1", "R1"};
    private static String[] rebookingTaxes = new String[]{"CP", "PO"};
    private static String[] refundTaxes = new String[]{"P1", "P2"};

    @Override
    protected String getVendorCode() {
        return "5N";
    }

    @Override
    public String getId() {
        return "na-sales-report";
    }

    @Override
    protected String getPenaltyTaxCode() {
        return "P1";
    }

    private static boolean isContainsCode(String[] codes, String code) {
        if (codes == null || TextUtil.isBlank((String)code)) {
            return false;
        }
        for (String tax : codes) {
            if (!tax.equals(code)) continue;
            return true;
        }
        return false;
    }

    private Map<String, NaSummaryReportItem> getRegistryLettersItems(Map<String, Object> data) {
        TreeMap items = (TreeMap)data.get("key-registry-letters-data");
        if (items == null) {
            items = new TreeMap();
            data.put("key-registry-letters-data", items);
        }
        return items;
    }

    private NaSummaryReportItem getNaRegistryLetterItem(Map<String, NaSummaryReportItem> items, ProductStatus opType, TransportationType tranType, NaSummaryReportItem.FieldDefinition fieldDef) {
        NaSummaryReportItem item = items.get(tranType.name() + opType.name() + fieldDef.name());
        if (item == null) {
            item = new NaSummaryReportItem();
            item.fieldDef = fieldDef;
            items.put(tranType.name() + opType.name() + fieldDef.name(), item);
        }
        return item;
    }

    private void addToRegItem(double value, Map<String, NaSummaryReportItem> items, ProductStatus opType, TransportationType tranType, NaSummaryReportItem.FieldDefinition fieldDef) {
        NaSummaryReportItem item = this.getNaRegistryLetterItem(items, opType, tranType, fieldDef);
        item.sum += value;
    }

    private void addToRegItem(int value, Map<String, NaSummaryReportItem> items, ProductStatus opType, TransportationType tranType, NaSummaryReportItem.FieldDefinition fieldDef) {
        NaSummaryReportItem item = this.getNaRegistryLetterItem(items, opType, tranType, fieldDef);
        item.cnt += value;
    }

    @Override
    protected void updateTicketRegistryLetterData(SuTicket ticket, String batchId, Map<String, Object> data) {
        if (ticket.getStatus() == null) {
            return;
        }
        TransportationType tranType = TransportationType.DOMESTIC;
        if (ticket.getTransportationType() != TransportationType.DOMESTIC) {
            tranType = TransportationType.INTERNATIONAL;
        }
        Map<String, NaSummaryReportItem> items = this.getRegistryLettersItems(data);
        FareCommissionInfo taxInfo = this.getFareAndTaxInfo(ticket);
        if (batchId.equals("SALE")) {
            if (ticket.getProductCategory() == ProductCategory.MCO) {
                this.addToRegItem(1, items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.Tickets);
                if (ticket.getMcoCategory().equals((Object)MCOCategory.SEAT_RESERVATION) || ticket.getMcoCategory().equals((Object)MCOCategory.SPECIAL_FOOD)) {
                    this.addToRegItem(taxInfo.getFare(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.RuTax);
                } else if (ticket.getMcoCategory().equals((Object)MCOCategory.REBOOKING)) {
                    this.addToRegItem(taxInfo.getRebookingPenalty(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.Penalty);
                }
                if (!ticket.getMcoCategory().equals((Object)MCOCategory.REBOOKING)) {
                    this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.RuTax);
                }
                return;
            }
            this.addToRegItem(taxInfo.getFare(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.Fare);
            this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.RuTax);
            this.addToRegItem(taxInfo.getTaxYQ(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.YqTax);
            this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.OtherTax);
            this.addToRegItem(taxInfo.getCommission(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.Comm);
            this.addToRegItem(1, items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.Tickets);
            this.addToRegItem(taxInfo.getCashFop(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.CashFop);
            this.addToRegItem(taxInfo.getOtherFop(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.OtherFop);
        }
        if (batchId.equals("REFUND")) {
            if (ticket.getProductCategory() == ProductCategory.MCO) {
                this.addToRegItem(1, items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.Tickets);
                this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.RuTax);
                this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.OtherTax);
                return;
            }
            this.addToRegItem(taxInfo.getFare(), items, ProductStatus.REFUND, tranType, NaSummaryReportItem.FieldDefinition.Fare);
            this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.RuTax);
            this.addToRegItem(0.0, items, ProductStatus.REFUND, tranType, NaSummaryReportItem.FieldDefinition.RuTax);
            this.addToRegItem(taxInfo.getTaxYQ(), items, ProductStatus.REFUND, tranType, NaSummaryReportItem.FieldDefinition.YqTax);
            this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.REFUND, tranType, NaSummaryReportItem.FieldDefinition.OtherTax);
            this.addToRegItem(taxInfo.getCommission(), items, ProductStatus.REFUND, tranType, NaSummaryReportItem.FieldDefinition.Comm);
            this.addToRegItem(taxInfo.getRefPenalty(), items, ProductStatus.REFUND, tranType, NaSummaryReportItem.FieldDefinition.Penalty);
            this.addToRegItem(taxInfo.getCashFop(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.CashFop);
            this.addToRegItem(taxInfo.getOtherFop(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.OtherFop);
            this.addToRegItem(1, items, ProductStatus.REFUND, tranType, NaSummaryReportItem.FieldDefinition.Tickets);
        }
        if (batchId.equals("EXC")) {
            if (ticket.getProductCategory() == ProductCategory.MCO) {
                this.addToRegItem(1, items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.Tickets);
                if (ticket.getMcoCategory() != MCOCategory.ADDITIONAL_TARIFF) {
                    this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.RuTax);
                }
                return;
            }
            ProductStatus prodStatus = ProductStatus.SELL;
            if (ticket.getStatus() == ProductStatus.EXCHANGE || ticket.getStatus() == ProductStatus.REFUND) {
                prodStatus = ProductStatus.REFUND;
            }
            this.addToRegItem(taxInfo.getFare(), items, prodStatus, tranType, NaSummaryReportItem.FieldDefinition.Fare);
            this.addToRegItem(taxInfo.getRebookingPenalty(), items, ProductStatus.SELL, tranType, NaSummaryReportItem.FieldDefinition.Penalty);
            this.addToRegItem(taxInfo.getTaxVendor(), items, prodStatus, tranType, NaSummaryReportItem.FieldDefinition.RuTax);
            this.addToRegItem(taxInfo.getTaxYQ(), items, prodStatus, tranType, NaSummaryReportItem.FieldDefinition.YqTax);
            this.addToRegItem(taxInfo.getOtherTax(), items, prodStatus, tranType, NaSummaryReportItem.FieldDefinition.OtherTax);
            this.addToRegItem(taxInfo.getCommission(), items, prodStatus, tranType, NaSummaryReportItem.FieldDefinition.Comm);
            this.addToRegItem(taxInfo.getRefPenalty(), items, ProductStatus.REFUND, tranType, NaSummaryReportItem.FieldDefinition.Penalty);
            this.addToRegItem(taxInfo.getCashFop(), items, prodStatus, tranType, NaSummaryReportItem.FieldDefinition.CashFop);
            this.addToRegItem(taxInfo.getOtherFop(), items, prodStatus, tranType, NaSummaryReportItem.FieldDefinition.OtherFop);
            this.addToRegItem(1, items, prodStatus, tranType, NaSummaryReportItem.FieldDefinition.Tickets);
        }
        if (batchId.equals("CANCEL")) {
            this.addToRegItem(1, items, ProductStatus.VOID, tranType, NaSummaryReportItem.FieldDefinition.Tickets);
        }
    }

    private FareCommissionInfo getFareAndTaxInfo(SuTicket ticket) {
        FareCommissionInfo result = new FareCommissionInfo();
        MCOCategory mcoCategory = ticket.getMcoCategory();
        double equivalentFare = ticket.getEquivalentFare() == null ? 0.0 : ticket.getEquivalentFare().doubleValue();
        switch (ticket.getStatus()) {
            case SELL: {
                result.setFare(equivalentFare);
                break;
            }
            case REFUND: 
            case EXCHANGE: {
                result.setFare(Math.abs(equivalentFare));
                break;
            }
            case VOID: {
                return result;
            }
        }
        double otherTax = 0.0;
        double vendorTax = 0.0;
        double sellTaxAmount = 0.0;
        double fuelTax = 0.0;
        for (Tax tax : ticket.getTaxes()) {
            double amount;
            double d = amount = tax.getEquivalentAmount() == null ? 0.0 : tax.getEquivalentAmount().doubleValue();
            String code = tax.getCode();
            if (NaSalesReportPrepareHandler.isContainsCode(refundTaxes, code)) continue;
            if (NaSalesReportPrepareHandler.isContainsCode(carrierTaxes, code)) {
                vendorTax += Math.abs(amount);
                continue;
            }
            if (this.getFuelTaxCode().equals(code)) {
                fuelTax += Math.abs(amount);
                continue;
            }
            if (NaSalesReportPrepareHandler.isContainsCode(rebookingTaxes, code)) {
                result.setRebookingPenalty(Math.abs(amount));
                continue;
            }
            otherTax += Math.abs(amount);
        }
        if (ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.SELL && ticket.getPrevTicket() != null && ticket.getPrevTicket().getStatus() == ProductStatus.EXCHANGE) {
            double penalty = ticket.getPenalty() != null ? ticket.getPenalty().doubleValue() : 0.0;
            result.setRefPenalty(penalty);
        } else if (ticket.getStatus() == ProductStatus.SELL && mcoCategory == MCOCategory.REBOOKING && ticket.getPenalty() != null) {
            result.setRebookingPenalty(ticket.getPenalty().doubleValue());
        }
        BigDecimal cashFop = SalesReportHelper.getFopAmount((PaymentType)PaymentType.CASH, (BaseSalesReportTicket)ticket, null);
        double cashFopDouble = cashFop == null ? 0.0 : cashFop.doubleValue();
        result.setCashFop(cashFopDouble);
        double otherFops = SalesReportHelper.getFopAmount(null, (BaseSalesReportTicket)ticket, null).doubleValue();
        result.setOtherFop(Math.abs(otherFops) - cashFopDouble);
        result.setTaxYR(fuelTax);
        result.setOtherTax(otherTax);
        result.setTaxVendor(vendorTax);
        result.setSellTaxVendor(sellTaxAmount);
        double commission = ticket.getVendorEquivalentCommission() == null ? 0.0 : Math.abs(ticket.getVendorEquivalentCommission().doubleValue());
        result.setCommission(commission);
        return result;
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_5N_AGENCY_CODE;
    }

    @Override
    protected String getStockControlReportUid() {
        return "na-stock-control-report";
    }

    class FareCommissionInfo {
        private double fare;
        private double taxYQ;
        private double taxVendor;
        private double otherTax;
        private double commission;
        private double refPenalty;
        private double sellPenalty;
        private double rebookingPenalty;
        private double cashFop;
        private double otherFop;
        private double sellTaxVendor;

        FareCommissionInfo() {
        }

        public double getCommission() {
            return this.commission;
        }

        public void setCommission(double value) {
            this.commission = value;
        }

        public double getFare() {
            return this.fare;
        }

        public void setFare(double value) {
            this.fare = value;
        }

        public double getTaxYQ() {
            return this.taxYQ;
        }

        public void setTaxYR(double value) {
            this.taxYQ = value;
        }

        public double getTaxVendor() {
            return this.taxVendor;
        }

        public void setTaxVendor(double value) {
            this.taxVendor = value;
        }

        public double getOtherTax() {
            return this.otherTax;
        }

        public void setOtherTax(double value) {
            this.otherTax = value;
        }

        public double getRefPenalty() {
            return this.refPenalty;
        }

        public void setRefPenalty(double value) {
            this.refPenalty = value;
        }

        public double getSellPenalty() {
            return this.sellPenalty;
        }

        public void setSellPenalty(double value) {
            this.sellPenalty = value;
        }

        public double getCashFop() {
            return this.cashFop;
        }

        public void setCashFop(double value) {
            this.cashFop = value;
        }

        public double getOtherFop() {
            return this.otherFop;
        }

        public void setOtherFop(double value) {
            this.otherFop = value;
        }

        public void setSellTaxVendor(double sellTaxVendorValue) {
            this.sellTaxVendor = sellTaxVendorValue;
        }

        public double getSellTaxVendor() {
            return this.sellTaxVendor;
        }

        public double getRebookingPenalty() {
            return this.rebookingPenalty;
        }

        public void setRebookingPenalty(double value) {
            this.rebookingPenalty = value;
        }
    }
}

