/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.nn;

import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegment;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegmentTariff;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNReportHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNSellReportTicket;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NNExchangeReportTicket
extends NNSellReportTicket {
    private final BigDecimal penalty;
    private final String firstSellNumber;
    private final Date firstSellIssueDate;
    private final String fareBasis;

    public static List<NNExchangeReportTicket> createExchangeTickets(AirTicketsTemplateReportTicket ticket) {
        ArrayList<NNExchangeReportTicket> result = new ArrayList<NNExchangeReportTicket>();
        for (AirTicketsTemplateReportSegmentTariff st : ticket.getSegmentTariffs()) {
            int segmentNumber = NNReportHelper.findFinancialSegmentNumber(ticket, st);
            for (int n = 0; n < st.getSegments().size(); ++n) {
                result.add(new NNExchangeReportTicket(ticket, st, (AirTicketsTemplateReportSegment)st.getSegments().get(n), n == segmentNumber));
            }
        }
        return result;
    }

    public NNExchangeReportTicket(AirTicketsTemplateReportTicket ticket, AirTicketsTemplateReportSegmentTariff st, AirTicketsTemplateReportSegment seg, boolean includeFinanceFields) {
        super(ticket, st, seg, includeFinanceFields);
        this.penalty = ticket.getPenalty();
        this.firstSellNumber = ticket.getRelatedTicketNumber();
        this.firstSellIssueDate = ticket.getRelatedTicketIssueDate();
        this.fareBasis = seg.getFareBasis();
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public String getFirstSellNumber() {
        return this.firstSellNumber;
    }

    public Date getFirstSellIssueDate() {
        return this.firstSellIssueDate;
    }

    public String getFareBasis() {
        return this.fareBasis;
    }
}

