/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.nn;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicketType;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class NNLetter {
    private BigDecimal sellTariff = BigDecimal.ZERO;
    private BigDecimal exchangeTariff = BigDecimal.ZERO;
    private BigDecimal sellMco = BigDecimal.ZERO;
    private BigDecimal sellTaxForBlank = BigDecimal.ZERO;
    private BigDecimal sellTaxForFuel = BigDecimal.ZERO;
    private final BigDecimal sellPenalty = BigDecimal.ZERO;
    private BigDecimal refundTariff = BigDecimal.ZERO;
    private BigDecimal refundTaxForBlank = BigDecimal.ZERO;
    private BigDecimal refundTaxForFuel = BigDecimal.ZERO;
    private BigDecimal refundMco = BigDecimal.ZERO;
    private BigDecimal sellTicketCommission = BigDecimal.ZERO;
    private BigDecimal exchangeTicketCommission = BigDecimal.ZERO;
    private BigDecimal sellLuggageCommission = BigDecimal.ZERO;
    private BigDecimal refundLuggageCommission = BigDecimal.ZERO;
    private BigDecimal refundTicketCommission = BigDecimal.ZERO;
    private BigDecimal cacheFop = BigDecimal.ZERO;
    private BigDecimal creditFop = BigDecimal.ZERO;
    private BigDecimal ccFop = BigDecimal.ZERO;
    private BigDecimal invoiceFop = BigDecimal.ZERO;
    private BigDecimal vpdFop = BigDecimal.ZERO;

    public void addTicket(AirTicketsTemplateReportTicket ticket) {
        if (ticket.getType() == AirTicketsTemplateReportTicketType.MEMO || ProductStatusHandler.getAllVoidStatuses().contains(ticket.getStatus())) {
            return;
        }
        BigDecimal taxForBlank = AirProductTaxHelper.getEquivalentTaxesAmount((Collection)ticket.getTaxes(), (String[])new String[]{"RU"});
        BigDecimal taxForFuel = AirProductTaxHelper.getEquivalentTaxesAmount((Collection)ticket.getTaxes(), (String[])new String[]{"SA", "XT"});
        switch (ticket.getOperationBatch()) {
            case SELL: {
                if (ticket.getProductCategory() == ProductCategory.MCO) {
                    this.sellMco = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellMco, ticket.getEquivalentFare()});
                } else {
                    this.sellTariff = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellTariff, ticket.getEquivalentFare()});
                }
                this.sellTaxForBlank = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellTaxForBlank, taxForBlank});
                this.sellTaxForFuel = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellTaxForFuel, taxForFuel});
                if (ticket.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE) {
                    this.sellLuggageCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellLuggageCommission, ticket.getVendorCommissionValue()});
                    break;
                }
                this.sellTicketCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellTicketCommission, ticket.getVendorCommissionValue()});
                break;
            }
            case EXCHANGE: {
                if (ticket.getProductCategory() == ProductCategory.MCO) {
                    this.sellMco = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellMco, ticket.getEquivalentFare()});
                } else {
                    this.exchangeTariff = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.exchangeTariff, ticket.getEquivalentFare()});
                }
                this.sellTaxForBlank = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellTaxForBlank, taxForBlank});
                this.sellTaxForFuel = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.sellTaxForFuel, taxForFuel});
                this.exchangeTicketCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.exchangeTicketCommission, ticket.getVendorCommissionValue()});
                break;
            }
            case REFUND: {
                if (ticket.getProductCategory() == ProductCategory.MCO) {
                    this.refundMco = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.refundMco, ticket.getEquivalentFare()});
                } else {
                    this.refundTariff = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.refundTariff, ticket.getEquivalentFare()});
                }
                this.refundTaxForBlank = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.refundTaxForBlank, taxForBlank});
                this.refundTaxForFuel = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.refundTaxForFuel, taxForFuel});
                if (ticket.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE) {
                    this.refundLuggageCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.refundLuggageCommission, ticket.getVendorCommissionValue()});
                    break;
                }
                this.refundTicketCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.refundTicketCommission, ticket.getVendorCommissionValue()});
                break;
            }
        }
        this.cacheFop = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.cacheFop, this.calculateFopValue(ticket.getPaymentsInfo(), ticket.getStatus() == ProductStatus.REFUND, PaymentType.CASH)});
        this.creditFop = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.creditFop, this.calculateFopValue(ticket.getPaymentsInfo(), ticket.getStatus() == ProductStatus.REFUND, PaymentType.CREDIT)});
        this.ccFop = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.ccFop, this.calculateFopValue(ticket.getPaymentsInfo(), ticket.getStatus() == ProductStatus.REFUND, PaymentType.CREDIT_CARD)});
        this.invoiceFop = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.invoiceFop, this.calculateFopValue(ticket.getPaymentsInfo(), ticket.getStatus() == ProductStatus.REFUND, PaymentType.INVOICE)});
        this.vpdFop = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.vpdFop, this.calculateFopValue(ticket.getPaymentsInfo(), ticket.getStatus() == ProductStatus.REFUND, PaymentType.MTD)});
    }

    private BigDecimal calculateFopValue(Map<PaymentType, Money> paymentsInfo, boolean negate, PaymentType paymentType) {
        BigDecimal result = BigDecimal.ZERO;
        for (Map.Entry<PaymentType, Money> entry : paymentsInfo.entrySet()) {
            if (entry.getKey() != paymentType || entry.getValue() == null || entry.getValue().getValue() == null) continue;
            result = negate ? MiscUtil.sub((BigDecimal)result, (BigDecimal[])new BigDecimal[]{entry.getValue().getValue()}) : MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, entry.getValue().getValue()});
        }
        return result;
    }

    public BigDecimal getSellTariff() {
        return this.sellTariff;
    }

    public BigDecimal getExchangeTariff() {
        return this.exchangeTariff;
    }

    public BigDecimal getSellMco() {
        return this.sellMco;
    }

    public BigDecimal getSellTaxForBlank() {
        return this.sellTaxForBlank;
    }

    public BigDecimal getSellTaxForFuel() {
        return this.sellTaxForFuel;
    }

    public BigDecimal getSellPenalty() {
        return this.sellPenalty;
    }

    public BigDecimal getRefundTariff() {
        return this.refundTariff;
    }

    public BigDecimal getRefundTaxForBlank() {
        return this.refundTaxForBlank;
    }

    public BigDecimal getRefundTaxForFuel() {
        return this.refundTaxForFuel;
    }

    public BigDecimal getRefundMco() {
        return this.refundMco;
    }

    public BigDecimal getSellTicketCommission() {
        return this.sellTicketCommission;
    }

    public BigDecimal getExchangeTicketCommission() {
        return this.exchangeTicketCommission;
    }

    public BigDecimal getSellLuggageCommission() {
        return this.sellLuggageCommission;
    }

    public BigDecimal getRefundLuggageCommission() {
        return this.refundLuggageCommission;
    }

    public BigDecimal getRefundTicketCommission() {
        return this.refundTicketCommission;
    }

    public BigDecimal getCacheFop() {
        return this.cacheFop;
    }

    public BigDecimal getCreditFop() {
        return this.creditFop;
    }

    public BigDecimal getCcFop() {
        return this.ccFop;
    }

    public BigDecimal getInvoiceFop() {
        return this.invoiceFop;
    }

    public BigDecimal getVpdFop() {
        return this.vpdFop;
    }
}

